/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.report;

import java.awt.Color;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.GregorianCalendar;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Footer;
import org.apache.poi.ss.usermodel.Header;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.report.CellStyleCacheManager;
import org.kopi.galite.visual.report.Constants;
import org.kopi.galite.visual.report.MReport;
import org.kopi.galite.visual.report.PConfig;
import org.kopi.galite.visual.report.PExport;
import org.kopi.galite.visual.report.UReport;
import org.kopi.galite.visual.report.VDecimalColumn;
import org.kopi.galite.visual.report.VReportColumn;
import org.kopi.galite.visual.type.Month;
import org.kopi.galite.visual.type.Week;
import org.kopi.galite.visual.util.base.InconsistencyException;
import org.kopi.galite.visual.visual.VlibProperties;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0017\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0016\n\u0002\u0010\n\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 Q2\u00020\u00012\u00020\u0002:\u0001QB%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!H\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020%H&J\n\u0010&\u001a\u0004\u0018\u00010\u001bH$J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0014J\u001d\u0010+\u001a\u00020(2\u000e\u0010,\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0-H\u0014\u00a2\u0006\u0002\u0010.J=\u0010/\u001a\u00020(2\u0006\u00100\u001a\u00020\u00152\u000e\u0010,\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0-2\u000e\u00101\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001020-2\u0006\u00103\u001a\u00020\u0011H\u0014\u00a2\u0006\u0002\u00104J\u001d\u00105\u001a\u00020(2\u0006\u0010 \u001a\u00020!2\u0006\u00106\u001a\u00020\u0015H\u0010\u00a2\u0006\u0002\b7J\u001d\u00108\u001a\u00020(2\u0006\u0010 \u001a\u00020!2\u0006\u00106\u001a\u00020\u0015H\u0010\u00a2\u0006\u0002\b9J\u001d\u0010:\u001a\u00020(2\u0006\u0010 \u001a\u00020!2\u0006\u00106\u001a\u00020\u0015H\u0010\u00a2\u0006\u0002\b;J\u001d\u0010<\u001a\u00020(2\u0006\u0010 \u001a\u00020!2\u0006\u00106\u001a\u00020\u0015H\u0010\u00a2\u0006\u0002\b=J\u001d\u0010>\u001a\u00020(2\u0006\u0010 \u001a\u00020!2\u0006\u00106\u001a\u00020\u0015H\u0010\u00a2\u0006\u0002\b?J\u001d\u0010@\u001a\u00020(2\u0006\u0010 \u001a\u00020!2\u0006\u00106\u001a\u00020\u0015H\u0010\u00a2\u0006\u0002\bAJ\u001d\u0010B\u001a\u00020(2\u0006\u0010 \u001a\u00020!2\u0006\u00106\u001a\u00020\u0015H\u0010\u00a2\u0006\u0002\bCJ\u001d\u0010D\u001a\u00020(2\u0006\u0010 \u001a\u00020!2\u0006\u00106\u001a\u00020\u0015H\u0010\u00a2\u0006\u0002\bEJ\u001d\u0010F\u001a\u00020(2\u0006\u0010 \u001a\u00020!2\u0006\u00106\u001a\u00020\u0015H\u0010\u00a2\u0006\u0002\bGJ\u0018\u0010H\u001a\u00020I2\u0006\u00103\u001a\u00020\u00112\u0006\u0010J\u001a\u00020\u0015H\u0004J\u0010\u0010K\u001a\u00020I2\u0006\u0010J\u001a\u00020\u0015H\u0004J,\u0010L\u001a\u00020(2\u0006\u0010M\u001a\u00020N2\u0006\u0010J\u001a\u00020\u00152\b\u0010,\u001a\u0004\u0018\u00010\n2\b\u00101\u001a\u0004\u0018\u000102H\u0004J\u0012\u0010O\u001a\u00020(2\b\u0010P\u001a\u0004\u0018\u00010\nH\u0014R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b@BX\u0084\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006R"}, d2={"Lorg/kopi/galite/visual/report/PExport2Excel;", "Lorg/kopi/galite/visual/report/PExport;", "Lorg/kopi/galite/visual/report/Constants;", "table", "Lorg/kopi/galite/visual/report/UReport$UTable;", "model", "Lorg/kopi/galite/visual/report/MReport;", "printConfig", "Lorg/kopi/galite/visual/report/PConfig;", "title", "", "(Lorg/kopi/galite/visual/report/UReport$UTable;Lorg/kopi/galite/visual/report/MReport;Lorg/kopi/galite/visual/report/PConfig;Ljava/lang/String;)V", "cellStyleCacheManager", "Lorg/kopi/galite/visual/report/CellStyleCacheManager;", "dataformats", "", "datatype", "", "format", "Lorg/apache/poi/ss/usermodel/DataFormat;", "rowNumber", "", "sheet", "Lorg/apache/poi/ss/usermodel/Sheet;", "sheetIndex", "widths", "<set-?>", "Lorg/apache/poi/ss/usermodel/Workbook;", "workbook", "getWorkbook", "()Lorg/apache/poi/ss/usermodel/Workbook;", "computeColumnWidth", "column", "Lorg/kopi/galite/visual/report/VReportColumn;", "createFillForegroundColor", "Lorg/apache/poi/ss/usermodel/Color;", "color", "Ljava/awt/Color;", "createWorkbook", "export", "", "stream", "Ljava/io/OutputStream;", "exportHeader", "data", "", "([Ljava/lang/String;)V", "exportRow", "level", "orig", "", "alignments", "(I[Ljava/lang/String;[Ljava/lang/Object;[I)V", "formatBooleanColumn", "index", "formatBooleanColumn$galite_core", "formatDateColumn", "formatDateColumn$galite_core", "formatDecimalColumn", "formatDecimalColumn$galite_core", "formatIntegerColumn", "formatIntegerColumn$galite_core", "formatMonthColumn", "formatMonthColumn$galite_core", "formatStringColumn", "formatStringColumn$galite_core", "formatTimeColumn", "formatTimeColumn$galite_core", "formatTimestampColumn", "formatTimestampColumn$galite_core", "formatWeekColumn", "formatWeekColumn$galite_core", "getAlignment", "", "cellPos", "getDataFormat", "setCellValue", "cell", "Lorg/apache/poi/ss/usermodel/Cell;", "startGroup", "subTitle", "Companion", "galite-core"})
public abstract class PExport2Excel
extends PExport
implements Constants {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int rowNumber;
    @Nullable
    private Workbook workbook;
    @Nullable
    private Sheet sheet;
    @Nullable
    private DataFormat format;
    @NotNull
    private final int[] datatype;
    @NotNull
    private final short[] dataformats;
    @NotNull
    private final short[] widths;
    private int sheetIndex;
    @NotNull
    private final CellStyleCacheManager cellStyleCacheManager;

    public PExport2Excel(@NotNull UReport.UTable table, @NotNull MReport model2, @NotNull PConfig printConfig, @NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)printConfig, (String)"printConfig");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        super(table, model2, printConfig, title, false, 16, null);
        this.datatype = new int[this.getColumnCount()];
        this.dataformats = new short[this.getColumnCount()];
        this.widths = new short[this.getColumnCount()];
        this.cellStyleCacheManager = new CellStyleCacheManager();
    }

    @Nullable
    protected final Workbook getWorkbook() {
        return this.workbook;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void export(@NotNull OutputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        this.rowNumber = 0;
        this.sheetIndex = 0;
        try {
            Workbook workbook = this.workbook = this.createWorkbook();
            Intrinsics.checkNotNull((Object)workbook);
            this.format = workbook.createDataFormat();
            this.formatColumns();
            this.exportData();
            Workbook workbook2 = this.workbook;
            Intrinsics.checkNotNull((Object)workbook2);
            workbook2.write(stream);
            stream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (this.workbook instanceof SXSSFWorkbook) {
                Workbook workbook = this.workbook;
                if (workbook == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.apache.poi.xssf.streaming.SXSSFWorkbook");
                }
                ((SXSSFWorkbook)workbook).dispose();
            }
        }
    }

    @Override
    protected void startGroup(@Nullable String subTitle) {
        PExport2Excel pExport2Excel;
        String string;
        CharSequence charSequence;
        Regex regex;
        String subTitle2 = subTitle;
        if (subTitle2 == null) {
            subTitle2 = this.getTitle();
        }
        if ((subTitle2 = (regex = new Regex("/|\\\\|\\*|\\?|\\[|\\]")).replace(charSequence = (CharSequence)subTitle2, string = "")).length() > 31) {
            String string2 = subTitle2.substring(0, 28);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            subTitle2 = Intrinsics.stringPlus((String)string2, (Object)"...");
        } else if (((CharSequence)subTitle2).length() == 0) {
            subTitle2 = " ";
        }
        this.rowNumber = 0;
        PExport2Excel pExport2Excel2 = this;
        try {
            pExport2Excel = pExport2Excel2;
            Workbook workbook = this.workbook;
            Intrinsics.checkNotNull((Object)workbook);
            charSequence = workbook.createSheet(subTitle2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            pExport2Excel = pExport2Excel2;
            Workbook workbook = this.workbook;
            Intrinsics.checkNotNull((Object)workbook);
            charSequence = workbook.createSheet(Intrinsics.stringPlus((String)"", (Object)subTitle2.hashCode()));
        }
        pExport2Excel.sheet = charSequence;
        int n = 0;
        int e = this.getColumnCount();
        while (n < e) {
            int i = n++;
            Sheet sheet = this.sheet;
            Intrinsics.checkNotNull((Object)sheet);
            sheet.setColumnWidth(i, (int)this.widths[i]);
        }
        Sheet sheet = this.sheet;
        if (sheet != null) {
            sheet.setRepeatingColumns(new CellRangeAddress(-1, -1, 0, this.getColumnCount() - 1));
        }
        Sheet sheet2 = this.sheet;
        if (sheet2 != null) {
            sheet2.setRepeatingRows(new CellRangeAddress(0, 0, -1, -1));
        }
        Sheet sheet3 = this.sheet;
        Intrinsics.checkNotNull((Object)sheet3);
        Footer footer = sheet3.getFooter();
        Sheet sheet4 = this.sheet;
        Intrinsics.checkNotNull((Object)sheet4);
        Header header = sheet4.getHeader();
        header.setLeft(this.getTitle() + "  " + this.getColumnLabel(0) + " : " + subTitle2);
        footer.setLeft(this.getTitle() + " - " + VlibProperties.getString("print-page") + " &P / &N ");
        footer.setRight(LocalDate.now().format(DateTimeFormatter.ofPattern("dd.MM.yyyy")) + ' ' + LocalTime.now().format(DateTimeFormatter.ofPattern("HH:mm")));
        ++this.sheetIndex;
        Sheet sheet5 = this.sheet;
        Intrinsics.checkNotNull((Object)sheet5);
        PrintSetup ps = sheet5.getPrintSetup();
        Sheet sheet6 = this.sheet;
        Intrinsics.checkNotNull((Object)sheet6);
        sheet6.setAutobreaks(true);
        ps.setFitWidth((short)1);
        ps.setFitHeight((short)999);
        ps.setLandscape(Intrinsics.areEqual((Object)this.getPrintConfig().getPaperlayout(), (Object)"Landscape"));
        ps.setPaperSize((short)9);
    }

    @Override
    protected void exportHeader(@NotNull String[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Sheet sheet = this.sheet;
        Intrinsics.checkNotNull((Object)sheet);
        Row titleRow = sheet.createRow(0);
        int cellPos = 0;
        String[] $this$forEach$iv = data;
        boolean $i$f$forEach = false;
        for (String element$iv : $this$forEach$iv) {
            String it = element$iv;
            boolean bl = false;
            int n = cellPos;
            cellPos = n + 1;
            titleRow.createCell(n).setCellValue(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void exportRow(int level, @NotNull String[] data, @NotNull Object[] orig, @NotNull int[] alignments) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)orig, (String)"orig");
        Intrinsics.checkNotNullParameter((Object)alignments, (String)"alignments");
        Sheet sheet = this.sheet;
        Intrinsics.checkNotNull((Object)sheet);
        Row row = sheet.createRow(this.rowNumber + 1);
        Color color = this.getBackgroundForLevel(level);
        int cellPos = 0;
        String[] $this$forEachIndexed$iv = data;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (String item$iv : $this$forEachIndexed$iv) {
            void element;
            int n = index$iv;
            index$iv = n + 1;
            String string = item$iv;
            int index = n;
            boolean bl = false;
            Cell cell = row.createCell(cellPos);
            Intrinsics.checkNotNullExpressionValue((Object)cell, (String)"row.createCell(cellPos)");
            Cell cell2 = cell;
            Workbook workbook = this.getWorkbook();
            Intrinsics.checkNotNull((Object)workbook);
            CellStyle cellStyle = this.cellStyleCacheManager.getStyle(this, workbook, this.getAlignment(alignments, index), this.getDataFormat(index), color);
            this.setCellValue(cell2, index, (String)element, orig[index]);
            cell2.setCellStyle(cellStyle);
            int n2 = cellPos;
            cellPos = n2 + 1;
        }
        ++this.rowNumber;
    }

    protected final void setCellValue(@NotNull Cell cell, int cellPos, @Nullable String data, @Nullable Object orig) {
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        if (data != null && orig != null) {
            if (this.datatype[cellPos] == CellType.STRING.getCode()) {
                cell.setCellValue(StringsKt.replace$default((String)data, (char)'\n', (char)' ', (boolean)false, (int)4, null));
            } else if (orig instanceof BigDecimal) {
                cell.setCellValue(((BigDecimal)orig).doubleValue());
            } else if (orig instanceof Integer) {
                if (this.datatype[cellPos] == CellType.BOOLEAN.getCode()) {
                    cell.setCellValue((double)((Number)orig).intValue() == 1.0);
                } else {
                    cell.setCellValue((double)((Number)orig).intValue());
                }
            } else if (orig instanceof Boolean) {
                cell.setCellValue(((Boolean)orig).booleanValue());
            } else if (orig instanceof LocalDate) {
                Companion.setCellValue(cell, (LocalDate)orig);
            } else if (orig instanceof org.kopi.galite.visual.type.Timestamp || orig instanceof Timestamp) {
                cell.setCellValue(data);
                this.datatype[cellPos] = CellType.STRING.getCode();
            } else if (orig instanceof Month) {
                Companion.setCellValue(cell, ((Month)orig).getFirstDay());
            } else if (orig instanceof Week) {
                Companion.setCellValue(cell, ((Week)orig).getFirstDay());
            } else if (!(orig instanceof String) || !StringsKt.isBlank((CharSequence)((CharSequence)orig))) {
                throw new InconsistencyException("Type not supported: datatype=" + this.datatype[cellPos] + "   CellNumber= " + cellPos + ' ' + orig.getClass() + " of " + orig);
            }
            cell.setCellType(CellType.forInt((int)this.datatype[cellPos]));
        } else {
            cell.setCellType(CellType.BLANK);
        }
    }

    protected final short getAlignment(@NotNull int[] alignments, int cellPos) {
        short s;
        Intrinsics.checkNotNullParameter((Object)alignments, (String)"alignments");
        switch (alignments[cellPos]) {
            case 0: 
            case 1: {
                s = HorizontalAlignment.LEFT.getCode();
                break;
            }
            case 2: {
                s = HorizontalAlignment.CENTER.getCode();
                break;
            }
            case 4: {
                s = HorizontalAlignment.RIGHT.getCode();
                break;
            }
            default: {
                throw new InconsistencyException("Unknown alignment");
            }
        }
        return s;
    }

    protected final short getDataFormat(int cellPos) {
        return this.datatype[cellPos] != CellType.STRING.getCode() ? this.dataformats[cellPos] : (short)-1;
    }

    private final int computeColumnWidth(VReportColumn column2) {
        return column2.getLabel().length() < column2.getWidth() ? column2.getWidth() : column2.getLabel().length() + 2;
    }

    @Override
    public void formatStringColumn$galite_core(@NotNull VReportColumn column2, int index) {
        Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
        this.dataformats[index] = 0;
        this.datatype[index] = CellType.STRING.getCode();
        this.widths[index] = (short)(256 * this.computeColumnWidth(column2));
    }

    @Override
    public void formatWeekColumn$galite_core(@NotNull VReportColumn column2, int index) {
        Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
        this.dataformats[index] = 0;
        this.datatype[index] = CellType.STRING.getCode();
        this.widths[index] = (short)(256 * this.computeColumnWidth(column2));
    }

    @Override
    public void formatDateColumn$galite_core(@NotNull VReportColumn column2, int index) {
        Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
        DataFormat dataFormat = this.format;
        Intrinsics.checkNotNull((Object)dataFormat);
        this.dataformats[index] = dataFormat.getFormat("dd.mm.yyyy");
        this.datatype[index] = CellType.NUMERIC.getCode();
        this.widths[index] = (short)(256 * this.computeColumnWidth(column2));
    }

    @Override
    public void formatMonthColumn$galite_core(@NotNull VReportColumn column2, int index) {
        Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
        DataFormat dataFormat = this.format;
        Intrinsics.checkNotNull((Object)dataFormat);
        this.dataformats[index] = dataFormat.getFormat("mm.yyyy");
        this.datatype[index] = CellType.NUMERIC.getCode();
        this.widths[index] = (short)(256 * this.computeColumnWidth(column2));
    }

    @Override
    public void formatDecimalColumn$galite_core(@NotNull VReportColumn column2, int index) {
        Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
        String decimalFormat = "#,##0";
        int n = 0;
        int n2 = ((VDecimalColumn)column2).getMaxScale();
        while (n < n2) {
            int i;
            decimalFormat = Intrinsics.stringPlus((String)decimalFormat, (Object)((i = n++) == 0 ? ".0" : "0"));
        }
        DataFormat dataFormat = this.format;
        Intrinsics.checkNotNull((Object)dataFormat);
        this.dataformats[index] = dataFormat.getFormat(decimalFormat);
        this.datatype[index] = CellType.NUMERIC.getCode();
        this.widths[index] = (short)(256 * this.computeColumnWidth(column2));
    }

    @Override
    public void formatIntegerColumn$galite_core(@NotNull VReportColumn column2, int index) {
        Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
        DataFormat dataFormat = this.format;
        Intrinsics.checkNotNull((Object)dataFormat);
        this.dataformats[index] = dataFormat.getFormat("0");
        this.datatype[index] = CellType.NUMERIC.getCode();
        this.widths[index] = (short)(256 * this.computeColumnWidth(column2));
    }

    @Override
    public void formatBooleanColumn$galite_core(@NotNull VReportColumn column2, int index) {
        Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
        this.dataformats[index] = 0;
        this.datatype[index] = CellType.BOOLEAN.getCode();
        this.widths[index] = (short)(256 * this.computeColumnWidth(column2));
    }

    @Override
    public void formatTimeColumn$galite_core(@NotNull VReportColumn column2, int index) {
        Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
        this.dataformats[index] = 0;
        this.datatype[index] = CellType.STRING.getCode();
        this.widths[index] = (short)(256 * this.computeColumnWidth(column2));
    }

    @Override
    public void formatTimestampColumn$galite_core(@NotNull VReportColumn column2, int index) {
        Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
        this.dataformats[index] = 0;
        this.datatype[index] = CellType.STRING.getCode();
        this.widths[index] = (short)(256 * this.computeColumnWidth(column2));
    }

    @Nullable
    protected abstract Workbook createWorkbook();

    @Nullable
    public abstract org.apache.poi.ss.usermodel.Color createFillForegroundColor(@NotNull Color var1);

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0004\u00a8\u0006\t"}, d2={"Lorg/kopi/galite/visual/report/PExport2Excel$Companion;", "", "()V", "setCellValue", "", "cell", "Lorg/apache/poi/ss/usermodel/Cell;", "value", "Ljava/time/LocalDate;", "galite-core"})
    public static final class Companion {
        private Companion() {
        }

        protected final void setCellValue(@NotNull Cell cell, @NotNull LocalDate value) {
            Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            GregorianCalendar cal = new GregorianCalendar();
            cal.clear();
            cal.set(1, value.getYear());
            cal.set(2, value.getMonthValue() - 1);
            cal.set(5, value.getDayOfMonth());
            cell.setCellValue((Calendar)cal);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

