/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.ui.vaadin.field;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.ui.vaadin.field.AllowAllValidator;
import org.kopi.galite.visual.ui.vaadin.field.CheckTypeException;
import org.kopi.galite.visual.ui.vaadin.field.InputTextField;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0000\u0018\u00002\u00020\u0001B#\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\u0014"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/field/IntegerValidator;", "Lorg/kopi/galite/visual/ui/vaadin/field/AllowAllValidator;", "minval", "", "maxval", "maxLength", "", "(Ljava/lang/Double;Ljava/lang/Double;I)V", "(Ljava/lang/Integer;Ljava/lang/Integer;I)V", "Ljava/lang/Integer;", "checkType", "", "field", "Lorg/kopi/galite/visual/ui/vaadin/field/InputTextField;", "text", "", "validate", "", "c", "", "galite-core"})
public final class IntegerValidator
extends AllowAllValidator {
    @Nullable
    private final Integer minval;
    @Nullable
    private final Integer maxval;

    public IntegerValidator(@Nullable Integer minval, @Nullable Integer maxval, int maxLength) {
        super(maxLength);
        this.minval = minval;
        this.maxval = maxval;
    }

    public IntegerValidator(@Nullable Double minval, @Nullable Double maxval, int maxLength) {
        Double d = minval;
        Double d2 = maxval;
        this(d == null ? null : Integer.valueOf((int)d.doubleValue()), d2 == null ? null : Integer.valueOf((int)d2.doubleValue()), maxLength);
    }

    @Override
    public boolean validate(char c) {
        return Character.isDigit(c) || c == '.' || c == '-';
    }

    @Override
    public void checkType(@NotNull InputTextField<?> field, @NotNull String text) {
        Intrinsics.checkNotNullParameter(field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (Intrinsics.areEqual((Object)"", (Object)text)) {
            field.setValue(null);
        } else {
            int n;
            try {
                n = Integer.parseInt(text);
            }
            catch (NumberFormatException e) {
                throw new CheckTypeException(field, "00006");
            }
            int v = n;
            if (this.minval != null && v < this.minval) {
                Object[] objectArray = new Object[]{this.minval};
                throw new CheckTypeException(field, "00012", objectArray);
            }
            if (this.maxval != null && v > this.maxval) {
                Object[] objectArray = new Object[]{this.maxval};
                throw new CheckTypeException(field, "00009", objectArray);
            }
            field.setValue(text);
        }
    }
}

