/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.ui.vaadin.field;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.KeyNotifier;
import com.vaadin.flow.component.textfield.TextField;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.type.DateKt;
import org.kopi.galite.visual.ui.vaadin.field.DatePickerLight;
import org.kopi.galite.visual.ui.vaadin.field.InputTextField;
import org.kopi.galite.visual.ui.vaadin.field.TimestampValidator;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J)\u0010\u0005\u001a\u00020\u00062!\u0010\u0007\u001a\u001d\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\u00060\bJ\u0012\u0010\r\u001a\u00020\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0014\u00a8\u0006\u0010"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/field/VDateField;", "Lorg/kopi/galite/visual/ui/vaadin/field/InputTextField;", "Lorg/kopi/galite/visual/ui/vaadin/field/DatePickerLight;", "Lcom/vaadin/flow/component/KeyNotifier;", "()V", "addDateValueChangeListener", "", "listener", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "fromClient", "setPresentationValue", "newPresentationValue", "", "galite-core"})
public final class VDateField
extends InputTextField<DatePickerLight>
implements KeyNotifier {
    public VDateField() {
        super((AbstractField)new DatePickerLight());
    }

    public final void addDateValueChangeListener(@NotNull Function1<? super Boolean, Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        ((DatePickerLight)((Object)this.getInternalField())).addValueChangeListener((HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<TextField, String>>)new HasValue.ValueChangeListener(listener){
            final /* synthetic */ Function1<Boolean, Unit> $listener;
            {
                this.$listener = $listener;
            }

            public final void valueChanged(AbstractField.ComponentValueChangeEvent<TextField, String> it) {
                this.$listener.invoke((Object)it.isFromClient());
            }
        });
        ((DatePickerLight)((Object)this.getInternalField())).addPickerListener((ComponentEventListener<DatePickerLight.ValueChanged>)new ComponentEventListener(this, listener){
            final /* synthetic */ VDateField this$0;
            final /* synthetic */ Function1<Boolean, Unit> $listener;
            {
                this.this$0 = $receiver;
                this.$listener = $listener;
            }

            public final void onComponentEvent(DatePickerLight.ValueChanged it) {
                if (((CharSequence)it.getValue()).length() > 0) {
                    LocalDate localDate = LocalDate.parse(it.getValue(), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                    Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"parse(it.value, DateTime\u2026.ofPattern(\"yyyy-MM-dd\"))");
                    String date = DateKt.format(localDate);
                    if (!Intrinsics.areEqual((Object)((DatePickerLight)this.this$0.getContent()).getValue(), (Object)date)) {
                        ((DatePickerLight)this.this$0.getContent()).setValue(date);
                    }
                }
                this.$listener.invoke((Object)it.isFromClient());
            }
        });
    }

    @Override
    protected void setPresentationValue(@Nullable String newPresentationValue) {
        String string;
        String string2;
        String string3 = newPresentationValue;
        if (string3 == null) {
            string3 = "";
        }
        LocalDate date = TimestampValidator.Companion.parseDate(string3);
        DatePickerLight datePickerLight = (DatePickerLight)this.getContent();
        LocalDate localDate = date;
        String string4 = string2 = localDate == null ? null : DateKt.format(localDate);
        if (string2 == null) {
            string = newPresentationValue;
            if (string == null) {
                string = "";
            }
        } else {
            string = string2;
        }
        datePickerLight.setValue(string);
    }
}

