/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.vkopi.lib.ui.swing.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.base.UComponent;
import org.kopi.galite.visual.form.Alignment;
import org.kopi.galite.visual.form.LayoutManager;
import org.kopi.galite.visual.form.UMultiBlock;
import org.kopi.galite.visual.form.VBlock;
import org.kopi.galite.visual.form.VField;
import org.kopi.galite.visual.form.ViewBlockAlignment;
import org.kopi.galite.visual.visual.VRuntimeException;
import org.kopi.vkopi.lib.ui.swing.form.DChartBlock;
import org.kopi.vkopi.lib.ui.swing.form.DForm;
import org.kopi.vkopi.lib.ui.swing.form.KopiMultiBlockLayout;
import org.kopi.vkopi.lib.ui.swing.form.KopiSimpleBlockLayout;

public class DMultiBlock
extends DChartBlock
implements UMultiBlock {
    private final JLayeredPane layeredPane = new JLayeredPane(){
        private static final long serialVersionUID = -3239511954723094795L;

        @Override
        public Dimension getPreferredSize() {
            Dimension dim1 = DMultiBlock.this.chartPane.getPreferredSize();
            Dimension dim2 = DMultiBlock.this.detailLayerPane.getPreferredSize();
            Dimension dim = new Dimension();
            dim.width = Math.max(dim1.width, dim2.width);
            dim.height = Math.max(dim1.height, dim2.height);
            return dim;
        }

        @Override
        public void setBounds(int x, int y, int w, int h) {
            super.setBounds(x, y, w, h);
            DMultiBlock.this.chartPane.setBounds(0, 0, w, h);
            DMultiBlock.this.detailLayerPane.setBounds(0, 0, w, h);
        }
    };
    private JPanel chartPane;
    private JPanel detailPane;
    private JPanel detailLayerPane;
    private LayoutManager detailLayout;
    private LayoutManager chartLayout;

    public DMultiBlock(DForm form, VBlock model2) {
        super(form, model2);
        this.chartPane.setOpaque(true);
        this.detailLayerPane = new JPanel(new BorderLayout());
        this.detailLayerPane.setOpaque(true);
        this.detailPane.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.detailLayerPane.setBorder(this.border);
        this.detailLayerPane.add((Component)this.detailPane, "Center");
        this.layeredPane.add(this.chartPane, new Integer(2), 0);
        this.layeredPane.add(this.detailLayerPane, new Integer(1), 0);
        this.setLayout(new BorderLayout());
        super.add((Component)this.layeredPane, "Center");
        int displaySize = this.getModel().getDisplaySize();
        for (int i = 0; i < displaySize + 1; ++i) {
            this.chartPane.add((Component)new JLabel(""), new Alignment(0, i, 1, 1, false));
        }
    }

    @Override
    protected void createFields() {
        this.chartPane = new JPanel();
        this.detailPane = new JPanel();
        this.detailLayout = new KopiSimpleBlockLayout(2 * this.maxColumnPos, this.maxRowPos, this.model.getAlignment() == null ? null : new ViewBlockAlignment(this.getFormView(), this.model.getAlignment()));
        this.detailPane.setLayout(this.detailLayout);
        this.chartLayout = this.layout = new KopiMultiBlockLayout(this.displayedFields + 1, this.getModel().getDisplaySize() + 1);
        this.chartPane.setLayout(this.layout);
        super.createFields();
    }

    @Override
    public boolean inDetailMode() {
        return this.getModel().isDetailMode();
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return null;
    }

    @Override
    protected void addScrollBar(JScrollBar bar) {
        this.chartPane.add(bar);
    }

    public void addToChart(Component c, Object o) {
        this.chartPane.add(c, o);
    }

    @Override
    public void addToDetail(@Nullable UComponent comp, @NotNull Alignment constraint) {
        this.detailPane.add((Component)((Object)comp), constraint);
    }

    @Override
    public void switchView(int row) {
        if (this.getModel().getForm().getActiveBlock() != this.getModel()) {
            if (!this.getModel().isAccessible()) {
                return;
            }
            try {
                this.getModel().getForm().gotoBlock(this.getModel());
            }
            catch (Exception ex) {
                ((DForm)this.getFormView()).reportError(new VRuntimeException(ex.getMessage(), ex));
                return;
            }
        }
        if (row >= 0) {
            this.getModel().gotoRecord(this.getRecordFromDisplayLine(row));
        }
        if (this.getModel().isDetailMode()) {
            this.getModel().setDetailMode(false);
            this.layout = this.chartLayout;
        } else {
            this.getModel().setDetailMode(true);
            this.layout = this.detailLayout;
        }
    }

    @Override
    public void add(UComponent comp, Alignment constraints) {
        this.chartPane.add((Component)((Object)comp), constraints);
    }

    @Override
    public void blockViewModeLeaved(VBlock block, VField activeField) {
        if (activeField != null) {
            activeField.leave(true);
        }
    }

    @Override
    public void blockViewModeEntered(VBlock block, VField activeField) {
        if (this.inDetailMode()) {
            if (activeField != null) {
                if (!activeField.noDetail()) {
                    activeField.enter();
                } else {
                    block.setActiveField(activeField);
                    this.getModel().gotoNextField();
                }
            }
            this.layeredPane.setLayer(this.chartPane, 1, 0);
            this.layeredPane.setLayer(this.detailLayerPane, 2, 0);
        } else {
            if (activeField != null) {
                if (!activeField.noChart()) {
                    activeField.enter();
                } else {
                    block.setActiveField(activeField);
                    this.getModel().gotoNextField();
                }
            }
            this.layeredPane.setLayer(this.chartPane, 2, 0);
            this.layeredPane.setLayer(this.detailLayerPane, 1, 0);
        }
    }
}

