/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.vkopi.lib.ui.swing.form;

import java.awt.Color;
import java.awt.Toolkit;
import java.text.DecimalFormatSymbols;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.kopi.galite.visual.form.ModelTransformer;
import org.kopi.galite.visual.form.VDecimalField;
import org.kopi.galite.visual.form.VField;
import org.kopi.galite.visual.util.base.InconsistencyException;
import org.kopi.galite.visual.visual.ApplicationContext;
import org.kopi.vkopi.lib.ui.swing.form.KopiDocument;

class KopiFieldDocument
extends PlainDocument
implements KopiDocument {
    private int state;
    private boolean alert;
    private boolean autofill = false;
    private boolean hasCriticalValue;
    private boolean hasAction;
    private Color bgColor;
    private VField model;
    private ModelTransformer transformer;

    public KopiFieldDocument(VField model2, ModelTransformer transformer) {
        this.model = model2;
        this.transformer = transformer;
    }

    @Override
    public synchronized String getModelText() {
        try {
            String text = this.getText(0, this.getLength());
            return this.transformer.toModel(text);
        }
        catch (BadLocationException e) {
            throw new InconsistencyException("BadLocationException in KopiFieldDocument");
        }
    }

    @Override
    public synchronized void setModelText(String s) {
        try {
            super.remove(0, this.getLength());
            s = this.transformer.toGui(s);
            super.insertString(0, s, null);
        }
        catch (BadLocationException e) {
            throw new InconsistencyException("BadLocationException in KopiFieldDocument");
        }
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        String text = this.getText(0, this.getLength());
        text = text.substring(0, offs) + text.substring(offs + len);
        if (!this.transformer.checkFormat(text = this.transformer.toModel(text))) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        if (this.model.checkText(text)) {
            super.remove(offs, len);
            this.model.onTextChange(this.getText(0, this.getLength()));
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        DecimalFormatSymbols symbols;
        if (str == null) {
            return;
        }
        if (this.model instanceof VDecimalField && str.equals(".") && (symbols = new DecimalFormatSymbols(ApplicationContext.Companion.getDefaultLocale())).getDecimalSeparator() != '.') {
            str = str.replace('.', symbols.getDecimalSeparator());
        }
        String text = this.getText(0, this.getLength());
        text = text.substring(0, offs) + str + text.substring(offs);
        if (!this.transformer.checkFormat(text = this.transformer.toModel(text))) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        if (this.model.checkText(text)) {
            super.insertString(offs, str, a);
            this.model.onTextChange(this.getText(0, this.getLength()));
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    @Override
    public Object getModel() {
        return this.model;
    }

    @Override
    public void setState(int state) {
        this.state = state;
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public void setHasCriticalValue(boolean hasCriticalValue) {
        this.hasCriticalValue = hasCriticalValue;
    }

    @Override
    public boolean hasCriticalValue() {
        return this.hasCriticalValue;
    }

    @Override
    public void setHasAction(boolean hasAction) {
        this.hasAction = hasAction;
    }

    @Override
    public boolean hasAction() {
        return this.hasAction;
    }

    @Override
    public void setBgColor(Color bgColor) {
        this.bgColor = bgColor;
    }

    @Override
    public Color getBgColor() {
        return this.bgColor;
    }

    @Override
    public void setAlert(boolean alert) {
        this.alert = alert;
    }

    @Override
    public boolean isAlert() {
        return this.alert;
    }

    @Override
    public boolean getAutofill() {
        return this.autofill;
    }

    @Override
    public void setAutofill(boolean autofill) {
        this.autofill = autofill;
    }
}

