/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.l10n;

import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jdom2.Document;
import org.jdom2.input.SAXBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.l10n.ActorLocalizer;
import org.kopi.galite.visual.l10n.BlockLocalizer;
import org.kopi.galite.visual.l10n.ChartLocalizer;
import org.kopi.galite.visual.l10n.FormLocalizer;
import org.kopi.galite.visual.l10n.ListLocalizer;
import org.kopi.galite.visual.l10n.MenuLocalizer;
import org.kopi.galite.visual.l10n.MessageLocalizer;
import org.kopi.galite.visual.l10n.ModuleLocalizer;
import org.kopi.galite.visual.l10n.PropertyLocalizer;
import org.kopi.galite.visual.l10n.ReportLocalizer;
import org.kopi.galite.visual.l10n.TypeLocalizer;
import org.kopi.galite.visual.util.base.InconsistencyException;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000f\u001a\u00020\bJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\bJ\u0010\u0010\u0012\u001a\u00020\u00132\b\u0010\u000e\u001a\u0004\u0018\u00010\bJ\u0012\u0010\u0014\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\b\u0010\u000e\u001a\u0004\u0018\u00010\bJ\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\bJ\u0018\u0010\u0019\u001a\u00020\u001a2\b\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000f\u001a\u00020\bJ\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\bJ\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\bJ\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010\u000e\u001a\u00020\bJ\u0016\u0010\u001f\u001a\u00020 2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\bJ\u0010\u0010!\u001a\u00020\"2\b\u0010\u000e\u001a\u0004\u0018\u00010\bJ\u001a\u0010#\u001a\u00020$2\b\u0010\u000e\u001a\u0004\u0018\u00010\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\bJ\u0012\u0010%\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\bH\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006&"}, d2={"Lorg/kopi/galite/visual/l10n/LocalizationManager;", "", "locale", "Ljava/util/Locale;", "defaultLocale", "(Ljava/util/Locale;Ljava/util/Locale;)V", "documents", "Ljava/util/Hashtable;", "", "Lorg/jdom2/Document;", "getLocale", "()Ljava/util/Locale;", "getActorLocalizer", "Lorg/kopi/galite/visual/l10n/ActorLocalizer;", "source", "name", "getBlockLocalizer", "Lorg/kopi/galite/visual/l10n/BlockLocalizer;", "getChartLocalizer", "Lorg/kopi/galite/visual/l10n/ChartLocalizer;", "getDocument", "getFormLocalizer", "Lorg/kopi/galite/visual/l10n/FormLocalizer;", "getListLocalizer", "Lorg/kopi/galite/visual/l10n/ListLocalizer;", "getMenuLocalizer", "Lorg/kopi/galite/visual/l10n/MenuLocalizer;", "getMessageLocalizer", "Lorg/kopi/galite/visual/l10n/MessageLocalizer;", "getModuleLocalizer", "Lorg/kopi/galite/visual/l10n/ModuleLocalizer;", "getPropertyLocalizer", "Lorg/kopi/galite/visual/l10n/PropertyLocalizer;", "getReportLocalizer", "Lorg/kopi/galite/visual/l10n/ReportLocalizer;", "getTypeLocalizer", "Lorg/kopi/galite/visual/l10n/TypeLocalizer;", "loadDocument", "galite-core"})
public final class LocalizationManager {
    @Nullable
    private final Locale locale;
    @Nullable
    private final Locale defaultLocale;
    @NotNull
    private final Hashtable<String, Document> documents;

    public LocalizationManager(@Nullable Locale locale, @Nullable Locale defaultLocale) {
        this.locale = locale;
        this.defaultLocale = defaultLocale;
        this.documents = new Hashtable();
    }

    @Nullable
    public final Locale getLocale() {
        return this.locale;
    }

    @NotNull
    public final FormLocalizer getFormLocalizer(@Nullable String source) {
        return new FormLocalizer(this.getDocument(source));
    }

    @NotNull
    public final BlockLocalizer getBlockLocalizer(@NotNull String source, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new BlockLocalizer(this, this.getDocument(source), name);
    }

    @NotNull
    public final ActorLocalizer getActorLocalizer(@Nullable String source, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new ActorLocalizer(this.getDocument(source), name);
    }

    @NotNull
    public final MenuLocalizer getMenuLocalizer(@Nullable String source, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new MenuLocalizer(this.getDocument(source), name);
    }

    @NotNull
    public final ListLocalizer getListLocalizer(@NotNull String source, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new ListLocalizer(this, this.getDocument(source), name);
    }

    @NotNull
    public final TypeLocalizer getTypeLocalizer(@Nullable String source, @Nullable String name) {
        return new TypeLocalizer(this, this.getDocument(source), name);
    }

    @NotNull
    public final ReportLocalizer getReportLocalizer(@Nullable String source) {
        return new ReportLocalizer(this, this.getDocument(source));
    }

    @NotNull
    public final ChartLocalizer getChartLocalizer(@Nullable String source) {
        return new ChartLocalizer(this, this.getDocument(source));
    }

    @NotNull
    public final ModuleLocalizer getModuleLocalizer(@NotNull String source, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new ModuleLocalizer(this.getDocument(source), name);
    }

    @NotNull
    public final MessageLocalizer getMessageLocalizer(@NotNull String source, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new MessageLocalizer(this.getDocument(source), name);
    }

    @NotNull
    public final PropertyLocalizer getPropertyLocalizer(@NotNull String source, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new PropertyLocalizer(this.getDocument(source), name);
    }

    @NotNull
    public final PropertyLocalizer getPropertyLocalizer(@NotNull String source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return new PropertyLocalizer(this.getDocument(source));
    }

    private final Document getDocument(String source) {
        if (!this.documents.containsKey(source)) {
            Map map = this.documents;
            Document document = this.loadDocument(source);
            map.put(source, document);
        }
        Document document = this.documents.get(source);
        if (document == null) {
            throw new InconsistencyException(Intrinsics.stringPlus((String)"Cannot find document for ", (Object)source));
        }
        return document;
    }

    private final Document loadDocument(String source) {
        String fileName = null;
        Document document = null;
        SAXBuilder builder = new SAXBuilder();
        StringBuilder stringBuilder = new StringBuilder();
        String string = source;
        Intrinsics.checkNotNull((Object)string);
        fileName = stringBuilder.append(StringsKt.replace$default((String)string, (char)'.', (char)'/', (boolean)false, (int)4, null)).append('-').append(this.locale).append(".xml").toString();
        try {
            Document document2 = builder.build(LocalizationManager.class.getClassLoader().getResourceAsStream(fileName));
            Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"builder.build(Localizati\u2026sourceAsStream(fileName))");
            document = document2;
        }
        catch (Exception localeException) {
            if (this.defaultLocale == null) {
                throw new InconsistencyException("Cannot load file " + fileName + localeException.getMessage());
            }
            System.err.println("Warning: Cannot load file " + fileName + ": " + localeException.getMessage());
            try {
                fileName = StringsKt.replace$default((String)source, (char)'.', (char)'/', (boolean)false, (int)4, null) + '-' + this.defaultLocale + ".xml";
                Document document3 = builder.build(LocalizationManager.class.getClassLoader().getResourceAsStream(fileName));
                Intrinsics.checkNotNullExpressionValue((Object)document3, (String)"builder.build(Localizati\u2026sourceAsStream(fileName))");
                document = document3;
            }
            catch (Exception defaultLocaleException) {
                throw new InconsistencyException("Cannot load file " + fileName + ": " + defaultLocaleException.getMessage());
            }
        }
        document.setBaseURI(fileName);
        return document;
    }
}

