/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.ui.vaadin.form;

import java.io.Serializable;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.form.VBlock;
import org.kopi.galite.visual.form.VField;
import org.kopi.galite.visual.ui.vaadin.form.GridBlockItem;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0005B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/form/DGridBlockItemSorter;", "", "model", "Lorg/kopi/galite/visual/form/VBlock;", "(Lorg/kopi/galite/visual/form/VBlock;)V", "DefaultComparator", "galite-core"})
public final class DGridBlockItemSorter {
    @NotNull
    private final VBlock model;

    public DGridBlockItemSorter(@NotNull VBlock model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        this.model = model2;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u00032\u00020\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00022\b\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fH\u0002R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0015"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/form/DGridBlockItemSorter$DefaultComparator;", "Ljava/util/Comparator;", "Lorg/kopi/galite/visual/ui/vaadin/form/GridBlockItem;", "Lkotlin/Comparator;", "Ljava/io/Serializable;", "model", "Lorg/kopi/galite/visual/form/VBlock;", "field", "Lorg/kopi/galite/visual/form/VField;", "(Lorg/kopi/galite/visual/form/VBlock;Lorg/kopi/galite/visual/form/VField;)V", "getField", "()Lorg/kopi/galite/visual/form/VField;", "getModel", "()Lorg/kopi/galite/visual/form/VBlock;", "compare", "", "o1", "o2", "isSortedRecordFilled", "", "rec", "galite-core"})
    public static final class DefaultComparator
    implements Comparator<GridBlockItem>,
    Serializable {
        @NotNull
        private final VBlock model;
        @NotNull
        private final VField field;

        public DefaultComparator(@NotNull VBlock model2, @NotNull VField field) {
            Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            this.model = model2;
            this.field = field;
        }

        @NotNull
        public final VBlock getModel() {
            return this.model;
        }

        @NotNull
        public final VField getField() {
            return this.field;
        }

        @Override
        public int compare(@Nullable GridBlockItem o1, @Nullable GridBlockItem o2) {
            int n;
            GridBlockItem gridBlockItem = o1;
            Intrinsics.checkNotNull((Object)gridBlockItem);
            int n2 = gridBlockItem.getRecord();
            GridBlockItem gridBlockItem2 = o2;
            Intrinsics.checkNotNull((Object)gridBlockItem2);
            boolean ascendantSortDirection = n2 > gridBlockItem2.getRecord();
            Pair pair = ascendantSortDirection ? TuplesKt.to((Object)this.model.getSortedPosition(o1.getRecord()), (Object)this.model.getSortedPosition(o2.getRecord())) : TuplesKt.to((Object)this.model.getSortedPosition(o2.getRecord()), (Object)this.model.getSortedPosition(o1.getRecord()));
            int rec1 = ((Number)pair.component1()).intValue();
            int rec2 = ((Number)pair.component2()).intValue();
            Object item1 = new GridBlockItem(o1.getRecord()).getValue(this.field);
            Object item2 = new GridBlockItem(o2.getRecord()).getValue(this.field);
            if (this.isSortedRecordFilled(rec1) && this.isSortedRecordFilled(rec2)) {
                if (item1 != null && item2 != null) {
                    n = ((Comparable)item1).compareTo(item2);
                } else if (Intrinsics.areEqual((Object)item1, (Object)item2)) {
                    n = 0;
                } else {
                    Object item;
                    Object object = item = ascendantSortDirection ? item2 : item1;
                    n = item == null ? -1 : 1;
                }
            } else {
                n = !this.isSortedRecordFilled(rec1) && !this.isSortedRecordFilled(rec2) ? Intrinsics.compare((int)rec1, (int)rec2) : (this.isSortedRecordFilled(rec1) ? -1 : 1);
            }
            return n;
        }

        private final boolean isSortedRecordFilled(int rec) {
            return this.model.isRecordChanged(this.model.getDataPosition(rec)) || this.model.isRecordFetched(this.model.getDataPosition(rec));
        }
    }
}

