/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.ui.vaadin.form;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.data.binder.Result;
import com.vaadin.flow.data.binder.ValueContext;
import com.vaadin.flow.data.converter.Converter;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.form.ModelTransformer;
import org.kopi.galite.visual.form.UTextField;
import org.kopi.galite.visual.form.VCodeField;
import org.kopi.galite.visual.form.VDateField;
import org.kopi.galite.visual.form.VDecimalField;
import org.kopi.galite.visual.form.VField;
import org.kopi.galite.visual.form.VFieldUI;
import org.kopi.galite.visual.form.VIntegerField;
import org.kopi.galite.visual.form.VMonthField;
import org.kopi.galite.visual.form.VStringField;
import org.kopi.galite.visual.form.VTimeField;
import org.kopi.galite.visual.form.VTimestampField;
import org.kopi.galite.visual.form.VWeekField;
import org.kopi.galite.visual.type.DefaultFormatKt;
import org.kopi.galite.visual.ui.vaadin.base.BackgroundThreadHandler;
import org.kopi.galite.visual.ui.vaadin.form.DGridEditorField;
import org.kopi.galite.visual.ui.vaadin.form.DGridEditorLabel;
import org.kopi.galite.visual.ui.vaadin.grid.GridEditorDateField;
import org.kopi.galite.visual.ui.vaadin.grid.GridEditorDecimalField;
import org.kopi.galite.visual.ui.vaadin.grid.GridEditorEnumField;
import org.kopi.galite.visual.ui.vaadin.grid.GridEditorField;
import org.kopi.galite.visual.ui.vaadin.grid.GridEditorIntegerField;
import org.kopi.galite.visual.ui.vaadin.grid.GridEditorMonthField;
import org.kopi.galite.visual.ui.vaadin.grid.GridEditorTextAreaField;
import org.kopi.galite.visual.ui.vaadin.grid.GridEditorTextField;
import org.kopi.galite.visual.ui.vaadin.grid.GridEditorTimeField;
import org.kopi.galite.visual.ui.vaadin.grid.GridEditorTimestampField;
import org.kopi.galite.visual.ui.vaadin.grid.GridEditorWeekField;
import org.kopi.galite.visual.visual.VException;
import org.kopi.galite.visual.visual.VlibProperties;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0003LMNB'\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u001a\u0010\u0017\u001a\u00020\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0019\u001a\u00020\rH\u0002J\u0016\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001bH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020 H\u0014J\b\u0010!\u001a\u00020 H\u0002J\b\u0010\"\u001a\u00020#H\u0002J\b\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020)H\u0002J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00020+H\u0016J\b\u0010,\u001a\u00020 H\u0002J\b\u0010-\u001a\u00020.H\u0002J\b\u0010/\u001a\u000200H\u0002J\b\u00101\u001a\u000202H\u0002J\b\u00103\u001a\u000204H\u0002J\b\u00105\u001a\u00020\u0016H\u0002J\u0014\u00106\u001a\u0004\u0018\u00010\u001c2\b\u00107\u001a\u0004\u0018\u00010\u001cH\u0016J\n\u00108\u001a\u0004\u0018\u00010\u001cH\u0016J\n\u00109\u001a\u0004\u0018\u00010\u0002H\u0016J\u001c\u0010:\u001a\u00020\r2\b\u0010;\u001a\u0004\u0018\u00010\u00022\b\u0010<\u001a\u0004\u0018\u00010\u0002H\u0002J\b\u0010=\u001a\u00020\u0016H\u0002J\b\u0010>\u001a\u00020\u0016H\u0002J\b\u0010?\u001a\u00020\u0016H\u0016J\b\u0010@\u001a\u00020\u0016H\u0016J\u0010\u0010A\u001a\u00020\u00162\u0006\u0010B\u001a\u00020\rH\u0016J\u0010\u0010C\u001a\u00020\u00162\u0006\u0010D\u001a\u00020\rH\u0016J\b\u0010E\u001a\u00020\u0016H\u0016J\b\u0010F\u001a\u00020\u0016H\u0016J \u0010G\u001a\u00020\u00162\u0018\u0010H\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020J\u0012\u0004\u0012\u00020\u00020IJ\u0012\u0010G\u001a\u00020\u00162\b\u0010K\u001a\u0004\u0018\u00010\u0002H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u00028TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006O"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/form/DGridTextEditorField;", "Lorg/kopi/galite/visual/ui/vaadin/form/DGridEditorField;", "", "Lorg/kopi/galite/visual/form/UTextField;", "columnView", "Lorg/kopi/galite/visual/form/VFieldUI;", "label", "Lorg/kopi/galite/visual/ui/vaadin/form/DGridEditorLabel;", "align", "", "options", "(Lorg/kopi/galite/visual/form/VFieldUI;Lorg/kopi/galite/visual/ui/vaadin/form/DGridEditorLabel;II)V", "inside", "", "nullRepresentation", "getNullRepresentation", "()Ljava/lang/String;", "scanner", "selectionAfterUpdateDisabled", "transformer", "Lorg/kopi/galite/visual/form/ModelTransformer;", "addSelectionFocusListener", "", "checkText", "s", "changed", "createConverter", "Lcom/vaadin/flow/data/converter/Converter;", "", "createDateEditorField", "Lorg/kopi/galite/visual/ui/vaadin/grid/GridEditorDateField;", "createEditor", "Lorg/kopi/galite/visual/ui/vaadin/grid/GridEditorTextField;", "createEditorField", "createEnumEditorField", "Lorg/kopi/galite/visual/ui/vaadin/grid/GridEditorEnumField;", "createFixnumEditorField", "Lorg/kopi/galite/visual/ui/vaadin/grid/GridEditorDecimalField;", "createIntegerEditorField", "Lorg/kopi/galite/visual/ui/vaadin/grid/GridEditorIntegerField;", "createMonthEditorField", "Lorg/kopi/galite/visual/ui/vaadin/grid/GridEditorMonthField;", "createRenderer", "Lcom/vaadin/flow/data/renderer/Renderer;", "createStringEditorField", "createTextEditorField", "Lorg/kopi/galite/visual/ui/vaadin/grid/GridEditorTextAreaField;", "createTimeEditorField", "Lorg/kopi/galite/visual/ui/vaadin/grid/GridEditorTimeField;", "createTimestampEditorField", "Lorg/kopi/galite/visual/ui/vaadin/grid/GridEditorTimestampField;", "createWeekEditorField", "Lorg/kopi/galite/visual/ui/vaadin/grid/GridEditorWeekField;", "enterMe", "format", "input", "getObject", "getText", "isChanged", "oldText", "newText", "leaveMe", "reInstallSelectionFocusListener", "removeSelectionFocusListener", "reset", "setHasCriticalValue", "b", "setSelectionAfterUpdateDisabled", "disable", "updateFocus", "updateText", "valueChanged", "event", "Lcom/vaadin/flow/component/AbstractField$ComponentValueChangeEvent;", "Lorg/kopi/galite/visual/ui/vaadin/grid/GridEditorField;", "oldValue", "DefaultTransformer", "NewlineTransformer", "ScannerTransformer", "galite-core"})
public final class DGridTextEditorField
extends DGridEditorField<String>
implements UTextField {
    private boolean inside;
    private boolean scanner;
    private boolean selectionAfterUpdateDisabled;
    @NotNull
    private ModelTransformer transformer;

    public DGridTextEditorField(@NotNull VFieldUI columnView, @Nullable DGridEditorLabel label, int align, int options) {
        Intrinsics.checkNotNullParameter((Object)columnView, (String)"columnView");
        super(columnView, label, align, options);
        this.scanner = (options & 1) != 0 && this.getModel().getHeight() > 1;
        this.transformer = this.getModel().getHeight() == 1 || !this.scanner && (this.getModel().getTypeOptions() & 0x10000) > 0 ? (ModelTransformer)new DefaultTransformer(this.getModel().getWidth(), this.getModel().getHeight()) : (!this.scanner ? (ModelTransformer)new NewlineTransformer(this.getModel().getWidth(), this.getModel().getHeight()) : (ModelTransformer)new ScannerTransformer(this.getEditor()));
        this.getEditor().addValueChangeListener(new HasValue.ValueChangeListener(){

            public final void valueChanged(@NotNull AbstractField.ComponentValueChangeEvent<GridEditorField<String>, String> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                DGridTextEditorField.this.valueChanged(p0);
            }
        });
    }

    public final void valueChanged(@NotNull AbstractField.ComponentValueChangeEvent<GridEditorField<String>, String> event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        if (event.isFromClient()) {
            this.checkText(((String)event.getValue()).toString(), true);
        }
    }

    @Override
    public void valueChanged(@Nullable String oldValue) {
        this.checkText((String)this.getEditor().getValue(), this.isChanged(oldValue, (String)this.getEditor().getValue()));
    }

    @Override
    @Nullable
    public Object getObject() {
        return this.getEditor().getValue();
    }

    @Override
    public void updateText() {
        String newModelTxt = this.getModel().getText(this.getBlockView().getRecordFromDisplayLine(this.getPosition()));
        BackgroundThreadHandler.INSTANCE.access(this.getCurrentUI(), (Function0<Unit>)((Function0)new Function0<Unit>(this, newModelTxt){
            final /* synthetic */ DGridTextEditorField this$0;
            final /* synthetic */ String $newModelTxt;
            {
                this.this$0 = $receiver;
                this.$newModelTxt = $newModelTxt;
                super(0);
            }

            public final void invoke() {
                String string;
                this.this$0.getEditor().setValue((string = DGridTextEditorField.access$getTransformer$p(this.this$0).toGui(this.$newModelTxt)) == null ? null : ((Object)StringsKt.trim((CharSequence)string)).toString());
            }
        }));
        if (this.modelHasFocus() && !this.selectionAfterUpdateDisabled) {
            this.selectionAfterUpdateDisabled = false;
        }
    }

    @Override
    public void updateFocus() {
        if (!this.modelHasFocus()) {
            if (this.inside) {
                this.inside = false;
                this.leaveMe();
            }
        } else if (!this.inside) {
            this.inside = true;
            this.enterMe();
        }
        super.updateFocus();
    }

    @Override
    @NotNull
    protected String getNullRepresentation() {
        return "";
    }

    @Override
    public void reset() {
        this.inside = false;
        this.selectionAfterUpdateDisabled = false;
        super.reset();
    }

    @Override
    @Nullable
    public String getText() {
        String string;
        Object value = this.getEditor().getValue();
        if (value instanceof LocalDate) {
            string = DefaultFormatKt.format((LocalDate)value);
        } else if (value instanceof LocalTime) {
            string = DefaultFormatKt.format((LocalTime)value);
        } else if (value instanceof Instant) {
            string = DefaultFormatKt.format((Instant)value);
        } else if (value instanceof LocalDateTime) {
            string = DefaultFormatKt.format((LocalDateTime)value);
        } else {
            Object object = value;
            string = object == null ? null : object.toString();
        }
        return string;
    }

    @Override
    public void setHasCriticalValue(boolean b) {
    }

    @Override
    public void addSelectionFocusListener() {
    }

    @Override
    public void removeSelectionFocusListener() {
    }

    @Override
    public void setSelectionAfterUpdateDisabled(boolean disable) {
        this.selectionAfterUpdateDisabled = disable;
    }

    @NotNull
    protected GridEditorTextField createEditor() {
        GridEditorTextField editor2 = this.createEditorField();
        editor2.setAlignment(this.getColumnView$galite_core().getModel().getAlign());
        if (this.getColumnView$galite_core().hasAutofill()) {
            editor2.setAutofill();
        }
        return editor2;
    }

    @Override
    @NotNull
    public Converter<String, Object> createConverter() {
        return (Converter)new Converter<String, Object>(this){
            final /* synthetic */ DGridTextEditorField this$0;
            {
                this.this$0 = $receiver;
            }

            @Nullable
            public String convertToPresentation(@Nullable Object value, @Nullable ValueContext context) {
                return DGridTextEditorField.access$getTransformer$p(this.this$0).toGui(this.this$0.getModel().toText(value));
            }

            @NotNull
            public Result<Object> convertToModel(@Nullable String value, @Nullable ValueContext context) {
                Result result;
                try {
                    VField vField2 = this.this$0.getModel();
                    String string = DGridTextEditorField.access$getTransformer$p(this.this$0).toModel(value);
                    Intrinsics.checkNotNull((Object)string);
                    result = Result.ok((Object)vField2.toObject(string));
                    Intrinsics.checkNotNullExpressionValue((Object)result, (String)"{\n          Result.ok(ge\u2026odel(value)!!))\n        }");
                }
                catch (VException e) {
                    Result result2 = Result.error((String)e.getMessage());
                    Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"{\n          Result.error(e.message)\n        }");
                    result = result2;
                }
                return result;
            }
        };
    }

    @Override
    @NotNull
    public Renderer<String> createRenderer() {
        return (Renderer)new TextRenderer();
    }

    @Override
    @Nullable
    public Object format(@Nullable Object input) {
        return this.transformer.toGui(this.getModel().toText(input));
    }

    private final GridEditorTextField createEditorField() {
        GridEditorTextField gridEditorTextField;
        if (this.getModel() instanceof VStringField) {
            gridEditorTextField = this.getModel().getHeight() > 1 ? (GridEditorTextField)this.createTextEditorField() : this.createStringEditorField();
        } else if (this.getModel() instanceof VIntegerField) {
            gridEditorTextField = this.createIntegerEditorField();
        } else if (this.getModel() instanceof VMonthField) {
            gridEditorTextField = this.createMonthEditorField();
        } else if (this.getModel() instanceof VDateField) {
            gridEditorTextField = this.createDateEditorField();
        } else if (this.getModel() instanceof VWeekField) {
            gridEditorTextField = this.createWeekEditorField();
        } else if (this.getModel() instanceof VTimeField) {
            gridEditorTextField = this.createTimeEditorField();
        } else if (this.getModel() instanceof VCodeField) {
            gridEditorTextField = this.createEnumEditorField();
        } else if (this.getModel() instanceof VDecimalField) {
            gridEditorTextField = this.createFixnumEditorField();
        } else if (this.getModel() instanceof VTimestampField) {
            gridEditorTextField = this.createTimestampEditorField();
        } else {
            throw new IllegalArgumentException(Intrinsics.stringPlus((String)"unknown field model : ", (Object)this.getModel().getClass().getName()));
        }
        return gridEditorTextField;
    }

    private final GridEditorTextField createStringEditorField() {
        return new GridEditorTextField(this.getModel().getWidth());
    }

    private final GridEditorTextAreaField createTextEditorField() {
        boolean scanner = (this.getOptions() & 1) != 0 && this.getModel().getHeight() > 1;
        return new GridEditorTextAreaField(scanner ? 40 : this.getModel().getWidth(), this.getModel().getHeight(), ((VStringField)this.getModel()).getVisibleHeight(), !scanner && (this.getOptions() & 0x10000) > 0);
    }

    private final GridEditorIntegerField createIntegerEditorField() {
        VIntegerField model2 = (VIntegerField)this.getModel();
        return new GridEditorIntegerField(model2.getWidth(), model2.getMaxValue(), model2.getMaxValue());
    }

    private final GridEditorDecimalField createFixnumEditorField() {
        VDecimalField model2 = (VDecimalField)this.getModel();
        return new GridEditorDecimalField(model2.getWidth(), model2.getMaxValue().doubleValue(), model2.getMaxValue().doubleValue(), model2.getMaxScale(), model2.isFraction());
    }

    private final GridEditorEnumField createEnumEditorField() {
        return new GridEditorEnumField(this.getModel().getWidth(), ((VCodeField)this.getModel()).getLabels());
    }

    private final GridEditorMonthField createMonthEditorField() {
        return new GridEditorMonthField();
    }

    private final GridEditorDateField createDateEditorField() {
        return new GridEditorDateField();
    }

    private final GridEditorTimeField createTimeEditorField() {
        return new GridEditorTimeField();
    }

    private final GridEditorTimestampField createTimestampEditorField() {
        return new GridEditorTimestampField();
    }

    private final GridEditorWeekField createWeekEditorField() {
        return new GridEditorWeekField();
    }

    private final void reInstallSelectionFocusListener() {
        this.removeSelectionFocusListener();
        this.addSelectionFocusListener();
    }

    private final synchronized void leaveMe() {
        this.reInstallSelectionFocusListener();
        if (this.scanner) {
            BackgroundThreadHandler.INSTANCE.access(this.getCurrentUI(), (Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ DGridTextEditorField this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    GridEditorField<T> gridEditorField = this.this$0.getEditor();
                    ModelTransformer modelTransformer = DGridTextEditorField.access$getTransformer$p(this.this$0);
                    String string = this.this$0.getText();
                    Intrinsics.checkNotNull((Object)string);
                    gridEditorField.setValue(modelTransformer.toModel(string));
                }
            }));
        }
    }

    private final synchronized void enterMe() {
        BackgroundThreadHandler.INSTANCE.access(this.getCurrentUI(), (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ DGridTextEditorField this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                if (DGridTextEditorField.access$getScanner$p(this.this$0)) {
                    this.this$0.getEditor().setValue(DGridTextEditorField.access$getTransformer$p(this.this$0).toGui(""));
                }
                this.this$0.getEditor().focus();
            }
        }));
    }

    private final void checkText(String s, boolean changed) {
        String text = this.transformer.toModel(s);
        if (!this.transformer.checkFormat(text)) {
            return;
        }
        VField vField2 = this.getModel();
        String string = text;
        Intrinsics.checkNotNull((Object)string);
        if (vField2.checkText(string) && changed) {
            this.getModel().setChangedUI(true);
        }
        this.getModel().setChanged(changed);
    }

    private final boolean isChanged(String oldText, String newText) {
        return !Intrinsics.areEqual((Object)oldText, (Object)newText);
    }

    public static final /* synthetic */ ModelTransformer access$getTransformer$p(DGridTextEditorField $this) {
        return $this.transformer;
    }

    public static final /* synthetic */ boolean access$getScanner$p(DGridTextEditorField $this) {
        return $this.scanner;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000fH\u0016J\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\t\u00a8\u0006\u0014"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/form/DGridTextEditorField$DefaultTransformer;", "Lorg/kopi/galite/visual/form/ModelTransformer;", "col", "", "row", "(II)V", "getCol", "()I", "setCol", "(I)V", "getRow", "setRow", "checkFormat", "", "guiTxt", "", "toGui", "modelTxt", "toModel", "Companion", "galite-core"})
    public static final class DefaultTransformer
    implements ModelTransformer {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private int col;
        private int row;

        public DefaultTransformer(int col, int row) {
            this.col = col;
            this.row = row;
        }

        public final int getCol() {
            return this.col;
        }

        public final void setCol(int n) {
            this.col = n;
        }

        public final int getRow() {
            return this.row;
        }

        public final void setRow(int n) {
            this.row = n;
        }

        @Override
        @Nullable
        public String toGui(@Nullable String modelTxt) {
            return modelTxt;
        }

        @Override
        @Nullable
        public String toModel(@Nullable String guiTxt) {
            return guiTxt;
        }

        @Override
        public boolean checkFormat(@Nullable String guiTxt) {
            return this.row == 1 ? true : DefaultTransformer.Companion.convertToSingleLine(guiTxt, this.col, this.row).length() <= this.row * this.col;
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/form/DGridTextEditorField$DefaultTransformer$Companion;", "", "()V", "convertToSingleLine", "", "source", "col", "", "row", "galite-core"})
        public static final class Companion {
            private Companion() {
            }

            private final String convertToSingleLine(String source, int col, int row) {
                StringBuilder stringBuilder;
                StringBuilder $this$convertToSingleLine_u24lambda_u2d0 = stringBuilder = new StringBuilder();
                boolean bl = false;
                String string = source;
                Intrinsics.checkNotNull((Object)string);
                int length = string.length();
                int start = 0;
                while (start < length) {
                    int n;
                    int index = StringsKt.indexOf$default((CharSequence)source, (char)'\n', (int)start, (boolean)false, (int)4, null);
                    if (index - start < col && index != -1) {
                        String string2 = source.substring(start, index);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                        $this$convertToSingleLine_u24lambda_u2d0.append(string2);
                        n = index - start;
                        while (n < col) {
                            int j = n++;
                            $this$convertToSingleLine_u24lambda_u2d0.append(' ');
                        }
                        start = index + 1;
                        if (start != length) continue;
                        n = 0;
                        while (n < col) {
                            int j22 = n++;
                            $this$convertToSingleLine_u24lambda_u2d0.append(' ');
                        }
                        continue;
                    }
                    if (start + col >= length) {
                        String j22 = source.substring(start, length);
                        Intrinsics.checkNotNullExpressionValue((Object)j22, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                        $this$convertToSingleLine_u24lambda_u2d0.append(j22);
                        n = length;
                        int j22 = start + col;
                        while (n < j22) {
                            int j = n++;
                            $this$convertToSingleLine_u24lambda_u2d0.append(' ');
                        }
                        start = length;
                        continue;
                    }
                    int i = start + col - 1;
                    while (i > start && !Character.isWhitespace(source.charAt(i))) {
                        int j22 = i;
                        i = j22 + -1;
                    }
                    index = i == start ? start + col : i + 1;
                    String string3 = source.substring(start, index);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    $this$convertToSingleLine_u24lambda_u2d0.append(string3);
                    int j = (index - start) % col;
                    while (j != 0 && j < col) {
                        $this$convertToSingleLine_u24lambda_u2d0.append(' ');
                        int n2 = j;
                        j = n2 + 1;
                    }
                    start = index;
                }
                String string4 = stringBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"StringBuilder().apply(builderAction).toString()");
                return string4;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0004H\u0016J\u0012\u0010\t\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u0004H\u0016J\u0014\u0010\u000b\u001a\u0004\u0018\u00010\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u0004H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/form/DGridTextEditorField$ScannerTransformer;", "Lorg/kopi/galite/visual/form/ModelTransformer;", "field", "Lorg/kopi/galite/visual/ui/vaadin/grid/GridEditorField;", "", "(Lorg/kopi/galite/visual/ui/vaadin/grid/GridEditorField;)V", "checkFormat", "", "guiTxt", "toGui", "modelTxt", "toModel", "galite-core"})
    public static final class ScannerTransformer
    implements ModelTransformer {
        @NotNull
        private final GridEditorField<String> field;

        public ScannerTransformer(@NotNull GridEditorField<String> field) {
            Intrinsics.checkNotNullParameter(field, (String)"field");
            this.field = field;
        }

        @Override
        @NotNull
        public String toGui(@Nullable String modelTxt) {
            return modelTxt == null || Intrinsics.areEqual((Object)"", (Object)modelTxt) ? VlibProperties.getString("scan-ready") : (!this.field.isReadOnly() ? VlibProperties.getString("scan-read") + ' ' + modelTxt : VlibProperties.getString("scan-finished"));
        }

        @Override
        @Nullable
        public String toModel(@Nullable String guiTxt) {
            return guiTxt;
        }

        @Override
        public boolean checkFormat(@Nullable String guiTxt) {
            return true;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0000\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u0012\u0010\n\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\tH\u0016J\u0012\u0010\f\u001a\u00020\t2\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/form/DGridTextEditorField$NewlineTransformer;", "Lorg/kopi/galite/visual/form/ModelTransformer;", "col", "", "row", "(II)V", "checkFormat", "", "guiTxt", "", "toGui", "modelTxt", "toModel", "Companion", "galite-core"})
    public static final class NewlineTransformer
    implements ModelTransformer {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int col;
        private final int row;

        public NewlineTransformer(int col, int row) {
            this.col = col;
            this.row = row;
        }

        @Override
        @NotNull
        public String toModel(@Nullable String guiTxt) {
            return NewlineTransformer.Companion.convertFixedTextToSingleLine(guiTxt, this.col, this.row);
        }

        @Override
        @NotNull
        public String toGui(@Nullable String modelTxt) {
            StringBuilder stringBuilder;
            StringBuilder $this$toGui_u24lambda_u2d0 = stringBuilder = new StringBuilder();
            boolean bl = false;
            String string = modelTxt;
            Intrinsics.checkNotNull((Object)string);
            int length = string.length();
            int usedRows = 1;
            for (int start = 0; start < length; start += this.col) {
                String string2 = modelTxt;
                int n = RangesKt.coerceAtMost((int)(start + this.col), (int)length);
                String string3 = string2.substring(start, n);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                String line = string3;
                int last = -1;
                for (int i = line.length() - 1; last == -1 && i >= 0; --i) {
                    if (Character.isWhitespace(line.charAt(i))) continue;
                    last = i;
                }
                if (last != -1) {
                    string3 = line;
                    int n2 = 0;
                    int n3 = last + 1;
                    String string4 = string3.substring(n2, n3);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    $this$toGui_u24lambda_u2d0.append(string4);
                }
                if (usedRows >= this.row) continue;
                if (start + this.col < length) {
                    $this$toGui_u24lambda_u2d0.append('\n');
                }
                int n4 = usedRows;
                usedRows = n4 + 1;
            }
            String string5 = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"StringBuilder().apply(builderAction).toString()");
            return string5;
        }

        @Override
        public boolean checkFormat(@Nullable String guiTxt) {
            String string = guiTxt;
            Intrinsics.checkNotNull((Object)string);
            return string.length() <= this.row * this.col;
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/form/DGridTextEditorField$NewlineTransformer$Companion;", "", "()V", "convertFixedTextToSingleLine", "", "source", "col", "", "row", "galite-core"})
        public static final class Companion {
            private Companion() {
            }

            private final String convertFixedTextToSingleLine(String source, int col, int row) {
                StringBuilder stringBuilder;
                StringBuilder $this$convertFixedTextToSingleLine_u24lambda_u2d0 = stringBuilder = new StringBuilder();
                boolean bl = false;
                String string = source;
                Intrinsics.checkNotNull((Object)string);
                int length = string.length();
                int start = 0;
                while (start < length) {
                    int n;
                    String string2;
                    int index = StringsKt.indexOf$default((CharSequence)source, (char)'\n', (int)start, (boolean)false, (int)4, null);
                    if (index - start < col && index != -1) {
                        string2 = source.substring(start, index);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                        $this$convertFixedTextToSingleLine_u24lambda_u2d0.append(string2);
                        n = index - start;
                        while (n < col) {
                            int j = n++;
                            $this$convertFixedTextToSingleLine_u24lambda_u2d0.append(' ');
                        }
                        start = index + 1;
                        if (start != length) continue;
                        n = 0;
                        while (n < col) {
                            int j = n++;
                            $this$convertFixedTextToSingleLine_u24lambda_u2d0.append(' ');
                        }
                        continue;
                    }
                    if (start + col >= length) {
                        string2 = source.substring(start, length);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                        $this$convertFixedTextToSingleLine_u24lambda_u2d0.append(string2);
                        n = length;
                        int n2 = start + col;
                        while (n < n2) {
                            int j = n++;
                            $this$convertFixedTextToSingleLine_u24lambda_u2d0.append(' ');
                        }
                        start = length;
                        continue;
                    }
                    int i = start + col;
                    while (i > start && !Character.isWhitespace(source.charAt(i))) {
                        int n3 = i;
                        i = n3 + -1;
                    }
                    index = i == start ? start + col : i;
                    String j = source.substring(start, index);
                    Intrinsics.checkNotNullExpressionValue((Object)j, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    $this$convertFixedTextToSingleLine_u24lambda_u2d0.append(j);
                    int n4 = index - start;
                    while (n4 < col) {
                        int j2 = n4++;
                        $this$convertFixedTextToSingleLine_u24lambda_u2d0.append(' ');
                    }
                    start = index + 1;
                }
                String string3 = stringBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"StringBuilder().apply(builderAction).toString()");
                return string3;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

