/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.ui.vaadin.visual;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.router.HasDynamicTitle;
import com.vaadin.flow.router.PreserveOnRefresh;
import com.vaadin.flow.server.VaadinServlet;
import com.vaadin.flow.server.VaadinSession;
import java.sql.SQLException;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.base.UComponent;
import org.kopi.galite.visual.db.Connection;
import org.kopi.galite.visual.l10n.LocalizationManager;
import org.kopi.galite.visual.print.PrintManager;
import org.kopi.galite.visual.ui.vaadin.base.BackgroundThreadHandler;
import org.kopi.galite.visual.ui.vaadin.base.FontMetrics;
import org.kopi.galite.visual.ui.vaadin.base.StyleManager;
import org.kopi.galite.visual.ui.vaadin.main.MainWindow;
import org.kopi.galite.visual.ui.vaadin.main.MainWindowListener;
import org.kopi.galite.visual.ui.vaadin.notif.AbstractNotification;
import org.kopi.galite.visual.ui.vaadin.notif.ConfirmNotification;
import org.kopi.galite.visual.ui.vaadin.notif.ErrorNotification;
import org.kopi.galite.visual.ui.vaadin.notif.InformationNotification;
import org.kopi.galite.visual.ui.vaadin.notif.NotificationListener;
import org.kopi.galite.visual.ui.vaadin.notif.WarningNotification;
import org.kopi.galite.visual.ui.vaadin.visual.DAdminMenu;
import org.kopi.galite.visual.ui.vaadin.visual.DBookmarkMenu;
import org.kopi.galite.visual.ui.vaadin.visual.DMainMenu;
import org.kopi.galite.visual.ui.vaadin.visual.DUserMenu;
import org.kopi.galite.visual.ui.vaadin.visual.Theme;
import org.kopi.galite.visual.ui.vaadin.visual.VApplication;
import org.kopi.galite.visual.ui.vaadin.visual.VApplicationContext;
import org.kopi.galite.visual.ui.vaadin.visual.VFileHandler;
import org.kopi.galite.visual.ui.vaadin.visual.VImageHandler;
import org.kopi.galite.visual.ui.vaadin.visual.VUIFactory;
import org.kopi.galite.visual.ui.vaadin.visual.VWindowController;
import org.kopi.galite.visual.ui.vaadin.welcome.WelcomeView;
import org.kopi.galite.visual.ui.vaadin.welcome.WelcomeViewEvent;
import org.kopi.galite.visual.ui.vaadin.window.Window;
import org.kopi.galite.visual.visual.Application;
import org.kopi.galite.visual.visual.ApplicationConfiguration;
import org.kopi.galite.visual.visual.ApplicationContext;
import org.kopi.galite.visual.visual.FileHandler;
import org.kopi.galite.visual.visual.ImageHandler;
import org.kopi.galite.visual.visual.Message;
import org.kopi.galite.visual.visual.MessageCode;
import org.kopi.galite.visual.visual.PrinterManager;
import org.kopi.galite.visual.visual.PropertyException;
import org.kopi.galite.visual.visual.Registry;
import org.kopi.galite.visual.visual.UIFactory;
import org.kopi.galite.visual.visual.VMenuTree;
import org.kopi.galite.visual.visual.VerifyConfiguration;
import org.kopi.galite.visual.visual.VlibProperties;
import org.kopi.galite.visual.visual.WindowController;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@PreserveOnRefresh
@CssImport.Container(value={@CssImport(value="./styles/galite/styles.css"), @CssImport(value="./styles/galite/common.css")})
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00e4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b'\u0018\u0000 \u00b1\u00012\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0002\u00b1\u0001B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010{\u001a\u00020|2\u0006\u0010}\u001a\u00020~2\u0006\u0010k\u001a\u000203J\b\u0010\u007f\u001a\u00020'H\u0016J\u0010\u0010\u0080\u0001\u001a\u00020'2\u0007\u0010\u0081\u0001\u001a\u000203J\u001b\u0010\u0080\u0001\u001a\u00020\u00132\u0007\u0010\u0081\u0001\u001a\u0002032\u0007\u0010\u0082\u0001\u001a\u00020'H\u0016J\u0012\u0010\u0083\u0001\u001a\u00020'2\u0007\u0010\u0084\u0001\u001a\u000203H\u0002J\u001b\u0010\u0085\u0001\u001a\u00020|2\u0007\u0010\u0086\u0001\u001a\u0002032\u0007\u0010\u0087\u0001\u001a\u000203H\u0002J \u0010\u0088\u0001\u001a\u00020|2\n\u0010\u0089\u0001\u001a\u0005\u0018\u00010\u008a\u00012\t\u0010\u0081\u0001\u001a\u0004\u0018\u000103H\u0016J\u0014\u0010\u008b\u0001\u001a\u00020|2\t\u0010\u0081\u0001\u001a\u0004\u0018\u000103H\u0016J\u0014\u0010\u008c\u0001\u001a\u0004\u0018\u0001032\u0007\u0010\u008d\u0001\u001a\u000203H\u0002J\u0014\u0010\u008e\u0001\u001a\u0004\u0018\u0001032\u0007\u0010\u008d\u0001\u001a\u000203H\u0004J\t\u0010\u008f\u0001\u001a\u00020\tH\u0014J\u000b\u0010\u0090\u0001\u001a\u0004\u0018\u000103H\u0016J&\u0010\u0091\u0001\u001a\u00020\u00132\t\u0010\u0092\u0001\u001a\u0004\u0018\u0001032\u0007\u0010\u0093\u0001\u001a\u00020\u00132\t\u0010\u0094\u0001\u001a\u0004\u0018\u000103J\t\u0010\u0095\u0001\u001a\u00020|H\u0004J\u0007\u0010\u0096\u0001\u001a\u00020|J\t\u0010\u0097\u0001\u001a\u00020|H\u0016J\u0012\u0010\u0098\u0001\u001a\u00020|2\u0007\u0010\u0081\u0001\u001a\u000203H\u0016J\t\u0010\u0099\u0001\u001a\u00020|H\u0016J\u0013\u0010\u009a\u0001\u001a\u00020|2\b\u0010\u009b\u0001\u001a\u00030\u009c\u0001H\u0014J\t\u0010\u009d\u0001\u001a\u00020|H\u0016J\u0011\u0010\u009e\u0001\u001a\u00020|2\b\u0010\u009f\u0001\u001a\u00030\u00a0\u0001J\t\u0010\u00a1\u0001\u001a\u00020|H\u0016J\t\u0010\u00a2\u0001\u001a\u00020|H\u0016J\t\u0010\u00a3\u0001\u001a\u00020|H\u0016J\u0011\u0010\u00a4\u0001\u001a\u00020|2\b\u00108\u001a\u0004\u0018\u000109J\u0012\u0010\u00a5\u0001\u001a\u00020|2\u0007\u0010\u0084\u0001\u001a\u00020\tH\u0004J\u0017\u0010\u00a6\u0001\u001a\u00020|2\u0006\u0010k\u001a\u000203H\u0000\u00a2\u0006\u0003\b\u00a7\u0001J\t\u0010\u00a8\u0001\u001a\u00020|H\u0004J\u0013\u0010\u00a9\u0001\u001a\u00020|2\b\u0010\u00aa\u0001\u001a\u00030\u00ab\u0001H\u0014J\u001d\u0010\u00a9\u0001\u001a\u00020|2\b\u0010\u00aa\u0001\u001a\u00030\u00ab\u00012\b\u0010\u00ac\u0001\u001a\u00030\u00ad\u0001H\u0014J\t\u0010\u00ae\u0001\u001a\u00020|H\u0016J\t\u0010\u00af\u0001\u001a\u00020|H\u0016J\u0012\u0010\u00b0\u0001\u001a\u00020|2\u0007\u0010\u0081\u0001\u001a\u000203H\u0016R\u0012\u0010\b\u001a\u00020\tX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0016\u001a\u0004\u0018\u00010\u00178FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\tX\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u000b\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020'X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010(\"\u0004\b)\u0010*R\u0014\u0010+\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010(R\u001c\u0010,\u001a\u0004\u0018\u00010-X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u0012\u00102\u001a\u000203X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u0012\u00106\u001a\u000203X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00105R\u001c\u00108\u001a\u0004\u0018\u000109X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R\u001c\u0010>\u001a\u0004\u0018\u00010?X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010A\"\u0004\bB\u0010CR\u0014\u0010D\u001a\u0002038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bE\u00105R\u0010\u0010F\u001a\u0004\u0018\u000103X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010G\u001a\u0004\u0018\u00010HX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bI\u0010J\"\u0004\bK\u0010LR\u001a\u0010M\u001a\u00020NX\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bO\u0010P\"\u0004\bQ\u0010RR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bS\u0010TR\u0014\u0010U\u001a\u0002038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bV\u00105R\u0012\u0010W\u001a\u000203X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\bX\u00105R\u0014\u0010Y\u001a\u00020ZX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b[\u0010\\R\u001a\u0010]\u001a\u00020^X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b_\u0010`\"\u0004\ba\u0010bR\u0018\u0010c\u001a\b\u0012\u0004\u0012\u00020\t0dX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\be\u0010fR\u0014\u0010g\u001a\u00020hX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bi\u0010jR\u0016\u0010k\u001a\u0004\u0018\u000103X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bl\u00105R\u0011\u0010m\u001a\u0002038F\u00a2\u0006\u0006\u001a\u0004\bn\u00105R\u0014\u0010o\u001a\u0002038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bp\u00105R\u0014\u0010q\u001a\u0002038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\br\u00105R\u0010\u0010s\u001a\u0004\u0018\u00010tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010u\u001a\u0004\u0018\u00010vX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bw\u0010x\"\u0004\by\u0010z\u00a8\u0006\u00b2\u0001"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/visual/VApplication;", "Lcom/vaadin/flow/component/orderedlayout/VerticalLayout;", "Lorg/kopi/galite/visual/visual/Application;", "Lorg/kopi/galite/visual/ui/vaadin/main/MainWindowListener;", "Lcom/vaadin/flow/router/HasDynamicTitle;", "registry", "Lorg/kopi/galite/visual/visual/Registry;", "(Lorg/kopi/galite/visual/visual/Registry;)V", "alternateLocale", "Ljava/util/Locale;", "getAlternateLocale", "()Ljava/util/Locale;", "applicationConfiguration", "Lorg/kopi/galite/visual/visual/ApplicationConfiguration;", "getApplicationConfiguration", "()Lorg/kopi/galite/visual/visual/ApplicationConfiguration;", "setApplicationConfiguration", "(Lorg/kopi/galite/visual/visual/ApplicationConfiguration;)V", "askAnswer", "", "configProperties", "Ljava/util/ResourceBundle;", "currentUI", "Lcom/vaadin/flow/component/UI;", "getCurrentUI", "()Lcom/vaadin/flow/component/UI;", "setCurrentUI", "(Lcom/vaadin/flow/component/UI;)V", "dBConnection", "Lorg/kopi/galite/visual/db/Connection;", "getDBConnection", "()Lorg/kopi/galite/visual/db/Connection;", "setDBConnection", "(Lorg/kopi/galite/visual/db/Connection;)V", "defaultLocale", "getDefaultLocale", "setDefaultLocale", "(Ljava/util/Locale;)V", "isGeneratingHelp", "", "()Z", "setGeneratingHelp", "(Z)V", "isNoBugReport", "localizationManager", "Lorg/kopi/galite/visual/l10n/LocalizationManager;", "getLocalizationManager", "()Lorg/kopi/galite/visual/l10n/LocalizationManager;", "setLocalizationManager", "(Lorg/kopi/galite/visual/l10n/LocalizationManager;)V", "logoHref", "", "getLogoHref", "()Ljava/lang/String;", "logoImage", "getLogoImage", "mainWindow", "Lorg/kopi/galite/visual/ui/vaadin/main/MainWindow;", "getMainWindow$galite_core", "()Lorg/kopi/galite/visual/ui/vaadin/main/MainWindow;", "setMainWindow$galite_core", "(Lorg/kopi/galite/visual/ui/vaadin/main/MainWindow;)V", "menu", "Lorg/kopi/galite/visual/visual/VMenuTree;", "getMenu", "()Lorg/kopi/galite/visual/visual/VMenuTree;", "setMenu", "(Lorg/kopi/galite/visual/visual/VMenuTree;)V", "notificationLocale", "getNotificationLocale", "pageTitle", "printManager", "Lorg/kopi/galite/visual/print/PrintManager;", "getPrintManager", "()Lorg/kopi/galite/visual/print/PrintManager;", "setPrintManager", "(Lorg/kopi/galite/visual/print/PrintManager;)V", "printerManager", "Lorg/kopi/galite/visual/visual/PrinterManager;", "getPrinterManager", "()Lorg/kopi/galite/visual/visual/PrinterManager;", "setPrinterManager", "(Lorg/kopi/galite/visual/visual/PrinterManager;)V", "getRegistry", "()Lorg/kopi/galite/visual/visual/Registry;", "resourceFile", "getResourceFile", "sologanImage", "getSologanImage", "startupTime", "Ljava/util/Date;", "getStartupTime", "()Ljava/util/Date;", "styleManager", "Lorg/kopi/galite/visual/ui/vaadin/base/StyleManager;", "getStyleManager", "()Lorg/kopi/galite/visual/ui/vaadin/base/StyleManager;", "setStyleManager", "(Lorg/kopi/galite/visual/ui/vaadin/base/StyleManager;)V", "supportedLocales", "", "getSupportedLocales", "()[Ljava/util/Locale;", "theme", "Lorg/kopi/galite/visual/ui/vaadin/visual/Theme;", "getTheme", "()Lorg/kopi/galite/visual/ui/vaadin/visual/Theme;", "title", "getTitle", "url", "getUrl", "userIP", "getUserIP", "userName", "getUserName", "welcomeView", "Lorg/kopi/galite/visual/ui/vaadin/welcome/WelcomeView;", "windowError", "", "getWindowError$galite_core", "()Ljava/lang/Throwable;", "setWindowError$galite_core", "(Ljava/lang/Throwable;)V", "addWindow", "", "window", "Lorg/kopi/galite/visual/ui/vaadin/window/Window;", "allowQuit", "ask", "message", "yesIsDefault", "checkLocale", "locale", "connectToDatabase", "username", "password", "displayError", "parent", "Lorg/kopi/galite/visual/base/UComponent;", "error", "getConfigParameter", "key", "getInitParameter", "getInitializationLocale", "getPageTitle", "getWidth", "fontFamily", "fontSize", "text", "gotoWelcomeView", "initialize", "logout", "notice", "onAdmin", "onAttach", "attachEvent", "Lcom/vaadin/flow/component/AttachEvent;", "onHelp", "onLogin", "event", "Lorg/kopi/galite/visual/ui/vaadin/welcome/WelcomeViewEvent;", "onLogout", "onSupport", "onUser", "remove", "setLocalizationContext", "setPageTitle", "setPageTitle$galite_core", "setTraceLevel", "showNotification", "notification", "Lorg/kopi/galite/visual/ui/vaadin/notif/AbstractNotification;", "lock", "Ljava/lang/Object;", "startApplication", "verifyConfiguration", "warn", "Companion", "galite-core"})
public abstract class VApplication
extends VerticalLayout
implements Application,
MainWindowListener,
HasDynamicTitle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Registry registry;
    @Nullable
    private MainWindow mainWindow;
    @Nullable
    private WelcomeView welcomeView;
    @Nullable
    private Throwable windowError;
    private int askAnswer;
    public StyleManager styleManager;
    @Nullable
    private UI currentUI;
    @Nullable
    private final ResourceBundle configProperties;
    @NotNull
    private final Date startupTime;
    @Nullable
    private ApplicationConfiguration applicationConfiguration;
    @Nullable
    private PrintManager printManager;
    public PrinterManager printerManager;
    @Nullable
    private VMenuTree menu;
    private boolean isGeneratingHelp;
    @Nullable
    private Connection dBConnection;
    public Locale defaultLocale;
    @Nullable
    private LocalizationManager localizationManager;
    @Nullable
    private final String title;
    @NotNull
    private final Theme theme;
    @Nullable
    private String pageTitle;
    public static Application instance;
    @NotNull
    private static final FontMetrics[] FONT_METRICS;

    public VApplication(@NotNull Registry registry) {
        ResourceBundle resourceBundle;
        VApplication vApplication;
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        this.registry = registry;
        VApplication vApplication2 = this;
        try {
            vApplication = vApplication2;
            resourceBundle = ResourceBundle.getBundle(this.getResourceFile());
        }
        catch (MissingResourceException missingResourceException) {
            vApplication = vApplication2;
            resourceBundle = null;
        }
        vApplication.configProperties = resourceBundle;
        this.startupTime = new Date();
        this.setClassName("galite");
        this.initialize();
        this.gotoWelcomeView();
        this.askAnswer = 3;
        Companion.setInstance(this);
        this.theme = new Theme("#009bd4", "#d9f0f8", "#547988", "#82cfe9");
        this.pageTitle = this.getTitle();
    }

    @Override
    @NotNull
    public Registry getRegistry() {
        return this.registry;
    }

    @Nullable
    public final MainWindow getMainWindow$galite_core() {
        return this.mainWindow;
    }

    public final void setMainWindow$galite_core(@Nullable MainWindow mainWindow) {
        this.mainWindow = mainWindow;
    }

    @Nullable
    public final Throwable getWindowError$galite_core() {
        return this.windowError;
    }

    public final void setWindowError$galite_core(@Nullable Throwable throwable) {
        this.windowError = throwable;
    }

    @NotNull
    public final StyleManager getStyleManager() {
        StyleManager styleManager2 = this.styleManager;
        if (styleManager2 != null) {
            return styleManager2;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"styleManager");
        return null;
    }

    public final void setStyleManager(@NotNull StyleManager styleManager2) {
        Intrinsics.checkNotNullParameter((Object)styleManager2, (String)"<set-?>");
        this.styleManager = styleManager2;
    }

    @Nullable
    public final UI getCurrentUI() {
        UI uI = this.currentUI;
        if (uI == null) {
            uI = UI.getCurrent();
        }
        return uI;
    }

    public final void setCurrentUI(@Nullable UI uI) {
        this.currentUI = uI;
    }

    @Override
    @NotNull
    public Date getStartupTime() {
        return this.startupTime;
    }

    protected void onAttach(@NotNull AttachEvent attachEvent) {
        UI ui;
        Intrinsics.checkNotNullParameter((Object)attachEvent, (String)"attachEvent");
        this.currentUI = ui = attachEvent.getUI();
        UI uI = this.getCurrentUI();
        Intrinsics.checkNotNull((Object)uI);
        this.setStyleManager(new StyleManager(uI));
        ui.getElement().getStyle().set("--background-color", this.getTheme().getBackgroundColor());
        ui.getElement().getStyle().set("--background-hover-color", this.getTheme().getBackgroundHoverColor());
        ui.getElement().getStyle().set("--actor-hover-color", this.getTheme().getActorHoverColor());
        ui.getElement().getStyle().set("--disabled-actor-color", this.getTheme().getDisabledActorColor());
    }

    @Override
    public void notice(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        InformationNotification dialog = new InformationNotification(VlibProperties.getString("Notice"), message, this.getNotificationLocale(), (Component)this.mainWindow);
        Object lock = new Object();
        dialog.addNotificationListener(new NotificationListener(lock){
            final /* synthetic */ Object $lock;
            {
                this.$lock = $lock;
            }

            public void onClose(@Nullable Boolean action2) {
                BackgroundThreadHandler.INSTANCE.releaseLock(this.$lock);
            }
        });
        this.showNotification(dialog, lock);
    }

    @Override
    public void error(@Nullable String message) {
        ErrorNotification dialog = new ErrorNotification(VlibProperties.getString("Error"), message, this.getNotificationLocale(), (Component)this.mainWindow);
        Object lock = new Object();
        dialog.addNotificationListener(new NotificationListener(this, lock){
            final /* synthetic */ VApplication this$0;
            final /* synthetic */ Object $lock;
            {
                this.this$0 = $receiver;
                this.$lock = $lock;
            }

            public void onClose(@Nullable Boolean action2) {
                this.this$0.setWindowError$galite_core(null);
                BackgroundThreadHandler.INSTANCE.releaseLock(this.$lock);
            }
        });
        this.showNotification(dialog, lock);
    }

    @Override
    public void warn(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        WarningNotification dialog = new WarningNotification(VlibProperties.getString("Warning"), message, this.getNotificationLocale(), (Component)this.mainWindow);
        Object lock = new Object();
        dialog.addNotificationListener(new NotificationListener(lock){
            final /* synthetic */ Object $lock;
            {
                this.$lock = $lock;
            }

            public void onClose(@Nullable Boolean action2) {
                BackgroundThreadHandler.INSTANCE.releaseLock(this.$lock);
            }
        });
        this.showNotification(dialog, lock);
    }

    public final boolean ask(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return this.ask(message, false) == 1;
    }

    @Override
    public int ask(@NotNull String message, boolean yesIsDefault) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        ConfirmNotification dialog = new ConfirmNotification(VlibProperties.getString("Question"), message, this.getNotificationLocale(), (Component)this.mainWindow);
        Object lock = new Object();
        dialog.setYesIsDefault$galite_core(yesIsDefault);
        dialog.addNotificationListener(new NotificationListener(this, lock){
            final /* synthetic */ VApplication this$0;
            final /* synthetic */ Object $lock;
            {
                this.this$0 = $receiver;
                this.$lock = $lock;
            }

            public void onClose(@Nullable Boolean yes) {
                VApplication.access$setAskAnswer$p(this.this$0, Intrinsics.areEqual((Object)yes, (Object)true) ? 1 : 2);
                BackgroundThreadHandler.INSTANCE.releaseLock(this.$lock);
            }
        });
        this.showNotification(dialog, lock);
        return this.askAnswer;
    }

    private final String getNotificationLocale() {
        String string = this.getDefaultLocale().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"defaultLocale.toString()");
        return string;
    }

    protected void showNotification(@NotNull AbstractNotification notification) {
        Intrinsics.checkNotNullParameter((Object)((Object)notification), (String)"notification");
        BackgroundThreadHandler.INSTANCE.accessAndPush(this.getCurrentUI(), (Function0<Unit>)((Function0)new Function0<Unit>(notification){
            final /* synthetic */ AbstractNotification $notification;
            {
                this.$notification = $notification;
                super(0);
            }

            public final void invoke() {
                this.$notification.show();
            }
        }));
    }

    protected void showNotification(@NotNull AbstractNotification notification, @NotNull Object lock) {
        Intrinsics.checkNotNullParameter((Object)((Object)notification), (String)"notification");
        Intrinsics.checkNotNullParameter((Object)lock, (String)"lock");
        BackgroundThreadHandler.INSTANCE.startAndWaitAndPush(lock, this.getCurrentUI(), (Function0<Unit>)((Function0)new Function0<Unit>(notification){
            final /* synthetic */ AbstractNotification $notification;
            {
                this.$notification = $notification;
                super(0);
            }

            public final void invoke() {
                this.$notification.show();
            }
        }));
    }

    @Override
    public void logout() {
        ConfirmNotification dialog = new ConfirmNotification(VlibProperties.getString("Question"), Message.INSTANCE.getMessage("confirm_quit"), this.getNotificationLocale(), (Component)this.mainWindow);
        dialog.setYesIsDefault$galite_core(false);
        dialog.addNotificationListener(new NotificationListener(this){
            final /* synthetic */ VApplication this$0;
            {
                this.this$0 = $receiver;
            }

            public void onClose(@Nullable Boolean yes) {
                if (Intrinsics.areEqual((Object)yes, (Object)true)) {
                    this.this$0.gotoWelcomeView();
                }
                UI uI = this.this$0.getCurrentUI();
                if (uI != null) {
                    uI.push();
                }
            }
        });
        this.showNotification(dialog);
    }

    @Override
    public void startApplication() {
        this.setMenu(new VMenuTree(this.getDBConnection()));
        VMenuTree vMenuTree = this.getMenu();
        Intrinsics.checkNotNull((Object)vMenuTree);
        StringBuilder stringBuilder = new StringBuilder().append(this.getUserName()).append('@');
        String string = this.getUrl().substring(StringsKt.indexOf$default((CharSequence)this.getUrl(), (String)"//", (int)0, (boolean)false, (int)6, null) + 2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        vMenuTree.setTitle(stringBuilder.append(string).toString());
        MainWindow mainWindow = this.mainWindow = new MainWindow(this.getDefaultLocale(), this.getLogoImage(), this.getLogoHref(), this);
        Intrinsics.checkNotNull((Object)((Object)mainWindow));
        mainWindow.addMainWindowListener(this);
        MainWindow mainWindow2 = this.mainWindow;
        Intrinsics.checkNotNull((Object)((Object)mainWindow2));
        VMenuTree vMenuTree2 = this.getMenu();
        Intrinsics.checkNotNull((Object)vMenuTree2);
        mainWindow2.setMainMenu(new DMainMenu(vMenuTree2));
        MainWindow mainWindow3 = this.mainWindow;
        Intrinsics.checkNotNull((Object)((Object)mainWindow3));
        VMenuTree vMenuTree3 = this.getMenu();
        Intrinsics.checkNotNull((Object)vMenuTree3);
        mainWindow3.setUserMenu(new DUserMenu(vMenuTree3));
        MainWindow mainWindow4 = this.mainWindow;
        Intrinsics.checkNotNull((Object)((Object)mainWindow4));
        VMenuTree vMenuTree4 = this.getMenu();
        Intrinsics.checkNotNull((Object)vMenuTree4);
        mainWindow4.setAdminMenu(new DAdminMenu(vMenuTree4));
        MainWindow mainWindow5 = this.mainWindow;
        Intrinsics.checkNotNull((Object)((Object)mainWindow5));
        VMenuTree vMenuTree5 = this.getMenu();
        Intrinsics.checkNotNull((Object)vMenuTree5);
        mainWindow5.setBookmarksMenu(new DBookmarkMenu(vMenuTree5));
        MainWindow mainWindow6 = this.mainWindow;
        Intrinsics.checkNotNull((Object)((Object)mainWindow6));
        VMenuTree vMenuTree6 = this.getMenu();
        Intrinsics.checkNotNull((Object)vMenuTree6);
        mainWindow6.setWorkspaceContextItemMenu(new DBookmarkMenu(vMenuTree6));
        MainWindow mainWindow7 = this.mainWindow;
        Intrinsics.checkNotNull((Object)((Object)mainWindow7));
        mainWindow7.setConnectedUser(this.getUserName());
    }

    public final void remove(@Nullable MainWindow mainWindow) {
        Component[] componentArray = new Component[]{(Component)mainWindow};
        super.remove(componentArray);
        this.getParent().ifPresent(VApplication::remove$lambda-2);
    }

    @Override
    public boolean allowQuit() {
        return this.getInitParameter("allowQuit") == null || Boolean.parseBoolean(this.getInitParameter("allowQuit"));
    }

    @Override
    @Nullable
    public ApplicationConfiguration getApplicationConfiguration() {
        return this.applicationConfiguration;
    }

    @Override
    public void setApplicationConfiguration(@Nullable ApplicationConfiguration applicationConfiguration) {
        this.applicationConfiguration = applicationConfiguration;
    }

    @Override
    @Nullable
    public PrintManager getPrintManager() {
        return this.printManager;
    }

    @Override
    public void setPrintManager(@Nullable PrintManager printManager) {
        this.printManager = printManager;
    }

    @Override
    @NotNull
    public PrinterManager getPrinterManager() {
        PrinterManager printerManager = this.printerManager;
        if (printerManager != null) {
            return printerManager;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"printerManager");
        return null;
    }

    @Override
    public void setPrinterManager(@NotNull PrinterManager printerManager) {
        Intrinsics.checkNotNullParameter((Object)printerManager, (String)"<set-?>");
        this.printerManager = printerManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onLogin(@NotNull WelcomeViewEvent event) {
        Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
        String string = event.getLocale().substring(0, 2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String string2 = string;
        string = event.getLocale().substring(3, 5);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        this.setLocalizationContext(new Locale(string2, string));
        try {
            this.connectToDatabase(event.getUsername(), event.getPassword());
            this.startApplication();
            if (this.welcomeView != null) {
                this.welcomeView = null;
                this.removeAll();
            }
            Component[] componentArray = new Component[]{(Component)this.mainWindow};
            this.add(componentArray);
        }
        catch (SQLException e) {
            WelcomeView welcomeView = this.welcomeView;
            Intrinsics.checkNotNull((Object)welcomeView);
            welcomeView.setError(e.getMessage());
        }
        finally {
            UI uI = this.getCurrentUI();
            if (uI != null) {
                uI.push();
            }
        }
    }

    private final void connectToDatabase(String username, String password) {
        String database = this.getInitParameter("database");
        String driver = this.getInitParameter("driver");
        String schema = this.getInitParameter("schema");
        if (database == null) {
            boolean $i$a$-requireNotNull-VApplication$connectToDatabase$32 = false;
            String $i$a$-requireNotNull-VApplication$connectToDatabase$32 = "The database url shouldn't be null";
            throw new IllegalArgumentException($i$a$-requireNotNull-VApplication$connectToDatabase$32.toString());
        }
        if (driver == null) {
            boolean bl = false;
            String string = "The jdbc driver shouldn't be null";
            throw new IllegalArgumentException(string.toString());
        }
        this.setDBConnection(this.login(database, driver, username, password, schema));
        if (this.getDBConnection() == null) {
            throw new SQLException(MessageCode.getMessage$default(MessageCode.INSTANCE, "VIS-00054", null, false, 6, null));
        }
        this.setTraceLevel();
    }

    @Override
    public boolean isNoBugReport() {
        return Boolean.parseBoolean(this.getInitParameter("nobugreport"));
    }

    @Override
    @Nullable
    public VMenuTree getMenu() {
        return this.menu;
    }

    public void setMenu(@Nullable VMenuTree vMenuTree) {
        this.menu = vMenuTree;
    }

    @Override
    public boolean isGeneratingHelp() {
        return this.isGeneratingHelp;
    }

    public void setGeneratingHelp(boolean bl) {
        this.isGeneratingHelp = bl;
    }

    @Override
    @Nullable
    public Connection getDBConnection() {
        return this.dBConnection;
    }

    public void setDBConnection(@Nullable Connection connection) {
        this.dBConnection = connection;
    }

    @Override
    @NotNull
    public String getUserName() {
        Connection connection = this.getDBConnection();
        Intrinsics.checkNotNull((Object)connection);
        return connection.getUserName();
    }

    @Override
    @NotNull
    public Locale getDefaultLocale() {
        Locale locale = this.defaultLocale;
        if (locale != null) {
            return locale;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"defaultLocale");
        return null;
    }

    public void setDefaultLocale(@NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"<set-?>");
        this.defaultLocale = locale;
    }

    @Override
    @Nullable
    public LocalizationManager getLocalizationManager() {
        return this.localizationManager;
    }

    public void setLocalizationManager(@Nullable LocalizationManager localizationManager) {
        this.localizationManager = localizationManager;
    }

    @Override
    public void displayError(@Nullable UComponent parent, @Nullable String message) {
        this.error(message);
    }

    @NotNull
    public final String getUrl() {
        Connection connection = this.getDBConnection();
        Intrinsics.checkNotNull((Object)connection);
        return connection.getUrl();
    }

    public final void initialize() {
        this.getRegistry().buildDependencies();
        this.setLocalizationContext(this.getInitializationLocale());
    }

    public void verifyConfiguration() {
        VerifyConfiguration verifyConfiguration = VerifyConfiguration.Companion.getVerifyConfiguration();
        try {
            ApplicationConfiguration applicationConfiguration = ApplicationConfiguration.Companion.getConfiguration();
            Intrinsics.checkNotNull((Object)applicationConfiguration);
            String string = applicationConfiguration.getSMTPServer();
            ApplicationConfiguration applicationConfiguration2 = ApplicationConfiguration.Companion.getConfiguration();
            Intrinsics.checkNotNull((Object)applicationConfiguration2);
            String string2 = applicationConfiguration2.getDebugMailRecipient();
            ApplicationConfiguration applicationConfiguration3 = ApplicationConfiguration.Companion.getConfiguration();
            Intrinsics.checkNotNull((Object)applicationConfiguration3);
            verifyConfiguration.verifyConfiguration(string, string2, applicationConfiguration3.getApplicationName());
        }
        catch (PropertyException e) {
            e.printStackTrace();
        }
    }

    public final void addWindow(@NotNull Window window, @NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)((Object)window), (String)"window");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        if (this.mainWindow != null) {
            BackgroundThreadHandler.INSTANCE.access(this.getCurrentUI(), (Function0<Unit>)((Function0)new Function0<Unit>(window, this, title){
                final /* synthetic */ Window $window;
                final /* synthetic */ VApplication this$0;
                final /* synthetic */ String $title;
                {
                    this.$window = $window;
                    this.this$0 = $receiver;
                    this.$title = $title;
                    super(0);
                }

                public final void invoke() {
                    this.$window.setSizeFull();
                    MainWindow mainWindow = this.this$0.getMainWindow$galite_core();
                    Intrinsics.checkNotNull((Object)((Object)mainWindow));
                    mainWindow.addWindow((Component)this.$window, this.$title);
                }
            }));
        }
    }

    protected final void setLocalizationContext(@NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        this.setDefaultLocale(locale);
        this.setLocalizationManager(new LocalizationManager(this.getDefaultLocale(), Locale.getDefault()));
        UI uI = UI.getCurrent();
        if (uI != null) {
            uI.setLocale(this.getDefaultLocale());
        }
    }

    @NotNull
    protected Locale getInitializationLocale() {
        Locale locale;
        String locale2 = this.getInitParameter("locale");
        if (locale2 == null) {
            return this.getAlternateLocale();
        }
        if (!this.checkLocale(locale2)) {
            System.err.println("Error: Wrong locale format. Alternate locale will be used");
            locale = this.getAlternateLocale();
        } else {
            String string = locale2.substring(0, 2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String string2 = string;
            string = locale2.substring(3, 5);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            Locale locale3 = new Locale(string2, string);
            locale = locale3;
        }
        return locale;
    }

    protected final void setTraceLevel() {
    }

    public final int getWidth(@Nullable String fontFamily, int fontSize, @Nullable String text) {
        return 0;
    }

    protected final void gotoWelcomeView() {
        if (this.mainWindow != null) {
            MainWindow mainWindow = this.mainWindow;
            Intrinsics.checkNotNull((Object)((Object)mainWindow));
            mainWindow.resetTitle();
            this.remove(this.mainWindow);
            this.mainWindow = null;
            this.setMenu(null);
            this.setLocalizationManager(null);
            this.setGeneratingHelp(false);
        }
        if (this.welcomeView == null) {
            WelcomeView welcomeView = this.welcomeView = new WelcomeView(this.getDefaultLocale(), this.getSupportedLocales(), this.getSologanImage(), this.getLogoImage(), this.getLogoHref());
            Intrinsics.checkNotNull((Object)welcomeView);
            welcomeView.setSizeFull();
            WelcomeView welcomeView2 = this.welcomeView;
            Intrinsics.checkNotNull((Object)welcomeView2);
            welcomeView2.addWelcomeViewListener((Function1<? super WelcomeViewEvent, Unit>)((Function1)new Function1<WelcomeViewEvent, Unit>(this){
                final /* synthetic */ VApplication this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull WelcomeViewEvent event) {
                    Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
                    WelcomeView welcomeView = VApplication.access$getWelcomeView$p(this.this$0);
                    Intrinsics.checkNotNull((Object)welcomeView);
                    welcomeView.setWaitInfo();
                    new Thread(() -> gotoWelcomeView.1.invoke$lambda-0(this.this$0, event)).start();
                }

                private static final void invoke$lambda-0(VApplication this$0, WelcomeViewEvent $event) {
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    Intrinsics.checkNotNullParameter((Object)((Object)$event), (String)"$event");
                    BackgroundThreadHandler.INSTANCE.accessAndPush(this$0.getCurrentUI(), (Function0<Unit>)((Function0)new Function0<Unit>(this$0, $event){
                        final /* synthetic */ VApplication this$0;
                        final /* synthetic */ WelcomeViewEvent $event;
                        {
                            this.this$0 = $receiver;
                            this.$event = $event;
                            super(0);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public final void invoke() {
                            try {
                                this.this$0.onLogin(this.$event);
                            }
                            finally {
                                WelcomeView welcomeView = VApplication.access$getWelcomeView$p(this.this$0);
                                if (welcomeView != null) {
                                    welcomeView.unsetWaitInfo();
                                }
                            }
                        }
                    }));
                }
            }));
            Component[] componentArray = new Component[]{(Component)this.welcomeView};
            this.add(componentArray);
        }
    }

    private final boolean checkLocale(String locale) {
        char[] cArray = locale.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
        char[] chars = cArray;
        return chars.length == 5 && Intrinsics.compare((int)chars[0], (int)97) >= 0 && Intrinsics.compare((int)chars[0], (int)122) <= 0 && Intrinsics.compare((int)chars[1], (int)97) >= 0 && Intrinsics.compare((int)chars[1], (int)122) <= 0 && chars[2] == '_' && Intrinsics.compare((int)chars[3], (int)65) >= 0 && Intrinsics.compare((int)chars[3], (int)90) <= 0 && Intrinsics.compare((int)chars[4], (int)65) >= 0 && Intrinsics.compare((int)chars[4], (int)90) <= 0;
    }

    @Override
    public void onAdmin() {
    }

    @Override
    public void onSupport() {
    }

    @Override
    public void onHelp() {
    }

    @Override
    public void onLogout() {
        this.logout();
    }

    @Override
    public void onUser() {
    }

    @Override
    @NotNull
    public String getUserIP() {
        Ref.ObjectRef userIP2 = new Ref.ObjectRef();
        userIP2.element = "";
        VaadinSession currentSession = VaadinSession.getCurrent();
        if (currentSession != null) {
            String string = currentSession.getBrowser().getAddress();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"currentSession.browser.address");
            return string;
        }
        BackgroundThreadHandler.INSTANCE.accessAndAwait(this.getCurrentUI(), (Function0<Unit>)((Function0)new Function0<Unit>((Ref.ObjectRef<String>)userIP2){
            final /* synthetic */ Ref.ObjectRef<String> $userIP;
            {
                this.$userIP = $userIP;
                super(0);
            }

            public final void invoke() {
                String string = VaadinSession.getCurrent().getBrowser().getAddress();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCurrent().browser.address");
                this.$userIP.element = string;
            }
        }));
        return (String)userIP2.element;
    }

    @Nullable
    protected final String getInitParameter(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        VaadinServlet vaadinServlet = VaadinServlet.getCurrent();
        String string = vaadinServlet == null ? null : vaadinServlet.getInitParameter(key);
        if (string == null) {
            string = this.getConfigParameter(key);
        }
        return string;
    }

    @NotNull
    public String getResourceFile() {
        return "config";
    }

    private final String getConfigParameter(String key) {
        return this.configProperties != null && this.configProperties.containsKey(key) ? this.configProperties.getString(key) : null;
    }

    @NotNull
    protected abstract Locale[] getSupportedLocales();

    @NotNull
    protected abstract String getSologanImage();

    @NotNull
    protected abstract String getLogoImage();

    @NotNull
    protected abstract String getLogoHref();

    @NotNull
    protected abstract Locale getAlternateLocale();

    @Nullable
    public String getTitle() {
        return this.title;
    }

    @NotNull
    public Theme getTheme() {
        return this.theme;
    }

    @Nullable
    public String getPageTitle() {
        return this.pageTitle;
    }

    public final void setPageTitle$galite_core(@NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        this.pageTitle = title;
        UI uI = this.getCurrentUI();
        Intrinsics.checkNotNull((Object)uI);
        uI.getInternals().setTitle(title);
    }

    private static final boolean remove$lambda-2$lambda-0(Component component) {
        return component instanceof Dialog;
    }

    private static final void remove$lambda-2$lambda-1(Component it) {
        Component component = it;
        if (component == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.vaadin.flow.component.dialog.Dialog");
        }
        Dialog dialog = (Dialog)component;
        if (dialog.isOpened()) {
            dialog.close();
        }
    }

    private static final void remove$lambda-2(Component body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        body.getChildren().filter(VApplication::remove$lambda-2$lambda-0).forEach(VApplication::remove$lambda-2$lambda-1);
    }

    public static final /* synthetic */ void access$setAskAnswer$p(VApplication $this, int n) {
        $this.askAnswer = n;
    }

    public static final /* synthetic */ WelcomeView access$getWelcomeView$p(VApplication $this) {
        return $this.welcomeView;
    }

    static {
        FontMetrics[] fontMetricsArray = new FontMetrics[]{FontMetrics.Companion.getDIGIT(), FontMetrics.Companion.getLETTER()};
        FONT_METRICS = fontMetricsArray;
        ApplicationContext.Companion.setApplicationContext(new VApplicationContext());
        FileHandler.Companion.setFileHandler(new VFileHandler());
        ImageHandler.Companion.setImageHandler(new VImageHandler());
        WindowController.Companion.setWindowController(new VWindowController());
        UIFactory.Companion.setUiFactory(new VUIFactory());
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/visual/VApplication$Companion;", "", "()V", "FONT_METRICS", "", "Lorg/kopi/galite/visual/ui/vaadin/base/FontMetrics;", "[Lorg/kopi/galite/visual/ui/vaadin/base/FontMetrics;", "instance", "Lorg/kopi/galite/visual/visual/Application;", "getInstance", "()Lorg/kopi/galite/visual/visual/Application;", "setInstance", "(Lorg/kopi/galite/visual/visual/Application;)V", "galite-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Application getInstance() {
            Application application = instance;
            if (application != null) {
                return application;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"instance");
            return null;
        }

        public final void setInstance(@NotNull Application application) {
            Intrinsics.checkNotNullParameter((Object)application, (String)"<set-?>");
            instance = application;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

