/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.ui.vaadin.window;

import com.vaadin.componentfactory.EnhancedDialog;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.dependency.CssImport;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.ui.vaadin.common.VSpan;
import org.kopi.galite.visual.ui.vaadin.main.MainWindow;
import org.kopi.galite.visual.ui.vaadin.window.Window;

@CssImport(value="./styles/galite/dialog.css")
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/window/PopupWindow;", "Lcom/vaadin/componentfactory/EnhancedDialog;", "Lcom/vaadin/flow/component/HasStyle;", "mainWindow", "Lorg/kopi/galite/visual/ui/vaadin/main/MainWindow;", "(Lorg/kopi/galite/visual/ui/vaadin/main/MainWindow;)V", "caption", "Lorg/kopi/galite/visual/ui/vaadin/common/VSpan;", "getMainWindow", "()Lorg/kopi/galite/visual/ui/vaadin/main/MainWindow;", "close", "", "setCaption", "title", "", "galite-core"})
public final class PopupWindow
extends EnhancedDialog
implements HasStyle {
    @Nullable
    private final MainWindow mainWindow;
    @NotNull
    private VSpan caption;

    public PopupWindow(@Nullable MainWindow mainWindow) {
        this.mainWindow = mainWindow;
        this.caption = new VSpan();
        this.setClassName("k-popup-window");
        this.caption.setClassName("k-popup-window-caption");
        this.setDraggable(true);
        this.setResizable(false);
        this.setCloseOnOutsideClick(false);
        this.setCloseOnEsc(false);
        Component[] componentArray = new Component[]{(Component)this.caption};
        this.addToHeader(componentArray);
    }

    @Nullable
    public final MainWindow getMainWindow() {
        return this.mainWindow;
    }

    public final void setCaption(@NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        this.caption.setText(title);
    }

    public void close() {
        Window lastActiveWindow;
        super.close();
        MainWindow mainWindow = this.mainWindow;
        Component component = mainWindow == null ? null : mainWindow.getCurrentWindow();
        Window window = lastActiveWindow = component instanceof Window ? (Window)component : null;
        if (lastActiveWindow != null) {
            lastActiveWindow.focus();
            if (lastActiveWindow.hasLastFocusedTextField()) {
                lastActiveWindow.goBackToLastFocusedTextField();
            }
        }
    }
}

