/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.vkopi.lib.ui.swing.form;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.time.LocalDate;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.kopi.galite.visual.type.Week;
import org.kopi.galite.visual.visual.VlibProperties;
import org.kopi.vkopi.lib.ui.swing.form.DateChooser;

class CalendarPane
extends JComponent {
    private static final Color WEEKEND_COLOR = UIManager.getColor("DateChooser.weekend");
    private static final Color WEEK_NUMBER_COLOR = UIManager.getColor("DateChooser.weeknumber");
    private static final int SHIFT_FOR_KW_COLUMN = 21;
    private static final int CELL_SIZE = 21;
    private static final String[] WEEKDAY_NAMES = new String[]{VlibProperties.getString("Monday"), VlibProperties.getString("Tuesday"), VlibProperties.getString("Wednesday"), VlibProperties.getString("Thursday"), VlibProperties.getString("Friday"), VlibProperties.getString("Saturday"), VlibProperties.getString("Sunday")};
    private int dp;
    private Color highlightColor;
    private DateChooser dateChooser;
    private static final long serialVersionUID = 8823525349311235417L;

    CalendarPane(DateChooser dateChooser) {
        this.dateChooser = dateChooser;
        this.highlightColor = new Color(180, 180, 240);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LocalDate selectedDate = CalendarPane.this.dateChooser.getSelectedDate();
                Insets ins = CalendarPane.this.getInsets();
                int x0 = (CalendarPane.this.getSize().width - CalendarPane.this.getPreferredSize().width) / 2;
                int x = evt.getX() - ins.left - x0 - 21;
                int y = evt.getY() - ins.top - 20;
                int maxw = 161;
                int maxh = 138;
                if (x < 0 || x > maxw || y < 0 || y > maxh) {
                    return;
                }
                int day = 7 * (y /= 23) + (x /= 23) - (CalendarPane.this.dp - 1);
                if (day >= 1 && day <= DateChooser.getDaysInMonth(selectedDate)) {
                    CalendarPane.this.dateChooser.setSelectedDate(LocalDate.of(selectedDate.getYear(), selectedDate.getMonth(), day));
                    CalendarPane.this.dateChooser.refresh();
                    CalendarPane.this.dateChooser.setOkay(true);
                    CalendarPane.this.dateChooser.dispose();
                }
            }
        });
    }

    @Override
    public void paint(Graphics gc) {
        int y0;
        FontMetrics fm = gc.getFontMetrics();
        Insets ins = this.getInsets();
        int h = fm.getMaxAscent();
        this.dp = (this.dateChooser.getFirstDay() + 6) % 7 - 1;
        if (this.dp < 0) {
            this.dp += 7;
        }
        int x = this.dp;
        int yp = y0 = (this.getSize().height - this.getPreferredSize().height) / 2;
        int x0 = (this.getSize().width - this.getPreferredSize().width) / 2;
        int xp = x0 + 21;
        this.paintBorder(gc);
        gc.setColor(Color.black);
        gc.clipRect(ins.left, ins.top, this.getSize().width - ins.left - ins.right, this.getSize().height - ins.top - ins.bottom);
        gc.translate(ins.left, ins.top);
        for (int i = 0; i < 7; ++i) {
            gc.drawString(WEEKDAY_NAMES[i], xp + 5 + i * 23, yp + h);
        }
        yp += 20;
        xp += this.dp * 23;
        for (int d = 1; d <= DateChooser.getDaysInMonth(this.dateChooser.getSelectedDate()); ++d) {
            gc.setColor(d == this.dateChooser.getSelectedDate().getDayOfMonth() ? this.highlightColor : Color.lightGray);
            gc.fill3DRect(xp, yp, 21, 21, true);
            gc.setColor(x > 4 ? WEEKEND_COLOR : Color.black);
            String ss = String.valueOf(d);
            int sw = fm.stringWidth(ss);
            gc.drawString(ss, xp - 3 + (21 - sw), yp + 3 + h);
            if (++x == 7 || d == DateChooser.getDaysInMonth(this.dateChooser.getSelectedDate())) {
                Week week = new Week(LocalDate.of(this.dateChooser.getSelectedDate().getYear(), this.dateChooser.getSelectedDate().getMonth(), d));
                gc.setColor(WEEK_NUMBER_COLOR);
                gc.drawString(String.valueOf(week.getWeek()), x0 + 1, yp + h + 3);
            }
            if (x == 7) {
                x = 0;
                xp = x0 + 21;
                yp += 23;
                continue;
            }
            xp += 23;
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Insets ins = this.getInsets();
        return new Dimension(184 + ins.left + ins.right, 158 + ins.top + ins.bottom);
    }
}

