/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.vkopi.lib.ui.swing.form;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.activation.MimetypesFileTypeMap;
import org.kopi.galite.visual.form.VBlock;
import org.kopi.galite.visual.form.VField;
import org.kopi.galite.visual.form.VImageField;
import org.kopi.galite.visual.form.VStringField;
import org.kopi.galite.visual.visual.VException;

public class DBlockDropTargetHandler
implements DropTargetListener {
    private final VBlock block;
    private static final MimetypesFileTypeMap MIMETYPES_FILE_TYPEMAP = new MimetypesFileTypeMap();

    public DBlockDropTargetHandler(VBlock block2) {
        this.block = block2;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        this.dragOver(dtde);
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        dtde.acceptDrag(1);
        if (!this.isAccepted(dtde.getTransferable())) {
            dtde.rejectDrag();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        dtde.acceptDrop(1);
        try {
            if (this.isChartBlockContext()) {
                dtde.dropComplete(this.handleDrop((List)dtde.getTransferable().getTransferData(DataFlavor.javaFileListFlavor)));
            } else {
                File flavor = (File)((List)dtde.getTransferable().getTransferData(DataFlavor.javaFileListFlavor)).get(0);
                dtde.dropComplete(this.handleDrop(flavor, DBlockDropTargetHandler.getExtension(flavor)));
            }
        }
        catch (UnsupportedFlavorException e) {
            dtde.dropComplete(false);
        }
        catch (IOException e) {
            dtde.dropComplete(false);
        }
        catch (VException e) {
            dtde.dropComplete(false);
        }
    }

    private boolean isAccepted(Transferable transferable) {
        if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            try {
                List flavors = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                if (this.isChartBlockContext()) {
                    return this.isAccepted(flavors);
                }
                if (flavors.size() > 1) {
                    return false;
                }
                return this.isAccepted(DBlockDropTargetHandler.getExtension((File)flavors.get(0)));
            }
            catch (UnsupportedFlavorException e) {
                return false;
            }
            catch (IOException e) {
                return false;
            }
        }
        return false;
    }

    private boolean isAccepted(String flavor) {
        return flavor != null && flavor.length() > 0 && this.block.isAccepted(flavor);
    }

    private boolean isAccepted(List<File> flavors) {
        String oldFlavor = null;
        for (int i = 0; i < flavors.size(); ++i) {
            String newFlavor = DBlockDropTargetHandler.getExtension(flavors.get(i));
            if (oldFlavor != null && !newFlavor.equals(oldFlavor) || !this.isAccepted(newFlavor)) {
                return false;
            }
            oldFlavor = newFlavor;
        }
        return true;
    }

    private boolean handleDrop(List<File> files) throws VException {
        for (int i = 0; i < files.size(); ++i) {
            File file = files.get(i);
            if (this.handleDrop(file, DBlockDropTargetHandler.getExtension(file))) continue;
            return false;
        }
        return true;
    }

    private boolean handleDrop(File file, String flavor) throws VException {
        VField target = this.block.getDropTarget(flavor);
        if (target == null) {
            return false;
        }
        target.onBeforeDrop();
        if (target instanceof VStringField) {
            if (target.getWidth() < file.getAbsolutePath().length()) {
                return false;
            }
            if (this.isChartBlockContext()) {
                int rec = DBlockDropTargetHandler.getFirstUnfilledRecord(this.block, target);
                this.block.setActiveRecord(rec);
                ((VStringField)target).setString(rec, file.getAbsolutePath());
                target.onAfterDrop();
                this.block.setActiveRecord(rec + 1);
                this.block.gotoRecord(this.block.getActiveRecord());
                return true;
            }
            ((VStringField)target).setString(file.getAbsolutePath());
            target.onAfterDrop();
            return true;
        }
        if (target instanceof VImageField) {
            if (!target.isInternal()) {
                if (DBlockDropTargetHandler.isImage(file)) {
                    return this.handleImage((VImageField)target, file);
                }
                return false;
            }
            return this.handleImage((VImageField)target, file);
        }
        return false;
    }

    private boolean handleImage(VImageField target, File file) throws VException {
        if (this.isChartBlockContext()) {
            int rec = DBlockDropTargetHandler.getFirstUnfilledRecord(this.block, target);
            this.block.setActiveRecord(rec);
            target.setImage(rec, DBlockDropTargetHandler.toByteArray(file));
            target.onAfterDrop();
            this.block.setActiveRecord(rec + 1);
            this.block.gotoRecord(this.block.getActiveRecord());
            return true;
        }
        target.setImage(DBlockDropTargetHandler.toByteArray(file));
        target.onAfterDrop();
        return true;
    }

    private boolean isChartBlockContext() {
        return this.block.noDetail() || this.block.isMulti() && !this.block.isDetailMode();
    }

    private static String getExtension(File file) {
        String extension = null;
        String name = file.getName();
        int index = name.lastIndexOf(46);
        if (index > 0 && index < name.length() - 1) {
            extension = name.substring(index + 1).toLowerCase();
        }
        return extension;
    }

    private static boolean isImage(File file) {
        String mimeType = MIMETYPES_FILE_TYPEMAP.getContentType(file);
        return mimeType.split("/")[0].equals("image");
    }

    private static byte[] toByteArray(File file) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DBlockDropTargetHandler.copy(new FileInputStream(file), baos, 1024);
            return baos.toByteArray();
        }
        catch (IOException e) {
            return null;
        }
    }

    private static void copy(InputStream input, OutputStream output, int bufferSize) throws IOException {
        byte[] buf = new byte[bufferSize];
        int bytesRead = input.read(buf);
        while (bytesRead != -1) {
            output.write(buf, 0, bytesRead);
            bytesRead = input.read(buf);
        }
        output.flush();
    }

    private static int getFirstUnfilledRecord(VBlock block2, VField target) {
        for (int i = 0; i < block2.getBufferSize(); ++i) {
            if (!target.isNull(i)) continue;
            return i;
        }
        return 0;
    }

    static {
        MIMETYPES_FILE_TYPEMAP.addMimeTypes("image/png png");
    }
}

