/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.vkopi.lib.ui.swing.form;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import javax.swing.Action;
import javax.swing.DefaultSingleSelectionModel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.kopi.galite.visual.base.Utils;
import org.kopi.galite.visual.form.BlockListener;
import org.kopi.galite.visual.form.BlockRecordListener;
import org.kopi.galite.visual.form.UBlock;
import org.kopi.galite.visual.form.UForm;
import org.kopi.galite.visual.form.VBlock;
import org.kopi.galite.visual.form.VField;
import org.kopi.galite.visual.form.VFieldException;
import org.kopi.galite.visual.form.VForm;
import org.kopi.galite.visual.util.AWTToPS;
import org.kopi.galite.visual.util.PrintJob;
import org.kopi.galite.visual.util.base.InconsistencyException;
import org.kopi.galite.visual.visual.ApplicationConfiguration;
import org.kopi.galite.visual.visual.DPositionPanelListener;
import org.kopi.galite.visual.visual.VException;
import org.kopi.galite.visual.visual.VExecFailedException;
import org.kopi.galite.visual.visual.VRuntimeException;
import org.kopi.galite.visual.visual.VlibProperties;
import org.kopi.vkopi.lib.ui.swing.form.DBlock;
import org.kopi.vkopi.lib.ui.swing.form.DChartBlock;
import org.kopi.vkopi.lib.ui.swing.form.DMultiBlock;
import org.kopi.vkopi.lib.ui.swing.form.DPage;
import org.kopi.vkopi.lib.ui.swing.form.Environment;
import org.kopi.vkopi.lib.ui.swing.visual.DPositionPanel;
import org.kopi.vkopi.lib.ui.swing.visual.DWindow;
import org.kopi.vkopi.lib.ui.swing.visual.SwingThreadHandler;

public class DForm
extends DWindow
implements UForm,
DPositionPanelListener {
    static final Insets emptyInsets = new Insets(0, 0, 0, 0);
    private BlockRecordHandler blockRecordHandler;
    private BlockListener blockListener;
    private int currentPage = -1;
    private DPage[] blockPanel;
    private JTabbedPane tabbedBlockPanel;
    private DBlock[] blockViews;
    protected Environment environment;
    private static final long serialVersionUID = -5894823173117976720L;

    public DForm(VForm model2) {
        super(model2);
        int i;
        SwingThreadHandler.verifyRunsInEventThread("DForm <init>");
        model2.addFormListener(this);
        JPanel contentPanel = this.getContentPanel();
        contentPanel.setLayout(new BorderLayout());
        this.blockPanel = new DPage[this.getPageCount() == 0 ? 1 : this.getPageCount()];
        for (i = 0; i < this.blockPanel.length; ++i) {
            this.blockPanel[i] = this.getPageCount() != 0 ? new DPage(this.getPageTitle(i).endsWith("<CENTER>")) : new DPage(false);
        }
        if (this.getPageCount() == 0) {
            JScrollPane pane = new JScrollPane();
            pane.setViewportView(this.blockPanel[0]);
            pane.setBorder(null);
            contentPanel.add((Component)pane, "Center");
        } else {
            this.tabbedBlockPanel = new JTabbedPane();
            for (i = 0; i < this.blockPanel.length; ++i) {
                JScrollPane pane = new JScrollPane();
                JPanel inner = new JPanel();
                String pageTitle = this.getPageTitle(i);
                inner.setFocusCycleRoot(true);
                inner.setFocusable(false);
                inner.setLayout(new BorderLayout());
                inner.add((Component)this.blockPanel[i], "Center");
                pane.setViewportView(inner);
                pane.setBorder(null);
                this.tabbedBlockPanel.addTab(pageTitle.endsWith("<CENTER>") ? pageTitle.substring(0, pageTitle.length() - 8) : pageTitle, pane);
                this.tabbedBlockPanel.setEnabledAt(i, false);
            }
            this.tabbedBlockPanel.setModel(new DefaultSingleSelectionModel(){
                private static final long serialVersionUID = -8625496726239343162L;

                @Override
                public void setSelectedIndex(final int index) {
                    if (DForm.this.getCurrentPage() != index) {
                        DForm.this.performBasicAction(new org.kopi.galite.visual.visual.Action("setSelectedIndex"){

                            @Override
                            public void execute() {
                                DForm.this.getModel().gotoPage(index);
                                this.superSetSelectedIndex(index);
                            }
                        });
                    } else {
                        super.setSelectedIndex(index);
                    }
                }

                private void superSetSelectedIndex(int index) {
                    super.setSelectedIndex(index);
                }
            });
            this.tabbedBlockPanel.setRequestFocusEnabled(false);
            contentPanel.add((Component)this.tabbedBlockPanel, "Center");
        }
        DPositionPanel blockInfo = new DPositionPanel(this);
        this.setStatePanel(blockInfo);
        this.blockRecordHandler = new BlockRecordHandler(blockInfo);
        this.blockListener = new BlockAccessHandler();
        int blockcount = this.getModel().getBlockCount();
        this.blockViews = new DBlock[blockcount];
        for (int i2 = 0; i2 < blockcount; ++i2) {
            DBlock blockView;
            VBlock blockModel = this.getModel().getBlock(i2);
            this.blockViews[i2] = blockView = this.createViewForBlock(blockModel);
            this.addBlock(blockView, blockModel.getPageNumber());
            blockModel.addBlockListener(this.blockListener);
        }
        this.getModel().enableCommands();
    }

    protected DBlock createViewForBlock(VBlock blockModel) {
        DBlock blockView;
        if (!blockModel.isMulti()) {
            blockView = new DBlock(this, blockModel);
        } else {
            if (blockModel.noChart() && blockModel.noDetail()) {
                throw new InconsistencyException("Block " + blockModel.name + " is \"NO DEATIL\" and \"NO CHART\" at the same time");
            }
            blockView = blockModel.noChart() ? new DBlock(this, blockModel) : (blockModel.noDetail() ? new DChartBlock(this, blockModel) : new DMultiBlock(this, blockModel));
        }
        return blockView;
    }

    @Override
    public Throwable getRuntimeDebugInfo() {
        return this.runtimeDebugInfo;
    }

    public void addBlock(DBlock block2, int page) {
        if (!block2.getModel().isInternal()) {
            if (block2.getModel().isFollow()) {
                this.blockPanel[page].addFollowBlock(block2);
            } else {
                this.blockPanel[page].addBlock(block2);
            }
        }
    }

    @Override
    protected void createEditMenu() {
        JMenu edit = new JMenu(VlibProperties.getString("menu-file"));
        this.getDMenuBar().add(edit);
        edit = new JMenu(VlibProperties.getString("menu-edit"));
        this.getDMenuBar().add(edit);
        this.undoAction = new DWindow.UndoAction(this);
        this.redoAction = new DWindow.RedoAction(this);
        edit.add(this.undoAction);
        edit.add(this.redoAction);
        edit.addSeparator();
        Action action2 = this.getActionByName("cut-to-clipboard");
        JMenuItem item = new JMenuItem(VlibProperties.getString("item-cut"));
        item.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        item.addActionListener(action2);
        edit.add(item);
        action2 = this.getActionByName("copy-to-clipboard");
        item = new JMenuItem(VlibProperties.getString("item-copy"));
        item.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        item.addActionListener(action2);
        edit.add(item);
        action2 = this.getActionByName("paste-from-clipboard");
        item = new JMenuItem(VlibProperties.getString("item-paste"));
        item.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        item.addActionListener(action2);
        edit.add(item);
        edit.addSeparator();
        action2 = this.getActionByName("select-all");
        action2.putValue("Name", VlibProperties.getString("item-select-all"));
        edit.addSeparator();
    }

    @Override
    public void run() throws VException {
        if (!SwingUtilities.isEventDispatchThread()) {
            System.err.println("ERROR: run() of DForm called outside the event-dispatching-thread");
        }
        this.getModel().prepareForm();
        int blockcount = this.getModel().getBlockCount();
        for (int i = 0; i < blockcount; ++i) {
            VBlock blockModel = this.getModel().getBlock(i);
            blockModel.updateBlockAccess();
        }
        Window window = org.kopi.vkopi.lib.ui.swing.visual.Utils.getWindowAncestor(this);
        window.pack();
        java.awt.Rectangle rectangle = org.kopi.vkopi.lib.ui.swing.visual.Utils.calculateBounds(window, window.getLocation(), null);
        window.setBounds(rectangle);
        window.show();
        this.getModel().executeAfterStart();
    }

    @Override
    public void reportError(VRuntimeException e) {
        Toolkit.getDefaultToolkit().beep();
        if (e.getCause() instanceof VFieldException && e.getMessage() != null) {
            this.displayFieldError((VFieldException)e.getCause());
        } else {
            super.reportError(e);
        }
    }

    public void displayFieldError(VFieldException fe) {
        VField field = fe.getField();
        field.displayFieldError(fe.getMessage());
    }

    public void gotoPage(int i) {
        this.setCurrentPage(i);
        if (this.tabbedBlockPanel != null) {
            this.tabbedBlockPanel.setSelectedIndex(i);
        }
    }

    @Override
    public void gotoNextPosition() {
        this.performAsyncAction(new org.kopi.galite.visual.visual.Action("gotoNextPosition"){

            @Override
            public void execute() {
                DForm.this.getModel().getActiveBlock().gotoNextRecord();
            }
        });
    }

    @Override
    public void gotoPrevPosition() {
        this.performAsyncAction(new org.kopi.galite.visual.visual.Action("gotoPrevPosition"){

            @Override
            public void execute() {
                DForm.this.getModel().getActiveBlock().gotoPrevRecord();
            }
        });
    }

    @Override
    public void gotoLastPosition() {
        this.performAsyncAction(new org.kopi.galite.visual.visual.Action("gotoLastPosition"){

            @Override
            public void execute() {
                DForm.this.getModel().getActiveBlock().gotoLastRecord();
            }
        });
    }

    @Override
    public void gotoFirstPosition() {
        this.performAsyncAction(new org.kopi.galite.visual.visual.Action("gotoFirstPosition"){

            @Override
            public void execute() {
                DForm.this.getModel().getActiveBlock().gotoFirstRecord();
            }
        });
    }

    @Override
    public void gotoPosition(final int posno) {
        this.performAsyncAction(new org.kopi.galite.visual.visual.Action("gotoPosition"){

            @Override
            public void execute() {
                DForm.this.getModel().getActiveBlock().gotoRecord(posno - 1);
            }
        });
    }

    public int getPageCount() {
        return this.getModel().getPages().size();
    }

    public String getPageTitle(int index) {
        return this.getModel().getPages().get(index);
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int i) {
        this.currentPage = i;
    }

    @Override
    public VForm getModel() {
        return (VForm)super.getModel();
    }

    @Override
    public void currentBlockChanged(VBlock oldBlock, VBlock newBlock) {
        if (oldBlock != null) {
            oldBlock.removeBlockRecordListener(this.blockRecordHandler);
        }
        if (newBlock != null) {
            newBlock.addBlockRecordListener(this.blockRecordHandler);
            this.blockRecordHandler.blockRecordChanged(newBlock.getSortedPosition(newBlock.getRecord()), newBlock.getRecordCount());
        }
        if (newBlock != null && newBlock.getPageNumber() != this.getCurrentPage()) {
            this.gotoPage(newBlock.getPageNumber());
        }
    }

    @Override
    public void setFieldSearchOperator(int op) {
    }

    @Override
    public UBlock getBlockView(VBlock block2) {
        List<VBlock> blocks = this.getModel().getBlocks();
        for (int i = 0; i < blocks.size(); ++i) {
            if (block2 != blocks.get(i)) continue;
            return this.blockViews[i];
        }
        return null;
    }

    @Override
    public void release() {
        this.getModel().removeFormListener(this);
        for (int i = 0; i < this.blockViews.length; ++i) {
            this.getModel().getBlock(i).removeBlockListener(this.blockListener);
        }
        super.release();
    }

    public Environment getEnvironment() {
        if (this.environment == null) {
            this.environment = new Environment();
        }
        return this.environment;
    }

    @Override
    public void launchDocumentPreview(String file) throws VException {
        try {
            int art = 0;
            if (file != null) {
                if (file.toLowerCase().endsWith(".pdf")) {
                    art = 0;
                } else if (file.toLowerCase().endsWith(".jpeg")) {
                    art = 1;
                } else if (file.toLowerCase().endsWith(".tif") || file.toLowerCase().endsWith(".tiff")) {
                    art = 2;
                }
            }
            String command = art == 0 ? ApplicationConfiguration.Companion.getConfiguration().getStringFor("pdf.preview.command") : ApplicationConfiguration.Companion.getConfiguration().getStringFor("image.preview.command");
            Runtime.getRuntime().exec(command + " " + file);
        }
        catch (IOException e) {
            throw new VExecFailedException(e);
        }
    }

    @Override
    public void printSnapshot() {
        try {
            this.createFrame();
            this.setVisible(true);
            RepaintManager rm = RepaintManager.currentManager(this.getContentPanel());
            rm.setDoubleBufferingEnabled(false);
            this.setDoubleBuffered(false);
            for (int i = 0; i < this.getModel().getBlocks().size(); ++i) {
                try {
                    BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream("images/" + this.getClass().getName().replace('.', '_') + "_" + this.getModel().getBlocks().get(i).getTitle().replace(' ', '_') + ".ps"));
                    if (this.getModel().getActiveBlock() != null) {
                        this.getModel().getActiveBlock().leave(false);
                    }
                    this.getModel().setActiveBlock(this.getModel().getBlocks().get(i));
                    for (int j = 0; this.getModel().getBlocks().size() > j; ++j) {
                        this.getModel().getBlocks().get(j).prepareSnapshot(this.getModel().getBlocks().get(j) == this.getModel().getBlocks().get(i));
                    }
                    Thread.sleep(1000L);
                    Toolkit.getDefaultToolkit().sync();
                    Thread.sleep(1000L);
                    int w = this.getSize().width / 2;
                    int h = this.getSize().height / 2;
                    AWTToPS ps = new AWTToPS(fos);
                    ps.setBoundingBox(0, 0, w + 2, h + 2);
                    ps.translate(0, 1200 - h - 1);
                    ps.drawRect(0, 0, w + 2, h + 2);
                    ps.translate(0, -(1200 - h - 1));
                    ps.setScale(0.5, 0.5);
                    ps.translate(2, 1200 - h * 2 - 2);
                    ps.setTransparentColor(UIManager.getColor("snapshot.background"));
                    this.paint(ps);
                    ps.showPage();
                    ((OutputStream)fos).close();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.close(0);
    }

    @Override
    public PrintJob printForm() throws VException {
        File file;
        Rectangle pageSize = PageSize.A4.rotate();
        Document document = new Document(pageSize, 50.0f, 50.0f, 50.0f, 50.0f);
        try {
            file = Utils.Companion.getTempFile("kopi", "srn");
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(file));
            document.open();
            Frame frame = org.kopi.vkopi.lib.ui.swing.visual.Utils.getFrameAncestor(this);
            Dimension dim = frame.getSize(null);
            PdfContentByte cb = writer.getDirectContent();
            PdfTemplate tp = cb.createTemplate((float)dim.width, (float)dim.height);
            Graphics2D g2 = tp.createGraphics((float)dim.width, (float)dim.height);
            frame.invalidate();
            frame.validate();
            frame.paint(g2);
            g2.dispose();
            PdfPTable foot = new PdfPTable(2);
            foot.addCell(this.createCell(this.getModel().getName(), 7.0, Color.black, Color.white, 0, false));
            foot.addCell(this.createCell(LocalDate.now().format(DateTimeFormatter.ofPattern("dd.MM.yyyy")) + " " + LocalTime.now().format(DateTimeFormatter.ofPattern("HH:mm")), 7.0, Color.black, Color.white, 2, false));
            foot.setTotalWidth(pageSize.getWidth() - document.leftMargin() - document.rightMargin());
            foot.writeSelectedRows(0, -1, document.leftMargin(), document.bottomMargin() + foot.getTotalHeight(), cb);
            float scale = Math.min((pageSize.getWidth() - 100.0f) / (float)dim.width, (pageSize.getHeight() - 100.0f) / (float)dim.height);
            cb.addTemplate(tp, scale, 0.0f, 0.0f, scale, 50.0f, (pageSize.getHeight() - scale * (float)dim.height) / 2.0f);
        }
        catch (DocumentException de) {
            throw new VExecFailedException(de);
        }
        catch (IOException ioe) {
            throw new VExecFailedException(ioe);
        }
        document.close();
        PrintJob printJob = new PrintJob(file, true, PrintJob.Companion.getFORMAT_A4());
        printJob.setDataType(1);
        printJob.setNumberOfPages(1);
        return printJob;
    }

    private PdfPCell createCell(String text, double size, Color textColor, Color background, int alignment, boolean border) {
        Font font = FontFactory.getFont((String)"Helvetica", (float)((float)size), (int)0, (Color)textColor);
        PdfPCell cell = new PdfPCell((Phrase)new Paragraph(new Chunk(text, font)));
        cell.setBorderWidth(1.0f);
        cell.setPaddingLeft(0.0f);
        cell.setPaddingRight(0.0f);
        cell.setNoWrap(true);
        cell.setUseDescender(true);
        cell.setVerticalAlignment(4);
        cell.setHorizontalAlignment(alignment);
        cell.setBackgroundColor(background);
        if (!border) {
            cell.setBorder(0);
        }
        return cell;
    }

    private class BlockAccessHandler
    implements BlockListener {
        private BlockAccessHandler() {
        }

        @Override
        public void blockClosed() {
        }

        @Override
        public void blockChanged() {
        }

        @Override
        public void blockCleared() {
        }

        @Override
        public void blockViewModeEntered(VBlock block2, VField field) {
        }

        @Override
        public void blockViewModeLeaved(VBlock block2, VField field) {
        }

        @Override
        public void blockAccessChanged(VBlock block2, boolean newAccess) {
            if (DForm.this.tabbedBlockPanel == null) {
                return;
            }
            int pageNumber = block2.getPageNumber();
            List<VBlock> blocks = DForm.this.getModel().getBlocks();
            if (newAccess) {
                if (!DForm.this.tabbedBlockPanel.isEnabledAt(pageNumber)) {
                    DForm.this.tabbedBlockPanel.setEnabledAt(pageNumber, true);
                }
            } else if (DForm.this.tabbedBlockPanel.isEnabledAt(pageNumber)) {
                for (int i = 0; i < blocks.size(); ++i) {
                    if (pageNumber != blocks.get(i).getPageNumber() || !blocks.get(i).isAccessible()) continue;
                    return;
                }
                DForm.this.tabbedBlockPanel.setEnabledAt(pageNumber, false);
            }
        }

        @Override
        public void validRecordNumberChanged() {
        }

        @Override
        public void recordInfoChanged(int rec, int info) {
        }

        @Override
        public void orderChanged() {
        }

        @Override
        public void filterHidden() {
        }

        @Override
        public void filterShown() {
        }

        @Override
        public void goToDate(LocalDate date) {
        }

        @Override
        public LocalDate getSelectedDate() {
            return null;
        }

        @Override
        public void refreshEntries() {
        }

        @Override
        public void enter() {
        }

        @Override
        public UBlock getCurrentDisplay() {
            return null;
        }
    }

    private static class BlockRecordHandler
    implements BlockRecordListener {
        private DPositionPanel blockInfo;

        public BlockRecordHandler(DPositionPanel blockInfo) {
            this.blockInfo = blockInfo;
        }

        @Override
        public void blockRecordChanged(int current, int count) {
            this.blockInfo.setPosition(current, count);
        }
    }
}

