/*
 * Copyright (c) 2013-2022 kopiLeft Services SARL, Tunis TN
 * Copyright (c) 1990-2022 kopiRight Managed Solutions GmbH, Wien AT
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package org.kopi.galite.visual.ui.vaadin.grid

import org.kopi.galite.visual.ui.vaadin.common.VImage
import org.kopi.galite.visual.visual.VColor

import com.vaadin.flow.component.Component

/**
 * The server side implementation of an image grid editor.
 */
class GridEditorImageField : GridEditorField<Any?>() {

  private val image: VImage = VImage()

  init {
    className = "editor-imagefield"
    image.setWidthFull()
    image.setBorder(0)
  }

  override fun setPresentationValue(newPresentationValue: Any?) {
    image.src = newPresentationValue.toString()
  }

  override fun getValue(): Any? = image.src

  override fun initContent(): Component {
    return image
  }

  override fun doFocus() {
    image.focus()
  }

  override fun addFocusListener(focusFunction: () -> Unit) {
    image.addFocusListener {
      focusFunction()
    }
  }

  override fun setBlink(blink: Boolean) {}

  override fun setColor(align: Int, foreground: VColor?, background: VColor?) {}

  fun setImageWidth(width: Int) {
    image.width = "${width}px"
  }

  fun setImageHeight(height: Int) {
    image.height = "${height}px"
  }
}
