/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.form;

import java.sql.Date;
import java.time.LocalDate;
import java.util.StringTokenizer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ResultRow;
import org.kopi.galite.visual.form.PredefinedValueHandler;
import org.kopi.galite.visual.form.VBlock;
import org.kopi.galite.visual.form.VField;
import org.kopi.galite.visual.form.VFieldException;
import org.kopi.galite.visual.list.VDateColumn;
import org.kopi.galite.visual.list.VListColumn;
import org.kopi.galite.visual.type.DefaultFormatKt;
import org.kopi.galite.visual.visual.MessageCode;
import org.kopi.galite.visual.visual.VException;
import org.kopi.galite.visual.visual.VlibProperties;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 <2\u00020\u0001:\u0001<B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00032\b\u0010\r\u001a\u0004\u0018\u00010\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\fH\u0016J\u0012\u0010\u0018\u001a\u00020\f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u000e\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\tJ\f\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001dH\u0016J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J\r\u0010 \u001a\u00020!H\u0010\u00a2\u0006\u0002\b\"J\u0012\u0010#\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J\u0012\u0010$\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J\u0010\u0010%\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J\b\u0010&\u001a\u00020\u000eH\u0016J\b\u0010'\u001a\u00020\u000eH\u0016J\b\u0010(\u001a\u00020\fH\u0016J\b\u0010)\u001a\u00020\fH\u0016J\u0010\u0010*\u001a\u00020\f2\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J\b\u0010.\u001a\u00020\fH\u0016J\u001a\u0010/\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00032\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u001e\u00100\u001a\u0004\u0018\u00010\u00122\u0006\u00101\u001a\u0002022\n\u00103\u001a\u0006\u0012\u0002\b\u000304H\u0016J\u001a\u00105\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u00032\b\u00106\u001a\u0004\u0018\u00010\tH\u0016J\u0010\u00107\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J\u001a\u00108\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u00032\b\u00106\u001a\u0004\u0018\u00010\u0012H\u0016J\u0012\u00109\u001a\u0004\u0018\u00010\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010:\u001a\u00020\u000e2\b\u0010;\u001a\u0004\u0018\u00010\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006="}, d2={"Lorg/kopi/galite/visual/form/VDateField;", "Lorg/kopi/galite/visual/form/VField;", "bufferSize", "", "(I)V", "getBufferSize", "()I", "value", "", "Ljava/time/LocalDate;", "[Ljava/time/LocalDate;", "checkText", "", "s", "", "checkType", "", "rec", "", "copyRecord", "f", "t", "enumerateValue", "desc", "fillField", "handler", "Lorg/kopi/galite/visual/form/PredefinedValueHandler;", "formatDate", "getDataType", "Lkotlin/reflect/KClass;", "getDate", "r", "getListColumn", "Lorg/kopi/galite/visual/list/VListColumn;", "getListColumn$galite_core", "getObjectImpl", "getSqlImpl", "getTextImpl", "getTypeInformation", "getTypeName", "hasAutofill", "hasNextPreviousEntry", "isDateChar", "c", "", "isNullImpl", "isNumeric", "parseDate", "retrieveQuery", "result", "Lorg/jetbrains/exposed/sql/ResultRow;", "column", "Lorg/jetbrains/exposed/sql/Column;", "setDate", "v", "setNull", "setObject", "toObject", "toText", "o", "Companion", "galite-core"})
public final class VDateField
extends VField {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int bufferSize;
    @NotNull
    private LocalDate[] value;

    public VDateField(int bufferSize) {
        super(10, 1);
        this.bufferSize = bufferSize;
        this.value = new LocalDate[2 * this.bufferSize];
    }

    public final int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public boolean hasAutofill() {
        return true;
    }

    @Override
    @NotNull
    public String getTypeInformation() {
        return VlibProperties.getString("date-type-field");
    }

    @Override
    @NotNull
    public String getTypeName() {
        return VlibProperties.getString("Date");
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    @NotNull
    public VListColumn getListColumn$galite_core() {
        return new VDateColumn(this.getHeader(), null, null, this.getPriority() >= 0);
    }

    @Override
    public boolean checkText(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        if (s.length() > 10) {
            return false;
        }
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            char element = s.charAt(i);
            if (this.isDateChar(element)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void checkType(int rec, @Nullable Object s) {
        String s2;
        String string = s2 = s instanceof String ? (String)s : null;
        if (Intrinsics.areEqual((Object)s2, (Object)"")) {
            this.setNull(rec);
        } else {
            this.parseDate(rec, s2);
        }
    }

    private final void parseDate(int rec, String s) {
        LocalDate now;
        int month = 0;
        int year = -2;
        StringTokenizer tokens = new StringTokenizer(s, "/.#");
        if (!tokens.hasMoreTokens()) {
            throw new VFieldException(this, MessageCode.getMessage$default(MessageCode.INSTANCE, "VIS-00003", null, false, 6, null), null, 4, null);
        }
        String string = tokens.nextToken();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tokens.nextToken()");
        int day = Companion.stringToInt$galite_core(string);
        if (tokens.hasMoreTokens()) {
            string = tokens.nextToken();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tokens.nextToken()");
            month = Companion.stringToInt$galite_core(string);
        }
        if (tokens.hasMoreTokens()) {
            string = tokens.nextToken();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tokens.nextToken()");
            year = Companion.stringToInt$galite_core(string);
        }
        if (tokens.hasMoreTokens() || day == -1 || month == -1 || year == -1) {
            throw new VFieldException(this, MessageCode.getMessage$default(MessageCode.INSTANCE, "VIS-00003", null, false, 6, null), null, 4, null);
        }
        if (month == 0) {
            LocalDate localDate = LocalDate.now();
            Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"now()");
            now = localDate;
            month = now.getMonthValue();
            year = now.getYear();
        } else if (year == -2) {
            LocalDate localDate = LocalDate.now();
            Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"now()");
            now = localDate;
            year = now.getYear();
        } else if (year < 50) {
            year += 2000;
        } else if (year < 100) {
            year += 1900;
        } else if (year < 1000) {
            throw new VFieldException(this, MessageCode.getMessage$default(MessageCode.INSTANCE, "VIS-00003", null, false, 6, null), null, 4, null);
        }
        if (!Companion.isDate$galite_core(day, month, year)) {
            throw new VFieldException(this, MessageCode.getMessage$default(MessageCode.INSTANCE, "VIS-00003", null, false, 6, null), null, 4, null);
        }
        this.setDate(rec, LocalDate.of(year, month, day));
    }

    @Override
    public void setNull(int r) {
        this.setDate(r, null);
    }

    @Override
    public void setDate(int r, @Nullable LocalDate v) {
        block3: {
            block2: {
                if (this.isChangedUI() || this.value[r] == null && v != null) break block2;
                if (this.value[r] == null) break block3;
                LocalDate localDate = this.value[r];
                Intrinsics.checkNotNull((Object)localDate);
                if (Intrinsics.areEqual((Object)localDate, (Object)v)) break block3;
            }
            this.trail(r);
            this.value[r] = v;
            this.setChanged(r);
        }
    }

    @Override
    public void setObject(int r, @Nullable Object v) {
        this.setDate(r, v instanceof LocalDate ? (LocalDate)v : null);
    }

    @Override
    @Nullable
    public Object retrieveQuery(@NotNull ResultRow result, @NotNull Column<?> column2) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Intrinsics.checkNotNullParameter(column2, (String)"column");
        Object date = result.get((Expression)column2);
        return date instanceof LocalDate ? (LocalDate)date : (date instanceof Date ? ((Date)date).toLocalDate() : null);
    }

    @Override
    public boolean isNullImpl(int r) {
        return this.value[r] == null;
    }

    @Override
    @Nullable
    public LocalDate getDate(int r) {
        Object object = this.getObject(r);
        return object instanceof LocalDate ? (LocalDate)object : null;
    }

    @Override
    @Nullable
    public Object getObjectImpl(int r) {
        return this.value[r];
    }

    @Override
    @NotNull
    public String toText(@Nullable Object o) {
        return o == null ? "" : Companion.toText((LocalDate)o);
    }

    @Override
    @Nullable
    public Object toObject(@NotNull String s) {
        LocalDate now;
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        if (Intrinsics.areEqual((Object)s, (Object)"")) {
            return null;
        }
        int month = 0;
        int year = -2;
        StringTokenizer tokens = new StringTokenizer(s, "/.#");
        if (!tokens.hasMoreTokens()) {
            throw new VFieldException(this, MessageCode.getMessage$default(MessageCode.INSTANCE, "VIS-00003", null, false, 6, null), null, 4, null);
        }
        String string = tokens.nextToken();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tokens.nextToken()");
        int day = Companion.stringToInt$galite_core(string);
        if (tokens.hasMoreTokens()) {
            string = tokens.nextToken();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tokens.nextToken()");
            month = Companion.stringToInt$galite_core(string);
        }
        if (tokens.hasMoreTokens()) {
            string = tokens.nextToken();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tokens.nextToken()");
            year = Companion.stringToInt$galite_core(string);
        }
        if (tokens.hasMoreTokens() || day == -1 || month == -1 || year == -1) {
            throw new VFieldException(this, MessageCode.getMessage$default(MessageCode.INSTANCE, "VIS-00003", null, false, 6, null), null, 4, null);
        }
        if (month == 0) {
            LocalDate localDate = LocalDate.now();
            Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"now()");
            now = localDate;
            month = now.getMonthValue();
            year = now.getYear();
        } else if (year == -2) {
            LocalDate localDate = LocalDate.now();
            Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"now()");
            now = localDate;
            year = now.getYear();
        } else if (year < 50) {
            year += 2000;
        } else if (year < 100) {
            year += 1900;
        } else {
            if (year < 1000) {
                throw new VFieldException(this, MessageCode.getMessage$default(MessageCode.INSTANCE, "VIS-00003", null, false, 6, null), null, 4, null);
            }
            if (!Companion.isDate$galite_core(day, month, year)) {
                throw new VFieldException(this, MessageCode.getMessage$default(MessageCode.INSTANCE, "VIS-00003", null, false, 6, null), null, 4, null);
            }
        }
        return LocalDate.of(year, month, day);
    }

    @Override
    @NotNull
    public String getTextImpl(int r) {
        String string;
        if (this.value[r] == null) {
            string = "";
        } else {
            LocalDate localDate = this.value[r];
            Intrinsics.checkNotNull((Object)localDate);
            string = Companion.toText(localDate);
        }
        return string;
    }

    @Override
    @Nullable
    public LocalDate getSqlImpl(int r) {
        return this.value[r];
    }

    @Override
    public void copyRecord(int f, int t) {
        LocalDate oldValue = this.value[t];
        this.value[t] = this.value[f];
        VBlock vBlock = this.getBlock();
        Intrinsics.checkNotNull((Object)vBlock);
        if (t < vBlock.getBufferSize() && (oldValue != null && this.value[t] == null || oldValue == null && this.value[t] != null || oldValue != null && !Intrinsics.areEqual((Object)oldValue, (Object)this.value[t]))) {
            this.fireValueChanged(t);
        }
    }

    @Override
    @NotNull
    public KClass<?> getDataType() {
        return Reflection.getOrCreateKotlinClass(LocalDate.class);
    }

    @NotNull
    public final String formatDate(@NotNull LocalDate value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return Companion.toText(value);
    }

    private final boolean isDateChar(char c) {
        return ('0' <= c ? c < ':' : false) || c == '.' || c == '/';
    }

    @Override
    public boolean fillField(@Nullable PredefinedValueHandler handler) {
        boolean bl;
        VBlock vBlock = this.getBlock();
        Intrinsics.checkNotNull((Object)vBlock);
        int record = vBlock.getActiveRecord();
        if (this.getList() != null) {
            bl = super.fillField(handler);
        } else {
            boolean bl2;
            try {
                Object object = this.getDisplayedValue(true);
                String oldText = object instanceof String ? (String)object : null;
                this.checkType(oldText);
                VBlock vBlock2 = this.getBlock();
                Intrinsics.checkNotNull((Object)vBlock2);
                String newText = this.getText(vBlock2.getActiveRecord());
                bl2 = oldText == null || newText == null || Intrinsics.areEqual((Object)newText, (Object)"") || !Intrinsics.areEqual((Object)oldText, (Object)newText);
            }
            catch (Exception e) {
                bl2 = true;
            }
            boolean force = bl2;
            if (handler == null || force) {
                this.setDate(record, LocalDate.now());
            } else {
                LocalDate localDate = this.getDate(record);
                Intrinsics.checkNotNull((Object)localDate);
                this.setDate(record, handler.selectDate(localDate));
            }
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean hasNextPreviousEntry() {
        return true;
    }

    @Override
    public void enumerateValue(boolean desc) {
        VBlock vBlock = this.getBlock();
        Intrinsics.checkNotNull((Object)vBlock);
        int record = vBlock.getActiveRecord();
        if (this.getList() != null) {
            super.enumerateValue(desc);
        } else if (this.isNull(record)) {
            this.autofill();
        } else {
            try {
                this.checkType(this.getText(record));
            }
            catch (VException e) {
                this.setDate(record, LocalDate.now());
            }
            LocalDate localDate = this.getDate(record);
            this.setDate(record, localDate == null ? null : localDate.plusDays(desc ? -1L : 1L));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\tJ\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u0015\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000fJ\u000e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012\u00a8\u0006\u0013"}, d2={"Lorg/kopi/galite/visual/form/VDateField$Companion;", "", "()V", "isDate", "", "d", "", "m", "y", "isDate$galite_core", "isLeapYear", "year", "stringToInt", "input", "", "stringToInt$galite_core", "toText", "value", "Ljava/time/LocalDate;", "galite-core"})
    public static final class Companion {
        private Companion() {
        }

        public final int stringToInt$galite_core(@NotNull String input) {
            int n;
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            try {
                n = Integer.valueOf(input);
            }
            catch (Exception e) {
                n = -1;
            }
            return n;
        }

        public final boolean isDate$galite_core(int d, int m, int y) {
            boolean bl;
            if (y < 1 || m < 1 || m > 12 || d < 1) {
                bl = false;
            } else {
                switch (m) {
                    case 2: {
                        if (d <= (this.isLeapYear(y) ? 29 : 28)) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    case 4: 
                    case 6: 
                    case 9: 
                    case 11: {
                        if (d <= 30) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    default: {
                        bl = d <= 31;
                    }
                }
            }
            return bl;
        }

        private final boolean isLeapYear(int year) {
            return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
        }

        @NotNull
        public final String toText(@NotNull LocalDate value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return DefaultFormatKt.format(value);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

