/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.ui.vaadin.block;

import com.vaadin.flow.component.Component;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.ui.vaadin.block.AbstractBlockLayout;
import org.kopi.galite.visual.ui.vaadin.block.ComponentConstraint;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\u0012\u0013B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\u0002\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\bJ\b\u0010\t\u001a\u00020\u0007H\u0002J&\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/block/LayoutManager;", "", "layout", "Lorg/kopi/galite/visual/ui/vaadin/block/AbstractBlockLayout;", "(Lorg/kopi/galite/visual/ui/vaadin/block/AbstractBlockLayout;)V", "handler", "Lorg/kopi/galite/visual/ui/vaadin/block/LayoutManager$ConstraintsHandler;", "", "layout$galite_core", "release", "setComponent", "component", "Lcom/vaadin/flow/component/Component;", "c", "Lorg/kopi/galite/visual/ui/vaadin/block/ComponentConstraint;", "colSpan", "", "rowSpan", "ConstraintWrapper", "ConstraintsHandler", "galite-core"})
public final class LayoutManager {
    @Nullable
    private AbstractBlockLayout layout;
    @Nullable
    private ConstraintsHandler handler;

    public LayoutManager(@Nullable AbstractBlockLayout layout2) {
        this.layout = layout2;
        this.handler = new ConstraintsHandler();
    }

    public final void setComponent(@NotNull Component component, @NotNull ComponentConstraint c, int colSpan, int rowSpan) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        ConstraintWrapper constraint = new ConstraintWrapper(c, colSpan, rowSpan);
        constraint.setComponent(component);
        ConstraintsHandler constraintsHandler = this.handler;
        Intrinsics.checkNotNull((Object)constraintsHandler);
        constraintsHandler.add(constraint);
    }

    public final void layout$galite_core() {
        ConstraintsHandler constraintsHandler = this.handler;
        Intrinsics.checkNotNull((Object)constraintsHandler);
        constraintsHandler.handleColSpan();
        ConstraintsHandler constraintsHandler2 = this.handler;
        Intrinsics.checkNotNull((Object)constraintsHandler2);
        constraintsHandler2.layout(this.layout);
    }

    private final void release() {
        ConstraintsHandler constraintsHandler = this.handler;
        Intrinsics.checkNotNull((Object)constraintsHandler);
        constraintsHandler.release();
        this.handler = null;
        this.layout = null;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001f\u001a\u00020\u0005H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000bR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\t\"\u0004\b\u0019\u0010\u000bR\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\t\"\u0004\b\u001b\u0010\u000b\u00a8\u0006 "}, d2={"Lorg/kopi/galite/visual/ui/vaadin/block/LayoutManager$ConstraintWrapper;", "", "constraint", "Lorg/kopi/galite/visual/ui/vaadin/block/ComponentConstraint;", "colSpan", "", "rowSpan", "(Lorg/kopi/galite/visual/ui/vaadin/block/ComponentConstraint;II)V", "getColSpan", "()I", "setColSpan", "(I)V", "column", "getColumn", "setColumn", "component", "Lcom/vaadin/flow/component/Component;", "getComponent", "()Lcom/vaadin/flow/component/Component;", "setComponent", "(Lcom/vaadin/flow/component/Component;)V", "getConstraint", "()Lorg/kopi/galite/visual/ui/vaadin/block/ComponentConstraint;", "row", "getRow", "setRow", "getRowSpan", "setRowSpan", "equals", "", "other", "hashCode", "galite-core"})
    public static final class ConstraintWrapper {
        @NotNull
        private final ComponentConstraint constraint;
        private int colSpan;
        private int rowSpan;
        private int column;
        private int row;
        public Component component;

        public ConstraintWrapper(@NotNull ComponentConstraint constraint, int colSpan, int rowSpan) {
            Intrinsics.checkNotNullParameter((Object)constraint, (String)"constraint");
            this.constraint = constraint;
            this.colSpan = colSpan;
            this.rowSpan = rowSpan;
            this.column = this.constraint.getX();
            this.row = this.constraint.getY();
        }

        @NotNull
        public final ComponentConstraint getConstraint() {
            return this.constraint;
        }

        public final int getColSpan() {
            return this.colSpan;
        }

        public final void setColSpan(int n) {
            this.colSpan = n;
        }

        public final int getRowSpan() {
            return this.rowSpan;
        }

        public final void setRowSpan(int n) {
            this.rowSpan = n;
        }

        public final int getColumn() {
            return this.column;
        }

        public final void setColumn(int n) {
            this.column = n;
        }

        public final int getRow() {
            return this.row;
        }

        public final void setRow(int n) {
            this.row = n;
        }

        @NotNull
        public final Component getComponent() {
            Component component = this.component;
            if (component != null) {
                return component;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"component");
            return null;
        }

        public final void setComponent(@NotNull Component component) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"<set-?>");
            this.component = component;
        }

        public boolean equals(@Nullable Object other) {
            if (other instanceof ConstraintWrapper) {
                return this.column == ((ConstraintWrapper)other).column && this.row == ((ConstraintWrapper)other).row && this.colSpan == ((ConstraintWrapper)other).colSpan && this.rowSpan == ((ConstraintWrapper)other).rowSpan;
            }
            return false;
        }

        public int hashCode() {
            return this.column + this.row + this.colSpan + this.rowSpan;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005J#\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u000eJ#\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u0010J\u0006\u0010\u0011\u001a\u00020\u0007J\u0010\u0010\u0012\u001a\u00020\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u0006\u0010\u0015\u001a\u00020\u0007R\u0016\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/block/LayoutManager$ConstraintsHandler;", "", "()V", "constraints", "", "Lorg/kopi/galite/visual/ui/vaadin/block/LayoutManager$ConstraintWrapper;", "add", "", "constraint", "getBesideConstraints", "", "row", "", "col", "getBesideConstraints$galite_core", "getBottomConstraints", "getBottomConstraints$galite_core", "handleColSpan", "layout", "container", "Lorg/kopi/galite/visual/ui/vaadin/block/AbstractBlockLayout;", "release", "galite-core"})
    public static final class ConstraintsHandler {
        @Nullable
        private List<ConstraintWrapper> constraints = new ArrayList();

        public final void add(@NotNull ConstraintWrapper constraint) {
            Intrinsics.checkNotNullParameter((Object)constraint, (String)"constraint");
            List<ConstraintWrapper> list = this.constraints;
            Intrinsics.checkNotNull(list);
            list.add(constraint);
        }

        public final void handleColSpan() {
            List<ConstraintWrapper> list = this.constraints;
            Intrinsics.checkNotNull(list);
            for (ConstraintWrapper c : list) {
                if (c.getColSpan() <= 1) continue;
                List<ConstraintWrapper> constraints = this.getBesideConstraints$galite_core(c.getRow(), c.getColumn());
                for (ConstraintWrapper constraint : constraints) {
                    constraint.setColumn(constraint.getColumn() - c.getColSpan() + 1);
                    constraint.getConstraint().setX(constraint.getColumn());
                }
            }
        }

        @NotNull
        public final List<ConstraintWrapper> getBesideConstraints$galite_core(int row, int col) {
            List constraints = null;
            constraints = new ArrayList();
            List<ConstraintWrapper> list = this.constraints;
            Intrinsics.checkNotNull(list);
            for (ConstraintWrapper c : list) {
                if (c.getRow() != row || c.getColumn() <= col) continue;
                constraints.add(c);
            }
            return constraints;
        }

        @NotNull
        public final List<ConstraintWrapper> getBottomConstraints$galite_core(int row, int col) {
            List constraints = null;
            constraints = new ArrayList();
            List<ConstraintWrapper> list = this.constraints;
            Intrinsics.checkNotNull(list);
            for (ConstraintWrapper c : list) {
                if (c.getRow() <= row || c.getRow() > row + c.getRowSpan() || c.getColumn() <= col) continue;
                constraints.add(c);
            }
            return constraints;
        }

        public final void layout(@Nullable AbstractBlockLayout container) {
            List<ConstraintWrapper> list = this.constraints;
            Intrinsics.checkNotNull(list);
            for (ConstraintWrapper c : list) {
                AbstractBlockLayout abstractBlockLayout = container;
                Intrinsics.checkNotNull((Object)abstractBlockLayout);
                abstractBlockLayout.setComponent(c.getComponent(), c.getColumn(), c.getRow(), c.getColSpan(), c.getRowSpan());
            }
        }

        public final void release() {
            List<ConstraintWrapper> list = this.constraints;
            Intrinsics.checkNotNull(list);
            list.clear();
            this.constraints = null;
        }
    }
}

