/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.ui.vaadin.common;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.dom.Element;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.ui.vaadin.label.Label;

@Tag(value="table")
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J/\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00052\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0014\"\u00020\u0001\u00a2\u0006\u0002\u0010\u0015J\u000e\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0001J\u0016\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005J\u0018\u0010\u0019\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005J\u001e\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u0005J\u000e\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u0005J\u000e\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u0005J\u001e\u0010#\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010$\u001a\u00020%J\u001e\u0010&\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010'\u001a\u00020%R\u0011\u0010\b\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006("}, d2={"Lorg/kopi/galite/visual/ui/vaadin/common/VTable;", "Lcom/vaadin/flow/component/Component;", "Lcom/vaadin/flow/component/HasSize;", "Lcom/vaadin/flow/component/HasStyle;", "rowsNumber", "", "colsNumber", "(II)V", "rowCount", "getRowCount", "()I", "tbody", "Lcom/vaadin/flow/dom/Element;", "getTbody", "()Lcom/vaadin/flow/dom/Element;", "add", "", "row", "column", "components", "", "(II[Lcom/vaadin/flow/component/Component;)V", "addInNewRow", "component", "getCellAt", "getCellAtOrNull", "setAlignment", "right", "", "setBorderWidth", "width", "setCellPadding", "padding", "setCellSpacing", "spacing", "setColSpan", "colSpan", "", "setRowSpan", "rowSpan", "galite-core"})
public class VTable
extends Component
implements HasSize,
HasStyle {
    @NotNull
    private final Element tbody = new Element("tbody");

    public VTable(int rowsNumber, int colsNumber) {
        Element[] elementArray = new Element[]{this.tbody};
        this.getElement().appendChild(elementArray);
        int n = 0;
        while (n < rowsNumber) {
            int i = n++;
            Element tr = new Element("tr");
            Element[] elementArray2 = new Element[]{tr};
            this.tbody.appendChild(elementArray2);
            int n2 = 0;
            while (n2 < colsNumber) {
                int j = n2++;
                Element[] elementArray3 = new Element[]{new Element("td")};
                tr.appendChild(elementArray3);
            }
        }
    }

    @NotNull
    public final Element getTbody() {
        return this.tbody;
    }

    public final void setCellSpacing(int spacing) {
        this.getElement().setProperty("cellSpacing", (double)spacing);
    }

    public final void setCellPadding(int padding) {
        this.getElement().setProperty("cellPadding", (double)padding);
    }

    public final void setBorderWidth(int width) {
        this.getElement().setProperty("border", Intrinsics.stringPlus((String)"", (Object)width));
    }

    public final void add(int row, int column2, Component ... components) {
        Intrinsics.checkNotNullParameter((Object)components, (String)"components");
        Element cell = this.getCellAt(row, column2);
        Component[] $this$forEach$iv = components;
        boolean $i$f$forEach = false;
        for (Component element$iv : $this$forEach$iv) {
            Component it = element$iv;
            boolean bl = false;
            Element[] elementArray = new Element[]{it.getElement()};
            cell.appendChild(elementArray);
            if (!(it instanceof Label)) continue;
            cell.getStyle().set("padding-top", "5px");
        }
    }

    public final void setAlignment(int row, int column2, boolean right) {
        this.getCellAt(row, column2).setProperty("align", right ? "right" : "left");
    }

    public final void setColSpan(int row, int column2, @NotNull String colSpan) {
        Intrinsics.checkNotNullParameter((Object)colSpan, (String)"colSpan");
        this.getCellAt(row, column2).setProperty("colSpan", colSpan);
    }

    public final void setRowSpan(int row, int column2, @NotNull String rowSpan) {
        Intrinsics.checkNotNullParameter((Object)rowSpan, (String)"rowSpan");
        this.getCellAt(row, column2).setProperty("rowSpan", rowSpan);
    }

    @NotNull
    public final Element getCellAt(int row, int column2) {
        if (row < 0 || row >= this.tbody.getChildCount()) {
            throw new IndexOutOfBoundsException(Intrinsics.stringPlus((String)"Row index out of range: ", (Object)row));
        }
        Element tableRow = this.tbody.getChild(row);
        if (column2 < 0 || column2 >= tableRow.getChildCount()) {
            throw new IndexOutOfBoundsException(Intrinsics.stringPlus((String)"Column index out of range: ", (Object)column2));
        }
        Element element = tableRow.getChild(column2);
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"tableRow.getChild(column)");
        return element;
    }

    public final void addInNewRow(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Element tr = new Element("tr");
        Element[] elementArray = new Element[]{component.getElement()};
        Element componentInTD = (Element)new Element("td").appendChild(elementArray);
        elementArray = new Element[]{tr};
        this.tbody.appendChild(elementArray);
        elementArray = new Element[]{componentInTD};
        tr.appendChild(elementArray);
    }

    @Nullable
    public final Element getCellAtOrNull(int row, int column2) {
        if (row < 0 || row >= this.tbody.getChildCount()) {
            return null;
        }
        Element tableRow = this.tbody.getChild(row);
        if (column2 < 0 || column2 >= tableRow.getChildCount()) {
            return null;
        }
        return tableRow.getChild(column2);
    }

    public final int getRowCount() {
        return this.tbody.getChildCount();
    }
}

