/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.ui.vaadin.report;

import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kopi.galite.visual.report.ColumnStyle;
import org.kopi.galite.visual.report.MReport;
import org.kopi.galite.visual.report.Parameters;
import org.kopi.galite.visual.report.VReportColumn;
import org.kopi.galite.visual.report.VReportRow;
import org.kopi.galite.visual.report.VSeparatorColumn;
import org.kopi.galite.visual.ui.vaadin.report.DTable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J@\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0016\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\""}, d2={"Lorg/kopi/galite/visual/ui/vaadin/report/ReportCellStyler;", "", "model", "Lorg/kopi/galite/visual/report/MReport;", "parameters", "Lorg/kopi/galite/visual/report/Parameters;", "table", "Lorg/kopi/galite/visual/ui/vaadin/report/DTable;", "(Lorg/kopi/galite/visual/report/MReport;Lorg/kopi/galite/visual/report/Parameters;Lorg/kopi/galite/visual/ui/vaadin/report/DTable;)V", "getTable", "()Lorg/kopi/galite/visual/ui/vaadin/report/DTable;", "fontStyle", "", "isItalic", "", "fontWeight", "isBold", "getCSSColor", "color", "Ljava/awt/Color;", "setStyle", "", "level", "", "background", "foreground", "fontSize", "fontFamily", "updateStyle", "columnStyle", "Lorg/kopi/galite/visual/report/ColumnStyle;", "updateStyles", "i", "j", "galite-core"})
public final class ReportCellStyler {
    @NotNull
    private final MReport model;
    @NotNull
    private final Parameters parameters;
    @NotNull
    private final DTable table;

    public ReportCellStyler(@NotNull MReport model2, @NotNull Parameters parameters, @NotNull DTable table) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        this.model = model2;
        this.parameters = parameters;
        this.table = table;
    }

    @NotNull
    public final DTable getTable() {
        return this.table;
    }

    public final void updateStyles(int i, int j) {
        VReportColumn column2 = this.model.getAccessibleColumn(j);
        if (column2 instanceof VSeparatorColumn) {
            return;
        }
        VReportColumn vReportColumn = column2;
        Intrinsics.checkNotNull((Object)vReportColumn);
        ColumnStyle style = vReportColumn.getStyles()[0];
        VReportRow vReportRow = this.model.getRow(i);
        Intrinsics.checkNotNull((Object)vReportRow);
        this.updateStyle(style, vReportRow.getLevel());
    }

    private final void updateStyle(ColumnStyle columnStyle, int level) {
        Color background = !Intrinsics.areEqual((Object)columnStyle.getBackground(), (Object)columnStyle.getBackground()) ? columnStyle.getBackground() : this.parameters.getBackground(level);
        Color foreground = !Intrinsics.areEqual((Object)columnStyle.getForeground(), (Object)columnStyle.getForeground()) ? columnStyle.getForeground() : this.parameters.getForeground(level);
        int fontSize = columnStyle.getFont().getSize() != columnStyle.getFont().getSize() ? columnStyle.getFont().getSize() : this.parameters.getFont().getSize();
        String fontFamily = !Intrinsics.areEqual((Object)columnStyle.getFont().getName(), (Object)columnStyle.getFont().getName()) ? columnStyle.getFont().getName() : this.parameters.getFont().getName();
        boolean isBold = columnStyle.getFont().isBold() != columnStyle.getFont().isBold() ? columnStyle.getFont().isBold() : this.parameters.getFont().isBold();
        boolean isItalic = columnStyle.getFont().isItalic() != columnStyle.getFont().isItalic() ? columnStyle.getFont().isItalic() : this.parameters.getFont().isItalic();
        Intrinsics.checkNotNullExpressionValue((Object)fontFamily, (String)"fontFamily");
        this.setStyle(level, background, foreground, fontSize, fontFamily, this.fontWeight(isBold), this.fontStyle(isItalic));
    }

    private final void setStyle(int level, Color background, Color foreground, int fontSize, String fontFamily, String fontWeight, String fontStyle) {
        this.table.getStyle().set("--level-" + level + "-background", this.getCSSColor(background));
        this.table.getStyle().set("--level-" + level + "-color", this.getCSSColor(foreground));
        this.table.getStyle().set("--level-" + level + "-font-size", String.valueOf(fontSize));
        this.table.getStyle().set("--level-" + level + "-font-family", fontFamily);
        this.table.getStyle().set("--level-" + level + "-font-weight", fontWeight);
        this.table.getStyle().set("--level-" + level + "-font-style", fontStyle);
    }

    private final String getCSSColor(Color color) {
        return "rgb(" + color.getRed() + ',' + color.getGreen() + ',' + color.getBlue() + ')';
    }

    private final String fontWeight(boolean isBold) {
        return isBold ? "bold" : "normal";
    }

    private final String fontStyle(boolean isItalic) {
        return isItalic ? "italic" : "normal";
    }
}

