/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.util;

import gnu.hylafax.HylaFAXClient;
import gnu.hylafax.Job;
import gnu.hylafax.Pagesize;
import gnu.inet.ftp.ServerResponseException;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.util.AbstractPrinter;
import org.kopi.galite.visual.util.PrintJob;
import org.kopi.galite.visual.util.Printer;
import org.kopi.galite.visual.util.base.InconsistencyException;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\f\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0017\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\r\u00a8\u0006\u0014"}, d2={"Lorg/kopi/galite/visual/util/HylaFAXPrinter;", "Lorg/kopi/galite/visual/util/AbstractPrinter;", "Lorg/kopi/galite/visual/util/Printer;", "faxHost", "", "number", "user", "attachments", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getAttachments", "()Ljava/util/List;", "getNumber", "()Ljava/lang/String;", "setNumber", "(Ljava/lang/String;)V", "getUser", "print", "data", "Lorg/kopi/galite/visual/util/PrintJob;", "galite-core"})
public final class HylaFAXPrinter
extends AbstractPrinter
implements Printer {
    @NotNull
    private final String faxHost;
    @NotNull
    private String number;
    @NotNull
    private final String user;
    @Nullable
    private final List<?> attachments;

    public HylaFAXPrinter(@NotNull String faxHost, @NotNull String number, @NotNull String user, @Nullable List<?> attachments) {
        Intrinsics.checkNotNullParameter((Object)faxHost, (String)"faxHost");
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        super(Intrinsics.stringPlus((String)"FaxPrinter ", (Object)number));
        this.faxHost = faxHost;
        this.number = number;
        this.user = user;
        this.attachments = attachments;
    }

    @NotNull
    public final String getNumber() {
        return this.number;
    }

    public final void setNumber(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.number = string;
    }

    @NotNull
    public final String getUser() {
        return this.user;
    }

    @Nullable
    public final List<?> getAttachments() {
        return this.attachments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public String print(@NotNull PrintJob data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        ArrayList<String> documents = new ArrayList<String>();
        HylaFAXClient faxClient = new HylaFAXClient();
        try {
            Job job;
            HylaFAXClient $this$print_u24lambda_u2d0 = faxClient;
            boolean bl = false;
            $this$print_u24lambda_u2d0.setDebug(false);
            $this$print_u24lambda_u2d0.open(this.faxHost);
            $this$print_u24lambda_u2d0.user(this.getUser());
            $this$print_u24lambda_u2d0.type('I');
            $this$print_u24lambda_u2d0.noop();
            $this$print_u24lambda_u2d0.tzone("LOCAL");
            documents.add(faxClient.putTemporary(data.getInputStream()));
            List<?> list = this.attachments;
            if (list != null) {
                List<?> it = list;
                boolean bl2 = false;
                Iterable $this$forEach$iv = it;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv;
                    Object element = element$iv = iterator.next();
                    boolean bl3 = false;
                    Object t = element;
                    if (t == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.io.InputStream");
                    }
                    InputStream dataSource = (InputStream)t;
                    documents.add(faxClient.putTemporary(dataSource));
                }
            }
            Job $this$print_u24lambda_u2d3 = job = faxClient.createJob();
            boolean bl4 = false;
            $this$print_u24lambda_u2d3.setFromUser(this.getUser());
            $this$print_u24lambda_u2d3.setNotifyAddress(this.getUser());
            $this$print_u24lambda_u2d3.setKilltime("000259");
            $this$print_u24lambda_u2d3.setMaximumDials(3);
            $this$print_u24lambda_u2d3.setMaximumTries(3);
            $this$print_u24lambda_u2d3.setPriority(127);
            $this$print_u24lambda_u2d3.setDialstring(this.getNumber());
            $this$print_u24lambda_u2d3.setVerticalResolution(196);
            $this$print_u24lambda_u2d3.setPageDimension((Dimension)Pagesize.A4);
            $this$print_u24lambda_u2d3.setNotifyType("NONE");
            $this$print_u24lambda_u2d3.setChopThreshold(3);
            Iterable $this$forEach$iv = documents;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator.next();
                boolean bl5 = false;
                job.addDocument((String)it);
            }
            faxClient.submit(job);
        }
        catch (ServerResponseException e) {
            throw new InconsistencyException("Can't send fax job", e);
        }
        catch (IOException e) {
            throw new InconsistencyException("Can't send fax job", e);
        }
        finally {
            try {
                faxClient.quit();
            }
            catch (IOException e) {
                throw new InconsistencyException("Can't disconnect from server", e);
            }
            catch (ServerResponseException e) {
                throw new InconsistencyException("Can't disconnect from server", e);
            }
        }
        return "NYI";
    }
}

