/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.vkopi.lib.ui.swing.form;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.kopi.galite.visual.base.UComponent;
import org.kopi.galite.visual.form.UBlock;
import org.kopi.galite.visual.form.UField;
import org.kopi.galite.visual.form.VBlock;
import org.kopi.galite.visual.form.VField;
import org.kopi.galite.visual.form.VFieldUI;
import org.kopi.galite.visual.form.VForm;
import org.kopi.galite.visual.visual.Action;
import org.kopi.galite.visual.visual.VColor;
import org.kopi.vkopi.lib.ui.swing.base.JFieldButton;
import org.kopi.vkopi.lib.ui.swing.base.Utils;
import org.kopi.vkopi.lib.ui.swing.form.DLabel;
import org.kopi.vkopi.lib.ui.swing.visual.SwingThreadHandler;

public abstract class DField
extends JPanel
implements UField {
    protected VFieldUI model;
    public DLabel label;
    protected JFieldButton info;
    protected JFieldButton incr;
    protected JFieldButton decr;
    protected int state;
    protected int pos;
    protected int options;
    protected int align;
    protected int access;
    protected boolean isEditable;
    protected boolean mouseInside;
    private boolean inDetail;
    private static final ImageIcon listImg = Utils.getImage("list.gif");
    private static final ImageIcon rightImg = Utils.getImage("arrowright.gif");
    private static final ImageIcon leftImg = Utils.getImage("arrowleft.gif");

    public DField(VFieldUI model2, DLabel label, int align, int options, boolean detail) {
        this.setLayout(new BorderLayout());
        this.addMouseListener(new DFieldMouseListener());
        this.inDetail = detail;
        this.model = model2;
        this.options = options;
        this.label = label;
        this.align = align;
        boolean bl = this.isEditable = (options & 2) == 0;
        if (!this.getModel().getBlock().isMulti() || this.getModel().getBlock().noChart() || this.isInDetail()) {
            JPanel optionPane = new JPanel();
            optionPane.setLayout(new BorderLayout());
            if (model2.hasAutofill()) {
                this.info = new JFieldButton(listImg);
                this.info.addActionListener(new AbstractAction(){
                    private static final long serialVersionUID = 2172836625163999381L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DField.this.getModel().getForm().performAsyncAction(new Action("autofill"){

                            @Override
                            public void execute() {
                                DField.this.model.transferFocus(DField.this);
                                DField.this.model.autofillButton();
                            }
                        });
                    }
                });
                this.info.setEnabled(this.getModel().getDefaultAccess() > 1);
                optionPane.add((Component)this.info, "West");
            }
            if (model2.getDecrementCommand() != null) {
                this.decr = new JFieldButton(leftImg);
                this.decr.addActionListener(new AbstractAction(){
                    private static final long serialVersionUID = -6114904737254808842L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DField.this.model.getDecrementCommand().performAction();
                    }
                });
                optionPane.add((Component)this.decr, "Center");
            }
            if (model2.getIncrementCommand() != null) {
                this.incr = new JFieldButton(rightImg);
                this.incr.addActionListener(new AbstractAction(){
                    private static final long serialVersionUID = -3670989616287237005L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DField.this.model.getIncrementCommand().performAction();
                    }
                });
                optionPane.add((Component)this.incr, "East");
            }
            this.add((Component)optionPane, "East");
        }
    }

    @Override
    public abstract Object getObject();

    @Override
    public void setPosition(int pos) {
        this.pos = pos;
    }

    @Override
    public int getPosition() {
        return this.pos;
    }

    public int getAlign() {
        return this.align;
    }

    void enter(boolean refresh) {
        this.updateFocus();
    }

    void leave() {
        this.updateFocus();
    }

    @Override
    public void updateText() {
    }

    @Override
    public void updateFocus() {
        SwingThreadHandler.verifyRunsInEventThread("DField.updateFocus");
        if (this.modelHasFocus()) {
            VForm form = this.getModel().getForm();
            form.setInformationText(this.getModel().getToolTip());
            form.setFieldSearchOperator(this.getModel().getSearchOperator());
        }
    }

    @Override
    public void forceFocus() {
    }

    @Override
    public void updateAccess() {
        SwingThreadHandler.verifyRunsInEventThread("DField.updateAccess");
        this.access = this.getAccess();
        this.setVisible(this.access != 0);
        this.fireMouseHasChanged();
        this.update(this.info);
        this.update(this.incr);
        this.update(this.decr);
    }

    public void update() {
    }

    @Override
    public UBlock getBlockView() {
        return this.model.getBlockView();
    }

    protected final boolean modelHasFocus() {
        if (this.getModel() == null) {
            return false;
        }
        VBlock block2 = this.getModel().getBlock();
        return this.getModel().hasFocus() && block2.getActiveRecord() == this.model.getBlockView().getRecordFromDisplayLine(this.pos);
    }

    protected final boolean isSkipped() {
        VBlock block2 = this.getModel().getBlock();
        return this.getAccess() == 1 || !block2.isRecordAccessible(this.model.getBlockView().getRecordFromDisplayLine(this.getPosition()));
    }

    @Override
    public final int getAccess() {
        return this.getAccessAt(this.getPosition());
    }

    @Override
    public final Color getForeground() {
        return this.getForegroundAt(this.getPosition());
    }

    @Override
    public final Color getBackground() {
        return this.getBackgroundAt(this.getPosition());
    }

    protected final int getAccessAt(int at) {
        if (this.getModel() != null) {
            return this.getModel().getAccess(this.model.getBlockView().getRecordFromDisplayLine(at));
        }
        return 1;
    }

    protected final Color getForegroundAt(int at) {
        if (this.model != null) {
            VColor foreground = this.getModel().getForeground(this.model.getBlockView().getRecordFromDisplayLine(at));
            return foreground == null ? null : new Color(foreground.getRGB());
        }
        return null;
    }

    protected final Color getBackgroundAt(int at) {
        if (this.model != null) {
            VColor background = this.getModel().getBackground(this.model.getBlockView().getRecordFromDisplayLine(at));
            return background == null ? null : new Color(background.getRGB());
        }
        return null;
    }

    @Override
    public final VField getModel() {
        return this.model.getModel();
    }

    public final void fireMouseHasChanged() {
        VBlock block2;
        int localAccess = this.getAccess();
        int oldState = this.state;
        this.state = 0;
        if (this.modelHasFocus()) {
            this.state |= 8;
        }
        if (!this.isEditable) {
            this.state |= 0x80;
        }
        if (this.getModel().getBorder() == 5) {
            this.state |= 0x100;
        }
        if ((block2 = this.model.getBlock()).isMulti() && !block2.noChart() && !this.isInDetail()) {
            this.state |= 0x10;
            if (block2.getActiveRecord() == this.model.getBlockView().getRecordFromDisplayLine(this.pos)) {
                this.state |= 0x40;
            }
        } else {
            this.state |= 0x40;
        }
        if (this.mouseInside) {
            this.state |= 0x20;
        }
        switch (localAccess) {
            case 0: {
                this.state |= 1;
                break;
            }
            case 4: {
                this.state |= 4;
                break;
            }
            case 2: {
                this.state |= 3;
                break;
            }
            default: {
                this.state |= 2;
            }
        }
        if (oldState != this.state) {
            this.setDisplayProperties();
        }
    }

    @Override
    public UComponent getAutofillButton() {
        return this.info;
    }

    public VFieldUI getRowController() {
        return this.model;
    }

    protected abstract void setDisplayProperties();

    @Override
    public void prepareSnapshot(int fieldPos, boolean activ) {
        this.label.prepareSnapshot(activ);
        if (activ) {
            this.state |= 8;
            this.setDisplayProperties();
        } else {
            this.state |= 2;
            this.setDisplayProperties();
        }
        if (this.info != null) {
            this.info.setVisible(false);
        }
        if (this.incr != null) {
            this.incr.setVisible(false);
        }
        if (this.decr != null) {
            this.decr.setVisible(false);
        }
    }

    private void update(JButton button) {
        if (button != null) {
            boolean will;
            boolean was = button.isEnabled();
            boolean bl = will = this.access >= 2;
            if (was != will) {
                button.setEnabled(will);
            }
        }
    }

    @Override
    public void setInDetail(boolean detail) {
        this.inDetail = detail;
        this.label.setInDetailMode(detail);
    }

    public boolean isInDetail() {
        return this.inDetail;
    }

    protected final class DFieldMouseListener
    extends MouseAdapter {
        protected DFieldMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.performAction();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            DField.this.mouseInside = true;
            DField.this.fireMouseHasChanged();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            DField.this.mouseInside = false;
            DField.this.fireMouseHasChanged();
        }

        private void performAction() {
            if (!DField.this.model.hasAction() && !DField.this.modelHasFocus()) {
                if (DField.this.model.getBlock().isMulti()) {
                    int recno = DField.this.model.getBlockView().getRecordFromDisplayLine(DField.this.getPosition());
                    if (!DField.this.model.getBlock().isRecordFilled(recno)) {
                        DField.this.model.getBlock().updateAccess(recno);
                    }
                }
                if (!DField.this.model.getBlock().isMulti() || DField.this.model.getBlock().isDetailMode() == DField.this.isInDetail() || DField.this.model.getBlock().noChart()) {
                    Action action2 = new Action("mouse1"){

                        @Override
                        public void execute() {
                            DField.this.model.transferFocus(DField.this);
                        }
                    };
                    DField.this.model.performAsyncAction(action2);
                }
            }
        }
    }
}

