/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.vkopi.lib.ui.swing.form;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import org.kopi.galite.visual.form.VField;
import org.kopi.galite.visual.form.VFieldUI;
import org.kopi.galite.visual.visual.Action;
import org.kopi.vkopi.lib.ui.swing.form.DField;
import org.kopi.vkopi.lib.ui.swing.form.DLabel;

public abstract class DObjectField
extends DField {
    private static final int KEY_TAB = 0;
    private static final int KEY_STAB = 1;
    private static final int KEY_REC_UP = 2;
    private static final int KEY_REC_DOWN = 3;
    private static final int KEY_REC_FIRST = 4;
    private static final int KEY_REC_LAST = 5;
    private static final int KEY_BLOCK = 6;
    private static final long serialVersionUID = -4243258834913065429L;

    public DObjectField(VFieldUI model2, DLabel label, int align, int options, boolean detail) {
        super(model2, label, align, options, detail);
        this.addNavigationKey();
        this.setRequestFocusEnabled(true);
        this.setFocusCycleRoot(true);
    }

    void addNavigationKey() {
        this.addKey(0, 10, 0);
        this.addKey(0, 9, 0);
        this.addKey(1, 9, 1);
        this.addKey(6, 10, 1);
        this.addKey(2, 33, 0);
        this.addKey(3, 34, 0);
        this.addKey(4, 36, 0);
        this.addKey(5, 35, 0);
        this.addKey(1, 37, 2);
        this.addKey(0, 39, 2);
        this.addKey(2, 38, 2);
        this.addKey(3, 40, 2);
    }

    private void addKey(int code, int key, int mod) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(key, mod);
        this.registerKeyboardAction(new Navigator(code), null, keyStroke, 0);
    }

    @Override
    void enter(boolean refresh) {
        super.enter(refresh);
        this.requestFocusInWindow();
        this.setBlink(true);
    }

    @Override
    void leave() {
        this.setBlink(false);
        super.leave();
    }

    static class Navigator
    extends AbstractAction {
        private int keyCode;

        Navigator(int keyCode) {
            super("navigation-key");
            this.keyCode = keyCode;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Action action2 = null;
            if (e.getSource() == null) {
                return;
            }
            final VField field = ((DField)e.getSource()).getModel();
            if (field == null || field.getForm() == null || field.getForm().getActiveBlock() == null || field.getForm().getActiveBlock().getActiveField() != field && this.keyCode != 6) {
                return;
            }
            switch (this.keyCode) {
                case 0: {
                    action2 = new Action("key: next field"){

                        @Override
                        public void execute() {
                            field.getForm().getActiveBlock().gotoNextField();
                        }
                    };
                    break;
                }
                case 1: {
                    action2 = new Action("key: previous field"){

                        @Override
                        public void execute() {
                            field.getForm().getActiveBlock().gotoPrevField();
                        }
                    };
                    break;
                }
                case 6: {
                    action2 = new Action("key: next block"){

                        @Override
                        public void execute() {
                            field.getForm().gotoNextBlock();
                        }
                    };
                    break;
                }
                case 2: {
                    action2 = new Action("key: previous record"){

                        @Override
                        public void execute() {
                            field.getForm().getActiveBlock().gotoPrevRecord();
                        }
                    };
                    break;
                }
                case 3: {
                    action2 = new Action("key: next record"){

                        @Override
                        public void execute() {
                            field.getForm().getActiveBlock().gotoNextRecord();
                        }
                    };
                    break;
                }
                case 4: {
                    action2 = new Action("key: first record"){

                        @Override
                        public void execute() {
                            field.getForm().getActiveBlock().gotoFirstRecord();
                        }
                    };
                    break;
                }
                case 5: {
                    action2 = new Action("key: last record"){

                        @Override
                        public void execute() {
                            field.getForm().getActiveBlock().gotoLastRecord();
                        }
                    };
                }
            }
            field.getForm().performAsyncAction(action2);
        }
    }
}

