/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.vkopi.lib.ui.swing.spellchecker;

import java.awt.Frame;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.kopi.galite.visual.visual.VlibProperties;
import org.kopi.vkopi.lib.ui.swing.base.Utils;
import org.kopi.vkopi.lib.ui.swing.spellchecker.AspellProcess;
import org.kopi.vkopi.lib.ui.swing.spellchecker.SpellException;
import org.kopi.vkopi.lib.ui.swing.spellchecker.SpellcheckerDialog;
import org.kopi.vkopi.lib.ui.swing.spellchecker.Suggestions;

public class SpellChecker {
    private Suggestions result;
    private Iterator<Suggestions> resultIterator;
    private final Document document;
    private final String aspell;
    private final Frame parent;
    private final HashMap<String, String> changeAllMap = new HashMap();
    private final HashSet<String> ignoreAllSet = new HashSet();
    public static final ImageIcon ICN_NOTICE = Utils.getImage("notice.gif");

    public SpellChecker(String aspell, Frame parent, Document document) {
        this.aspell = aspell;
        this.parent = parent;
        this.document = document;
    }

    public void check() throws SpellException {
        AspellProcess spellChecker = new AspellProcess(this.aspell);
        List<Suggestions> results = null;
        try {
            results = spellChecker.checkText(this.document.getText(0, this.document.getLength()));
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.resultIterator = results.iterator();
        if (this.checkNext()) {
            SpellcheckerDialog spellDialog = new SpellcheckerDialog(this.parent, VlibProperties.getString("aspell-dialog-title"), this);
            spellDialog.show();
        }
        Object[] options = new Object[]{VlibProperties.getString("CLOSE")};
        JOptionPane.showOptionDialog(this.parent, VlibProperties.getString("aspell-finished"), VlibProperties.getString("aspell-notice"), -1, 1, ICN_NOTICE, options, options[0]);
    }

    protected boolean checkNext() {
        if (!this.resultIterator.hasNext()) {
            return false;
        }
        this.result = this.resultIterator.next();
        if (this.result.getType() != Suggestions.RLT_OK) {
            if (this.changeAllMap.containsKey(this.result.getOriginalWord())) {
                String replacementWord = this.changeAllMap.get(this.result.getOriginalWord());
                this.replaceWord(replacementWord);
                return this.checkNext();
            }
            if (this.ignoreAllSet.contains(this.result.getOriginalWord())) {
                return this.checkNext();
            }
            return true;
        }
        return this.checkNext();
    }

    Suggestions getSuggestions() {
        return this.result;
    }

    void change(String word) {
        if (this.changeAllMap.containsKey(this.result.getOriginalWord())) {
            System.err.println("Change  all: same word: " + this.result.getOriginalWord());
        }
        this.changeAllMap.put(this.result.getOriginalWord(), word);
        this.replaceWord(word);
    }

    void changeAll(String word) {
        this.replaceWord(word);
    }

    void ignore(String word) {
    }

    void ignoreAll(String word) {
        if (this.ignoreAllSet.contains(this.result.getOriginalWord())) {
            System.err.println("Ignore all: same word: " + this.result.getOriginalWord());
        }
        this.ignoreAllSet.add(this.result.getOriginalWord());
    }

    protected void replaceWord(String replacementWord) {
        String originalWord = this.result.getOriginalWord();
        int originalIndex = this.result.getOffset();
        try {
            this.document.remove(originalIndex - 1, originalWord.length());
            this.document.insertString(originalIndex - 1, replacementWord, null);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }
}

