/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.vkopi.lib.ui.swing.visual;

import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import org.kopi.galite.visual.visual.Item;
import org.kopi.vkopi.lib.ui.swing.base.Utils;

class ItemRenderer
extends JLabel
implements TreeCellRenderer {
    public static ImageIcon formIcon;
    private static ImageIcon rootIcon;
    private static ImageIcon collapsedIcon;
    private static ImageIcon expandedIcon;
    private static ImageIcon selectedFormIcon;
    private static ImageIcon checkedIcon;
    private static ImageIcon uncheckedIcon;
    private static ImageIcon defaultIcon;
    private static ImageIcon checkedIcon_S;
    private static ImageIcon uncheckedIcon_S;
    private static ImageIcon defaultIcon_S;
    private static ImageIcon radioCheckedIcon;
    private static ImageIcon radioCheckedIcon_S;
    private boolean noEdit;
    private boolean singleSelection;
    private boolean localised;
    private static Color CLR_PARENT;
    private static Color CLR_UNSELECT;
    private static Color CLR_FOCUS;
    private static Color CLR_FOCUS_BACK;
    private static final long serialVersionUID = -926187515637797250L;

    ItemRenderer(boolean noEdit, boolean singleSelection, boolean localised) {
        this.noEdit = noEdit;
        this.singleSelection = singleSelection;
        this.localised = localised;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Item item = (Item)((DefaultMutableTreeNode)value).getUserObject();
        if (hasFocus) {
            this.setOpaque(true);
            this.setBackground(CLR_FOCUS_BACK);
            this.setForeground(CLR_FOCUS);
        } else if (!leaf) {
            this.setOpaque(false);
            this.setForeground(CLR_PARENT);
        } else {
            this.setOpaque(false);
            this.setForeground(CLR_UNSELECT);
        }
        this.setText(item.getFormattedName(this.localised));
        if (row == 0) {
            this.setIcon(rootIcon);
        } else if (!this.noEdit) {
            if (item.isDefaultItem()) {
                if (hasFocus) {
                    this.setIcon(defaultIcon_S);
                } else {
                    this.setIcon(defaultIcon);
                }
            } else if (!item.isSelected()) {
                if (hasFocus) {
                    this.setIcon(uncheckedIcon_S);
                } else {
                    this.setIcon(uncheckedIcon);
                }
            } else if (hasFocus) {
                this.setIcon(this.singleSelection ? radioCheckedIcon_S : checkedIcon_S);
            } else {
                this.setIcon(this.singleSelection ? radioCheckedIcon : checkedIcon);
            }
        } else if (expanded) {
            this.setIcon(expandedIcon);
        } else if (!leaf) {
            this.setIcon(collapsedIcon);
        } else if (hasFocus) {
            this.setIcon(item.getSmallIcon() == null ? selectedFormIcon : (ImageIcon)((Object)item.getSmallIcon()));
        } else {
            this.setIcon(item.getSmallIcon() == null ? formIcon : (ImageIcon)((Object)item.getSmallIcon()));
        }
        return this;
    }

    static {
        collapsedIcon = Utils.getImage("collapsed.gif");
        expandedIcon = Utils.getImage("expanded.gif");
        formIcon = Utils.getImage("form.gif");
        selectedFormIcon = Utils.getImage("forms.png");
        checkedIcon = Utils.getImage("checked.png");
        uncheckedIcon = Utils.getImage("unchecked.png");
        defaultIcon = Utils.getImage("default.png");
        checkedIcon_S = Utils.getImage("checked_s.png");
        uncheckedIcon_S = Utils.getImage("unchecked_s.png");
        defaultIcon_S = Utils.getImage("default_s.png");
        radioCheckedIcon = Utils.getImage("radio_checked.png");
        radioCheckedIcon_S = Utils.getImage("radio_checked_s.png");
        rootIcon = Utils.getImage("desk.gif");
        if (rootIcon != null) {
            rootIcon = new ImageIcon(rootIcon.getImage().getScaledInstance(16, 16, 4));
        }
        CLR_PARENT = UIManager.getColor("kopi.menuitem.parent");
        CLR_UNSELECT = UIManager.getColor("kopi.menuitem.unselect");
        CLR_FOCUS = UIManager.getColor("kopi.menuitem.focus");
        CLR_FOCUS_BACK = UIManager.getColor("kopi.menuitem.focus.background");
    }
}

