/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.ui.vaadin.field;

import java.math.BigDecimal;
import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.ui.vaadin.field.AllowAllValidator;
import org.kopi.galite.visual.ui.vaadin.field.CheckTypeException;
import org.kopi.galite.visual.ui.vaadin.field.InputTextField;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000bJ\u001c\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012H\u0002J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0017J\u0010\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0012\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/field/DecimalValidator;", "Lorg/kopi/galite/visual/ui/vaadin/field/AllowAllValidator;", "maxScale", "", "fraction", "", "width", "minval", "", "maxval", "maxLength", "(IZILjava/lang/Double;Ljava/lang/Double;I)V", "Ljava/lang/Double;", "checkType", "", "field", "Lorg/kopi/galite/visual/ui/vaadin/field/InputTextField;", "text", "", "toFraction", "str", "toString", "value", "Ljava/math/BigDecimal;", "toText", "v", "validate", "c", "", "Companion", "galite-core"})
public final class DecimalValidator
extends AllowAllValidator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int maxScale;
    private final boolean fraction;
    private final int width;
    @Nullable
    private final Double minval;
    @Nullable
    private final Double maxval;

    public DecimalValidator(int maxScale, boolean fraction, int width, @Nullable Double minval, @Nullable Double maxval, int maxLength) {
        super(maxLength);
        this.maxScale = maxScale;
        this.fraction = fraction;
        this.width = width;
        this.minval = minval;
        this.maxval = maxval;
    }

    @Override
    public boolean validate(char c) {
        return ('0' <= c ? c < ':' : false) || c == '.' || c == '-' || c == ' ' || c == ',' || c == '/';
    }

    @Override
    public void checkType(@NotNull InputTextField<?> field, @NotNull String text) {
        Intrinsics.checkNotNullParameter(field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (!Intrinsics.areEqual((Object)"", (Object)text)) {
            Object[] objectArray;
            try {
                objectArray = DecimalValidator.Companion.scanBigDecimal(text);
            }
            catch (NumberFormatException e) {
                throw new CheckTypeException(field, "00006");
            }
            Object[] v = objectArray;
            if (v != null) {
                if (v.scale() > this.maxScale) {
                    objectArray = new Object[]{this.maxScale};
                    throw new CheckTypeException(field, "00011", objectArray);
                }
                if (this.minval != null && v.compareTo(new BigDecimal(this.minval)) == -1) {
                    objectArray = new Object[]{this.minval};
                    throw new CheckTypeException(field, "00012", objectArray);
                }
                if (this.maxval != null && v.compareTo(new BigDecimal(this.maxval)) == 1) {
                    objectArray = new Object[]{this.maxval};
                    throw new CheckTypeException(field, "00009", objectArray);
                }
                objectArray = v.setScale(this.maxScale);
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"v.setScale(maxScale)");
                if (this.toText((BigDecimal)objectArray).length() > this.width) {
                    throw new CheckTypeException(field, "00010");
                }
            }
            Intrinsics.checkNotNull((Object)v);
            objectArray = v.setScale(this.maxScale);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"v!!.setScale(maxScale)");
            field.setValue(this.toText((BigDecimal)objectArray));
        }
    }

    private final String toString(BigDecimal value) {
        String string;
        int n;
        String string2;
        int n2;
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u2d2 = stringBuilder = new StringBuilder();
        boolean bl = false;
        String string3 = value.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"value.toString()");
        String str = string3;
        int pos = 0;
        int dot = 0;
        if (str.charAt(0) == '-') {
            $this$toString_u24lambda_u2d2.append('-');
            pos = 1;
        }
        int it = n2 = StringsKt.indexOf$default((CharSequence)str, (char)'.', (int)0, (boolean)false, (int)6, null);
        boolean bl2 = false;
        dot = it;
        if (n2 == -1) {
            it = n2 = StringsKt.indexOf$default((CharSequence)str, (char)' ', (int)0, (boolean)false, (int)6, null);
            boolean bl3 = false;
            dot = it;
            if (n2 == -1) {
                dot = str.length();
            }
        }
        if (dot - pos <= 3) {
            string2 = str;
            n = dot;
            string = string2.substring(pos, n);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            $this$toString_u24lambda_u2d2.append(string);
            pos = dot;
        } else {
            switch ((dot - pos) % 3) {
                case 1: {
                    String string4 = str;
                    int n3 = pos + 1;
                    String string5 = string4.substring(pos, n3);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    $this$toString_u24lambda_u2d2.append(string5);
                    ++pos;
                    break;
                }
                case 2: {
                    String string6 = str;
                    int n3 = pos + 2;
                    String string5 = string6.substring(pos, n3);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    $this$toString_u24lambda_u2d2.append(string5);
                    pos += 2;
                    break;
                }
                case 0: {
                    String string7 = str;
                    int n3 = pos + 3;
                    String string5 = string7.substring(pos, n3);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    $this$toString_u24lambda_u2d2.append(string5);
                    pos += 3;
                }
            }
            do {
                $this$toString_u24lambda_u2d2.append(".");
                string2 = str;
                n = pos + 3;
                string = string2.substring(pos, n);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                $this$toString_u24lambda_u2d2.append(string);
            } while (dot - (pos += 3) > 0);
        }
        if (str.length() > pos) {
            $this$toString_u24lambda_u2d2.append(",");
            string2 = str;
            n = pos + 1;
            string = string2.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            $this$toString_u24lambda_u2d2.append(string);
        }
        String string8 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"StringBuilder().apply(builderAction).toString()");
        return string8;
    }

    @NotNull
    public final String toText(@NotNull BigDecimal v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return !this.fraction ? this.toString(v) : this.toFraction(this.toString(v));
    }

    private final String toFraction(String str) {
        String string;
        int n;
        int dot = 0;
        int it = n = StringsKt.indexOf$default((CharSequence)str, (char)',', (int)0, (boolean)false, (int)6, null);
        boolean bl = false;
        dot = it;
        if (n == -1) {
            return str;
        }
        String string2 = str.substring(0, dot);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String precomma = string2;
        String string3 = str.substring(dot + 1, str.length());
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        int fract = Integer.valueOf(string3);
        if (fract * 64 % 1000000 != 0) {
            string = str;
        } else if (fract == 0) {
            string = precomma;
        } else {
            int num = 0;
            int den = 64;
            num = fract * den / 1000000;
            while (num % 2 == 0) {
                num /= 2;
                den /= 2;
            }
            string2 = precomma;
            string = Intrinsics.areEqual((Object)string2, (Object)"0") ? "" + num + '/' + den : (Intrinsics.areEqual((Object)string2, (Object)"-0") ? "" + '-' + num + '/' + den : precomma + ' ' + num + '/' + den);
        }
        return string;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/field/DecimalValidator$Companion;", "", "()V", "scanBigDecimal", "Ljava/math/BigDecimal;", "str", "", "galite-core"})
    public static final class Companion {
        private Companion() {
        }

        private final BigDecimal scanBigDecimal(String str) {
            BigDecimal bigDecimal;
            boolean negative = false;
            int state = 0;
            int scale = 0;
            long value = 0L;
            long num = 0L;
            long den = 0L;
            if (Intrinsics.areEqual((Object)str, (Object)"")) {
                return null;
            }
            int n = 0;
            int n2 = str.length();
            block24: while (n < n2) {
                int i;
                if (str.charAt(i = n++) == '.') continue;
                switch (state) {
                    case 0: {
                        if (str.charAt(i) == ' ') {
                            state = 0;
                            continue block24;
                        }
                        if (str.charAt(i) == '+') {
                            state = 1;
                            continue block24;
                        }
                        if (str.charAt(i) == '-') {
                            negative = true;
                            state = 1;
                            continue block24;
                        }
                        if (str.charAt(i) == ',') {
                            state = 3;
                            continue block24;
                        }
                        if (Character.isDigit(str.charAt(i))) {
                            value = Character.digit(str.charAt(i), 10);
                            state = 2;
                            continue block24;
                        }
                        throw new NumberFormatException();
                    }
                    case 1: {
                        if (str.charAt(i) == ' ') {
                            state = 1;
                            continue block24;
                        }
                        if (str.charAt(i) == ',') {
                            state = 3;
                            continue block24;
                        }
                        if (Character.isDigit(str.charAt(i))) {
                            value = Character.digit(str.charAt(i), 10);
                            state = 2;
                            continue block24;
                        }
                        throw new NumberFormatException();
                    }
                    case 2: {
                        if (str.charAt(i) == ',') {
                            state = 3;
                            continue block24;
                        }
                        if (str.charAt(i) == ' ') {
                            state = 4;
                            continue block24;
                        }
                        if (str.charAt(i) == '/') {
                            num = value;
                            value = 0L;
                            state = 6;
                            continue block24;
                        }
                        if (Character.isDigit(str.charAt(i))) {
                            value = (long)10 * value + (long)Character.digit(str.charAt(i), 10);
                            state = 2;
                            continue block24;
                        }
                        throw new NumberFormatException();
                    }
                    case 3: {
                        if (Character.isDigit(str.charAt(i))) {
                            value = (long)10 * value + (long)Character.digit(str.charAt(i), 10);
                            ++scale;
                            state = 3;
                            continue block24;
                        }
                        throw new NumberFormatException();
                    }
                    case 4: {
                        if (str.charAt(i) == ' ') {
                            state = 4;
                            continue block24;
                        }
                        if (Character.isDigit(str.charAt(i))) {
                            num = Character.digit(str.charAt(i), 10);
                            state = 5;
                            continue block24;
                        }
                        throw new NumberFormatException();
                    }
                    case 5: {
                        if (str.charAt(i) == '/') {
                            state = 6;
                            continue block24;
                        }
                        if (Character.isDigit(str.charAt(i))) {
                            num = (long)10 * num + (long)Character.digit(str.charAt(i), 10);
                            state = 5;
                            continue block24;
                        }
                        throw new NumberFormatException();
                    }
                    case 6: {
                        if (str.charAt(i) == '0') {
                            state = 6;
                            continue block24;
                        }
                        if (Character.isDigit(str.charAt(i))) {
                            den = Character.digit(str.charAt(i), 10);
                            state = 7;
                            continue block24;
                        }
                        throw new NumberFormatException();
                    }
                    case 7: {
                        if (Character.isDigit(str.charAt(i))) {
                            den = (long)10 * den + (long)Character.digit(str.charAt(i), 10);
                            state = 7;
                            continue block24;
                        }
                        throw new NumberFormatException();
                    }
                }
                throw new RuntimeException();
            }
            block10 : switch (state) {
                case 0: {
                    return null;
                }
                case 2: {
                    break;
                }
                case 3: {
                    while (scale > 0 && value % (long)10 == 0L) {
                        value /= (long)10;
                        --scale;
                    }
                    break;
                }
                case 7: {
                    if (num > den || num % (long)2 == 0L || den > 64L) {
                        throw new NumberFormatException();
                    }
                    switch ((int)den) {
                        case 2: {
                            value = (long)10 * value + (long)5 * num;
                            scale = 1;
                            break block10;
                        }
                        case 4: {
                            value = (long)100 * value + (long)25 * num;
                            scale = 2;
                            break block10;
                        }
                        case 8: {
                            value = (long)1000 * value + (long)125 * num;
                            scale = 3;
                            break block10;
                        }
                        case 16: {
                            value = (long)10000 * value + (long)625 * num;
                            scale = 4;
                            break block10;
                        }
                        case 32: {
                            value = (long)100000 * value + (long)3125 * num;
                            scale = 5;
                            break block10;
                        }
                        case 64: {
                            value = (long)1000000 * value + (long)15625 * num;
                            scale = 6;
                            break block10;
                        }
                    }
                    throw new NumberFormatException();
                }
                default: {
                    throw new NumberFormatException();
                }
            }
            if (value == 0L) {
                bigDecimal = BigDecimal.ZERO;
            } else {
                if (negative) {
                    value = -value;
                }
                bigDecimal = new BigDecimal(BigInteger.valueOf(value), scale);
            }
            return bigDecimal;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

