/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.base.Utils;
import org.kopi.galite.visual.util.FaxException;
import org.kopi.galite.visual.util.FaxStatus;

@Deprecated(message="replaced by the class HylaFAXUtils")
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u0000 82\u00020\u0001:\u0005789:;B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0017\u001a\u00020\u00032\b\u0010\u0018\u001a\u0004\u0018\u00010\u0005H\u0002J\u0010\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J\u000e\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0005J\u0006\u0010\u001d\u001a\u00020\u001eJ$\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u00052\n\u0010!\u001a\u00060\"j\u0002`#2\u0006\u0010$\u001a\u00020\u0003H\u0004J\b\u0010%\u001a\u00020&H\u0002J\u000e\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020\u0005J\u000e\u0010)\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0005J\u000e\u0010*\u001a\u00020\u00032\u0006\u0010+\u001a\u00020\u0005J\u0018\u0010,\u001a\u00020\u00052\u0006\u0010-\u001a\u00020&2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010.\u001a\u00020\u001e2\u0006\u0010/\u001a\u00020\u0005H\u0002J\b\u00100\u001a\u00020\u0005H\u0002J\u000e\u00101\u001a\u00020\u00052\u0006\u00102\u001a\u000203J \u00104\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u00105\u001a\u00020\u00052\u0006\u00106\u001a\u00020\u0005H\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006<"}, d2={"Lorg/kopi/galite/visual/util/Fax;", "", "port", "", "host", "", "(ILjava/lang/String;)V", "clnt", "Ljava/net/Socket;", "clntIn", "Ljava/io/BufferedReader;", "clntOut", "Ljava/io/PrintWriter;", "debug", "", "getHost", "()Ljava/lang/String;", "setHost", "(Ljava/lang/String;)V", "getPort", "()I", "setPort", "(I)V", "check", "str", "checkNumber", "number", "command", "what", "endCon", "", "fail", "msg", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "which", "getInetAddr", "", "getReceived", "name", "infoS", "login", "uname", "makePORT", "iaddr", "print", "s", "readLine", "sendbuffer", "inputStream", "Ljava/io/InputStream;", "setNewJob", "user", "id", "BasicServ", "Companion", "PROTOException", "RecvServ", "SendServ", "galite-core"})
public final class Fax {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int port;
    @NotNull
    private String host;
    private final boolean debug;
    @Nullable
    private final Socket clnt;
    @NotNull
    private final BufferedReader clntIn;
    @NotNull
    private final PrintWriter clntOut;
    private static final int ABOUT_TO_OPEN_DATACON = 150;
    private static final int SYSTEM_STATUS = 211;
    private static final int HELP_MESSAGE = 214;
    private static final int NEEDS_PASSWD = 331;
    private static final int SERVICE_NOT_AVAILABLE = 421;
    private static final int NO_DATA_CONNECTION = 425;
    private static final int CONNECTION_CLOSED = 426;
    private static final int FILE_ACTION_NOT_TAKEN = 450;
    private static final int ACTION_ABORTED_ERROR = 451;
    private static final int ACTION_NOT_TAKEN_SPACE = 452;
    private static final int FAILED_TO_KILL_JOB = 460;
    private static final int SYNTAX_ERROR_COMMAND = 500;
    private static final int SYNTAX_ERROR_PARAMETER = 501;
    private static final int COMMAND_NOT_IMPLEMENTED = 502;
    private static final int BAD_COMMAND_SEQUENCE = 503;
    private static final int OPERATION_NOT_PERMITTET = 504;
    private static final int NOT_LOGGED_IN = 530;
    private static final int NEED_ACC_FOR_STORING = 532;
    private static final int ACTION_NOT_TAKEN = 550;
    private static final int ACTION_ABORTED_PAGETYPE = 551;
    private static final int FILE_ACTION_ABORTED = 552;
    private static final int ACTION_NOT_TAKEN_NAME = 553;
    private static final int LOST_CONNECTION = -1;
    private static final int EMPTY_REPLY_STRING = -2;
    private static final int HFAX_PORT = 4559;
    @NotNull
    private static final String HFAX_HOST = "localhost";
    @NotNull
    private static final String DEFAULT_USER = "GALITE";
    protected static final int NONE = 0;
    protected static final int RECEIVE = 1;
    protected static final int SEND = 2;
    private static int typeOfThread;
    private static final boolean verboseMode = false;
    @NotNull
    private static String errText;

    public Fax(int port, @NotNull String host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.port = port;
        this.host = host;
        if (this.port == 0) {
            this.port = 4559;
        }
        this.clnt = new Socket(this.host, this.port);
        this.clntIn = new BufferedReader(new InputStreamReader(this.clnt.getInputStream()));
        this.clntOut = new PrintWriter(this.clnt.getOutputStream());
        this.check(this.readLine());
    }

    public /* synthetic */ Fax(int n, String string, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            string = HFAX_HOST;
        }
        this(n, string);
    }

    public final int getPort() {
        return this.port;
    }

    public final void setPort(int n) {
        this.port = n;
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    public final void setHost(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.host = string;
    }

    public final int login(@NotNull String uname) {
        Intrinsics.checkNotNullParameter((Object)uname, (String)"uname");
        Utils.Companion.log("Fax", Intrinsics.stringPlus((String)"login:", (Object)uname));
        this.print("USER " + uname + '\n');
        this.clntOut.flush();
        int answer = this.check(this.readLine());
        if (answer == 331) {
            this.print("PASS 0\n");
            this.clntOut.flush();
        }
        return answer;
    }

    public final void endCon() {
        this.print("QUIT\n");
        this.clntOut.flush();
        this.check(this.readLine());
        if (this.clnt != null) {
            this.clntIn.close();
            this.clntOut.close();
            this.clnt.close();
        }
    }

    @NotNull
    public final String sendbuffer(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        SendServ sendsrv = null;
        String pstr = null;
        Deflater df = new Deflater(9, false);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DeflaterOutputStream dos = new DeflaterOutputStream((OutputStream)baos, df, inputStream.available());
        byte[] buffer = new byte[1024];
        int read = 0;
        while (true) {
            int n;
            int it = n = inputStream.read(buffer, 0, 1024);
            boolean bl = false;
            read = it;
            if (n == -1) break;
            dos.write(buffer, 0, read);
        }
        dos.close();
        byte[] byArray = baos.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"baos.toByteArray()");
        sendsrv = new SendServ(byArray, this.debug);
        byte[] iaddr = this.getInetAddr();
        pstr = this.makePORT(iaddr, sendsrv.getPort());
        this.print("TYPE I\n");
        this.clntOut.flush();
        this.check(this.readLine());
        this.print("MODE Z\n");
        this.clntOut.flush();
        this.check(this.readLine());
        this.print("PORT " + pstr + '\n');
        System.err.println("PORT " + pstr + '\n');
        this.clntOut.flush();
        this.check(this.readLine());
        this.print("STOT\n");
        this.clntOut.flush();
        String line = this.readLine();
        this.check(line);
        try {
            sendsrv.join();
        }
        catch (InterruptedException bl) {
            // empty catch block
        }
        StringTokenizer st = new StringTokenizer(line, " ");
        st.nextToken();
        st.nextToken();
        String filename = st.nextToken();
        this.check(this.readLine());
        Intrinsics.checkNotNullExpressionValue((Object)filename, (String)"filename");
        return filename;
    }

    @NotNull
    public final byte[] getReceived(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String pstr = null;
        RecvServ recsrv = new RecvServ(this.debug);
        byte[] iaddr = this.getInetAddr();
        pstr = this.makePORT(iaddr, recsrv.getPort());
        if (this.debug) {
            System.out.println((Object)Intrinsics.stringPlus((String)"Fax.getReceived: ", (Object)pstr));
        }
        this.print("TYPE I\n");
        this.clntOut.flush();
        this.check(this.readLine());
        this.print("MODE S\n");
        this.clntOut.flush();
        this.check(this.readLine());
        this.print("CWD recvq\n");
        this.clntOut.flush();
        this.check(this.readLine());
        this.print("PORT " + pstr + '\n');
        this.clntOut.flush();
        this.check(this.readLine());
        this.print("RETR " + name + '\n');
        this.clntOut.flush();
        this.check(this.readLine());
        this.check(this.readLine());
        try {
            recsrv.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.print("CWD\n");
        this.clntOut.flush();
        this.check(this.readLine());
        return recsrv.getData();
    }

    @NotNull
    public final String infoS(@NotNull String what) {
        Intrinsics.checkNotNullParameter((Object)what, (String)"what");
        String pstr = null;
        RecvServ recsrv = new RecvServ(this.debug);
        byte[] iaddr = this.getInetAddr();
        pstr = this.makePORT(iaddr, recsrv.getPort());
        this.print("PORT " + pstr + '\n');
        this.clntOut.flush();
        this.check(this.readLine());
        this.print("LIST " + what + '\n');
        this.clntOut.flush();
        try {
            recsrv.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (typeOfThread != 0) {
            throw new PROTOException(errText, -1);
        }
        if (this.check(this.readLine()) != 150) {
            throw new PROTOException("Fax.infoS: No Data from Fax server", 1);
        }
        this.check(this.readLine());
        int cnt = 0;
        while (cnt < recsrv.getData().length && recsrv.getData()[cnt] != 0) {
            int n = cnt;
            cnt = n + 1;
        }
        byte[] byArray = recsrv.getData();
        int n = 0;
        return new String(byArray, n, cnt, Charsets.UTF_8);
    }

    @NotNull
    public final String command(@NotNull String what) {
        Intrinsics.checkNotNullParameter((Object)what, (String)"what");
        StringBuffer response = new StringBuffer();
        String line = null;
        this.print(Intrinsics.stringPlus((String)what, (Object)"\n"));
        this.clntOut.flush();
        int erg = this.check(this.readLine());
        switch (erg) {
            case 211: 
            case 214: {
                while (this.check(line = this.readLine()) != erg) {
                    response.append(Intrinsics.stringPlus((String)line, (Object)"\n"));
                }
                break;
            }
        }
        String string = response.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"response.toString()");
        return string;
    }

    private final void setNewJob(String number, String user, String id) {
        String number2 = this.checkNumber(number);
        String user2 = DEFAULT_USER;
        Utils.Companion.log("Fax", "NEW JOB:" + id + " / user: " + user2);
        this.command("JNEW");
        this.command("JPARM FROMUSER \"" + user2 + '\"');
        this.command("JPARM LASTTIME 145959");
        this.command("JPARM MAXDIALS 3");
        this.command("JPARM MAXTRIES 3");
        this.command("JPARM SCHEDPRI 127");
        this.command("JPARM DIALSTRING \"" + number2 + '\"');
        this.command("JPARM NOTIFYADDR \"" + user2 + '\"');
        this.command("JPARM JOBINFO \"" + id + '\"');
        this.command("JPARM VRES 196");
        this.command("JPARM PAGEWIDTH 209");
        this.command("JPARM PAGELENGTH 296");
        this.command("JPARM NOTIFY \"NONE\"");
        this.command("JPARM PAGECHOP \"default\"");
        this.command("JPARM CHOPTHRESHOLD 3");
    }

    private final String checkNumber(String number) {
        String newNumber = null;
        newNumber = "";
        CharSequence $this$forEach$iv = number;
        boolean $i$f$forEach = false;
        CharSequence charSequence = $this$forEach$iv;
        int n = 0;
        while (n < charSequence.length()) {
            char element$iv = charSequence.charAt(n);
            ++n;
            char it = element$iv;
            boolean bl = false;
            boolean bl2 = '0' <= it ? it < ':' : false;
            if (!bl2) continue;
            newNumber = Intrinsics.stringPlus((String)newNumber, (Object)Character.valueOf(it));
        }
        return newNumber;
    }

    private final String makePORT(byte[] iaddr, int port) {
        byte a = (byte)(port & 0xFF);
        byte b = (byte)((port & 0xFF00) >> 8);
        return "" + (0xFF & iaddr[0]) + ',' + (0xFF & iaddr[1]) + ',' + (0xFF & iaddr[2]) + ',' + (0xFF & iaddr[3]) + ',' + (0xFF & b) + ',' + (0xFF & a);
    }

    private final void print(String s) {
        this.clntOut.print(s);
    }

    private final String readLine() {
        String string = this.clntIn.readLine();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"clntIn.readLine()");
        String readLine = string;
        return readLine;
    }

    private final int check(String str) {
        int n;
        StringBuffer message = new StringBuffer();
        int rtc = 0;
        if (str == null) {
            throw new PROTOException("Fax.check: empty Reply String!!!", -2);
        }
        String delim = str.charAt(3) == '-' ? "-" : " ";
        StringTokenizer st = new StringTokenizer(str, delim);
        try {
            String string = st.nextToken();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"st.nextToken()");
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            n = 0;
        }
        rtc = n;
        n = st.countTokens();
        if (1 <= n) {
            do {
                int i = n--;
                message.append(Intrinsics.stringPlus((String)st.nextToken(), (Object)" "));
            } while (1 <= n);
        }
        switch (rtc) {
            case 421: 
            case 425: 
            case 426: 
            case 450: 
            case 451: 
            case 452: 
            case 460: 
            case 500: 
            case 501: 
            case 502: 
            case 503: 
            case 504: 
            case 530: 
            case 532: 
            case 550: 
            case 551: 
            case 552: 
            case 553: {
                String string = message.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message.toString()");
                throw new PROTOException(string, rtc);
            }
        }
        return rtc;
    }

    private final byte[] getInetAddr() {
        byte[] byArray;
        if (StringsKt.equals((String)this.host, (String)HFAX_HOST, (boolean)true)) {
            byte[] byArray2 = new byte[]{127, 0, 0, 1};
            byArray = byArray2;
        } else {
            byte[] byArray3 = InetAddress.getLocalHost().getAddress();
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"{\n    InetAddress.getLocalHost().address\n  }");
            byArray = byArray3;
        }
        return byArray;
    }

    protected final void fail(@NotNull String msg, @NotNull Exception e, int which) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        System.err.println(msg + ": " + e);
        typeOfThread = which;
        errText = msg + ": " + e;
    }

    static {
        errText = "";
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/kopi/galite/visual/util/Fax$PROTOException;", "Lorg/kopi/galite/visual/util/FaxException;", "s", "", "number", "", "(Lorg/kopi/galite/visual/util/Fax;Ljava/lang/String;I)V", "message", "getMessage", "()Ljava/lang/String;", "getNumber", "()I", "galite-core"})
    public final class PROTOException
    extends FaxException {
        private final int number;

        public PROTOException(String s, int number) {
            Intrinsics.checkNotNullParameter((Object)Fax.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            super(s);
            this.number = number;
        }

        public final int getNumber() {
            return this.number;
        }

        @Override
        @NotNull
        public String getMessage() {
            return super.getMessage() + " Replay Code: " + this.number;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\"\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lorg/kopi/galite/visual/util/Fax$BasicServ;", "Ljava/lang/Thread;", "debug1", "", "(Z)V", "port", "", "getPort", "()I", "srv", "Ljava/net/ServerSocket;", "getSrv", "()Ljava/net/ServerSocket;", "debug", "", "message", "", "Companion", "galite-core"})
    private static abstract class BasicServ
    extends Thread {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final boolean debug1;
        private final int port;
        @NotNull
        private final ServerSocket srv;
        private static final int TIMEOUT = 20;

        protected BasicServ(boolean debug1) {
            this.debug1 = debug1;
            this.srv = new ServerSocket(0, 20);
            this.port = this.srv.getLocalPort();
            this.debug(Intrinsics.stringPlus((String)"BasicServ: port=", (Object)this.port));
            this.start();
        }

        protected final void debug(@Nullable String message) {
            if (this.debug1) {
                System.out.println((Object)message);
            }
        }

        public final int getPort() {
            return this.port;
        }

        @NotNull
        protected final ServerSocket getSrv() {
            return this.srv;
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/kopi/galite/visual/util/Fax$BasicServ$Companion;", "", "()V", "TIMEOUT", "", "galite-core"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lorg/kopi/galite/visual/util/Fax$RecvServ;", "Lorg/kopi/galite/visual/util/Fax$BasicServ;", "debug", "", "(Lorg/kopi/galite/visual/util/Fax;Z)V", "data", "", "getData", "()[B", "setData", "([B)V", "run", "", "galite-core"})
    private final class RecvServ
    extends BasicServ {
        public byte[] data;

        public RecvServ(boolean debug) {
            Intrinsics.checkNotNullParameter((Object)Fax.this, (String)"this$0");
            super(debug);
        }

        @Override
        public void run() {
            byte[] buf = new byte[1024];
            try {
                this.debug("RecvServ.run: Build connection");
                Socket srv_clnt = this.getSrv().accept();
                this.debug("RecvServ.run: Generate InputStream");
                DataInputStream dataInputStream = new DataInputStream(srv_clnt.getInputStream());
                this.debug("RecvServ.run: Wait for data");
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                int anz = 0;
                while (true) {
                    int n;
                    int it = n = dataInputStream.read(buf);
                    boolean bl = false;
                    anz = it;
                    if (n <= 0) break;
                    out.write(buf, 0, anz);
                }
                byte[] byArray = out.toByteArray();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"out.toByteArray()");
                this.setData(byArray);
                this.getSrv().close();
            }
            catch (IOException e) {
                Fax.this.fail("RecvServ", e, 1);
            }
            this.debug("RecvServ.run: Thread beendet!");
        }

        @NotNull
        public final byte[] getData() {
            byte[] byArray = this.data;
            if (byArray != null) {
                return byArray;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"data");
            return null;
        }

        public final void setData(@NotNull byte[] byArray) {
            Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
            this.data = byArray;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/kopi/galite/visual/util/Fax$SendServ;", "Lorg/kopi/galite/visual/util/Fax$BasicServ;", "buf", "", "debug", "", "(Lorg/kopi/galite/visual/util/Fax;[BZ)V", "run", "", "galite-core"})
    private final class SendServ
    extends BasicServ {
        @NotNull
        private final byte[] buf;

        public SendServ(byte[] buf, boolean debug) {
            Intrinsics.checkNotNullParameter((Object)Fax.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            super(debug);
            this.buf = buf;
        }

        @Override
        public void run() {
            DataOutputStream out = null;
            try {
                this.debug("SendServ.run: Build connection");
                Socket srv_clnt = this.getSrv().accept();
                this.debug("SendServ.run: Generate OutputStream");
                out = new DataOutputStream(srv_clnt.getOutputStream());
                out.write(this.buf, 0, this.buf.length);
                out.flush();
                srv_clnt.close();
                this.debug(Intrinsics.stringPlus((String)"SendServ.run: Bytes sent= ", (Object)out.size()));
                this.getSrv().close();
            }
            catch (IOException e) {
                Fax.this.fail("Thread error", e, 2);
            }
            this.debug("SendServ.run: Thread completed!");
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020\u000eJ\u001e\u0010'\u001a\u00020(2\u0006\u0010*\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020\u000eJ6\u0010-\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020/2\u0006\u0010+\u001a\u00020\u000e2\u0006\u00100\u001a\u00020\u000e2\u0006\u00101\u001a\u00020\u000eJ.\u0010-\u001a\u00020(2\u0006\u0010*\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020/2\u0006\u0010+\u001a\u00020\u000e2\u0006\u00100\u001a\u00020\u000e2\u0006\u00101\u001a\u00020\u000eJ(\u00102\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020\u000e2\u0006\u00103\u001a\u00020\u000eH\u0002J&\u00104\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020\u000eJ\u001e\u00104\u001a\u00020(2\u0006\u0010*\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020\u000eJ\u001c\u00105\u001a\b\u0012\u0004\u0012\u000207062\u0006\u0010*\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020\u000eJ&\u00108\u001a\b\u0012\u0004\u0012\u000207062\u0006\u0010*\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020\u000e2\u0006\u00103\u001a\u00020\u000eH\u0002J\u001c\u00109\u001a\b\u0012\u0004\u0012\u000207062\u0006\u0010*\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020\u000eJ\u001c\u0010:\u001a\b\u0012\u0004\u0012\u000207062\u0006\u0010*\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020\u000eJ\u0012\u0010;\u001a\u0004\u0018\u00010\u000e2\b\u00101\u001a\u0004\u0018\u00010\u000eJ\u001c\u0010<\u001a\b\u0012\u0004\u0012\u00020\u000e062\u0006\u0010*\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lorg/kopi/galite/visual/util/Fax$Companion;", "", "()V", "ABOUT_TO_OPEN_DATACON", "", "ACTION_ABORTED_ERROR", "ACTION_ABORTED_PAGETYPE", "ACTION_NOT_TAKEN", "ACTION_NOT_TAKEN_NAME", "ACTION_NOT_TAKEN_SPACE", "BAD_COMMAND_SEQUENCE", "COMMAND_NOT_IMPLEMENTED", "CONNECTION_CLOSED", "DEFAULT_USER", "", "EMPTY_REPLY_STRING", "FAILED_TO_KILL_JOB", "FILE_ACTION_ABORTED", "FILE_ACTION_NOT_TAKEN", "HELP_MESSAGE", "HFAX_HOST", "HFAX_PORT", "LOST_CONNECTION", "NEEDS_PASSWD", "NEED_ACC_FOR_STORING", "NONE", "NOT_LOGGED_IN", "NO_DATA_CONNECTION", "OPERATION_NOT_PERMITTET", "RECEIVE", "SEND", "SERVICE_NOT_AVAILABLE", "SYNTAX_ERROR_COMMAND", "SYNTAX_ERROR_PARAMETER", "SYSTEM_STATUS", "errText", "typeOfThread", "verboseMode", "", "clearJob", "", "port", "host", "user", "job", "fax", "inputStream", "Ljava/io/InputStream;", "number", "jobId", "getQueue", "qname", "killJob", "readDoneQueue", "Ljava/util/Vector;", "Lorg/kopi/galite/visual/util/FaxStatus;", "readQueue", "readRecQueue", "readSendQueue", "readSendtime", "readServerState", "galite-core"})
    public static final class Companion {
        private Companion() {
        }

        public final void fax(@NotNull String host, @NotNull InputStream inputStream, @NotNull String user, @NotNull String number, @NotNull String jobId) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter((Object)number, (String)"number");
            Intrinsics.checkNotNullParameter((Object)jobId, (String)"jobId");
            this.fax(4559, host, inputStream, user, number, jobId);
        }

        public final void fax(int port, @NotNull String host, @NotNull InputStream inputStream, @NotNull String user, @NotNull String number, @NotNull String jobId) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter((Object)number, (String)"number");
            Intrinsics.checkNotNullParameter((Object)jobId, (String)"jobId");
            Fax fax = new Fax(port, host);
            fax.login(user);
            fax.command("IDLE 900");
            fax.command("TZONE LOCAL");
            String filename = fax.sendbuffer(inputStream);
            fax.setNewJob(number, user, jobId);
            fax.command(Intrinsics.stringPlus((String)"JPARM DOCUMENT ", (Object)filename));
            fax.command("JSUBM");
            fax.endCon();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final Vector<FaxStatus> readQueue(String host, String user, String qname) {
            Vector<FaxStatus> queue = new Vector<FaxStatus>();
            try {
                String ret = this.getQueue(4559, host, user, qname);
                StringTokenizer token = new StringTokenizer(ret, "\n");
                Utils.Companion.log("Fax", "READ " + qname + " : host " + host + " / user " + user);
                while (token.hasMoreElements()) {
                    try {
                        String string;
                        String str = token.nextElement().toString();
                        StringTokenizer process = new StringTokenizer(str, "|");
                        if (!Intrinsics.areEqual((Object)qname, (Object)"recvq")) {
                            string = process.nextToken();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"process.nextToken()");
                            String string2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
                            string = process.nextToken();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"process.nextToken()");
                            String string3 = ((Object)StringsKt.trim((CharSequence)string)).toString();
                            string = process.nextToken();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"process.nextToken()");
                            String string4 = ((Object)StringsKt.trim((CharSequence)string)).toString();
                            string = process.nextToken();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"process.nextToken()");
                            String string5 = ((Object)StringsKt.trim((CharSequence)string)).toString();
                            string = process.nextToken();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"process.nextToken()");
                            String string6 = ((Object)StringsKt.trim((CharSequence)string)).toString();
                            string = process.nextToken();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"process.nextToken()");
                            String string7 = ((Object)StringsKt.trim((CharSequence)string)).toString();
                            string = process.nextToken();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"process.nextToken()");
                            String string8 = ((Object)StringsKt.trim((CharSequence)string)).toString();
                            string = process.nextToken();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"process.nextToken()");
                            queue.addElement(new FaxStatus(string2, string3, string4, string5, string6, string7, string8, ((Object)StringsKt.trim((CharSequence)string)).toString()));
                            continue;
                        }
                        string = process.nextToken();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"process.nextToken()");
                        String string9 = ((Object)StringsKt.trim((CharSequence)string)).toString();
                        string = process.nextToken();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"process.nextToken()");
                        String string10 = ((Object)StringsKt.trim((CharSequence)string)).toString();
                        string = process.nextToken();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"process.nextToken()");
                        String string11 = ((Object)StringsKt.trim((CharSequence)string)).toString();
                        string = process.nextToken();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"process.nextToken()");
                        String string12 = ((Object)StringsKt.trim((CharSequence)string)).toString();
                        string = process.nextToken();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"process.nextToken()");
                        String string13 = ((Object)StringsKt.trim((CharSequence)string)).toString();
                        string = process.nextToken();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"process.nextToken()");
                        queue.addElement(new FaxStatus(string9, string10, string11, string12, string13, ((Object)StringsKt.trim((CharSequence)string)).toString()));
                    }
                    catch (Exception e) {
                        String string = e.getMessage();
                        Intrinsics.checkNotNull((Object)string);
                        throw new FaxException(string, e);
                        return queue;
                    }
                }
            }
            catch (ConnectException e) {
                Utils.Companion.log("Fax", "NO FAX SERVER");
                throw new FaxException("NO FAX SERVER");
            }
            catch (Exception e) {
                String string = e.getMessage();
                Intrinsics.checkNotNull((Object)string);
                throw new FaxException(string, e);
            }
        }

        @NotNull
        public final Vector<FaxStatus> readSendQueue(@NotNull String host, @NotNull String user) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            return this.readQueue(host, user, "sendq");
        }

        @NotNull
        public final Vector<FaxStatus> readDoneQueue(@NotNull String host, @NotNull String user) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            return this.readQueue(host, user, "doneq");
        }

        @NotNull
        public final Vector<FaxStatus> readRecQueue(@NotNull String host, @NotNull String user) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            return this.readQueue(host, user, "recvq");
        }

        @NotNull
        public final Vector<String> readServerState(@NotNull String host, @NotNull String user) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Vector<String> queue = new Vector<String>();
            try {
                String ret = this.getQueue(4559, host, user, "status");
                StringTokenizer token = new StringTokenizer(ret, "\n");
                Utils.Companion.log("Fax", "READ STATE : host " + host + " / user " + user);
                while (token.hasMoreElements()) {
                    queue.addElement(token.nextElement().toString());
                }
            }
            catch (ConnectException e) {
                throw new FaxException("NO FAX SERVER");
            }
            catch (Exception e) {
                throw new FaxException(Intrinsics.stringPlus((String)"Trying read server state: ", (Object)e.getMessage()), e);
            }
            return queue;
        }

        @Nullable
        public final String readSendtime(@Nullable String jobId) {
            return null;
        }

        public final void killJob(@NotNull String host, @NotNull String user, @NotNull String job) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter((Object)job, (String)"job");
            this.killJob(4559, host, user, job);
        }

        public final void killJob(int port, @NotNull String host, @NotNull String user, @NotNull String job) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter((Object)job, (String)"job");
            Fax fax = new Fax(port, host);
            fax.login(Fax.DEFAULT_USER);
            fax.command(Intrinsics.stringPlus((String)"JKILL ", (Object)job));
            Utils.Companion.log("Fax", Intrinsics.stringPlus((String)"Kill 1: ", (Object)job));
            fax.endCon();
        }

        public final void clearJob(@NotNull String host, @NotNull String user, @NotNull String job) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter((Object)job, (String)"job");
            this.clearJob(4559, host, user, job);
        }

        public final void clearJob(int port, @NotNull String host, @NotNull String user, @NotNull String job) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter((Object)job, (String)"job");
            Fax fax = new Fax(port, host);
            fax.login(Fax.DEFAULT_USER);
            fax.command(Intrinsics.stringPlus((String)"JDELE ", (Object)job));
            Utils.Companion.log("Fax", Intrinsics.stringPlus((String)"Delete 1: ", (Object)job));
            fax.endCon();
        }

        private final String getQueue(int port, String host, String user, String qname) {
            Fax fax = new Fax(port, host);
            fax.login(user);
            fax.command("IDLE 900");
            fax.command("TZONE LOCAL");
            fax.command("JOBFMT \" %j| %J| %o| %e| %a| %P| %D| %s\"");
            fax.command("RCVFMT \" %f| %t| %s| %p| %h| %e\"");
            fax.command("MDMFMT \"Modem %m (%n): %s\"");
            String ret = fax.infoS(qname);
            fax.endCon();
            return ret;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

