/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.vkopi.lib.ui.swing.base;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import javax.swing.JTextPane;

public class JHtmlTextArea
extends JTextPane {
    private final int rows;
    private final int columns;
    private int columnWidth;
    private int rowHeight;
    private static final long serialVersionUID = 8176289608711629627L;

    public JHtmlTextArea(int rows, int columns) {
        if (rows < 0) {
            throw new IllegalArgumentException("rows: " + rows);
        }
        if (columns < 0) {
            throw new IllegalArgumentException("columns: " + columns);
        }
        this.rows = rows;
        this.columns = columns;
        this.setContentType("text/html");
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Dimension size = super.getPreferredScrollableViewportSize();
        Insets insets = this.getInsets();
        size = size == null ? new Dimension(400, 400) : size;
        size.width = this.columns == 0 ? size.width : this.columns * this.getColumnWidth() + insets.left + insets.right;
        size.height = this.rows == 0 ? size.height : this.rows * this.getRowHeight() + insets.top + insets.bottom;
        return size;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        Insets insets = this.getInsets();
        Dimension dimension = d = d == null ? new Dimension(400, 400) : d;
        if (this.columns != 0) {
            d.width = Math.max(d.width, this.columns * this.getColumnWidth() + insets.left + insets.right);
        }
        if (this.rows != 0) {
            d.height = Math.max(d.height, this.rows * this.getRowHeight() + insets.top + insets.bottom);
        }
        return d;
    }

    protected int getColumnWidth() {
        if (this.columnWidth == 0) {
            FontMetrics metrics = this.getFontMetrics(this.getFont());
            this.columnWidth = metrics.charWidth('m');
        }
        return this.columnWidth;
    }

    protected int getRowHeight() {
        if (this.rowHeight == 0) {
            FontMetrics metrics = this.getFontMetrics(this.getFont());
            this.rowHeight = metrics.getHeight();
        }
        return this.rowHeight;
    }
}

