/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.vkopi.lib.ui.swing.base;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class KopiTitledBorder
extends TitledBorder {
    private static final Color borderColor = UIManager.getColor("KopiTitleBorder.border");
    private static final Color foreColor = UIManager.getColor("KopiTitleBorder.foreground");
    private static final Color backColor = UIManager.getColor("KopiTitleBorder.background");
    private static final Font borderFont = UIManager.getFont("KopiTitleBorder.font");
    public static final Border BRD_EMPTY = UIManager.getBorder("KopiTitleBorder.border.emtpy");
    public static final Border BRD_RAISED = UIManager.getBorder("KopiTitleBorder.border.raised");
    public static final Border BRD_ETCHED = UIManager.getBorder("KopiTitleBorder.border.etched");
    public static final Border BRD_LINE = UIManager.getBorder("KopiTitleBorder.border.line");
    public static final Border BRD_LOWERED = UIManager.getBorder("KopiTitleBorder.border.lowered");
    private static final long serialVersionUID = -1785569445115086891L;

    public KopiTitledBorder(Border border, String title) {
        super(border, title);
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Border border = this.getBorder();
        Rectangle grooveRect = new Rectangle(x + 2, y + 2, width - 4, height - 4);
        Font font = g.getFont();
        Color color = g.getColor();
        g.setFont(borderFont);
        FontMetrics fm = g.getFontMetrics();
        int fontHeight = fm.getHeight();
        int descent = fm.getDescent();
        GradientPaint gp = new GradientPaint(grooveRect.x, grooveRect.y + fontHeight + 4, borderColor, (float)((double)(grooveRect.x + grooveRect.width) * 0.9), grooveRect.y + fontHeight + 4, backColor);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setPaint(gp);
        g.fillRect(grooveRect.x, grooveRect.y + fontHeight + 2, (int)((double)grooveRect.width * 0.9), 2);
        border.paintBorder(c, g, grooveRect.x, grooveRect.y, grooveRect.width, grooveRect.height);
        g.setColor(foreColor);
        g.drawString(this.getTitle(), grooveRect.x + 5, grooveRect.y + fontHeight + 2 - descent);
        g.setFont(font);
        g.setColor(color);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        int height = 16;
        Border border = this.getBorder();
        if (border != null) {
            if (border instanceof AbstractBorder) {
                ((AbstractBorder)border).getBorderInsets(c, insets);
            } else {
                Insets i = border.getBorderInsets(c);
                insets.top = i.top;
                insets.right = i.right;
                insets.bottom = i.bottom;
                insets.left = i.left;
            }
        } else {
            insets.bottom = 0;
            insets.right = 0;
            insets.top = 0;
            insets.left = 0;
        }
        insets.left += 4;
        insets.right += 4;
        insets.top += 4;
        insets.bottom += 4;
        if (c == null || this.getTitle() == null || this.getTitle().equals("")) {
            return insets;
        }
        FontMetrics fm = c.getFontMetrics(borderFont);
        if (fm != null) {
            height = fm.getHeight();
        }
        insets.top += height;
        return insets;
    }
}

