/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.vkopi.lib.ui.swing.report;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import javax.swing.JComponent;

public class CellRenderer
extends JComponent {
    private int state;
    private int align;
    private Color back;
    private Color fore;
    private Font font;
    private FontMetrics metrics;
    private Color level;
    private boolean selected;
    private String str;
    private static final long serialVersionUID = 6813974260529631662L;

    protected CellRenderer(int state) {
        this.state = state;
    }

    protected CellRenderer(int state, int align, Color back, Color fore, Font font) {
        this.state = state;
        this.align = align;
        this.back = back;
        this.fore = fore;
        this.font = font;
        this.metrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    @Override
    public void paint(Graphics g) {
        Color bg;
        Dimension size = this.getSize();
        switch (this.state) {
            case -1: {
                bg = Color.lightGray;
                break;
            }
            case -2: {
                bg = Color.red;
                break;
            }
            default: {
                bg = this.selected ? Color.black : (this.back == Color.white ? this.level : this.back);
            }
        }
        g.setColor(bg);
        g.fillRect(0, 0, size.width, size.height);
        switch (this.state) {
            case -2: 
            case -1: {
                break;
            }
            default: {
                int left;
                if (this.state == -2 || this.str == null) break;
                Color fg = this.selected ? this.level : this.fore;
                int index = 0;
                int oldIndex = 0;
                int line = 0;
                g.setColor(fg);
                g.setFont(this.font);
                while ((index = this.str.indexOf(10, oldIndex)) != -1) {
                    left = this.align == 4 ? size.width - this.metrics.stringWidth(this.str.substring(oldIndex, index)) - 2 : 2;
                    g.drawString(this.str.substring(oldIndex, index), left, (line++ + 1) * this.metrics.getHeight() - 2);
                    oldIndex = index + 1;
                }
                left = this.align == 4 ? size.width - this.metrics.stringWidth(this.str.substring(oldIndex)) - 2 : 2;
                g.drawString(this.str.substring(oldIndex), left, (line++ + 1) * this.metrics.getHeight() - 2);
            }
        }
    }

    public int getState() {
        return this.state;
    }

    public void set(String value, boolean selected, Color color) {
        this.str = value;
        this.level = color;
        this.selected = selected;
    }
}

