/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.vkopi.lib.ui.swing.spellchecker;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import org.kopi.vkopi.lib.ui.swing.spellchecker.SpellException;
import org.kopi.vkopi.lib.ui.swing.spellchecker.Suggestions;

public class AspellProcess {
    BufferedReader aspellInput;
    BufferedWriter aspellOutput;
    Process aspellProcess;

    public AspellProcess(String aSpellCommandLine) throws SpellException {
        try {
            String fehler = "";
            Runtime runtime = Runtime.getRuntime();
            this.aspellProcess = runtime.exec(aSpellCommandLine);
            this.aspellInput = new BufferedReader(new InputStreamReader(this.aspellProcess.getInputStream()));
            BufferedReader aspellError = new BufferedReader(new InputStreamReader(this.aspellProcess.getErrorStream()));
            this.aspellOutput = new BufferedWriter(new OutputStreamWriter(this.aspellProcess.getOutputStream()));
            String aspellVersionMsg = this.aspellInput.readLine();
            if (aspellError.ready()) {
                fehler = aspellError.readLine();
            }
            this.verifyStartup(aspellVersionMsg, fehler);
        }
        catch (IOException e) {
            throw new SpellException("Cannot create aspell process.", e);
        }
    }

    private void verifyStartup(String startupMsg, String fehler) throws SpellException {
        if (startupMsg == null || !startupMsg.startsWith("@(#)")) {
            throw new SpellException("Wrong configuration of Aspell:" + (startupMsg != null ? startupMsg : "") + " " + fehler);
        }
    }

    public List<Suggestions> checkText(String text) throws SpellException {
        try {
            ArrayList<Suggestions> results = new ArrayList<Suggestions>();
            String spellCheckLinePrefix = "^";
            this.aspellOutput.write("^" + text);
            this.aspellOutput.newLine();
            this.aspellOutput.flush();
            String response = this.aspellInput.readLine();
            while (response != null && !response.equals("")) {
                Suggestions result = new Suggestions(response);
                results.add(result);
                response = this.aspellInput.readLine();
            }
            return results;
        }
        catch (IOException e) {
            throw new SpellException("Failure during spell checking:", e);
        }
    }

    public void cancel() {
        this.aspellProcess.destroy();
    }
}

