/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.vkopi.lib.ui.swing.visual;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.kopi.vkopi.lib.ui.swing.plaf.KopiLookAndFeel;
import org.kopi.vkopi.lib.ui.swing.visual.DInfoPanel;
import org.kopi.vkopi.lib.ui.swing.visual.DStatePanel;
import org.kopi.vkopi.lib.ui.swing.visual.DWaitPanel;
import org.kopi.vkopi.lib.ui.swing.visual.DWindow;

public final class DFootPanel
extends JPanel {
    private DWaitPanel waitPanel;
    private DInfoPanel messagePanel;
    private DInfoPanel statisticsPanel;
    private DStatePanel statePanel;
    private JLabel emptyText;
    private String oldMessage;
    private static final long serialVersionUID = -8670576072788822069L;

    public DFootPanel(DWindow parent) {
        JPanel east = new JPanel();
        this.setLayout(new BorderLayout());
        this.setFocusable(false);
        this.setBorder(new KopiLookAndFeel.TopLineBorder());
        this.messagePanel = new DInfoPanel();
        this.add((Component)this.messagePanel, "Center");
        this.statePanel = new DStatePanel();
        this.waitPanel = new DWaitPanel(parent);
        this.waitPanel.setVisible(false);
        this.statisticsPanel = new DInfoPanel();
        this.statisticsPanel.setText(" ");
        east.setLayout(new BoxLayout(east, 0));
        this.emptyText = new JLabel(" ");
        east.add(this.emptyText);
        east.add(this.waitPanel);
        east.add(this.statePanel);
        east.add(this.statisticsPanel);
        this.add((Component)east, "East");
    }

    public void setInformationText(String message) {
        this.messagePanel.setText(message, false);
        this.waitPanel.setWaiting(false);
    }

    public void setStatisticsText(String message) {
        this.statisticsPanel.setText(message, false);
    }

    public void setWaitInfo(String message) {
        if (!SwingUtilities.isEventDispatchThread()) {
            System.err.println("ERROR: DFootPanel.setWaitInfo(..) calles outside of Eventdispatching Thread");
        }
        this.oldMessage = this.messagePanel.getText();
        if (message != null) {
            this.messagePanel.setText(message, true);
        }
        this.waitPanel.setWaiting(true);
    }

    public void setStatePanel(JPanel state) {
        this.statePanel.setInfo(state);
    }

    public void unsetWaitInfo() {
        if (!SwingUtilities.isEventDispatchThread()) {
            System.err.println("ERROR: DFootPanel.unsetWaitInfo() calles outside of Eventdispatching Thread");
        }
        this.messagePanel.setText(this.oldMessage, false);
        this.waitPanel.setWaiting(false);
    }

    public void setUserInterrupt(boolean allowed) {
        this.statePanel.setUserInterrupt(allowed);
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension prf = super.getPreferredSize();
        Dimension max = super.getMaximumSize();
        return new Dimension(max.width, Math.min(prf.height, max.height));
    }
}

