/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.vkopi.lib.ui.swing.visual;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.MenuComponent;
import java.awt.Window;
import javax.swing.FocusManager;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.kopi.galite.visual.ApplicationContext;
import org.kopi.galite.visual.UWindow;
import org.kopi.galite.visual.VException;
import org.kopi.galite.visual.VRuntimeException;
import org.kopi.galite.visual.VWindow;
import org.kopi.galite.visual.WindowBuilder;
import org.kopi.galite.visual.WindowController;
import org.kopi.vkopi.lib.ui.swing.visual.DWindow;
import org.kopi.vkopi.lib.ui.swing.visual.SwingThreadHandler;

public class JWindowController
extends WindowController {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doModal(VWindow model2) {
        ModalViewRunner viewStarter = new ModalViewRunner(model2);
        VWindow vWindow = model2;
        synchronized (vWindow) {
            SwingThreadHandler.startAndWait(viewStarter);
            try {
                if (SwingUtilities.isEventDispatchThread()) {
                    DWindow view = viewStarter.getView();
                    if (view == null) {
                        return false;
                    }
                    EventQueue eventQueue = view.getToolkit().getSystemEventQueue();
                    while (view.isShowing()) {
                        AWTEvent event = eventQueue.getNextEvent();
                        Object source = event.getSource();
                        try {
                            if (event instanceof ActiveEvent) {
                                ((ActiveEvent)((Object)event)).dispatch();
                                continue;
                            }
                            if (source instanceof Component) {
                                ((Component)source).dispatchEvent(event);
                                continue;
                            }
                            if (source instanceof MenuComponent) {
                                ((MenuComponent)source).dispatchEvent(event);
                                continue;
                            }
                            System.err.println("unable to dispatch event: " + event);
                        }
                        catch (RuntimeException e) {
                            ApplicationContext.Companion.reportTrouble("JWindowController", "JWindowController.dispatch (I should not be here!)", event.toString(), e);
                        }
                    }
                } else {
                    model2.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return viewStarter.getView() == null ? false : viewStarter.getView().getReturnCode() == 2;
    }

    @Override
    public boolean doModal(org.kopi.galite.visual.dsl.common.Window model2) {
        return this.doModal(model2.getModel());
    }

    @Override
    public void doNotModal(final VWindow model2) {
        SwingThreadHandler.start(new Runnable(){

            @Override
            public void run() {
                try {
                    WindowBuilder builder = JWindowController.this.getWindowBuilder(model2);
                    DWindow view = (DWindow)builder.createWindow(model2);
                    view.createFrame();
                    view.run();
                }
                catch (VException e) {
                    JWindowController.this.reportError(e);
                }
                catch (VRuntimeException e) {
                    JWindowController.this.reportError(e);
                }
            }
        });
    }

    @Override
    public void doNotModal(org.kopi.galite.visual.dsl.common.Window model2) {
        this.doNotModal(model2.getModel());
    }

    public void reportError(Exception e) {
        if (e.getMessage() != null) {
            DWindow.displayError(null, e.getMessage());
        }
    }

    @Override
    public void doNotModal(UWindow window) throws Exception {
        throw new Exception("NOT SUPPORTED");
    }

    class ModalViewRunner
    implements Runnable {
        private DWindow view;
        private VWindow model;

        ModalViewRunner(VWindow model2) {
            this.model = model2;
        }

        @Override
        public void run() {
            try {
                Window focus = FocusManager.getCurrentManager().getFocusedWindow();
                WindowBuilder builder = JWindowController.this.getWindowBuilder(this.model);
                this.view = (DWindow)builder.createWindow(this.model);
                if (focus instanceof JFrame) {
                    this.view.createModalDialog((Frame)focus);
                } else {
                    this.view.createFrame();
                }
                this.view.run();
            }
            catch (VException e) {
                throw new VRuntimeException(e.getMessage(), e);
            }
        }

        public DWindow getView() {
            return this.view;
        }
    }
}

