/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.vkopi.lib.ui.swing.visual;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import org.kopi.vkopi.lib.ui.swing.visual.DObject;

public class SplashScreen
extends Window {
    private Image image;
    private String caption;
    private static final long serialVersionUID = -1902568707559950635L;

    public SplashScreen(Image image, String caption) {
        super(DObject.phantom);
        this.image = image;
        this.caption = caption;
    }

    @Override
    public void paint(Graphics gc) {
        Dimension size = this.getSize();
        FontMetrics fm = gc.getFontMetrics();
        gc.setColor(Color.black);
        gc.drawRect(0, 0, size.width - 1, size.height - 1);
        gc.drawImage(this.image, 1, 1, null);
        if (this.caption != null) {
            int y = this.image.getHeight(null) + 2 + fm.getAscent();
            int x = (size.width - fm.stringWidth(this.caption)) / 2;
            gc.setColor(this.getForeground());
            gc.drawString(this.caption, x, y);
        }
    }

    @Override
    public void setVisible(boolean flag) {
        if (flag) {
            this.pack();
            SplashScreen.centerWindow(this);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    SplashScreen.this.setVisible(false);
                    SplashScreen.this.dispose();
                }
            });
        }
        super.setVisible(flag);
    }

    @Override
    public Dimension getPreferredSize() {
        FontMetrics fm = this.getGraphics().getFontMetrics();
        Dimension d = new Dimension(this.image.getWidth(null) + 2, this.image.getHeight(null) + 2);
        if (this.caption != null) {
            d.height += fm.getHeight() + 2;
        }
        return d;
    }

    public static final void centerWindow(Window w) {
        Dimension s_size = w.getToolkit().getScreenSize();
        Dimension w_size = w.getSize();
        int x = (s_size.width - w_size.width) / 2;
        int y = (s_size.height - w_size.height) / 2;
        w.setLocation(x, y);
    }
}

