/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual;

import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0015\u001a\u00020\u0000J\u0006\u0010\u0016\u001a\u00020\u0000J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0096\u0002J\b\u0010\u001b\u001a\u00020\u0003H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u0011\u0010\n\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\u0011\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\fR\u0011\u0010\u0013\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\f\u00a8\u0006\u001f"}, d2={"Lorg/kopi/galite/visual/VColor;", "Ljava/io/Serializable;", "r", "", "g", "b", "a", "(IIII)V", "rgb", "(I)V", "alpha", "getAlpha", "()I", "blue", "getBlue", "green", "getGreen", "rGB", "getRGB", "red", "getRed", "brighter", "darker", "equals", "", "other", "", "hashCode", "toString", "", "Companion", "galite-core"})
public final class VColor
implements Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int rGB;
    private static final double FACTOR = 0.7;
    @NotNull
    private static final VColor WHITE = new VColor(255, 255, 255, 0, 8, null);
    @NotNull
    private static final VColor LIGHT_GRAY = new VColor(192, 192, 192, 0, 8, null);
    @NotNull
    private static final VColor GRAY = new VColor(128, 128, 128, 0, 8, null);
    @NotNull
    private static final VColor DARK_GRAY = new VColor(64, 64, 64, 0, 8, null);
    @NotNull
    private static final VColor BLACK = new VColor(0, 0, 0, 0, 8, null);
    @NotNull
    private static final VColor RED = new VColor(255, 0, 0, 0, 8, null);
    @NotNull
    private static final VColor PINK = new VColor(255, 175, 175, 0, 8, null);
    @NotNull
    private static final VColor ORANGE = new VColor(255, 200, 0, 0, 8, null);
    @NotNull
    private static final VColor YELLOW = new VColor(255, 255, 0, 0, 8, null);
    @NotNull
    private static final VColor GREEN = new VColor(0, 255, 0, 0, 8, null);
    @NotNull
    private static final VColor MAGENTA = new VColor(255, 0, 255, 0, 8, null);
    @NotNull
    private static final VColor CYAN = new VColor(0, 255, 255, 0, 8, null);
    @NotNull
    private static final VColor BLUE = new VColor(0, 0, 255, 0, 8, null);

    public VColor(int r, int g, int b, int a) {
        this.rGB = (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0;
        VColor.Companion.testColorValueRange(r, g, b, a);
    }

    public /* synthetic */ VColor(int n, int n2, int n3, int n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 8) != 0) {
            n4 = 255;
        }
        this(n, n2, n3, n4);
    }

    public VColor(int rgb) {
        this.rGB = 0xFF000000 | rgb;
    }

    @NotNull
    public final VColor brighter() {
        int r = this.getRed();
        int g = this.getGreen();
        int b = this.getBlue();
        int alpha = this.getAlpha();
        int i = 3;
        if (r == 0 && g == 0 && b == 0) {
            return new VColor(i, i, i, alpha);
        }
        boolean bl = 1 <= r ? r < i : false;
        if (bl) {
            r = i;
        }
        boolean bl2 = 1 <= g ? g < i : false;
        if (bl2) {
            g = i;
        }
        boolean bl3 = 1 <= b ? b < i : false;
        if (bl3) {
            b = i;
        }
        int vColorRed = RangesKt.coerceAtMost((int)((int)((double)r / 0.7)), (int)255);
        int vColorGreen = RangesKt.coerceAtMost((int)((int)((double)g / 0.7)), (int)255);
        int vColorBlue = RangesKt.coerceAtMost((int)((int)((double)b / 0.7)), (int)255);
        return new VColor(vColorRed, vColorGreen, vColorBlue, alpha);
    }

    @NotNull
    public final VColor darker() {
        int vColorRed = RangesKt.coerceAtLeast((int)((int)((double)this.getRed() * 0.7)), (int)0);
        int vColorGreen = RangesKt.coerceAtLeast((int)((int)((double)this.getGreen() * 0.7)), (int)0);
        int vColorBlue = RangesKt.coerceAtLeast((int)((int)((double)this.getBlue() * 0.7)), (int)0);
        return new VColor(vColorRed, vColorGreen, vColorBlue, this.getAlpha());
    }

    public int hashCode() {
        return this.rGB;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof VColor && ((VColor)other).rGB == this.rGB;
    }

    @NotNull
    public String toString() {
        return this.getClass().getName() + "[r=" + this.getRed() + ",g=" + this.getGreen() + ",b=" + this.getBlue() + ']';
    }

    public final int getRed() {
        return this.rGB >> 16 & 0xFF;
    }

    public final int getGreen() {
        return this.rGB >> 8 & 0xFF;
    }

    public final int getBlue() {
        return this.rGB >> 0 & 0xFF;
    }

    public final int getAlpha() {
        return this.rGB >> 24 & 0xFF;
    }

    public final int getRGB() {
        return this.rGB;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0006\n\u0002\b\u0013\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020$2\u0006\u0010'\u001a\u00020$H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u000e\u0010\r\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0011\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0011\u0010\u0015\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006R\u0011\u0010\u0017\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0006R\u0011\u0010\u0019\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0006R\u0011\u0010\u001b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0006R\u0011\u0010\u001d\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0006R\u0011\u0010\u001f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0006\u00a8\u0006("}, d2={"Lorg/kopi/galite/visual/VColor$Companion;", "", "()V", "BLACK", "Lorg/kopi/galite/visual/VColor;", "getBLACK", "()Lorg/kopi/galite/visual/VColor;", "BLUE", "getBLUE", "CYAN", "getCYAN", "DARK_GRAY", "getDARK_GRAY", "FACTOR", "", "GRAY", "getGRAY", "GREEN", "getGREEN", "LIGHT_GRAY", "getLIGHT_GRAY", "MAGENTA", "getMAGENTA", "ORANGE", "getORANGE", "PINK", "getPINK", "RED", "getRED", "WHITE", "getWHITE", "YELLOW", "getYELLOW", "testColorValueRange", "", "r", "", "g", "b", "a", "galite-core"})
    public static final class Companion {
        private Companion() {
        }

        private final void testColorValueRange(int r, int g, int b, int a) {
            boolean rangeError = false;
            String badComponentString = null;
            badComponentString = "";
            if (a < 0 || a > 255) {
                rangeError = true;
                badComponentString = Intrinsics.stringPlus((String)badComponentString, (Object)" Alpha");
            }
            if (r < 0 || r > 255) {
                rangeError = true;
                badComponentString = Intrinsics.stringPlus((String)badComponentString, (Object)" Red");
            }
            if (g < 0 || g > 255) {
                rangeError = true;
                badComponentString = Intrinsics.stringPlus((String)badComponentString, (Object)" Green");
            }
            if (b < 0 || b > 255) {
                rangeError = true;
                badComponentString = Intrinsics.stringPlus((String)badComponentString, (Object)" Blue");
            }
            if (!(!rangeError)) {
                boolean bl = false;
                String string = Intrinsics.stringPlus((String)"Color parameter outside of expected range:", (Object)badComponentString);
                throw new IllegalArgumentException(string.toString());
            }
        }

        @NotNull
        public final VColor getWHITE() {
            return WHITE;
        }

        @NotNull
        public final VColor getLIGHT_GRAY() {
            return LIGHT_GRAY;
        }

        @NotNull
        public final VColor getGRAY() {
            return GRAY;
        }

        @NotNull
        public final VColor getDARK_GRAY() {
            return DARK_GRAY;
        }

        @NotNull
        public final VColor getBLACK() {
            return BLACK;
        }

        @NotNull
        public final VColor getRED() {
            return RED;
        }

        @NotNull
        public final VColor getPINK() {
            return PINK;
        }

        @NotNull
        public final VColor getORANGE() {
            return ORANGE;
        }

        @NotNull
        public final VColor getYELLOW() {
            return YELLOW;
        }

        @NotNull
        public final VColor getGREEN() {
            return GREEN;
        }

        @NotNull
        public final VColor getMAGENTA() {
            return MAGENTA;
        }

        @NotNull
        public final VColor getCYAN() {
            return CYAN;
        }

        @NotNull
        public final VColor getBLUE() {
            return BLUE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

