/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.dsl.common;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.AutoIncColumnType;
import org.jetbrains.exposed.sql.BinaryColumnType;
import org.jetbrains.exposed.sql.BooleanColumnType;
import org.jetbrains.exposed.sql.CharColumnType;
import org.jetbrains.exposed.sql.CharacterColumnType;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.IDateColumnType;
import org.jetbrains.exposed.sql.IntegerColumnType;
import org.jetbrains.exposed.sql.LongColumnType;
import org.jetbrains.exposed.sql.StringColumnType;
import org.jetbrains.exposed.sql.VarCharColumnType;
import org.kopi.galite.visual.domain.ListDomain;
import org.kopi.galite.visual.dsl.common.LocalizationWriter;
import org.kopi.galite.visual.list.VBooleanColumn;
import org.kopi.galite.visual.list.VDateColumn;
import org.kopi.galite.visual.list.VIntegerColumn;
import org.kopi.galite.visual.list.VListColumn;
import org.kopi.galite.visual.list.VStringColumn;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eR\u0015\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0015\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001f"}, d2={"Lorg/kopi/galite/visual/dsl/common/ListDescription;", "", "title", "", "column", "Lorg/jetbrains/exposed/sql/Column;", "domain", "Lorg/kopi/galite/visual/domain/ListDomain;", "(Ljava/lang/String;Lorg/jetbrains/exposed/sql/Column;Lorg/kopi/galite/visual/domain/ListDomain;)V", "getColumn", "()Lorg/jetbrains/exposed/sql/Column;", "getDomain", "()Lorg/kopi/galite/visual/domain/ListDomain;", "getTitle", "()Ljava/lang/String;", "type", "Lorg/jetbrains/exposed/sql/IColumnType;", "getType", "()Lorg/jetbrains/exposed/sql/IColumnType;", "width", "", "getWidth", "()I", "setWidth", "(I)V", "buildModel", "Lorg/kopi/galite/visual/list/VListColumn;", "genLocalization", "", "writer", "Lorg/kopi/galite/visual/dsl/common/LocalizationWriter;", "galite-core"})
public final class ListDescription {
    @NotNull
    private final String title;
    @NotNull
    private final Column<?> column;
    @NotNull
    private final ListDomain<?> domain;
    @NotNull
    private final IColumnType type;
    private int width;

    public ListDescription(@NotNull String title, @NotNull Column<?> column2, @NotNull ListDomain<?> domain) {
        int n;
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter(column2, (String)"column");
        Intrinsics.checkNotNullParameter(domain, (String)"domain");
        this.title = title;
        this.column = column2;
        this.domain = domain;
        IColumnType iColumnType = this.type = this.column.getColumnType() instanceof AutoIncColumnType ? (IColumnType)((AutoIncColumnType)this.column.getColumnType()).getDelegate() : this.column.getColumnType();
        if (iColumnType instanceof VarCharColumnType) {
            n = ((VarCharColumnType)this.type).getColLength();
        } else if (iColumnType instanceof CharColumnType) {
            n = ((CharColumnType)this.type).getColLength();
        } else if (iColumnType instanceof CharacterColumnType) {
            n = 1;
        } else if (iColumnType instanceof BinaryColumnType) {
            n = ((BinaryColumnType)this.type).getLength();
        } else {
            Integer n2 = this.domain.getWidth();
            Intrinsics.checkNotNull((Object)n2);
            n = n2;
        }
        this.width = n;
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    @NotNull
    public final Column<?> getColumn() {
        return this.column;
    }

    @NotNull
    public final ListDomain<?> getDomain() {
        return this.domain;
    }

    @NotNull
    public final IColumnType getType() {
        return this.type;
    }

    public final int getWidth() {
        return this.width;
    }

    public final void setWidth(int n) {
        this.width = n;
    }

    @NotNull
    public final VListColumn buildModel() {
        VListColumn vListColumn;
        IColumnType iColumnType = this.type;
        if (iColumnType instanceof IntegerColumnType ? true : iColumnType instanceof LongColumnType) {
            vListColumn = new VIntegerColumn(this.title, this.column, this.domain.getTableInitializer(), this.domain.getDefaultAlignment(), this.width, true);
        } else if (iColumnType instanceof StringColumnType) {
            vListColumn = new VStringColumn(this.title, this.column, this.domain.getTableInitializer(), this.domain.getDefaultAlignment(), this.width, true);
        } else if (iColumnType instanceof BooleanColumnType) {
            vListColumn = new VBooleanColumn(this.title, this.column, this.domain.getTableInitializer(), true);
        } else if (iColumnType instanceof IDateColumnType) {
            vListColumn = new VDateColumn(this.title, this.column, this.domain.getTableInitializer(), true);
        } else {
            StringBuilder stringBuilder = new StringBuilder().append("Type ");
            KClass<?> kClass = this.domain.getKClass();
            Intrinsics.checkNotNull(kClass);
            throw new RuntimeException(stringBuilder.append((Object)kClass.getQualifiedName()).append(" is not supported").toString());
        }
        return vListColumn;
    }

    public final void genLocalization(@NotNull LocalizationWriter writer) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        writer.genListDesc(this.column, this.title);
    }
}

