/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.fullcalendar;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.VColor;
import org.kopi.galite.visual.form.VField;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\b\u0018\u0000 (2\u00020\u0001:\u0001(B5\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00010\b\u00a2\u0006\u0002\u0010\nB+\u0012\u0006\u0010\u0004\u001a\u00020\u000b\u0012\u0006\u0010\u0006\u001a\u00020\u000b\u0012\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00010\b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u001b\u001a\u00020\u000bH\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u000bH\u00c6\u0003J\u0017\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00010\bH\u00c6\u0003J\u0016\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u000bJ5\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u000b2\b\b\u0002\u0010\u0006\u001a\u00020\u000b2\u0016\b\u0002\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00010\bH\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%J\b\u0010&\u001a\u00020%H\u0016J\t\u0010'\u001a\u00020\u000eH\u00d6\u0001R\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u0011\u0010\u0017\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0015R\u001f\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006)"}, d2={"Lorg/kopi/galite/visual/fullcalendar/VFullCalendarEntry;", "", "date", "Ljava/time/LocalDate;", "start", "Ljava/time/LocalTime;", "end", "values", "", "Lorg/kopi/galite/visual/form/VField;", "(Ljava/time/LocalDate;Ljava/time/LocalTime;Ljava/time/LocalTime;Ljava/util/Map;)V", "Ljava/time/Instant;", "(Ljava/time/Instant;Ljava/time/Instant;Ljava/util/Map;)V", "description", "", "getDescription", "()Ljava/lang/String;", "getEnd", "()Ljava/time/Instant;", "endDate", "getEndDate", "()Ljava/time/LocalDate;", "getStart", "startDate", "getStartDate", "getValues", "()Ljava/util/Map;", "component1", "component2", "component3", "copy", "equals", "", "other", "getColor", "Lorg/kopi/galite/visual/VColor;", "record", "", "hashCode", "toString", "Companion", "galite-core"})
public final class VFullCalendarEntry {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Instant start;
    @NotNull
    private final Instant end;
    @NotNull
    private final Map<VField, Object> values;
    @NotNull
    private static final List<VColor> colors;

    public VFullCalendarEntry(@NotNull Instant start, @NotNull Instant end, @NotNull Map<VField, Object> values) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        this.start = start;
        this.end = end;
        this.values = values;
    }

    @NotNull
    public final Instant getStart() {
        return this.start;
    }

    @NotNull
    public final Instant getEnd() {
        return this.end;
    }

    @NotNull
    public final Map<VField, Object> getValues() {
        return this.values;
    }

    public VFullCalendarEntry(@NotNull LocalDate date, @NotNull LocalTime start, @NotNull LocalTime end, @NotNull Map<VField, Object> values) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        Instant instant = Instant.from(LocalDateTime.of(date, start));
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"from(LocalDateTime.of(date, start))");
        Instant instant2 = instant;
        instant = Instant.from(LocalDateTime.of(date, end));
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"from(LocalDateTime.of(date, end))");
        this(instant2, instant, values);
    }

    @NotNull
    public final LocalDate getStartDate() {
        LocalDate localDate = LocalDate.from(this.start);
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"from(start)");
        return localDate;
    }

    @NotNull
    public final LocalDate getEndDate() {
        LocalDate localDate = LocalDate.from(this.end);
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"from(end)");
        return localDate;
    }

    @Nullable
    public final String getDescription() {
        Set<VField> fields = this.values.keySet();
        int priority = 0;
        VField descriptionField = (VField)CollectionsKt.first((Iterable)fields);
        for (VField field : fields) {
            if (field.getPriority() <= priority) continue;
            priority = field.getPriority();
            descriptionField = field;
        }
        Object object = this.values.get(descriptionField);
        return object == null ? null : object.toString();
    }

    @NotNull
    public final VColor getColor(int record) {
        return colors.get(record % colors.size());
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VFullCalendarEntry)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.start, (Object)((VFullCalendarEntry)other).start) || !Intrinsics.areEqual((Object)this.end, (Object)((VFullCalendarEntry)other).end)) {
            return false;
        }
        if (this.values.size() != ((VFullCalendarEntry)other).values.size()) {
            return false;
        }
        for (VField key : this.values.keySet()) {
            if (Intrinsics.areEqual((Object)this.values.get(key), (Object)((VFullCalendarEntry)other).values.get(key))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = this.start.hashCode();
        result = 31 * result + this.end.hashCode();
        result = 31 * result + ((Object)this.values).hashCode();
        return result;
    }

    @NotNull
    public final VFullCalendarEntry copy(@NotNull Instant start, @NotNull Instant end) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        return new VFullCalendarEntry(start, end, this.values);
    }

    @NotNull
    public final Instant component1() {
        return this.start;
    }

    @NotNull
    public final Instant component2() {
        return this.end;
    }

    @NotNull
    public final Map<VField, Object> component3() {
        return this.values;
    }

    @NotNull
    public final VFullCalendarEntry copy(@NotNull Instant start, @NotNull Instant end, @NotNull Map<VField, Object> values) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        return new VFullCalendarEntry(start, end, values);
    }

    public static /* synthetic */ VFullCalendarEntry copy$default(VFullCalendarEntry vFullCalendarEntry, Instant instant, Instant instant2, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            instant = vFullCalendarEntry.start;
        }
        if ((n & 2) != 0) {
            instant2 = vFullCalendarEntry.end;
        }
        if ((n & 4) != 0) {
            map = vFullCalendarEntry.values;
        }
        return vFullCalendarEntry.copy(instant, instant2, map);
    }

    @NotNull
    public String toString() {
        return "VFullCalendarEntry(start=" + this.start + ", end=" + this.end + ", values=" + this.values + ')';
    }

    static {
        Object[] objectArray = new VColor[]{new VColor(255, 99, 71, 0, 8, null), new VColor(255, 165, 0, 0, 8, null), new VColor(30, 144, 255, 0, 8, null), new VColor(60, 179, 113, 0, 8, null), new VColor(128, 128, 128, 0, 8, null), new VColor(106, 90, 205, 0, 8, null), new VColor(238, 130, 238, 0, 8, null)};
        colors = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/kopi/galite/visual/fullcalendar/VFullCalendarEntry$Companion;", "", "()V", "colors", "", "Lorg/kopi/galite/visual/VColor;", "getColors", "()Ljava/util/List;", "galite-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<VColor> getColors() {
            return colors;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

