/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.report;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.l10n.FieldLocalizer;
import org.kopi.galite.visual.l10n.ReportLocalizer;
import org.kopi.galite.visual.report.ColumnStyle;
import org.kopi.galite.visual.report.PExport;
import org.kopi.galite.visual.report.VCalculateColumn;
import org.kopi.galite.visual.report.VCellFormat;
import org.kopi.galite.visual.report.VHelpGenerator;
import org.kopi.galite.visual.util.LineBreaker;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001BK\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\u0018\u00108\u001a\u00020\u00052\u0006\u00109\u001a\u00020\u00012\u0006\u0010:\u001a\u00020\u0001H&J\u0012\u0010\f\u001a\u00020\u00032\b\u0010;\u001a\u0004\u0018\u00010\u0001H\u0016J\u0018\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020\u0005H\u0016J\u0010\u0010A\u001a\u00020\u00032\b\u0010;\u001a\u0004\u0018\u00010\u0001J\b\u0010B\u001a\u00020CH\u0016J\u0011\u0010D\u001a\b\u0012\u0004\u0012\u00020100\u00a2\u0006\u0002\u0010EJ\u000e\u0010F\u001a\u00020=2\u0006\u0010\u001c\u001a\u00020GJ\b\u0010H\u001a\u00020#H\u0016J\u0010\u0010I\u001a\u00020=2\u0006\u0010J\u001a\u00020KH\u0014J\u000e\u0010I\u001a\u00020=2\u0006\u0010L\u001a\u00020MR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0007\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0010\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u000b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0010\"\u0004\b\u001b\u0010\u0019R\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001eR\u001a\u0010\"\u001a\u00020#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010$\"\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020#X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010$\"\u0004\b(\u0010&R\u001a\u0010)\u001a\u00020#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010$\"\u0004\b*\u0010&R\u001a\u0010+\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u001e\"\u0004\b-\u0010 R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\u0010R\u0018\u0010/\u001a\n\u0012\u0004\u0012\u000201\u0018\u000100X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u00102R\u001a\u00103\u001a\u00020#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010$\"\u0004\b5\u0010&R\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010\u0010\"\u0004\b7\u0010\u0019\u00a8\u0006N"}, d2={"Lorg/kopi/galite/visual/report/VReportColumn;", "", "ident", "", "options", "", "align", "groups", "function", "Lorg/kopi/galite/visual/report/VCalculateColumn;", "width", "height", "format", "Lorg/kopi/galite/visual/report/VCellFormat;", "(Ljava/lang/String;IIILorg/kopi/galite/visual/report/VCalculateColumn;IILorg/kopi/galite/visual/report/VCellFormat;)V", "getAlign", "()I", "getFormat", "()Lorg/kopi/galite/visual/report/VCellFormat;", "setFormat", "(Lorg/kopi/galite/visual/report/VCellFormat;)V", "getFunction", "()Lorg/kopi/galite/visual/report/VCalculateColumn;", "getGroups", "setGroups", "(I)V", "getHeight", "setHeight", "help", "getHelp", "()Ljava/lang/String;", "setHelp", "(Ljava/lang/String;)V", "getIdent", "isAddedAtRuntime", "", "()Z", "setAddedAtRuntime", "(Z)V", "isFolded", "setFolded", "isVisible", "setVisible", "label", "getLabel", "setLabel", "getOptions", "styles", "", "Lorg/kopi/galite/visual/report/ColumnStyle;", "[Lorg/kopi/galite/visual/report/ColumnStyle;", "userDefinedLabel", "getUserDefinedLabel", "setUserDefinedLabel", "getWidth", "setWidth", "compareTo", "object1", "object2", "o", "formatColumn", "", "exporter", "Lorg/kopi/galite/visual/report/PExport;", "index", "formatWithLineBreaker", "getPrintedWidth", "", "getStyles", "()[Lorg/kopi/galite/visual/report/ColumnStyle;", "helpOnColumn", "Lorg/kopi/galite/visual/report/VHelpGenerator;", "isHidden", "localize", "parentLocalizer", "Lorg/kopi/galite/visual/l10n/FieldLocalizer;", "parent", "Lorg/kopi/galite/visual/l10n/ReportLocalizer;", "galite-core"})
public abstract class VReportColumn {
    @Nullable
    private final String ident;
    private final int options;
    private final int align;
    private int groups;
    @Nullable
    private final VCalculateColumn function;
    private int width;
    private int height;
    @Nullable
    private VCellFormat format;
    @NotNull
    private String label;
    @Nullable
    private String help;
    private boolean isVisible;
    private boolean isFolded;
    private boolean isAddedAtRuntime;
    private boolean userDefinedLabel;
    @Nullable
    private ColumnStyle[] styles;

    public VReportColumn(@Nullable String ident, int options, int align, int groups, @Nullable VCalculateColumn function, int width, int height, @Nullable VCellFormat format2) {
        this.ident = ident;
        this.options = options;
        this.align = align;
        this.groups = groups;
        this.function = function;
        this.width = width;
        this.height = height;
        this.format = format2;
        this.label = "";
        this.isVisible = true;
    }

    @Nullable
    public final String getIdent() {
        return this.ident;
    }

    public final int getOptions() {
        return this.options;
    }

    public final int getAlign() {
        return this.align;
    }

    public final int getGroups() {
        return this.groups;
    }

    public final void setGroups(int n) {
        this.groups = n;
    }

    @Nullable
    public final VCalculateColumn getFunction() {
        return this.function;
    }

    public final int getWidth() {
        return this.width;
    }

    public final void setWidth(int n) {
        this.width = n;
    }

    public final int getHeight() {
        return this.height;
    }

    public final void setHeight(int n) {
        this.height = n;
    }

    @Nullable
    protected final VCellFormat getFormat() {
        return this.format;
    }

    protected final void setFormat(@Nullable VCellFormat vCellFormat) {
        this.format = vCellFormat;
    }

    @NotNull
    public final String getLabel() {
        return this.label;
    }

    public final void setLabel(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.label = string;
    }

    @Nullable
    public final String getHelp() {
        return this.help;
    }

    public final void setHelp(@Nullable String string) {
        this.help = string;
    }

    public final boolean isVisible() {
        return this.isVisible;
    }

    public final void setVisible(boolean bl) {
        this.isVisible = bl;
    }

    public boolean isFolded() {
        return this.isFolded;
    }

    public void setFolded(boolean bl) {
        this.isFolded = bl;
    }

    public final boolean isAddedAtRuntime() {
        return this.isAddedAtRuntime;
    }

    public final void setAddedAtRuntime(boolean bl) {
        this.isAddedAtRuntime = bl;
    }

    public final boolean getUserDefinedLabel() {
        return this.userDefinedLabel;
    }

    public final void setUserDefinedLabel(boolean bl) {
        this.userDefinedLabel = bl;
    }

    public boolean isHidden() {
        return (this.options & 1) > 0;
    }

    public double getPrintedWidth() {
        return this.width;
    }

    @NotNull
    public String format(@Nullable Object o) {
        String string;
        if (this.isFolded() || o == null) {
            string = "";
        } else if (this.format != null) {
            VCellFormat vCellFormat = this.format;
            Intrinsics.checkNotNull((Object)vCellFormat);
            string = vCellFormat.format(o);
        } else if (this.height == 1) {
            String str = o.toString();
            int strLength = str.length();
            if (strLength <= this.width) {
                string = str;
            } else {
                String string2 = str.substring(0, this.width);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                string = string2;
            }
        } else {
            string = o.toString();
        }
        return string;
    }

    @NotNull
    public final String formatWithLineBreaker(@Nullable Object o) {
        return LineBreaker.Companion.modelToText(this.format(o), this.width);
    }

    public abstract int compareTo(@NotNull Object var1, @NotNull Object var2);

    public void formatColumn(@NotNull PExport exporter, int index) {
        Intrinsics.checkNotNullParameter((Object)exporter, (String)"exporter");
        exporter.formatStringColumn$galite_core(this, index);
    }

    public final void helpOnColumn(@NotNull VHelpGenerator help) {
        Intrinsics.checkNotNullParameter((Object)help, (String)"help");
        help.helpOnColumn(this.label, this.help);
    }

    public final void localize(@NotNull ReportLocalizer parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        if (!this.isHidden() && !Intrinsics.areEqual((Object)this.ident, (Object)"")) {
            String string = this.ident;
            Intrinsics.checkNotNull((Object)string);
            FieldLocalizer loc = parent.getFieldLocalizer(string);
            String string2 = loc.getLabel();
            if (string2 == null) {
                string2 = "";
            }
            this.label = string2;
            this.help = loc.getHelp();
            this.localize(loc);
        }
    }

    protected void localize(@NotNull FieldLocalizer parentLocalizer) {
        Intrinsics.checkNotNullParameter((Object)parentLocalizer, (String)"parentLocalizer");
    }

    @NotNull
    public final ColumnStyle[] getStyles() {
        ColumnStyle[] columnStyleArray;
        if (this.styles == null) {
            ColumnStyle style = new ColumnStyle();
            style.setFontName(0);
            style.setBackgroundCode(0);
            style.setForegroundCode(1);
            ColumnStyle[] columnStyleArray2 = new ColumnStyle[]{style};
            columnStyleArray = columnStyleArray2;
        } else {
            columnStyleArray = this.styles;
            Intrinsics.checkNotNull((Object)this.styles);
        }
        return columnStyleArray;
    }
}

