/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.ui.vaadin.block;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.upload.AllFinishedEvent;
import com.vaadin.flow.component.upload.FailedEvent;
import com.vaadin.flow.component.upload.FinishedEvent;
import com.vaadin.flow.component.upload.ProgressUpdateEvent;
import com.vaadin.flow.component.upload.Receiver;
import com.vaadin.flow.component.upload.StartedEvent;
import com.vaadin.flow.component.upload.Upload;
import com.vaadin.flow.component.upload.receivers.MemoryBuffer;
import com.vaadin.flow.component.upload.receivers.MultiFileMemoryBuffer;
import com.vaadin.flow.dom.Element;
import elemental.json.Json;
import elemental.json.JsonValue;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kopi.galite.visual.ui.vaadin.form.DBlockDropHandler;

@CssImport(value="./styles/galite/dropwrapper.css", themeFor="vaadin-upload")
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/block/BlockDropWrapper;", "Lcom/vaadin/flow/component/orderedlayout/VerticalLayout;", "layout", "Lcom/vaadin/flow/component/Component;", "dropHandler", "Lorg/kopi/galite/visual/ui/vaadin/form/DBlockDropHandler;", "(Lcom/vaadin/flow/component/Component;Lorg/kopi/galite/visual/ui/vaadin/form/DBlockDropHandler;)V", "buffer", "Lcom/vaadin/flow/component/upload/Receiver;", "getLayout", "()Lcom/vaadin/flow/component/Component;", "upload", "Lcom/vaadin/flow/component/upload/Upload;", "maybeReset", "", "galite-core"})
public final class BlockDropWrapper
extends VerticalLayout {
    @NotNull
    private final Component layout;
    @NotNull
    private final Receiver buffer;
    @NotNull
    private final Upload upload;

    /*
     * WARNING - void declaration
     */
    public BlockDropWrapper(@NotNull Component layout2, final @NotNull DBlockDropHandler dropHandler) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)layout2, (String)"layout");
        Intrinsics.checkNotNullParameter((Object)dropHandler, (String)"dropHandler");
        this.layout = layout2;
        this.buffer = dropHandler.isChartBlockContext$galite_core() ? (Receiver)new MultiFileMemoryBuffer() : (Receiver)new MemoryBuffer();
        this.upload = new Upload(this.buffer);
        VerticalLayout dropArea = new VerticalLayout();
        Iterable iterable = dropHandler.getAcceptedFlavors$galite_core();
        Upload upload2 = this.upload;
        boolean $i$f$map = false;
        void var7_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = it.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            collection.add(Intrinsics.stringPlus((String)".", (Object)string2));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        String[] stringArray2 = stringArray;
        upload2.setAcceptedFileTypes(Arrays.copyOf(stringArray2, stringArray2.length));
        this.upload.getElement().getThemeList().add((Object)"drop-wrapper-upload");
        stringArray2 = new Component[]{this.layout};
        dropArea.add((Component[])stringArray2);
        stringArray2 = new Element[]{dropArea.getElement()};
        this.upload.getElement().appendChild((Element[])stringArray2);
        stringArray2 = new Component[]{(Component)this.upload};
        this.add((Component[])stringArray2);
        this.upload.addStartedListener(new ComponentEventListener(){

            public final void onComponentEvent(StartedEvent it) {
                dropHandler.onStart();
                dropHandler.getStreamHandler$galite_core().streamingStarted(it.getContentLength());
            }
        });
        this.upload.addProgressListener(new ComponentEventListener(){

            public final void onComponentEvent(ProgressUpdateEvent it) {
                dropHandler.getStreamHandler$galite_core().onProgress(it.getReadBytes(), it.getContentLength());
            }
        });
        this.upload.addFinishedListener(new ComponentEventListener(){

            public final void onComponentEvent(FinishedEvent it) {
                OutputStream outputStream = buffer instanceof MultiFileMemoryBuffer ? (OutputStream)((MultiFileMemoryBuffer)buffer).getOutputBuffer(it.getFileName()) : ((MemoryBuffer)buffer).getFileData().getOutputBuffer();
                DBlockDropHandler.StreamHandler streamHandler = dropHandler.getStreamHandler$galite_core();
                String string = it.getFileName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.fileName");
                String string2 = string;
                string = it.getMIMEType();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.mimeType");
                OutputStream outputStream2 = outputStream;
                if (outputStream2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.io.ByteArrayOutputStream");
                }
                streamHandler.streamingFinished(string2, string, it.getContentLength(), (ByteArrayOutputStream)outputStream2);
            }
        });
        this.upload.addFailedListener(new ComponentEventListener(){

            public final void onComponentEvent(FailedEvent it) {
                DBlockDropHandler.StreamHandler streamHandler = dropHandler.getStreamHandler$galite_core();
                Object object = it.getFileName();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.fileName");
                String string = object;
                object = it.getMIMEType();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.mimeType");
                String string2 = object;
                long l = it.getContentLength();
                object = it.getReason();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.reason");
                streamHandler.streamingFailed(string, string2, l, (Exception)object);
            }
        });
        this.upload.addAllFinishedListener(new ComponentEventListener(){

            public final void onComponentEvent(AllFinishedEvent it) {
                dropHandler.onFinish(buffer);
                this.maybeReset();
            }
        });
    }

    @NotNull
    public final Component getLayout() {
        return this.layout;
    }

    private final void maybeReset() {
        if (!(this.buffer instanceof MultiFileMemoryBuffer)) {
            this.upload.getElement().setPropertyJson("files", (JsonValue)Json.createArray());
        }
    }
}

