/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.vkopi.lib.ui.swing.visual;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.kopi.galite.visual.MessageCode;
import org.kopi.vkopi.lib.ui.swing.visual.SwingThreadHandler;

public class ProgressWindow {
    int jobNumber = 0;
    int totalJobs;
    ProgressThread p;
    Frame frame;
    JDialog waitDialog;
    JProgressBar progressBar;
    JLabel text;

    public ProgressWindow(Frame frame) {
        this.frame = frame;
    }

    public void setTotalJobs(int totalJobs) {
        this.totalJobs = totalJobs;
    }

    public void setCurrentJob(int jobNumber) {
        if (jobNumber > this.totalJobs) {
            jobNumber = this.totalJobs;
        }
        this.jobNumber = jobNumber;
    }

    public final void setProgressDialog(String message, int totalJobs) {
        if (this.waitDialog == null) {
            this.waitDialog = new JDialog(this.frame, "no frame", true);
            this.waitDialog.setUndecorated(true);
            this.waitDialog.setDefaultCloseOperation(0);
            this.progressBar = new JProgressBar(0, 100);
            this.progressBar.setValue(0);
            this.progressBar.setStringPainted(true);
            this.text = new JLabel(message);
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.add((Component)new JLabel("<html><b> " + MessageCode.INSTANCE.getMessage("VIS-00067") + " </b><br>" + message), "North");
            panel.add((Component)this.progressBar, "South");
            panel.setBorder(new CompoundBorder(new LineBorder(Color.black, 1), new EmptyBorder(2, 2, 2, 2)));
            this.waitDialog.getContentPane().add(panel);
            this.setTotalJobs(totalJobs);
            this.p = new ProgressThread();
            this.p.start();
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            Point parentPos = new Point(0, 0);
            this.waitDialog.pack();
            SwingUtilities.convertPointToScreen(parentPos, this.frame);
            int posx = parentPos.x + this.frame.getSize().width / 2 - this.waitDialog.getSize().width / 2;
            int posy = parentPos.y + this.frame.getSize().height / 2 - this.waitDialog.getSize().height / 2;
            if (posx < 0) {
                posx = 0;
            } else if (posx + this.waitDialog.getSize().width > screen.width) {
                posx = screen.width - this.waitDialog.getSize().width;
            }
            if (posy < 0) {
                posy = 0;
            } else if (posy + this.waitDialog.getSize().height > screen.height) {
                posy = screen.height - this.waitDialog.getSize().height;
            }
            posx = Math.max(posx, 0);
            posy = Math.max(posy, 0);
            this.waitDialog.setLocation(posx, posy);
            final JDialog wd = this.waitDialog;
            SwingThreadHandler.start(new Runnable(){

                @Override
                public void run() {
                    wd.setVisible(true);
                }
            });
        } else {
            this.text.setText("<html><b> Bitte um Beduld</b><br>" + message);
            this.progressBar.setMaximum(100);
        }
    }

    public final void unsetProgressDialog() {
        this.waitDialog.setVisible(false);
        this.p.interrupt();
        this.waitDialog.dispose();
        this.waitDialog = null;
    }

    class ProgressThread
    extends Thread {
        ProgressThread() {
        }

        @Override
        public void run() {
            int progress = 0;
            while (progress < 100) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (ProgressWindow.this.totalJobs == 0) continue;
                progress = ProgressWindow.this.jobNumber * 100 / ProgressWindow.this.totalJobs;
                ProgressWindow.this.progressBar.setValue(progress);
            }
        }
    }
}

