/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.base;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.util.base.InconsistencyException;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/kopi/galite/visual/base/Utils;", "Lorg/kopi/galite/util/base/Utils;", "()V", "Companion", "galite-core"})
public class Utils
extends org.kopi.galite.util.base.Utils {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String APPLICATION_DIR = "resources";
    @NotNull
    public static final String RESOURCE_DIR = "org/kopi/galite/visual";
    @NotNull
    private static final String[] DEFAULT_VERSION;
    @Nullable
    private static Boolean allowExplicitGcCall;

    static {
        String[] stringArray = new String[]{"No version information available.", "Copyright (c) 2013-2022 kopiLeft Services SARL, Tunis TN. All rights reserved.", "Copyright (c) 1990-2022 kopiRight Managed Solutions GmbH, Wien AT. All rights reserved."};
        DEFAULT_VERSION = stringArray;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\rJ\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0004J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\rJ\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0019\u001a\u00020\u0004J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0019\u001a\u00020\u0004J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000e\u001a\u00020\u0004J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001d\u001a\u00020\u00042\b\u0010\u001e\u001a\u0004\u0018\u00010\u0004J$\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u00042\b\u0010!\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\"\u001a\u00020\nH\u0007J\u001e\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u001d\u001a\u00020\u00042\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u0004H\u0007J\u0011\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\u0002\u0010&J\u0016\u0010'\u001a\u00020\u00172\u0006\u0010(\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006*"}, d2={"Lorg/kopi/galite/visual/base/Utils$Companion;", "", "()V", "APPLICATION_DIR", "", "DEFAULT_VERSION", "", "[Ljava/lang/String;", "RESOURCE_DIR", "allowExplicitGcCall", "", "Ljava/lang/Boolean;", "compress", "", "file", "Ljava/io/File;", "convertUTF", "bytes", "str", "decompress", "Ljava/io/InputStream;", "b", "freeMemory", "", "getApplicationFile", "img", "getDefaultFile", "getFile", "getFileFromResource", "name", "directory", "getTempFile", "prefix", "extension", "deleteOnExit", "getURLFromResource", "Ljava/net/URL;", "getVersion", "()[Ljava/lang/String;", "log", "mod", "text", "galite-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final byte[] compress(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream output = new GZIPOutputStream(baos);
            FileInputStream input = new FileInputStream(file);
            byte[] buffer = new byte[10240];
            int length = input.read(buffer);
            while (length != -1) {
                output.write(buffer, 0, length);
                length = input.read(buffer);
            }
            output.close();
            byte[] byArray = baos.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"baos.toByteArray()");
            return byArray;
        }

        @NotNull
        public final InputStream decompress(@NotNull byte[] b) {
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return new GZIPInputStream(new ByteArrayInputStream(b));
        }

        @JvmOverloads
        @NotNull
        public final File getTempFile(@NotNull String prefix, @Nullable String extension, boolean deleteOnExit) {
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            String string = extension;
            if (string == null) {
                string = "tmp";
            }
            String extensionOrTmp = string;
            File file = File.createTempFile(prefix, Intrinsics.stringPlus((String)".", (Object)extensionOrTmp));
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempFile(prefix, \".$extensionOrTmp\")");
            File file2 = file;
            if (deleteOnExit) {
                file2.deleteOnExit();
            }
            return file2;
        }

        public static /* synthetic */ File getTempFile$default(Companion companion, String string, String string2, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = true;
            }
            return companion.getTempFile(string, string2, bl);
        }

        @Nullable
        public final InputStream getFile(@NotNull String file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            InputStream fileToFind = this.getDefaultFile(file);
            if (fileToFind == null) {
                fileToFind = this.getApplicationFile(file);
            }
            if (fileToFind == null) {
                System.err.println(Intrinsics.stringPlus((String)"Utils ==> cant load: ", (Object)file));
            }
            return fileToFind;
        }

        @Nullable
        public final InputStream getDefaultFile(@NotNull String img) {
            Intrinsics.checkNotNullParameter((Object)img, (String)"img");
            return this.getFileFromResource(img, Utils.RESOURCE_DIR);
        }

        @Nullable
        public final InputStream getApplicationFile(@NotNull String img) {
            Intrinsics.checkNotNullParameter((Object)img, (String)"img");
            return this.getFileFromResource(img, Utils.APPLICATION_DIR);
        }

        @JvmOverloads
        @Nullable
        public final URL getURLFromResource(@NotNull String name, @Nullable String directory) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return directory == null ? (URL)null : Utils.class.getClassLoader().getResource(directory + '/' + name);
        }

        public static /* synthetic */ URL getURLFromResource$default(Companion companion, String string, String string2, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = Utils.RESOURCE_DIR;
            }
            return companion.getURLFromResource(string, string2);
        }

        @Nullable
        public final InputStream getFileFromResource(@NotNull String name, @Nullable String directory) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return directory == null ? (InputStream)null : Utils.class.getClassLoader().getResourceAsStream(directory + '/' + name);
        }

        public final void log(@NotNull String mod, @NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)mod, (String)"mod");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            System.err.println(mod + '\t' + text);
            String filename = System.getProperty("java.io.tmpdir") + File.separator + "kopi.log";
            try {
                PrintWriter writer = new PrintWriter(new FileWriter(filename, true));
                writer.println();
                writer.println();
                writer.println(new Date().toString() + '\t' + mod + '\t' + text + "   ");
                if (writer.checkError()) {
                    writer.close();
                    throw new IOException("error while writing");
                }
                writer.close();
            }
            catch (IOException e) {
                System.err.println(Intrinsics.stringPlus((String)"Can't write in file: ", (Object)filename));
                System.err.println(Intrinsics.stringPlus((String)": ", (Object)e.getMessage()));
            }
        }

        @NotNull
        public final byte[] convertUTF(@NotNull String str) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            try {
                Object object = Charset.forName("UTF-8");
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"forName(charsetName)");
                object = str.getBytes((Charset)object);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this as java.lang.String).getBytes(charset)");
                return object;
            }
            catch (UnsupportedEncodingException e) {
                throw new InconsistencyException((Throwable)e);
            }
        }

        @NotNull
        public final String convertUTF(@NotNull byte[] bytes) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            try {
                object = Charset.forName("UTF-8");
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"forName(\"UTF-8\")");
                object = new String(bytes, (Charset)object);
            }
            catch (UnsupportedEncodingException e) {
                throw new InconsistencyException((Throwable)e);
            }
            return object;
        }

        @NotNull
        public final String[] getVersion() {
            try {
                ArrayList<String> list = new ArrayList<String>();
                InputStream inputStream = Utils.class.getClassLoader().getResourceAsStream("version");
                if (inputStream == null) {
                    String string = "Required value was null.";
                    throw new IllegalArgumentException(string.toString());
                }
                DataInputStream data = new DataInputStream(inputStream);
                while (data.available() != 0) {
                    list.add(data.readLine());
                }
                data.close();
                Collection $this$toTypedArray$iv = list;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                }
                return stringArray;
            }
            catch (Exception e) {
                System.err.println(Intrinsics.stringPlus((String)"Error while reading version information.\n", (Object)e));
                return DEFAULT_VERSION;
            }
        }

        public final void freeMemory() {
            if (allowExplicitGcCall == null) {
                allowExplicitGcCall = System.getProperty("visual.allowExplicitGcCall") != null;
            }
            if (Intrinsics.areEqual((Object)allowExplicitGcCall, (Object)true)) {
                System.gc();
            }
        }

        @JvmOverloads
        @NotNull
        public final File getTempFile(@NotNull String prefix, @Nullable String extension) {
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            return org.kopi.galite.visual.base.Utils$Companion.getTempFile$default(this, prefix, extension, false, 4, null);
        }

        @JvmOverloads
        @Nullable
        public final URL getURLFromResource(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return org.kopi.galite.visual.base.Utils$Companion.getURLFromResource$default(this, name, null, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

