/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.util;

import gnu.hylafax.HylaFAXClient;
import gnu.inet.ftp.ServerResponseException;
import java.io.IOException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.kopi.galite.visual.base.Utils;
import org.kopi.galite.visual.util.FaxException;
import org.kopi.galite.visual.util.FaxStatus;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016J6\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\u00182\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\nH\u0002J.\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016J,\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00182\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nJ6\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00182\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\nH\u0002J,\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00182\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nJ,\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00182\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nJ,\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0\u00182\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006!"}, d2={"Lorg/kopi/galite/visual/util/HylaFAXUtils;", "", "()V", "HFX_DEFAULT_PORT", "", "getHFX_DEFAULT_PORT", "()I", "setHFX_DEFAULT_PORT", "(I)V", "HFX_DEFAULT_USER", "", "getHFX_DEFAULT_USER", "()Ljava/lang/String;", "setHFX_DEFAULT_USER", "(Ljava/lang/String;)V", "deleteJob", "", "host", "port", "user", "password", "job", "", "getQueue", "Ljava/util/ArrayList;", "qname", "killJob", "readDoneQueue", "Lorg/kopi/galite/visual/util/FaxStatus;", "readQueue", "readRecQueue", "readSendQueue", "readServerStatus", "galite-core"})
public final class HylaFAXUtils {
    @NotNull
    public static final HylaFAXUtils INSTANCE = new HylaFAXUtils();
    private static int HFX_DEFAULT_PORT = 4559;
    @NotNull
    private static String HFX_DEFAULT_USER = "GALITE";

    private HylaFAXUtils() {
    }

    @NotNull
    public final ArrayList<FaxStatus> readSendQueue(@NotNull String host, int port, @NotNull String user, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        return this.readQueue(host, port, user, password, "sendq");
    }

    @NotNull
    public final ArrayList<FaxStatus> readDoneQueue(@NotNull String host, int port, @NotNull String user, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        return this.readQueue(host, port, user, password, "doneq");
    }

    @NotNull
    public final ArrayList<FaxStatus> readRecQueue(@NotNull String host, int port, @NotNull String user, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        return this.readQueue(host, port, user, password, "recvq");
    }

    @NotNull
    public final ArrayList<String> readServerStatus(@NotNull String host, int port, @NotNull String user, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        ArrayList<String> status = null;
        try {
            status = this.getQueue(host, port, user, password, "status");
            Utils.Companion.log("Fax", "READ STATE : host " + host + " / user " + user);
        }
        catch (ConnectException e) {
            throw new FaxException("NO FAX SERVER");
        }
        catch (IOException e) {
            throw new FaxException(Intrinsics.stringPlus((String)"Trying read server state: ", (Object)e.getMessage()), e);
        }
        catch (ServerResponseException e) {
            throw new FaxException(Intrinsics.stringPlus((String)"Trying read server state: ", (Object)e.getMessage()), e);
        }
        return status;
    }

    public final void killJob(@NotNull String host, int port, @NotNull String user, @NotNull String password, long job) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        try {
            HylaFAXClient faxClient = new HylaFAXClient();
            faxClient.open(host);
            if (faxClient.user(user)) {
                faxClient.pass(password);
            }
            faxClient.jkill(job);
            Utils.Companion.log("Fax", Intrinsics.stringPlus((String)"Kill 1: ", (Object)job));
            faxClient.quit();
        }
        catch (IOException ioe) {
            throw new FaxException(ioe);
        }
        catch (ServerResponseException sre) {
            throw new FaxException(sre);
        }
    }

    public final void deleteJob(@NotNull String host, int port, @NotNull String user, @NotNull String password, long job) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        try {
            HylaFAXClient faxClient = new HylaFAXClient();
            faxClient.open(host);
            if (faxClient.user(user)) {
                faxClient.pass(password);
            }
            faxClient.jdele(job);
            Utils.Companion.log("Fax", Intrinsics.stringPlus((String)"Delete 1: ", (Object)job));
            faxClient.quit();
        }
        catch (IOException ioe) {
            throw new FaxException(ioe);
        }
        catch (ServerResponseException sre) {
            throw new FaxException(sre);
        }
    }

    private final ArrayList<String> getQueue(String host, int port, String user, String password, String qname) {
        HylaFAXClient faxClient = new HylaFAXClient();
        faxClient.open(host);
        if (faxClient.user(user)) {
            faxClient.pass(password);
        }
        faxClient.tzone("LOCAL");
        faxClient.rcvfmt("%f| %t| %s| %p| %h| %e");
        faxClient.jobfmt("%j| %J| %o| %e| %a| %P| %D| %.25s");
        faxClient.mdmfmt("Modem %m (%n): %s");
        ArrayList<String> entries = new ArrayList<String>(faxClient.getList(qname));
        faxClient.quit();
        return entries;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final ArrayList<FaxStatus> readQueue(String host, int port, String user, String password, String qname) {
        ArrayList<FaxStatus> queue = new ArrayList<FaxStatus>();
        try {
            ArrayList<String> result = this.getQueue(host, port, user, password, qname);
            Utils.Companion.log("Fax", "READ " + qname + " : host " + host + " / user " + user);
            Iterable $this$forEach$iv = result;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String element = (String)element$iv;
                boolean bl = false;
                try {
                    String string;
                    StringTokenizer process = new StringTokenizer(element, "|");
                    if (!Intrinsics.areEqual((Object)qname, (Object)"recvq")) {
                        string = process.nextToken();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"process.nextToken()");
                        String string2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
                        string = process.nextToken();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"process.nextToken()");
                        String string3 = ((Object)StringsKt.trim((CharSequence)string)).toString();
                        string = process.nextToken();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"process.nextToken()");
                        String string4 = ((Object)StringsKt.trim((CharSequence)string)).toString();
                        string = process.nextToken();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"process.nextToken()");
                        String string5 = ((Object)StringsKt.trim((CharSequence)string)).toString();
                        string = process.nextToken();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"process.nextToken()");
                        String string6 = ((Object)StringsKt.trim((CharSequence)string)).toString();
                        string = process.nextToken();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"process.nextToken()");
                        String string7 = ((Object)StringsKt.trim((CharSequence)string)).toString();
                        string = process.nextToken();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"process.nextToken()");
                        String string8 = ((Object)StringsKt.trim((CharSequence)string)).toString();
                        string = process.nextToken();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"process.nextToken()");
                        queue.add(new FaxStatus(string2, string3, string4, string5, string6, string7, string8, ((Object)StringsKt.trim((CharSequence)string)).toString()));
                        continue;
                    }
                    string = process.nextToken();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"process.nextToken()");
                    String string9 = ((Object)StringsKt.trim((CharSequence)string)).toString();
                    string = process.nextToken();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"process.nextToken()");
                    String string10 = ((Object)StringsKt.trim((CharSequence)string)).toString();
                    string = process.nextToken();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"process.nextToken()");
                    String string11 = ((Object)StringsKt.trim((CharSequence)string)).toString();
                    string = process.nextToken();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"process.nextToken()");
                    String string12 = ((Object)StringsKt.trim((CharSequence)string)).toString();
                    string = process.nextToken();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"process.nextToken()");
                    String string13 = ((Object)StringsKt.trim((CharSequence)string)).toString();
                    string = process.nextToken();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"process.nextToken()");
                    queue.add(new FaxStatus(string9, string10, string11, string12, string13, ((Object)StringsKt.trim((CharSequence)string)).toString()));
                }
                catch (Exception e) {
                    String string = e.getMessage();
                    Intrinsics.checkNotNull((Object)string);
                    throw new FaxException(string, e);
                    return queue;
                }
            }
        }
        catch (ConnectException e) {
            Utils.Companion.log("Fax", "NO FAX SERVER");
            throw new FaxException("NO FAX SERVER");
        }
        catch (IOException e) {
            throw new FaxException(e);
        }
        catch (ServerResponseException e) {
            throw new FaxException(e);
        }
    }

    public final int getHFX_DEFAULT_PORT() {
        return HFX_DEFAULT_PORT;
    }

    public final void setHFX_DEFAULT_PORT(int n) {
        HFX_DEFAULT_PORT = n;
    }

    @NotNull
    public final String getHFX_DEFAULT_USER() {
        return HFX_DEFAULT_USER;
    }

    public final void setHFX_DEFAULT_USER(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        HFX_DEFAULT_USER = string;
    }
}

