/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.util;

import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.util.lpr.LpR;
import org.kopi.galite.util.lpr.LpdException;
import org.kopi.galite.visual.util.PrintException;
import org.kopi.galite.visual.util.PrintJob;
import org.kopi.galite.visual.util.Printer;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0014B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nJ\b\u0010\r\u001a\u00020\u0003H\u0016J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u0006H\u0016J\u0012\u0010\u0013\u001a\u00020\u00122\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/kopi/galite/visual/util/LpRPrinter;", "Lorg/kopi/galite/visual/util/Printer;", "name", "", "serverHost", "port", "", "proxyHost", "queue", "user", "(Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "paperFormat", "tray", "getPrinterName", "print", "data", "Lorg/kopi/galite/visual/util/PrintJob;", "selectTray", "", "setPaperFormat", "LprImpl", "galite-core"})
public final class LpRPrinter
implements Printer {
    @NotNull
    private final String name;
    @NotNull
    private final String serverHost;
    private final int port;
    @NotNull
    private final String proxyHost;
    @NotNull
    private final String queue;
    @NotNull
    private final String user;
    private int tray;
    @Nullable
    private String paperFormat;

    public LpRPrinter(@NotNull String name, @NotNull String serverHost, int port, @NotNull String proxyHost, @NotNull String queue, @NotNull String user) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)serverHost, (String)"serverHost");
        Intrinsics.checkNotNullParameter((Object)proxyHost, (String)"proxyHost");
        Intrinsics.checkNotNullParameter((Object)queue, (String)"queue");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        this.name = name;
        this.serverHost = serverHost;
        this.port = port;
        this.proxyHost = proxyHost;
        this.queue = queue;
        this.user = user;
        this.selectTray(1);
        this.setPaperFormat(null);
    }

    @Override
    @NotNull
    public String getPrinterName() {
        return this.name;
    }

    @Override
    public void selectTray(int tray) {
        this.tray = tray;
    }

    @Override
    public void setPaperFormat(@Nullable String paperFormat) {
        this.paperFormat = paperFormat;
    }

    @Override
    @NotNull
    public String print(@NotNull PrintJob data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return new LprImpl(data).print();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/kopi/galite/visual/util/LpRPrinter$LprImpl;", "Lorg/kopi/galite/util/lpr/LpR;", "data", "Lorg/kopi/galite/visual/util/PrintJob;", "(Lorg/kopi/galite/visual/util/LpRPrinter;Lorg/kopi/galite/visual/util/PrintJob;)V", "print", "", "readFully", "", "inputStream", "Ljava/io/InputStream;", "galite-core"})
    private final class LprImpl
    extends LpR {
        @NotNull
        private final PrintJob data;

        public LprImpl(PrintJob data) {
            Intrinsics.checkNotNullParameter((Object)LpRPrinter.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            super(LpRPrinter.this.serverHost, LpRPrinter.this.port, LpRPrinter.this.proxyHost, LpRPrinter.this.queue, LpRPrinter.this.user);
            this.data = data;
            this.setPrintBurst(false);
        }

        @NotNull
        public final String print() {
            try {
                if (this.data.getTitle() != null) {
                    String string = this.data.getTitle();
                    Intrinsics.checkNotNull((Object)string);
                    this.setTitle(string);
                }
                this.print(this.data.getInputStream(), null);
                this.close();
            }
            catch (LpdException e) {
                String string = e.getMessage();
                Intrinsics.checkNotNull((Object)string);
                throw new PrintException(string, 0);
            }
            return "not yet implemented";
        }

        @NotNull
        protected byte[] readFully(@NotNull InputStream inputStream) {
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            int size = inputStream.available();
            byte[] data = new byte[size];
            for (int count = 0; count < size; count += inputStream.read(data, count, size - count)) {
            }
            inputStream.close();
            return data;
        }
    }
}

