/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.util;

import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.base.Utils;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u0000 D2\u00020\u0001:\u0001DB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B\u0017\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nB\u001d\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010:\u001a\u00020\u00002\u0006\u0010;\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010<\u001a\u00020=H\u0004J\u0006\u0010>\u001a\u00020\u0006J\u0006\u0010?\u001a\u00020\u0015J\u0006\u0010@\u001a\u00020\u0015J\u001e\u0010A\u001a\u00020=2\u0006\u00107\u001a\u00020(2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u00100\u001a\u00020\u0015J\b\u0010B\u001a\u00020(H\u0016J\u000e\u0010C\u001a\u00020=2\u0006\u0010;\u001a\u00020\fR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0017\"\u0004\b \u0010\u0019R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010\u0004R\u0011\u0010$\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u001c\u0010'\u001a\u0004\u0018\u00010(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001a\u0010-\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\u0017\"\u0004\b/\u0010\u0019R\u001a\u00100\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010\u0017\"\u0004\b2\u0010\u0019R\u0011\u00103\u001a\u0002048F\u00a2\u0006\u0006\u001a\u0004\b5\u00106R\u001c\u00107\u001a\u0004\u0018\u00010(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010*\"\u0004\b9\u0010,\u00a8\u0006E"}, d2={"Lorg/kopi/galite/visual/util/PrintJob;", "", "format", "Lcom/lowagie/text/Rectangle;", "(Lcom/lowagie/text/Rectangle;)V", "data", "", "([BLcom/lowagie/text/Rectangle;)V", "dataStream", "Ljava/io/InputStream;", "(Ljava/io/InputStream;Lcom/lowagie/text/Rectangle;)V", "dataFile", "Ljava/io/File;", "delete", "", "(Ljava/io/File;ZLcom/lowagie/text/Rectangle;)V", "getDataFile", "()Ljava/io/File;", "setDataFile", "(Ljava/io/File;)V", "dataType", "", "getDataType", "()I", "setDataType", "(I)V", "getDelete", "()Z", "setDelete", "(Z)V", "documentType", "getDocumentType", "setDocumentType", "getFormat", "()Lcom/lowagie/text/Rectangle;", "setFormat", "inputStream", "getInputStream", "()Ljava/io/InputStream;", "media", "", "getMedia", "()Ljava/lang/String;", "setMedia", "(Ljava/lang/String;)V", "numberOfCopies", "getNumberOfCopies", "setNumberOfCopies", "numberOfPages", "getNumberOfPages", "setNumberOfPages", "outputStream", "Ljava/io/OutputStream;", "getOutputStream", "()Ljava/io/OutputStream;", "title", "getTitle", "setTitle", "createFromThis", "file", "finalize", "", "getBytes", "getHeight", "getWidth", "setPrintInformation", "toString", "writeDataToFile", "Companion", "galite-core"})
public final class PrintJob {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private File dataFile;
    private boolean delete;
    @NotNull
    private Rectangle format;
    @Nullable
    private String title;
    @Nullable
    private String media;
    private int documentType;
    private int dataType;
    private int numberOfCopies;
    private int numberOfPages;
    public static final int DAT_PDF = 1;
    public static final int DAT_PS = 2;
    @NotNull
    private static final Rectangle FORMAT_A5;
    @NotNull
    private static final Rectangle FORMAT_A4;
    @NotNull
    private static final Rectangle FORMAT_A3;
    @NotNull
    private static final Rectangle FORMAT_LETTER;
    @NotNull
    private static final Rectangle FORMAT_LEGAL;
    @NotNull
    private static final Rectangle FORMAT_A5_R;
    @NotNull
    private static final Rectangle FORMAT_A4_R;
    @NotNull
    private static final Rectangle FORMAT_A3_R;
    @NotNull
    private static final Rectangle FORMAT_LETTER_R;
    @NotNull
    private static final Rectangle FORMAT_LEGAL_R;
    @NotNull
    private static final Rectangle FORMAT_RAW;

    public PrintJob(@NotNull File dataFile, boolean delete, @NotNull Rectangle format2) {
        Intrinsics.checkNotNullParameter((Object)dataFile, (String)"dataFile");
        Intrinsics.checkNotNullParameter((Object)format2, (String)"format");
        this.dataFile = dataFile;
        this.delete = delete;
        this.format = format2;
        this.dataType = 2;
        this.numberOfCopies = 1;
        this.numberOfPages = -1;
        if (this.delete) {
            this.dataFile.deleteOnExit();
        }
    }

    @NotNull
    public final File getDataFile() {
        return this.dataFile;
    }

    public final void setDataFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<set-?>");
        this.dataFile = file;
    }

    public final boolean getDelete() {
        return this.delete;
    }

    public final void setDelete(boolean bl) {
        this.delete = bl;
    }

    @NotNull
    public final Rectangle getFormat() {
        return this.format;
    }

    public final void setFormat(@NotNull Rectangle rectangle) {
        Intrinsics.checkNotNullParameter((Object)rectangle, (String)"<set-?>");
        this.format = rectangle;
    }

    public PrintJob(@NotNull Rectangle format2) {
        Intrinsics.checkNotNullParameter((Object)format2, (String)"format");
        this(Utils.Companion.getTempFile$default(Utils.Companion, "galite", "pdf", false, 4, null), true, format2);
    }

    public PrintJob(@NotNull byte[] data, @NotNull Rectangle format2) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)format2, (String)"format");
        this(PrintJob.Companion.writeToFile(new ByteArrayInputStream(data)), true, format2);
    }

    public PrintJob(@NotNull InputStream dataStream, @NotNull Rectangle format2) {
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        Intrinsics.checkNotNullParameter((Object)format2, (String)"format");
        this(PrintJob.Companion.writeToFile(dataStream), true, format2);
    }

    @Nullable
    public final String getTitle() {
        return this.title;
    }

    public final void setTitle(@Nullable String string) {
        this.title = string;
    }

    @Nullable
    public final String getMedia() {
        return this.media;
    }

    public final void setMedia(@Nullable String string) {
        this.media = string;
    }

    public final int getDocumentType() {
        return this.documentType;
    }

    public final void setDocumentType(int n) {
        this.documentType = n;
    }

    public final int getDataType() {
        return this.dataType;
    }

    public final void setDataType(int n) {
        this.dataType = n;
    }

    public final int getNumberOfCopies() {
        return this.numberOfCopies;
    }

    public final void setNumberOfCopies(int n) {
        this.numberOfCopies = n;
    }

    public final int getNumberOfPages() {
        return this.numberOfPages;
    }

    public final void setNumberOfPages(int n) {
        this.numberOfPages = n;
    }

    protected final void finalize() {
        if (this.delete) {
            this.dataFile.delete();
        }
    }

    @NotNull
    public String toString() {
        return "PrintJob (" + this.delete + ") " + this.dataFile + "  " + super.toString();
    }

    @NotNull
    public final OutputStream getOutputStream() {
        return new FileOutputStream(this.dataFile);
    }

    @NotNull
    public final InputStream getInputStream() {
        return new FileInputStream(this.dataFile);
    }

    @NotNull
    public final byte[] getBytes() {
        byte[] buffer = new byte[1024];
        int length = 0;
        InputStream data = this.getInputStream();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        while (true) {
            int n;
            int it = n = data.read(buffer);
            boolean bl = false;
            length = it;
            if (n == -1) break;
            output.write(buffer, 0, length);
        }
        byte[] byArray = output.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"output.toByteArray()");
        return byArray;
    }

    public final void writeDataToFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PrintJob.Companion.writeToFile(this.getInputStream(), file);
    }

    public final void setPrintInformation(@NotNull String title, @NotNull Rectangle format2, int numberOfPages) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)format2, (String)"format");
        this.title = title;
        this.format = format2;
        this.numberOfPages = numberOfPages;
    }

    public final int getWidth() {
        return (int)this.format.getWidth();
    }

    public final int getHeight() {
        return (int)this.format.getHeight();
    }

    @NotNull
    public final PrintJob createFromThis(@NotNull File file, boolean delete) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return new PrintJob(file, delete, this.format);
    }

    static {
        Rectangle rectangle = PageSize.A5;
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"A5");
        FORMAT_A5 = rectangle;
        rectangle = PageSize.A4;
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"A4");
        FORMAT_A4 = rectangle;
        rectangle = PageSize.A3;
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"A3");
        FORMAT_A3 = rectangle;
        rectangle = PageSize.LETTER;
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"LETTER");
        FORMAT_LETTER = rectangle;
        rectangle = PageSize.LEGAL;
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"LEGAL");
        FORMAT_LEGAL = rectangle;
        FORMAT_A5_R = new Rectangle(PageSize.A5.rotate().getWidth(), PageSize.A5.rotate().getHeight());
        FORMAT_A4_R = new Rectangle(PageSize.A4.rotate().getWidth(), PageSize.A4.rotate().getHeight());
        FORMAT_A3_R = new Rectangle(PageSize.A3.rotate().getWidth(), PageSize.A3.rotate().getHeight());
        FORMAT_LETTER_R = new Rectangle(PageSize.LETTER.rotate().getWidth(), PageSize.LETTER.rotate().getHeight());
        FORMAT_LEGAL_R = new Rectangle(PageSize.LEGAL.rotate().getWidth(), PageSize.LEGAL.rotate().getHeight());
        FORMAT_RAW = new Rectangle(-1.0f, -1.0f);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u0010\u001e\u001a\u00020\"2\u0006\u0010 \u001a\u00020!2\u0006\u0010#\u001a\u00020\u001fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\f\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u0011\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR\u0011\u0010\u0010\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\tR\u0011\u0010\u0012\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\tR\u0011\u0010\u0014\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\tR\u0011\u0010\u0016\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\tR\u0011\u0010\u0018\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\tR\u0011\u0010\u001a\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\tR\u0011\u0010\u001c\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\t\u00a8\u0006$"}, d2={"Lorg/kopi/galite/visual/util/PrintJob$Companion;", "", "()V", "DAT_PDF", "", "DAT_PS", "FORMAT_A3", "Lcom/lowagie/text/Rectangle;", "getFORMAT_A3", "()Lcom/lowagie/text/Rectangle;", "FORMAT_A3_R", "getFORMAT_A3_R", "FORMAT_A4", "getFORMAT_A4", "FORMAT_A4_R", "getFORMAT_A4_R", "FORMAT_A5", "getFORMAT_A5", "FORMAT_A5_R", "getFORMAT_A5_R", "FORMAT_LEGAL", "getFORMAT_LEGAL", "FORMAT_LEGAL_R", "getFORMAT_LEGAL_R", "FORMAT_LETTER", "getFORMAT_LETTER", "FORMAT_LETTER_R", "getFORMAT_LETTER_R", "FORMAT_RAW", "getFORMAT_RAW", "writeToFile", "Ljava/io/File;", "dataStream", "Ljava/io/InputStream;", "", "outputFile", "galite-core"})
    public static final class Companion {
        private Companion() {
        }

        private final File writeToFile(InputStream dataStream) {
            File tempFile = Utils.Companion.getTempFile$default(Utils.Companion, "galite", "pdf", false, 4, null);
            this.writeToFile(dataStream, tempFile);
            return tempFile;
        }

        private final void writeToFile(InputStream dataStream, File outputFile) {
            byte[] buffer = new byte[1024];
            int length = 0;
            FileOutputStream output = new FileOutputStream(outputFile);
            while (true) {
                int n;
                int it = n = dataStream.read(buffer);
                boolean bl = false;
                length = it;
                if (n == -1) break;
                output.write(buffer, 0, length);
            }
            output.flush();
            output.close();
        }

        @NotNull
        public final Rectangle getFORMAT_A5() {
            return FORMAT_A5;
        }

        @NotNull
        public final Rectangle getFORMAT_A4() {
            return FORMAT_A4;
        }

        @NotNull
        public final Rectangle getFORMAT_A3() {
            return FORMAT_A3;
        }

        @NotNull
        public final Rectangle getFORMAT_LETTER() {
            return FORMAT_LETTER;
        }

        @NotNull
        public final Rectangle getFORMAT_LEGAL() {
            return FORMAT_LEGAL;
        }

        @NotNull
        public final Rectangle getFORMAT_A5_R() {
            return FORMAT_A5_R;
        }

        @NotNull
        public final Rectangle getFORMAT_A4_R() {
            return FORMAT_A4_R;
        }

        @NotNull
        public final Rectangle getFORMAT_A3_R() {
            return FORMAT_A3_R;
        }

        @NotNull
        public final Rectangle getFORMAT_LETTER_R() {
            return FORMAT_LETTER_R;
        }

        @NotNull
        public final Rectangle getFORMAT_LEGAL_R() {
            return FORMAT_LEGAL_R;
        }

        @NotNull
        public final Rectangle getFORMAT_RAW() {
            return FORMAT_RAW;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

