/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.vkopi.lib.ui.swing.visual;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;
import org.kopi.galite.util.base.InconsistencyException;
import org.kopi.galite.visual.VHelpViewer;
import org.kopi.vkopi.lib.ui.swing.visual.DWindow;
import org.kopi.vkopi.lib.ui.swing.visual.SwingThreadHandler;

class DHelpViewer
extends DWindow
implements HyperlinkListener {
    private static final long serialVersionUID = -5681828259231318466L;
    private JEditorPane html;

    public DHelpViewer(VHelpViewer model2) {
        super(model2);
        this.registerKeyboardAction(new AbstractAction(){
            private static final long serialVersionUID = -4312276387422409187L;

            @Override
            public void actionPerformed(ActionEvent e) {
                DHelpViewer.this.closeWindow();
            }
        }, null, KeyStroke.getKeyStroke(27, 0), 2);
        this.getContentPanel().setLayout(new BorderLayout());
        try {
            this.html = new JEditorPane(model2.getUrl());
        }
        catch (IOException e) {
            throw new InconsistencyException((Throwable)e);
        }
        this.html.setEditable(false);
        this.html.addHyperlinkListener(this);
        JScrollPane scroller = new JScrollPane(this.html, 20, 30);
        scroller.setPreferredSize(new Dimension(600, 500));
        this.getContentPanel().add((Component)scroller, "Center");
    }

    @Override
    public void run() {
        this.setVisible(true);
        this.html.requestFocus();
        this.getModel().setActorEnabled(0, true);
    }

    public void setURL(final URL url) {
        SwingThreadHandler.startAndWait(new Runnable(){

            @Override
            public void run() {
                Document doc = DHelpViewer.this.html.getDocument();
                try {
                    DHelpViewer.this.html.setPage(url);
                }
                catch (IOException ioe) {
                    DHelpViewer.this.html.setDocument(doc);
                    DHelpViewer.this.getToolkit().beep();
                }
            }
        });
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.linkActivated(e.getURL());
        }
    }

    protected void linkActivated(URL u) {
        ((VHelpViewer)this.getModel()).setUrl(u);
    }
}

