/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.dsl.chart;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.kopi.galite.visual.dsl.chart.Chart;
import org.kopi.galite.visual.dsl.chart.ChartMeasure;
import org.kopi.galite.visual.dsl.chart.DimensionData;
import org.kopi.galite.visual.dsl.exceptions.MissingMeasureException;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0017\u0010\u0007\u001a\u00020\u0004\"\u0004\b\u0000\u0010\b*\u0002H\bH\u0002\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lorg/kopi/galite/visual/dsl/chart/Formatter;", "", "()V", "encode", "", "chart", "Lorg/kopi/galite/visual/dsl/chart/Chart;", "quoteIfNecessary", "T", "(Ljava/lang/Object;)Ljava/lang/String;", "galite-core"})
public final class Formatter {
    @NotNull
    public static final Formatter INSTANCE = new Formatter();

    private Formatter() {
    }

    @NotNull
    public final String encode(@NotNull Chart chart) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)chart, (String)"chart");
        StringBuilder $this$encode_u24lambda_u2d4 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$encode_u24lambda_u2d4.append("[[");
        $this$encode_u24lambda_u2d4.append(INSTANCE.quoteIfNecessary(chart.getDimension().getLabel()));
        Iterable $this$forEach$iv = chart.getMeasures();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChartMeasure it = (ChartMeasure)element$iv;
            boolean bl2 = false;
            $this$encode_u24lambda_u2d4.append(",");
            $this$encode_u24lambda_u2d4.append(INSTANCE.quoteIfNecessary(it.getLabel()));
        }
        $this$encode_u24lambda_u2d4.append("]");
        $this$forEach$iv = chart.getDimension().getValues();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DimensionData dimensionValue = (DimensionData)element$iv;
            boolean bl3 = false;
            $this$encode_u24lambda_u2d4.append(",");
            $this$encode_u24lambda_u2d4.append("[");
            $this$encode_u24lambda_u2d4.append(INSTANCE.quoteIfNecessary(dimensionValue.getValue()));
            Iterable $this$forEach$iv2 = chart.getMeasures();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                ChartMeasure measure = (ChartMeasure)element$iv2;
                boolean bl4 = false;
                $this$encode_u24lambda_u2d4.append(",");
                Number number = dimensionValue.getMeasureList().get(measure);
                if (number == null) {
                    boolean bl5 = false;
                    throw new MissingMeasureException(measure, (Comparable<?>)dimensionValue.getValue());
                }
                $this$encode_u24lambda_u2d4.append(number);
            }
            $this$encode_u24lambda_u2d4.append("]");
        }
        $this$encode_u24lambda_u2d4.append("]");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private final <T> String quoteIfNecessary(T $this$quoteIfNecessary) {
        String stringRepresentation = String.valueOf($this$quoteIfNecessary);
        return !StringsKt.startsWith$default((String)stringRepresentation, (String)"\"", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)stringRepresentation, (String)"\"", (boolean)false, (int)2, null) ? "\"" + stringRepresentation + "\"" : stringRepresentation;
    }
}

