/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.report;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfPageEventHelper;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.util.base.InconsistencyException;
import org.kopi.galite.visual.VlibProperties;
import org.kopi.galite.visual.base.Utils;
import org.kopi.galite.visual.report.Constants;
import org.kopi.galite.visual.report.MReport;
import org.kopi.galite.visual.report.PConfig;
import org.kopi.galite.visual.report.PExport;
import org.kopi.galite.visual.report.UReport;
import org.kopi.galite.visual.report.VReportColumn;
import org.kopi.galite.visual.report.VReportRow;
import org.kopi.galite.visual.util.PPaperType;
import org.kopi.galite.visual.util.PrintJob;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001a\u0018\u0000 \\2\u00020\u00012\u00020\u0002:\u0001\\B7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J8\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\n2\u0006\u0010&\u001a\u00020\u00192\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\rH\u0002J\b\u0010,\u001a\u00020\u0011H\u0002J\u0018\u0010-\u001a\u00020\u00112\u0006\u0010.\u001a\u00020\u00172\u0006\u0010/\u001a\u00020\u0017H\u0002J\b\u00100\u001a\u00020\u0011H\u0002J\u0006\u00101\u001a\u000202J\u0010\u00101\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"H\u0014J\u001d\u00103\u001a\u00020\u001e2\u000e\u00104\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n05H\u0014\u00a2\u0006\u0002\u00106J=\u00107\u001a\u00020\u001e2\u0006\u00108\u001a\u00020\u00172\u000e\u00104\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n052\u000e\u00109\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010:052\u0006\u0010;\u001a\u00020<H\u0014\u00a2\u0006\u0002\u0010=J\u0018\u00107\u001a\u00020\u001e2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020\rH\u0014J\u001d\u0010A\u001a\u00020\u001e2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020\u0017H\u0010\u00a2\u0006\u0002\bEJ\u001d\u0010F\u001a\u00020\u001e2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020\u0017H\u0010\u00a2\u0006\u0002\bGJ\u001d\u0010H\u001a\u00020\u001e2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020\u0017H\u0010\u00a2\u0006\u0002\bIJ\u001d\u0010J\u001a\u00020\u001e2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020\u0017H\u0010\u00a2\u0006\u0002\bKJ\u001d\u0010L\u001a\u00020\u001e2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020\u0017H\u0010\u00a2\u0006\u0002\bMJ\u001d\u0010N\u001a\u00020\u001e2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020\u0017H\u0010\u00a2\u0006\u0002\bOJ\u001d\u0010P\u001a\u00020\u001e2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020\u0017H\u0010\u00a2\u0006\u0002\bQJ\u001d\u0010R\u001a\u00020\u001e2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020\u0017H\u0010\u00a2\u0006\u0002\bSJ\u001d\u0010T\u001a\u00020\u001e2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020\u0017H\u0010\u00a2\u0006\u0002\bUJ \u0010V\u001a\u00020\u00192\u0006\u0010W\u001a\u00020\u00192\u0006\u0010X\u001a\u00020\u00192\u0006\u0010Y\u001a\u00020\u0019H\u0002J\u0012\u0010Z\u001a\u00020\u001e2\b\u0010[\u001a\u0004\u0018\u00010\nH\u0014R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006]"}, d2={"Lorg/kopi/galite/visual/report/PExport2PDF;", "Lorg/kopi/galite/visual/report/PExport;", "Lorg/kopi/galite/visual/report/Constants;", "table", "Lorg/kopi/galite/visual/report/UReport$UTable;", "model", "Lorg/kopi/galite/visual/report/MReport;", "printConfig", "Lorg/kopi/galite/visual/report/PConfig;", "title", "", "firstPageHeader", "tonerSaveMode", "", "(Lorg/kopi/galite/visual/report/UReport$UTable;Lorg/kopi/galite/visual/report/MReport;Lorg/kopi/galite/visual/report/PConfig;Ljava/lang/String;Ljava/lang/String;Z)V", "currentSubtitle", "datatable", "Lcom/lowagie/text/pdf/PdfPTable;", "document", "Lcom/lowagie/text/Document;", "firstPage", "nextPageSubtitle", "pages", "", "scale", "", "widthSum", "widths", "", "addFooter", "", "tempFile", "Ljava/io/File;", "out", "Ljava/io/OutputStream;", "createCell", "Lcom/lowagie/text/pdf/PdfPCell;", "text", "size", "textColor", "Ljava/awt/Color;", "background", "alignment", "border", "createFirstPageHeader", "createFooter", "page", "allPages", "createHeader", "export", "Lorg/kopi/galite/visual/util/PrintJob;", "exportHeader", "data", "", "([Ljava/lang/String;)V", "exportRow", "level", "orig", "", "alignments", "", "(I[Ljava/lang/String;[Ljava/lang/Object;[I)V", "row", "Lorg/kopi/galite/visual/report/VReportRow;", "tail", "formatBooleanColumn", "column", "Lorg/kopi/galite/visual/report/VReportColumn;", "index", "formatBooleanColumn$galite_core", "formatDateColumn", "formatDateColumn$galite_core", "formatDecimalColumn", "formatDecimalColumn$galite_core", "formatIntegerColumn", "formatIntegerColumn$galite_core", "formatMonthColumn", "formatMonthColumn$galite_core", "formatStringColumn", "formatStringColumn$galite_core", "formatTimeColumn", "formatTimeColumn$galite_core", "formatTimestampColumn", "formatTimestampColumn$galite_core", "formatWeekColumn", "formatWeekColumn$galite_core", "getScale", "min", "max", "precision", "startGroup", "subTitle", "Companion", "galite-core"})
public final class PExport2PDF
extends PExport
implements Constants {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String firstPageHeader;
    @Nullable
    private PdfPTable datatable;
    private int pages;
    private Document document;
    @Nullable
    private String currentSubtitle;
    @Nullable
    private String nextPageSubtitle;
    private boolean firstPage;
    private double scale;
    private double widthSum;
    @NotNull
    private final float[] widths;
    private static final int BORDER_PADDING = 1;
    private static final int BORDER_WIDTH = 1;

    public PExport2PDF(@NotNull UReport.UTable table, @NotNull MReport model2, @NotNull PConfig printConfig, @NotNull String title, @NotNull String firstPageHeader, boolean tonerSaveMode) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)printConfig, (String)"printConfig");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)firstPageHeader, (String)"firstPageHeader");
        super(table, model2, printConfig, title, tonerSaveMode);
        this.firstPageHeader = firstPageHeader;
        this.widths = new float[this.getColumnCount()];
    }

    public /* synthetic */ PExport2PDF(UReport.UTable uTable, MReport mReport, PConfig pConfig, String string, String string2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            bl = false;
        }
        this(uTable, mReport, pConfig, string, string2, bl);
    }

    @NotNull
    public final PrintJob export() {
        try {
            PrintJob printJob = null;
            File file = Utils.Companion.getTempFile$default(Utils.Companion, "galite", "pdf", false, 4, null);
            this.export(file);
            Document document = this.document;
            if (document == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"document");
                document = null;
            }
            Rectangle rectangle = document.getPageSize();
            Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"document.pageSize");
            Rectangle page = rectangle;
            printJob = new PrintJob(file, true, new Rectangle(page.getWidth(), page.getHeight()));
            printJob.setDataType(1);
            printJob.setTitle(this.getTitle());
            printJob.setNumberOfPages(this.pages);
            return printJob;
        }
        catch (Exception e) {
            throw new InconsistencyException((Throwable)e);
        }
    }

    @Override
    protected void export(@NotNull OutputStream out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        try {
            PPaperType paper = PPaperType.Companion.getPaperTypeFromCode(this.getPrintConfig().getPapertype());
            Rectangle paperSize = Intrinsics.areEqual((Object)this.getPrintConfig().getPaperlayout(), (Object)"Landscape") ? new Rectangle((float)paper.getHeight(), (float)paper.getWidth()) : new Rectangle((float)paper.getWidth(), (float)paper.getHeight());
            this.firstPage = true;
            PdfPTable head = this.createHeader();
            PdfPTable firstPageHead = this.createFirstPageHeader();
            PdfPTable foot = this.createFooter(0, 0);
            if (((CharSequence)this.firstPageHeader).length() > 0) {
                firstPageHead.setTotalWidth(paperSize.getWidth() - (float)this.getPrintConfig().getLeftmargin() - (float)this.getPrintConfig().getRightmargin());
            }
            head.setTotalWidth(paperSize.getWidth() - (float)this.getPrintConfig().getLeftmargin() - (float)this.getPrintConfig().getRightmargin());
            this.document = new Document(paperSize, (float)this.getPrintConfig().getLeftmargin(), (float)this.getPrintConfig().getRightmargin(), (float)this.getPrintConfig().getTopmargin() + head.getTotalHeight() + (float)this.getPrintConfig().getHeadermargin() + firstPageHead.getTotalHeight(), (float)this.getPrintConfig().getBottommargin() + foot.getTotalHeight() + (float)this.getPrintConfig().getFootermargin() + (float)2);
            if (this.getPrintConfig().getReportScale() == 3.0) {
                this.scale = this.getScale(3.0, 12.0, 0.1);
            } else {
                this.scale = this.getPrintConfig().getReportScale();
                this.formatColumns();
            }
            File tempFile = Utils.Companion.getTempFile$default(Utils.Companion, "kopiexport", "pdf", false, 4, null);
            Document document = this.document;
            if (document == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"document");
                document = null;
            }
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(tempFile));
            writer.setPageEvent((PdfPageEvent)new PdfPageEventHelper(this){
                final /* synthetic */ PExport2PDF this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onEndPage(@NotNull PdfWriter writer, @NotNull Document document) {
                    Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                    Intrinsics.checkNotNullParameter((Object)document, (String)"document");
                    try {
                        Rectangle rectangle = document.getPageSize();
                        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"document.pageSize");
                        Rectangle page = rectangle;
                        PdfPTable head = PExport2PDF.access$createHeader(this.this$0);
                        head.setTotalWidth(page.getWidth() - document.leftMargin() - document.rightMargin());
                        head.writeSelectedRows(0, -1, document.leftMargin(), page.getHeight() - document.topMargin() + head.getTotalHeight() + (float)this.this$0.getPrintConfig().getHeadermargin(), writer.getDirectContent());
                    }
                    catch (Exception e) {
                        throw new ExceptionConverter(e);
                    }
                }
            });
            Document document2 = this.document;
            if (document2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"document");
                document2 = null;
            }
            document2.open();
            if (!Intrinsics.areEqual((Object)this.firstPageHeader, (Object)"")) {
                try {
                    Document document3;
                    Document document4 = this.document;
                    if (document4 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"document");
                        document4 = null;
                    }
                    Rectangle page = document4.getPageSize();
                    Document document5 = this.document;
                    if (document5 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"document");
                        document5 = null;
                    }
                    float f = document5.leftMargin();
                    float f2 = page.getHeight();
                    Document document6 = this.document;
                    if (document6 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"document");
                        document6 = null;
                    }
                    firstPageHead.writeSelectedRows(0, -1, f, f2 - document6.topMargin() + head.getTotalHeight() + (float)this.getPrintConfig().getHeadermargin() + firstPageHead.getTotalHeight(), writer.getDirectContent());
                    Document document7 = this.document;
                    if (document7 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"document");
                        document7 = null;
                    }
                    if ((document3 = this.document) == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"document");
                        document3 = null;
                    }
                    float f3 = document3.leftMargin();
                    Document document8 = this.document;
                    if (document8 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"document");
                        document8 = null;
                    }
                    float f4 = document8.rightMargin();
                    Document document9 = this.document;
                    if (document9 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"document");
                        document9 = null;
                    }
                    float f5 = document9.topMargin() - firstPageHead.getTotalHeight();
                    Document document10 = this.document;
                    if (document10 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"document");
                        document10 = null;
                    }
                    document7.setMargins(f3, f4, f5, document10.bottomMargin());
                }
                catch (Exception e) {
                    throw new ExceptionConverter(e);
                }
            }
            this.exportData();
            Document document11 = this.document;
            if (document11 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"document");
                document11 = null;
            }
            document11.add((Element)this.datatable);
            Document document12 = this.document;
            if (document12 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"document");
                document12 = null;
            }
            document12.close();
            this.addFooter(tempFile, out);
        }
        catch (Exception e) {
            throw new InconsistencyException((Throwable)e);
        }
    }

    private final void addFooter(File tempFile, OutputStream out) {
        try {
            PdfReader reader = new PdfReader((InputStream)new FileInputStream(tempFile));
            PdfStamper stamper = new PdfStamper(reader, out);
            Document document = this.document;
            if (document == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"document");
                document = null;
            }
            Rectangle page = document.getPageSize();
            this.pages = reader.getNumberOfPages();
            int n = 1;
            int n2 = this.pages;
            if (n <= n2) {
                int i;
                do {
                    i = n++;
                    PdfPTable foot = this.createFooter(i, this.pages);
                    PdfContentByte cb = stamper.getOverContent(i);
                    float f = page.getWidth();
                    Document document2 = this.document;
                    if (document2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"document");
                        document2 = null;
                    }
                    float f2 = f - document2.leftMargin();
                    Document document3 = this.document;
                    if (document3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"document");
                        document3 = null;
                    }
                    foot.setTotalWidth(f2 - document3.rightMargin());
                    Document document4 = this.document;
                    if (document4 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"document");
                        document4 = null;
                    }
                    foot.writeSelectedRows(0, -1, document4.leftMargin(), (float)this.getPrintConfig().getBottommargin() + foot.getTotalHeight(), cb);
                } while (i != n2);
            }
            stamper.close();
        }
        catch (Exception e) {
            throw new InconsistencyException((Throwable)e);
        }
    }

    private final PdfPTable createFirstPageHeader() {
        PdfPTable head = new PdfPTable(1);
        Color color = Color.black;
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"black");
        Color color2 = color;
        color = Color.white;
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"white");
        head.addCell(this.createCell(this.firstPageHeader, 14.0, color2, color, 1, false));
        return head;
    }

    private final PdfPTable createHeader() {
        PdfPTable head = new PdfPTable(1);
        String text = this.currentSubtitle == null ? this.getTitle() : this.getTitle() + "  " + this.getColumnLabel(0) + " : " + this.currentSubtitle;
        Color color = Color.black;
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"black");
        Color color2 = color;
        color = Color.white;
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"white");
        head.addCell(this.createCell(text, 14.0, color2, color, 1, false));
        this.currentSubtitle = this.nextPageSubtitle;
        return head;
    }

    private final PdfPTable createFooter(int page, int allPages) {
        PdfPTable foot = new PdfPTable(2);
        String string = this.getTitle() + " - " + VlibProperties.getString("print-page") + " " + page + "/" + allPages;
        Color color = Color.black;
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"black");
        Color color2 = color;
        color = Color.white;
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"white");
        foot.addCell(this.createCell(string, 7.0, color2, color, 1, false));
        String string2 = LocalDate.now().format(DateTimeFormatter.ofPattern("dd.MM.yyyy")) + " " + LocalTime.now().format(DateTimeFormatter.ofPattern("HH:mm"));
        color = Color.black;
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"black");
        Color color3 = color;
        color = Color.white;
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"white");
        foot.addCell(this.createCell(string2, 7.0, color3, color, 4, false));
        return foot;
    }

    @Override
    protected void startGroup(@Nullable String subTitle) {
        try {
            if (this.datatable != null) {
                Document document = this.document;
                if (document == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"document");
                    document = null;
                }
                document.add((Element)this.datatable);
            }
            this.currentSubtitle = this.nextPageSubtitle;
            this.nextPageSubtitle = subTitle;
            PdfPTable pdfPTable = this.datatable = new PdfPTable(this.getColumnCount());
            Intrinsics.checkNotNull((Object)pdfPTable);
            pdfPTable.setWidthPercentage(100.0f);
            PdfPTable pdfPTable2 = this.datatable;
            Intrinsics.checkNotNull((Object)pdfPTable2);
            PdfPCell defaultCell = pdfPTable2.getDefaultCell();
            defaultCell.setBorderWidth(1.0f);
            defaultCell.setHorizontalAlignment(0);
            if (!this.firstPage) {
                Document document = this.document;
                if (document == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"document");
                    document = null;
                }
                document.newPage();
            } else {
                int n = 0;
                int n2 = this.widths.length;
                while (n < n2) {
                    int i = n++;
                    float[] fArray = this.widths;
                    float f = fArray[i];
                    PdfPTable pdfPTable3 = this.datatable;
                    Intrinsics.checkNotNull((Object)pdfPTable3);
                    float f2 = pdfPTable3.getDefaultCell().getPaddingLeft() - 1.0f;
                    PdfPTable pdfPTable4 = this.datatable;
                    Intrinsics.checkNotNull((Object)pdfPTable4);
                    fArray[i] = f + (f2 + pdfPTable4.getDefaultCell().getPaddingRight() - 1.0f);
                }
            }
            PdfPTable pdfPTable5 = this.datatable;
            Intrinsics.checkNotNull((Object)pdfPTable5);
            pdfPTable5.setWidths(this.widths);
            this.firstPage = false;
        }
        catch (Exception e) {
            throw new InconsistencyException((Throwable)e);
        }
    }

    @Override
    protected void exportHeader(@NotNull String[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String[] $this$forEach$iv = data;
        boolean $i$f$forEach = false;
        for (String element$iv : $this$forEach$iv) {
            String it = element$iv;
            boolean bl = false;
            PdfPTable pdfPTable = this.datatable;
            Intrinsics.checkNotNull((Object)pdfPTable);
            String string = it;
            Intrinsics.checkNotNull((Object)string);
            Color color = Color.white;
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"white");
            Color color2 = color;
            color = Color.black;
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"black");
            pdfPTable.addCell(this.createCell(string, this.scale, color2, color, 2, true));
        }
        PdfPTable pdfPTable = this.datatable;
        Intrinsics.checkNotNull((Object)pdfPTable);
        pdfPTable.setHeaderRows(1);
    }

    @Override
    protected void exportRow(@NotNull VReportRow row, boolean tail) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        this.exportRow(row, tail, true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void exportRow(int level, @NotNull String[] data, @NotNull Object[] orig, @NotNull int[] alignments) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)orig, (String)"orig");
        Intrinsics.checkNotNullParameter((Object)alignments, (String)"alignments");
        int cell = 0;
        PdfPTable pdfPTable = this.datatable;
        Intrinsics.checkNotNull((Object)pdfPTable);
        pdfPTable.getDefaultCell().setBorderWidth(1.0f);
        PdfPTable pdfPTable2 = this.datatable;
        Intrinsics.checkNotNull((Object)pdfPTable2);
        pdfPTable2.getDefaultCell().setBackgroundColor(Color.white);
        String[] $this$forEachIndexed$iv = data;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        String[] stringArray = $this$forEachIndexed$iv;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            Color color;
            void element;
            String item$iv = stringArray[n];
            ++n;
            int n3 = index$iv;
            index$iv = n3 + 1;
            String string = item$iv;
            int index = n3;
            boolean bl = false;
            if (element != null) {
                PdfPTable pdfPTable3 = this.datatable;
                Intrinsics.checkNotNull((Object)pdfPTable3);
                color = Color.black;
                Intrinsics.checkNotNullExpressionValue((Object)color, (String)"black");
                pdfPTable3.addCell(this.createCell((String)element, this.scale, color, this.getBackgroundForLevel(level), alignments[index], true));
            } else {
                PdfPTable pdfPTable4 = this.datatable;
                Intrinsics.checkNotNull((Object)pdfPTable4);
                color = Color.black;
                Intrinsics.checkNotNullExpressionValue((Object)color, (String)"black");
                pdfPTable4.addCell(this.createCell(" ", this.scale, color, this.getBackgroundForLevel(level), alignments[index], true));
            }
            ++cell;
        }
    }

    private final PdfPCell createCell(String text, double size, Color textColor, Color background, int alignment, boolean border) {
        PdfPCell cell = null;
        Font font = FontFactory.getFont((String)"Helvetica", (float)((float)size), (int)0, (Color)(this.tonerSaveMode() ? Color.black : textColor));
        cell = new PdfPCell((Phrase)new Paragraph(new Chunk(text, font)));
        cell.setBorderWidth(1.0f);
        cell.setPaddingLeft(1.0f);
        cell.setPaddingRight(1.0f);
        cell.setNoWrap(true);
        cell.setUseDescender(true);
        cell.setVerticalAlignment(4);
        switch (alignment) {
            case 0: 
            case 1: {
                cell.setHorizontalAlignment(0);
                break;
            }
            case 2: {
                cell.setHorizontalAlignment(1);
                break;
            }
            case 4: {
                cell.setHorizontalAlignment(2);
                break;
            }
            default: {
                throw new InconsistencyException("Unknown alignment");
            }
        }
        cell.setBackgroundColor(this.tonerSaveMode() ? Color.white : background);
        if (!border) {
            cell.setBorder(0);
        }
        return cell;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final double getScale(double min, double max, double precision) {
        double d;
        int width = 0;
        PPaperType paper = PPaperType.Companion.getPaperTypeFromCode(this.getPrintConfig().getPapertype());
        width = Intrinsics.areEqual((Object)this.getPrintConfig().getPaperlayout(), (Object)"Landscape") ? paper.getHeight() : paper.getWidth();
        this.widthSum = 0.0;
        this.scale = max;
        this.formatColumns();
        double widthSumMax = this.widthSum + (double)(this.getColumnCount() * 2 * 1) + (double)(this.getColumnCount() * 1);
        float f = width;
        Document document = this.document;
        if (document == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"document");
            document = null;
        }
        float f2 = f - document.leftMargin();
        Document document2 = this.document;
        if (document2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"document");
            document2 = null;
        }
        if (widthSumMax <= (double)(f2 - document2.rightMargin()) - (double)2 * this.getPrintConfig().getBorder()) {
            return max;
        }
        if (max - min <= precision) {
            return min;
        }
        this.widthSum = 0.0;
        this.scale = min;
        this.formatColumns();
        double widthSumMin = this.widthSum + (double)(this.getColumnCount() * 2 * 1) + (double)(this.getColumnCount() * 1);
        this.widthSum = 0.0;
        this.scale = min + (max - min) / (double)2;
        this.formatColumns();
        this.widthSum += (double)(this.getColumnCount() * 2 * 1 + this.getColumnCount() * 1);
        float f3 = width;
        Document document3 = this.document;
        if (document3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"document");
            document3 = null;
        }
        float f4 = f3 - document3.leftMargin();
        Document document4 = this.document;
        if (document4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"document");
            document4 = null;
        }
        if (widthSumMin <= (double)(f4 - document4.rightMargin()) - (double)2 * this.getPrintConfig().getBorder()) {
            float f5 = width;
            Document document5 = this.document;
            if (document5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"document");
                document5 = null;
            }
            float f6 = f5 - document5.leftMargin();
            Document document6 = this.document;
            if (document6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"document");
                document6 = null;
            }
            if (this.widthSum >= (double)(f6 - document6.rightMargin()) - (double)2 * this.getPrintConfig().getBorder()) {
                d = this.getScale(min, min + (max - min) / (double)2, precision);
                return d;
            }
        }
        d = this.getScale(max - (max - min) / (double)2, max, precision);
        return d;
    }

    @Override
    public void formatStringColumn$galite_core(@NotNull VReportColumn column2, int index) {
        Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
        this.widths[index] = Math.max(new Chunk(column2.getLabel(), FontFactory.getFont((String)"Helvetica", (float)((float)this.scale))).getWidthPoint(), new Chunk("X", FontFactory.getFont((String)"Helvetica", (float)((float)this.scale))).getWidthPoint() * (float)column2.getWidth());
        this.widthSum += (double)this.widths[index];
    }

    @Override
    public void formatWeekColumn$galite_core(@NotNull VReportColumn column2, int index) {
        Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
        this.widths[index] = Math.max(new Chunk(column2.getLabel(), FontFactory.getFont((String)"Helvetica", (float)((float)this.scale))).getWidthPoint(), new Chunk("00.0000", FontFactory.getFont((String)"Helvetica", (float)((float)this.scale))).getWidthPoint());
        this.widthSum += (double)this.widths[index];
    }

    @Override
    public void formatDateColumn$galite_core(@NotNull VReportColumn column2, int index) {
        Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
        this.widths[index] = Math.max(new Chunk(column2.getLabel(), FontFactory.getFont((String)"Helvetica", (float)((float)this.scale))).getWidthPoint(), new Chunk("00.00.0000", FontFactory.getFont((String)"Helvetica", (float)((float)this.scale))).getWidthPoint());
        this.widthSum += (double)this.widths[index];
    }

    @Override
    public void formatMonthColumn$galite_core(@NotNull VReportColumn column2, int index) {
        Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
        this.widths[index] = (float)4 + Math.max(new Chunk(column2.getLabel(), FontFactory.getFont((String)"Helvetica", (float)((float)this.scale))).getWidthPoint(), new Chunk("00.0000", FontFactory.getFont((String)"Helvetica", (float)((float)this.scale))).getWidthPoint());
        this.widthSum += (double)this.widths[index];
    }

    @Override
    public void formatDecimalColumn$galite_core(@NotNull VReportColumn column2, int index) {
        Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
        this.widths[index] = Math.max(new Chunk(column2.getLabel(), FontFactory.getFont((String)"Helvetica", (float)((float)this.scale))).getWidthPoint(), new Chunk("0", FontFactory.getFont((String)"Helvetica", (float)((float)this.scale))).getWidthPoint() * (float)column2.getWidth());
        this.widthSum += (double)this.widths[index];
    }

    @Override
    public void formatIntegerColumn$galite_core(@NotNull VReportColumn column2, int index) {
        Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
        this.widths[index] = Math.max(new Chunk(column2.getLabel(), FontFactory.getFont((String)"Helvetica", (float)((float)this.scale))).getWidthPoint(), new Chunk("0", FontFactory.getFont((String)"Helvetica", (float)((float)this.scale))).getWidthPoint() * (float)column2.getWidth());
        this.widthSum += (double)this.widths[index];
    }

    @Override
    public void formatBooleanColumn$galite_core(@NotNull VReportColumn column2, int index) {
        Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
        this.widths[index] = Math.max(new Chunk(column2.getLabel(), FontFactory.getFont((String)"Helvetica", (float)((float)this.scale))).getWidthPoint(), new Chunk("false", FontFactory.getFont((String)"Helvetica", (float)((float)this.scale))).getWidthPoint());
        this.widthSum += (double)this.widths[index];
    }

    @Override
    public void formatTimeColumn$galite_core(@NotNull VReportColumn column2, int index) {
        Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
        this.widths[index] = Math.max(new Chunk(column2.getLabel(), FontFactory.getFont((String)"Helvetica", (float)((float)this.scale))).getWidthPoint(), new Chunk("00:00", FontFactory.getFont((String)"Helvetica", (float)((float)this.scale))).getWidthPoint());
        this.widthSum += (double)this.widths[index];
    }

    @Override
    public void formatTimestampColumn$galite_core(@NotNull VReportColumn column2, int index) {
        Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
        this.widths[index] = Math.max(new Chunk(column2.getLabel(), FontFactory.getFont((String)"Helvetica", (float)((float)this.scale))).getWidthPoint(), new Chunk("00.00.0000 00:00.0000", FontFactory.getFont((String)"Helvetica", (float)((float)this.scale))).getWidthPoint());
        this.widthSum += (double)this.widths[index];
    }

    public static final /* synthetic */ PdfPTable access$createHeader(PExport2PDF $this) {
        return $this.createHeader();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/kopi/galite/visual/report/PExport2PDF$Companion;", "", "()V", "BORDER_PADDING", "", "BORDER_WIDTH", "galite-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

