/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.report;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.type.DefaultFormatKt;
import org.kopi.galite.util.base.InconsistencyException;
import org.kopi.galite.visual.form.VDecimalField;
import org.kopi.galite.visual.report.PExport;
import org.kopi.galite.visual.report.VCalculateColumn;
import org.kopi.galite.visual.report.VCellFormat;
import org.kopi.galite.visual.report.VReportColumn;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001%BK\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0005H\u0016J\b\u0010 \u001a\u00020!H\u0016J\u000e\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u0005J\u000e\u0010$\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u0005R\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006&"}, d2={"Lorg/kopi/galite/visual/report/VDecimalColumn;", "Lorg/kopi/galite/visual/report/VReportColumn;", "ident", "", "options", "", "align", "groups", "function", "Lorg/kopi/galite/visual/report/VCalculateColumn;", "digits", "maxScale", "format", "Lorg/kopi/galite/visual/report/VCellFormat;", "(Ljava/lang/String;IIILorg/kopi/galite/visual/report/VCalculateColumn;IILorg/kopi/galite/visual/report/VCellFormat;)V", "formula", "getFormula", "()Ljava/lang/String;", "setFormula", "(Ljava/lang/String;)V", "<set-?>", "getMaxScale", "()I", "compareTo", "object1", "", "object2", "formatColumn", "", "exporter", "Lorg/kopi/galite/visual/report/PExport;", "index", "getPrintedWidth", "", "setDisplayScale", "scale", "setMaxScale", "VFixedFormat", "galite-core"})
public final class VDecimalColumn
extends VReportColumn {
    @Nullable
    private String formula;
    private int maxScale;

    public VDecimalColumn(@Nullable String ident, int options, int align, int groups, @Nullable VCalculateColumn function, int digits, int maxScale, @Nullable VCellFormat format2) {
        int n = VDecimalField.Companion.computeWidth(digits, maxScale, null, null);
        VCellFormat vCellFormat = format2;
        if (vCellFormat == null) {
            vCellFormat = new VFixedFormat(maxScale, true);
        }
        super(ident, options, align, groups, function, n, 1, vCellFormat);
        this.maxScale = maxScale;
    }

    @Nullable
    public final String getFormula() {
        return this.formula;
    }

    public final void setFormula(@Nullable String string) {
        this.formula = string;
    }

    public final int getMaxScale() {
        return this.maxScale;
    }

    @Override
    public int compareTo(@NotNull Object object1, @NotNull Object object2) {
        Intrinsics.checkNotNullParameter((Object)object1, (String)"object1");
        Intrinsics.checkNotNullParameter((Object)object2, (String)"object2");
        return ((BigDecimal)object1).compareTo((BigDecimal)object2);
    }

    @Override
    public double getPrintedWidth() {
        return (double)this.getWidth() * 0.7;
    }

    @Override
    public void formatColumn(@NotNull PExport exporter, int index) {
        Intrinsics.checkNotNullParameter((Object)exporter, (String)"exporter");
        exporter.formatDecimalColumn$galite_core(this, index);
    }

    public final void setDisplayScale(int scale) {
        this.setFormat(new VFixedFormat(scale, true));
        this.maxScale = scale;
    }

    public final void setMaxScale(int scale) {
        this.setFormat(new VFixedFormat(scale, false));
        this.maxScale = scale;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/kopi/galite/visual/report/VDecimalColumn$VFixedFormat;", "Lorg/kopi/galite/visual/report/VCellFormat;", "maxScale", "", "exactScale", "", "(IZ)V", "format", "", "value", "", "galite-core"})
    private static final class VFixedFormat
    extends VCellFormat {
        private final int maxScale;
        private final boolean exactScale;

        public VFixedFormat(int maxScale, boolean exactScale) {
            this.maxScale = maxScale;
            this.exactScale = exactScale;
        }

        @Override
        @NotNull
        public String format(@Nullable Object value) {
            String string;
            Object object = value;
            if (object == null) {
                string = "";
            } else if (object instanceof Integer) {
                string = String.valueOf(((Number)value).intValue());
            } else if (object instanceof BigDecimal) {
                if (((BigDecimal)value).scale() > this.maxScale || this.exactScale) {
                    BigDecimal bigDecimal = ((BigDecimal)value).setScale(this.maxScale, RoundingMode.HALF_UP);
                    Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"value).setScale(maxScale\u2026ath.RoundingMode.HALF_UP)");
                    string = DefaultFormatKt.format((BigDecimal)bigDecimal);
                } else {
                    string = DefaultFormatKt.format((BigDecimal)((BigDecimal)value));
                }
            } else {
                throw new InconsistencyException("bad type for " + value);
            }
            return string;
        }
    }
}

