/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.report.triggers;

import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.dsl.report.ReportField;
import org.kopi.galite.visual.report.VBaseRow;
import org.kopi.galite.visual.report.VCCDepthFirstCircuitN;
import org.kopi.galite.visual.report.VCalculateColumn;
import org.kopi.galite.visual.report.VGroupRow;
import org.kopi.galite.visual.report.VReportRow;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000f\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\u001a\u0010\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u0002\u001a$\u0010\u0004\u001a\u00020\u0001\"\u0012\b\u0000\u0010\u0005*\b\u0012\u0004\u0012\u0002H\u00050\u0006*\u00020\u0007*\b\u0012\u0004\u0012\u0002H\u00050\u0002\u001a\u0010\u0010\b\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\t0\u0002\u001a\u000e\u0010\n\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u0002\u001a$\u0010\u000b\u001a\u00020\u0001\"\u0012\b\u0000\u0010\u0005*\b\u0012\u0004\u0012\u0002H\u00050\u0006*\u00020\u0007*\b\u0012\u0004\u0012\u0002H\u00050\u0002\u001a\u0010\u0010\f\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u0002\u001a\u0010\u0010\r\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\t0\u0002\u001a\u0010\u0010\u000e\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u0002\u001a$\u0010\u000f\u001a\u00020\u0001\"\u0012\b\u0000\u0010\u0005*\b\u0012\u0004\u0012\u0002H\u00050\u0006*\u00020\u0007*\b\u0012\u0004\u0012\u0002H\u00050\u0002\u00a8\u0006\u0010"}, d2={"avgDecimal", "Lorg/kopi/galite/visual/report/VCalculateColumn;", "Lorg/kopi/galite/visual/dsl/report/ReportField;", "Ljava/math/BigDecimal;", "avgInteger", "T", "", "", "countInteger", "", "reportIdenticalValue", "serialInteger", "sumDecimal", "sumInteger", "sumNullDecimal", "sumNullInteger", "galite-core"})
public final class TriggersKt {
    @NotNull
    public static final VCalculateColumn sumInteger(@NotNull ReportField<Integer> $this$sumInteger) {
        Intrinsics.checkNotNullParameter($this$sumInteger, (String)"<this>");
        return new VCCDepthFirstCircuitN(){

            @NotNull
            public Object evalNode(@NotNull VReportRow row, int column2) {
                Intrinsics.checkNotNullParameter((Object)row, (String)"row");
                int childCount = row.getChildCount();
                int result = 0;
                int n = 0;
                while (n < childCount) {
                    int i = n++;
                    TreeNode treeNode = row.getChildAt(i);
                    if (treeNode == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.kopi.galite.visual.report.VReportRow");
                    }
                    VReportRow child = (VReportRow)treeNode;
                    Integer value = (Integer)child.getValueAt(column2);
                    if (value == null) continue;
                    result += value.intValue();
                }
                return result;
            }
        };
    }

    @NotNull
    public static final VCalculateColumn countInteger(@NotNull ReportField<Integer> $this$countInteger) {
        Intrinsics.checkNotNullParameter($this$countInteger, (String)"<this>");
        return new VCCDepthFirstCircuitN(){

            @NotNull
            public Object evalNode(@NotNull VReportRow row, int column2) {
                int n;
                Intrinsics.checkNotNullParameter((Object)row, (String)"row");
                int childCount = row.getChildCount();
                if (row.getLevel() > 1) {
                    int result = 0;
                    int n2 = 0;
                    while (n2 < childCount) {
                        int i = n2++;
                        TreeNode treeNode = row.getChildAt(i);
                        if (treeNode == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.kopi.galite.visual.report.VReportRow");
                        }
                        VReportRow child = (VReportRow)treeNode;
                        Integer value = (Integer)child.getValueAt(column2);
                        if (value == null) continue;
                        result += value.intValue();
                    }
                    n = result;
                } else {
                    n = childCount;
                }
                return n;
            }
        };
    }

    @NotNull
    public static final VCalculateColumn sumDecimal(@NotNull ReportField<BigDecimal> $this$sumDecimal) {
        Intrinsics.checkNotNullParameter($this$sumDecimal, (String)"<this>");
        return new VCCDepthFirstCircuitN(){

            @NotNull
            public Object evalNode(@NotNull VReportRow row, int column2) {
                Intrinsics.checkNotNullParameter((Object)row, (String)"row");
                int childCount = row.getChildCount();
                BigDecimal result = BigDecimal.valueOf(0L, 2);
                int n = 0;
                while (n < childCount) {
                    int i = n++;
                    TreeNode treeNode = row.getChildAt(i);
                    if (treeNode == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.kopi.galite.visual.report.VReportRow");
                    }
                    VReportRow child = (VReportRow)treeNode;
                    Object object = child.getValueAt(column2);
                    BigDecimal value = object instanceof BigDecimal ? (BigDecimal)object : null;
                    if (value == null) continue;
                    object = result;
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"result");
                    BigDecimal bigDecimal = ((BigDecimal)object).add(value);
                    Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"this.add(other)");
                    result = bigDecimal;
                }
                BigDecimal bigDecimal = result;
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"result");
                return bigDecimal;
            }
        };
    }

    @NotNull
    public static final <T extends Number> VCalculateColumn sumNullInteger(@NotNull ReportField<T> $this$sumNullInteger) {
        Intrinsics.checkNotNullParameter($this$sumNullInteger, (String)"<this>");
        return new VCCDepthFirstCircuitN(){

            @Nullable
            public Object evalNode(@NotNull VReportRow row, int column2) {
                Intrinsics.checkNotNullParameter((Object)row, (String)"row");
                int childCount = row.getChildCount();
                int result = 0;
                boolean valueFound = false;
                int n = 0;
                while (n < childCount) {
                    int i = n++;
                    TreeNode treeNode = row.getChildAt(i);
                    if (treeNode == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.kopi.galite.visual.report.VReportRow");
                    }
                    VReportRow child = (VReportRow)treeNode;
                    Integer value = (Integer)child.getValueAt(column2);
                    if (value == null) continue;
                    valueFound = true;
                    result += value.intValue();
                }
                return valueFound ? Integer.valueOf(result) : null;
            }
        };
    }

    @NotNull
    public static final VCalculateColumn sumNullDecimal(@NotNull ReportField<BigDecimal> $this$sumNullDecimal) {
        Intrinsics.checkNotNullParameter($this$sumNullDecimal, (String)"<this>");
        return new VCCDepthFirstCircuitN(){

            @Nullable
            public Object evalNode(@NotNull VReportRow row, int column2) {
                Intrinsics.checkNotNullParameter((Object)row, (String)"row");
                int childCount = row.getChildCount();
                boolean valueFound = false;
                BigDecimal result = BigDecimal.valueOf(0L, 2);
                int n = 0;
                while (n < childCount) {
                    int i = n++;
                    TreeNode treeNode = row.getChildAt(i);
                    if (treeNode == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.kopi.galite.visual.report.VReportRow");
                    }
                    VReportRow child = (VReportRow)treeNode;
                    Object object = child.getValueAt(column2);
                    BigDecimal value = object instanceof BigDecimal ? (BigDecimal)object : null;
                    if (value == null) continue;
                    valueFound = true;
                    object = result;
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"result");
                    BigDecimal bigDecimal = ((BigDecimal)object).add(value);
                    Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"this.add(other)");
                    result = bigDecimal;
                }
                return valueFound ? result : null;
            }
        };
    }

    @NotNull
    public static final VCalculateColumn reportIdenticalValue(@NotNull ReportField<?> $this$reportIdenticalValue) {
        Intrinsics.checkNotNullParameter($this$reportIdenticalValue, (String)"<this>");
        return new VCCDepthFirstCircuitN(){

            @Nullable
            public Object evalNode(@NotNull VReportRow row, int column2) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)row, (String)"row");
                int childCount = row.getChildCount();
                TreeNode treeNode = row.getChildAt(0);
                if (treeNode == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.kopi.galite.visual.report.VReportRow");
                }
                Object value = ((VReportRow)treeNode).getValueAt(column2);
                if (value == null) {
                    object = null;
                } else {
                    int n = 1;
                    while (n < childCount) {
                        int i = n++;
                        TreeNode treeNode2 = row.getChildAt(i);
                        if (treeNode2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.kopi.galite.visual.report.VReportRow");
                        }
                        VReportRow child = (VReportRow)treeNode2;
                        if (Intrinsics.areEqual((Object)value, (Object)child.getValueAt(column2))) continue;
                        return null;
                    }
                    object = value;
                }
                return object;
            }
        };
    }

    @NotNull
    public static final <T extends Number> VCalculateColumn avgInteger(@NotNull ReportField<T> $this$avgInteger) {
        Intrinsics.checkNotNullParameter($this$avgInteger, (String)"<this>");
        return new VCCDepthFirstCircuitN(){

            @NotNull
            public Object evalNode(@NotNull VReportRow row, int column2) {
                Intrinsics.checkNotNullParameter((Object)row, (String)"row");
                int childCount = row.getChildCount();
                int result = 0;
                int n = 0;
                while (n < childCount) {
                    int i = n++;
                    TreeNode treeNode = row.getChildAt(i);
                    if (treeNode == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.kopi.galite.visual.report.VReportRow");
                    }
                    VReportRow child = (VReportRow)treeNode;
                    Integer value = (Integer)child.getValueAt(column2);
                    if (value == null) continue;
                    result += value.intValue();
                }
                return result / childCount;
            }
        };
    }

    @NotNull
    public static final <T extends Number> VCalculateColumn serialInteger(@NotNull ReportField<T> $this$serialInteger) {
        Intrinsics.checkNotNullParameter($this$serialInteger, (String)"<this>");
        return new VCCDepthFirstCircuitN(){

            @NotNull
            public Object evalNode(@NotNull VReportRow row, int column2) {
                int n;
                Intrinsics.checkNotNullParameter((Object)row, (String)"row");
                int childCount = row.getChildCount();
                if (row.getLevel() > 1) {
                    int result = 0;
                    int n2 = 0;
                    while (n2 < childCount) {
                        int i = n2++;
                        TreeNode treeNode = row.getChildAt(i);
                        if (treeNode == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.kopi.galite.visual.report.VReportRow");
                        }
                        VReportRow child = (VReportRow)treeNode;
                        Integer value = (Integer)child.getValueAt(column2);
                        if (value == null) continue;
                        result += value.intValue();
                    }
                    n = result;
                } else {
                    n = childCount;
                }
                return n;
            }

            public void calculate(@NotNull VGroupRow tree, int column2) {
                Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
                if (tree.getLevel() > 1) {
                    int childCount = tree.getChildCount();
                    int n = 0;
                    while (n < childCount) {
                        int i = n++;
                        TreeNode treeNode = tree.getChildAt(i);
                        if (treeNode == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.kopi.galite.visual.report.VGroupRow");
                        }
                        this.calculate((VGroupRow)treeNode, column2);
                    }
                } else {
                    int childCount = tree.getChildCount();
                    int n = 0;
                    while (n < childCount) {
                        int i = n++;
                        TreeNode treeNode = tree.getChildAt(i);
                        if (treeNode == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.kopi.galite.visual.report.VBaseRow");
                        }
                        ((VBaseRow)treeNode).setValueAt(column2, i + 1);
                    }
                }
                tree.setValueAt(column2, this.evalNode(tree, column2));
            }
        };
    }

    @NotNull
    public static final VCalculateColumn avgDecimal(@NotNull ReportField<BigDecimal> $this$avgDecimal) {
        Intrinsics.checkNotNullParameter($this$avgDecimal, (String)"<this>");
        return new VCCDepthFirstCircuitN(){

            @NotNull
            public Object evalNode(@NotNull VReportRow row, int column2) {
                BigDecimal bigDecimal;
                Object object;
                Intrinsics.checkNotNullParameter((Object)row, (String)"row");
                int leafCount = row.getLeafCount();
                double notNullLeafCount = 0.0;
                BigDecimal result = BigDecimal.valueOf(0L, 2);
                DefaultMutableTreeNode defaultMutableTreeNode = row.getFirstLeaf();
                VReportRow leaf = defaultMutableTreeNode instanceof VReportRow ? (VReportRow)defaultMutableTreeNode : null;
                int n = 0;
                while (n < leafCount) {
                    BigDecimal value;
                    int i = n++;
                    VReportRow vReportRow = leaf;
                    Intrinsics.checkNotNull((Object)vReportRow);
                    object = vReportRow.getValueAt(column2);
                    BigDecimal bigDecimal2 = value = object instanceof BigDecimal ? (BigDecimal)object : null;
                    if (value != null) {
                        object = result;
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"result");
                        BigDecimal bigDecimal3 = ((BigDecimal)object).add(value);
                        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"this.add(other)");
                        result = bigDecimal3;
                        double d = notNullLeafCount;
                        notNullLeafCount = d + 1.0;
                    }
                    leaf = (object = leaf.getNextLeaf()) instanceof VReportRow ? (VReportRow)object : null;
                }
                if (!(notNullLeafCount == 0.0)) {
                    BigDecimal bigDecimal4 = result;
                    Intrinsics.checkNotNullExpressionValue((Object)bigDecimal4, (String)"result");
                    BigDecimal bigDecimal5 = new BigDecimal(notNullLeafCount);
                    object = bigDecimal4.divide(bigDecimal5, RoundingMode.HALF_EVEN);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this.divide(other, RoundingMode.HALF_EVEN)");
                    bigDecimal = ((BigDecimal)object).setScale(2);
                } else {
                    bigDecimal = BigDecimal.valueOf(0L, 2);
                }
                BigDecimal bigDecimal6 = bigDecimal;
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal6, (String)"if (notNullLeafCount != \u2026mal.valueOf(0, 2)\n      }");
                return bigDecimal6;
            }
        };
    }
}

