/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.ui.vaadin.base;

import com.flowingcode.vaadin.addons.ironicons.AvIcons;
import com.flowingcode.vaadin.addons.ironicons.DeviceIcons;
import com.flowingcode.vaadin.addons.ironicons.EditorIcons;
import com.flowingcode.vaadin.addons.ironicons.FileIcons;
import com.flowingcode.vaadin.addons.ironicons.IronIcons;
import com.flowingcode.vaadin.addons.ironicons.MapsIcons;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.server.Command;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.VColor;
import org.kopi.galite.visual.ui.vaadin.base.BackgroundThreadHandler;
import org.kopi.galite.visual.ui.vaadin.base.Image;
import org.kopi.galite.visual.ui.vaadin.main.MainWindow;
import org.kopi.galite.visual.ui.vaadin.window.PopupWindow;
import org.kopi.galite.visual.ui.vaadin.window.Window;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0011\u001a\u00020\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u0004J\u001a\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00102\b\u0010\u0016\u001a\u0004\u0018\u00010\u0010J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0018\u001a\u00020\u0004J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001d\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0018\u001a\u00020\u0004J\u000e\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\u0004J\u0018\u0010 \u001a\u0004\u0018\u00010\b2\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0004J\u0010\u0010#\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0004H\u0002J\u0010\u0010$\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0018\u001a\u00020\u0004J\u0018\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020*J\u0018\u0010+\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020*J\u0012\u0010,\u001a\u0004\u0018\u00010\u00102\b\u0010-\u001a\u0004\u0018\u00010\u0004J\u001a\u0010.\u001a\u0004\u0018\u00010\u00042\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020*J\u0010\u0010/\u001a\u00020\u00042\b\u00100\u001a\u0004\u0018\u000101J\f\u00102\u001a\u0004\u0018\u000103*\u000204J\f\u00105\u001a\u0004\u0018\u000106*\u00020\u001cR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/base/Utils;", "Lorg/kopi/galite/visual/base/Utils;", "()V", "APPLICATION_DIR", "", "RESOURCE_DIR", "THEME_DIR", "UKN_IMAGE", "Lorg/kopi/galite/visual/ui/vaadin/base/Image;", "getUKN_IMAGE", "()Lorg/kopi/galite/visual/ui/vaadin/base/Image;", "VAADIN_RESOURCE_DIR", "cache", "Ljava/util/Hashtable;", "pngToIconMap", "", "", "createTooltip", "content", "equals", "", "o1", "o2", "getApplicationImage", "img", "getCursorPos", "", "field", "Lcom/vaadin/flow/component/Component;", "getDefaultImage", "getImage", "image", "getImageFromResource", "directory", "name", "getImageImpl", "getKopiResourceImage", "getOffsetLeft", "", "element", "Lcom/vaadin/flow/dom/Element;", "ui", "Lcom/vaadin/flow/component/UI;", "getOffsetWidth", "getVaadinIcon", "iconName", "getWidth", "toString", "color", "Lorg/kopi/galite/visual/VColor;", "findDialog", "Lorg/kopi/galite/visual/ui/vaadin/window/PopupWindow;", "Lorg/kopi/galite/visual/ui/vaadin/window/Window;", "findMainWindow", "Lorg/kopi/galite/visual/ui/vaadin/main/MainWindow;", "galite-core"})
public final class Utils
extends org.kopi.galite.visual.base.Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();
    @NotNull
    private static final String VAADIN_RESOURCE_DIR = "ui/vaadin";
    @NotNull
    private static final String THEME_DIR = "resource";
    @NotNull
    private static final String APPLICATION_DIR = "resources";
    @NotNull
    private static final String RESOURCE_DIR = "org/kopi/galite/visual";
    @NotNull
    private static final Image UKN_IMAGE = new Image("resource/unknown.png");
    @NotNull
    private static final Hashtable<String, Image> cache = new Hashtable();
    @NotNull
    private static Map<String, Object> pngToIconMap = new LinkedHashMap();

    private Utils() {
    }

    @NotNull
    public final Image getImage(@NotNull String image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Image img = cache.get(image);
        if (img == null) {
            img = this.getImageImpl(image);
            ((Map)cache).put(image, img);
        }
        return img;
    }

    private final Image getImageImpl(String img) {
        Image icon = this.getDefaultImage(img);
        if (icon == null) {
            icon = this.getKopiResourceImage(img);
        }
        if (icon == null) {
            icon = this.getApplicationImage(img);
        }
        if (icon == null) {
            System.err.println("Utils ==> cant load: " + img);
            return UKN_IMAGE;
        }
        return icon;
    }

    @Nullable
    public final Image getDefaultImage(@NotNull String img) {
        Intrinsics.checkNotNullParameter((Object)img, (String)"img");
        return this.getImageFromResource(VAADIN_RESOURCE_DIR, img);
    }

    @Nullable
    public final Image getApplicationImage(@NotNull String img) {
        Intrinsics.checkNotNullParameter((Object)img, (String)"img");
        return this.getImageFromResource(APPLICATION_DIR, img);
    }

    @Nullable
    public final Image getKopiResourceImage(@NotNull String img) {
        Intrinsics.checkNotNullParameter((Object)img, (String)"img");
        return this.getImageFromResource(RESOURCE_DIR, img);
    }

    @Nullable
    public final Image getImageFromResource(@NotNull String directory, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (org.kopi.galite.visual.base.Utils.class.getClassLoader().getResource("META-INF/resources/" + directory + "/" + name) != null) {
            return new Image(directory + "/" + name);
        }
        return null;
    }

    @NotNull
    public final String toString(@Nullable VColor color) {
        return color == null ? "" : "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
    }

    @NotNull
    public final String createTooltip(@Nullable String content) {
        String string = content;
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Nullable
    public final Object getVaadinIcon(@Nullable String iconName) {
        return pngToIconMap.get(iconName);
    }

    public final boolean equals(@Nullable Object o1, @Nullable Object o2) {
        return o1 == null ? o2 == null : (o2 == null ? false : Intrinsics.areEqual((Object)o1, (Object)o2));
    }

    public final double getOffsetLeft(@Nullable Element element, @NotNull UI ui) {
        Intrinsics.checkNotNullParameter((Object)ui, (String)"ui");
        CompletableFuture<Double> future = new CompletableFuture<Double>();
        ui.access(new Command(ui, element, future){
            final /* synthetic */ UI $ui;
            final /* synthetic */ Element $element;
            final /* synthetic */ CompletableFuture<Double> $future;
            {
                this.$ui = $ui;
                this.$element = $element;
                this.$future = $future;
            }

            public final void execute() {
                Serializable[] serializableArray = new Serializable[]{(Serializable)this.$element};
                this.$ui.getPage().executeJs("return $0.offsetLeft", serializableArray).then(Double.TYPE, new SerializableConsumer(this.$future){
                    final /* synthetic */ CompletableFuture<Double> $future;
                    {
                        this.$future = $future;
                    }

                    public final void accept(double value) {
                        this.$future.complete(value);
                    }
                });
                this.$ui.push();
            }
        });
        Double d = future.get();
        Intrinsics.checkNotNullExpressionValue((Object)d, (String)"future.get()");
        return ((Number)d).doubleValue();
    }

    public final double getOffsetWidth(@Nullable Element element, @NotNull UI ui) {
        Intrinsics.checkNotNullParameter((Object)ui, (String)"ui");
        CompletableFuture<Double> future = new CompletableFuture<Double>();
        ui.access(new Command(ui, element, future){
            final /* synthetic */ UI $ui;
            final /* synthetic */ Element $element;
            final /* synthetic */ CompletableFuture<Double> $future;
            {
                this.$ui = $ui;
                this.$element = $element;
                this.$future = $future;
            }

            public final void execute() {
                Serializable[] serializableArray = new Serializable[]{(Serializable)this.$element};
                this.$ui.getPage().executeJs("return $0.offsetWidth", serializableArray).then(Double.TYPE, new SerializableConsumer(this.$future){
                    final /* synthetic */ CompletableFuture<Double> $future;
                    {
                        this.$future = $future;
                    }

                    public final void accept(double value) {
                        this.$future.complete(value);
                    }
                });
                this.$ui.push();
            }
        });
        Double d = future.get();
        Intrinsics.checkNotNullExpressionValue((Object)d, (String)"future.get()");
        return ((Number)d).doubleValue();
    }

    @Nullable
    public final String getWidth(@Nullable Element element, @NotNull UI ui) {
        Intrinsics.checkNotNullParameter((Object)ui, (String)"ui");
        CompletableFuture<String> future = new CompletableFuture<String>();
        ui.access(new Command(ui, element, future){
            final /* synthetic */ UI $ui;
            final /* synthetic */ Element $element;
            final /* synthetic */ CompletableFuture<String> $future;
            {
                this.$ui = $ui;
                this.$element = $element;
                this.$future = $future;
            }

            public final void execute() {
                Serializable[] serializableArray = new Serializable[]{(Serializable)this.$element};
                this.$ui.getPage().executeJs("return $0.width", serializableArray).then(String.class, new SerializableConsumer(this.$future){
                    final /* synthetic */ CompletableFuture<String> $future;
                    {
                        this.$future = $future;
                    }

                    public final void accept(String value) {
                        this.$future.complete(value);
                    }
                });
                this.$ui.push();
            }
        });
        return future.get();
    }

    public final int getCursorPos(@NotNull Component field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        BackgroundThreadHandler.accessAndPush$default(BackgroundThreadHandler.INSTANCE, null, (Function0)new Function0<Unit>(field, future){
            final /* synthetic */ Component $field;
            final /* synthetic */ CompletableFuture<Integer> $future;
            {
                this.$field = $field;
                this.$future = $future;
                super(0);
            }

            public final void invoke() {
                Serializable[] serializableArray = new Serializable[]{(Serializable)this.$field.getElement()};
                UI.getCurrent().getPage().executeJs("return $0.shadowRoot.querySelector('[part=\"value\"]').selectionStart;", serializableArray).then(Integer.TYPE, new SerializableConsumer(this.$future){
                    final /* synthetic */ CompletableFuture<Integer> $future;
                    {
                        this.$future = $future;
                    }

                    public final void accept(int value) {
                        this.$future.complete(value);
                    }
                });
            }
        }, 1, null);
        Integer n = future.get();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"future.get()");
        return ((Number)n).intValue();
    }

    @Nullable
    public final MainWindow findMainWindow(@NotNull Component $this$findMainWindow) {
        Intrinsics.checkNotNullParameter((Object)$this$findMainWindow, (String)"<this>");
        if ($this$findMainWindow instanceof MainWindow) {
            return (MainWindow)$this$findMainWindow;
        }
        MainWindow mainWindow = null;
        Component parent = $this$findMainWindow.getParent().orElse(null);
        while (parent != null && mainWindow == null) {
            if (parent instanceof MainWindow) {
                mainWindow = (MainWindow)parent;
            }
            parent = parent.getParent().orElse(null);
        }
        return mainWindow;
    }

    @Nullable
    public final PopupWindow findDialog(@NotNull Window $this$findDialog) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$findDialog), (String)"<this>");
        PopupWindow mainWindow = null;
        Component parent = $this$findDialog.getParent().orElse(null);
        while (parent != null && mainWindow == null) {
            if (parent instanceof PopupWindow) {
                mainWindow = (PopupWindow)parent;
            }
            parent = parent.getParent().orElse(null);
        }
        return mainWindow;
    }

    @NotNull
    public final Image getUKN_IMAGE() {
        return UKN_IMAGE;
    }

    static {
        pngToIconMap.put("all", VaadinIcon.HAND);
        pngToIconMap.put("block", VaadinIcon.BAN);
        pngToIconMap.put("border", VaadinIcon.COG);
        pngToIconMap.put("bread_crumb_separator", VaadinIcon.ANGLE_DOUBLE_RIGHT);
        pngToIconMap.put("break", VaadinIcon.CLOSE_CIRCLE);
        pngToIconMap.put("calendar", VaadinIcon.CALENDAR_O);
        pngToIconMap.put("collapsed", VaadinIcon.FOLDER_O);
        pngToIconMap.put("collapsed_p", VaadinIcon.FOLDER_O);
        pngToIconMap.put("copy", VaadinIcon.COPY);
        pngToIconMap.put("delete", VaadinIcon.TRASH);
        pngToIconMap.put("desk", VaadinIcon.DESKTOP);
        pngToIconMap.put("detail", VaadinIcon.SEARCH_PLUS);
        pngToIconMap.put("detail_view", VaadinIcon.SEARCH);
        pngToIconMap.put("down", VaadinIcon.ANGLE_DOUBLE_DOWN);
        pngToIconMap.put("duke", VaadinIcon.LOCK);
        pngToIconMap.put("edit", VaadinIcon.EDIT);
        pngToIconMap.put("expanded_a", VaadinIcon.FOLDER_OPEN_O);
        pngToIconMap.put("expanded", VaadinIcon.FOLDER_OPEN_O);
        pngToIconMap.put("expanded_p", VaadinIcon.FOLDER_OPEN_O);
        pngToIconMap.put("exportCsv", VaadinIcon.FILE_TEXT_O);
        pngToIconMap.put("exportPdf", FileIcons.PDF);
        pngToIconMap.put("exportXlsx", FileIcons.EXCEL);
        pngToIconMap.put("foldColumn", VaadinIcon.FOLDER_O);
        pngToIconMap.put("fold", VaadinIcon.FOLDER_O);
        pngToIconMap.put("formula", VaadinIcon.CALC);
        pngToIconMap.put("help", VaadinIcon.QUESTION_CIRCLE_O);
        pngToIconMap.put("home", VaadinIcon.HOME);
        pngToIconMap.put("insertline", VaadinIcon.LIST_OL);
        pngToIconMap.put("insert", VaadinIcon.INSERT);
        pngToIconMap.put("list", VaadinIcon.LIST);
        pngToIconMap.put("loading", VaadinIcon.SPINNER);
        pngToIconMap.put("login_img", VaadinIcon.COFFEE);
        pngToIconMap.put("mail", VaadinIcon.ENVELOPE_O);
        pngToIconMap.put("menuquery", VaadinIcon.FILE_TEXT_O);
        pngToIconMap.put("note", VaadinIcon.NOTEBOOK);
        pngToIconMap.put("nothing", VaadinIcon.FILE_O);
        pngToIconMap.put("open", VaadinIcon.FILE_TEXT_O);
        pngToIconMap.put("options", VaadinIcon.COG);
        pngToIconMap.put("preview", VaadinIcon.FILE_TEXT_O);
        pngToIconMap.put("print", VaadinIcon.PRINT);
        pngToIconMap.put("quit", VaadinIcon.POWER_OFF);
        pngToIconMap.put("save", IronIcons.SAVE);
        pngToIconMap.put("searchop", VaadinIcon.SEARCH);
        pngToIconMap.put("search", VaadinIcon.FILE_SEARCH);
        pngToIconMap.put("serialquery", VaadinIcon.RECORDS);
        pngToIconMap.put("serviceoff", DeviceIcons.SIGNAL_CELLULAR_OFF);
        pngToIconMap.put("serviceon", DeviceIcons.SIGNAL_CELLULAR_4_BAR);
        pngToIconMap.put("store", VaadinIcon.BUILDING_O);
        pngToIconMap.put("suggest", VaadinIcon.PHONE);
        pngToIconMap.put("timeStamp", VaadinIcon.CLOCK);
        pngToIconMap.put("tri", VaadinIcon.SORT);
        pngToIconMap.put("unfoldColumn", VaadinIcon.FOLDER_OPEN_O);
        pngToIconMap.put("unfold", VaadinIcon.FOLDER_OPEN_O);
        pngToIconMap.put("up", VaadinIcon.ANGLE_DOUBLE_UP);
        pngToIconMap.put("add", VaadinIcon.FILE_ADD);
        pngToIconMap.put("align_center", VaadinIcon.ALIGN_CENTER);
        pngToIconMap.put("align_justify", VaadinIcon.ALIGN_JUSTIFY);
        pngToIconMap.put("align_left", VaadinIcon.ALIGN_LEFT);
        pngToIconMap.put("align_right", VaadinIcon.ALIGN_RIGHT);
        pngToIconMap.put("apply", VaadinIcon.COGS);
        pngToIconMap.put("area_chart", VaadinIcon.SPLINE_AREA_CHART);
        pngToIconMap.put("arrowfirst", VaadinIcon.STEP_BACKWARD);
        pngToIconMap.put("arrowlast", VaadinIcon.STEP_FORWARD);
        pngToIconMap.put("arrowleft", VaadinIcon.BACKWARDS);
        pngToIconMap.put("arrowright", VaadinIcon.FORWARD);
        pngToIconMap.put("article", VaadinIcon.FILE_TEXT_O);
        pngToIconMap.put("ask", VaadinIcon.QUESTION_CIRCLE_O);
        pngToIconMap.put("bar_chart", VaadinIcon.BAR_CHART);
        pngToIconMap.put("bkup3", VaadinIcon.WARNING);
        pngToIconMap.put("bkup", VaadinIcon.WARNING);
        pngToIconMap.put("block2", IronIcons.UNDO);
        pngToIconMap.put("board", VaadinIcon.COGS);
        pngToIconMap.put("bold", VaadinIcon.BOLD);
        pngToIconMap.put("bomb", VaadinIcon.BOMB);
        pngToIconMap.put("bookmark", VaadinIcon.BOOKMARK);
        pngToIconMap.put("boxarrow", VaadinIcon.TOOLBOX);
        pngToIconMap.put("bw", VaadinIcon.STEP_FORWARD);
        pngToIconMap.put("calculate", VaadinIcon.CALC);
        pngToIconMap.put("cfolder", VaadinIcon.FOLDER);
        pngToIconMap.put("chart_view", VaadinIcon.CHART);
        pngToIconMap.put("checkbox", VaadinIcon.THIN_SQUARE);
        pngToIconMap.put("clip", VaadinIcon.PAPERCLIP);
        pngToIconMap.put("collapsedb", VaadinIcon.ARROWS_LONG_RIGHT);
        pngToIconMap.put("collapsed_f", VaadinIcon.FOLDER);
        pngToIconMap.put("collapsed_t", VaadinIcon.FOLDER_O);
        pngToIconMap.put("column_chart", VaadinIcon.BAR_CHART);
        pngToIconMap.put("combo", VaadinIcon.LIGHTBULB);
        pngToIconMap.put("config", VaadinIcon.WRENCH);
        pngToIconMap.put("convert", VaadinIcon.EXCHANGE);
        pngToIconMap.put("cut", VaadinIcon.SCISSORS);
        pngToIconMap.put("deleteline", VaadinIcon.LIST_OL);
        pngToIconMap.put("done", VaadinIcon.CHECK_SQUARE_O);
        pngToIconMap.put("error", VaadinIcon.MINUS_CIRCLE);
        pngToIconMap.put("expandedb", VaadinIcon.ARROW_LONG_DOWN);
        pngToIconMap.put("expanded_f", VaadinIcon.FOLDER_OPEN);
        pngToIconMap.put("expanded_s", VaadinIcon.FOLDER_OPEN);
        pngToIconMap.put("expanded_t", VaadinIcon.FOLDER_OPEN);
        pngToIconMap.put("export", VaadinIcon.COG);
        pngToIconMap.put("fax", VaadinIcon.PHONE);
        pngToIconMap.put("fw", VaadinIcon.STEP_FORWARD);
        pngToIconMap.put("gifIcon", VaadinIcon.FILE_PICTURE);
        pngToIconMap.put("green", MapsIcons.MAP);
        pngToIconMap.put("guide", IronIcons.HELP);
        pngToIconMap.put("ident", VaadinIcon.ARROWS_LONG_RIGHT);
        pngToIconMap.put("index", VaadinIcon.BOOK);
        pngToIconMap.put("interrupt", VaadinIcon.STOP);
        pngToIconMap.put("italic", VaadinIcon.ITALIC);
        pngToIconMap.put("jpgIcon", VaadinIcon.PICTURE);
        pngToIconMap.put("launch", VaadinIcon.ARROW_RIGHT);
        pngToIconMap.put("line_chart", VaadinIcon.LINE_CHART);
        pngToIconMap.put("lock", VaadinIcon.LOCK);
        pngToIconMap.put("login", IronIcons.ACCOUNT_CIRCLE);
        pngToIconMap.put("moneycheck", VaadinIcon.MONEY);
        pngToIconMap.put("money", VaadinIcon.MONEY);
        pngToIconMap.put("notice", IronIcons.LIGHTBULB_OUTLINE);
        pngToIconMap.put("ofolder", IronIcons.FOLDER_OPEN);
        pngToIconMap.put("pageFirst", AvIcons.SKIP_PREVIOUS);
        pngToIconMap.put("pageLast", AvIcons.SKIP_NEXT);
        pngToIconMap.put("pageLeft", AvIcons.FAST_REWIND);
        pngToIconMap.put("pageRight", AvIcons.FAST_FORWARD);
        pngToIconMap.put("password", VaadinIcon.PASSWORD);
        pngToIconMap.put("paste", VaadinIcon.PASTE);
        pngToIconMap.put("phone", VaadinIcon.PHONE);
        pngToIconMap.put("pie_chart", VaadinIcon.PIE_CHART);
        pngToIconMap.put("printoptions", VaadinIcon.WRENCH);
        pngToIconMap.put("project", VaadinIcon.CUBES);
        pngToIconMap.put("red", MapsIcons.MAP);
        pngToIconMap.put("redo", IronIcons.REDO);
        pngToIconMap.put("refresh", VaadinIcon.REFRESH);
        pngToIconMap.put("reload", VaadinIcon.REFRESH);
        pngToIconMap.put("report", VaadinIcon.TABLE);
        pngToIconMap.put("sec", VaadinIcon.UNLOCK);
        pngToIconMap.put("selected", VaadinIcon.ARROWS_LONG_RIGHT);
        pngToIconMap.put("send", VaadinIcon.OUTBOX);
        pngToIconMap.put("sort", VaadinIcon.SORT);
        pngToIconMap.put("split", VaadinIcon.SPLIT);
        pngToIconMap.put("standard", VaadinIcon.PENCIL);
        pngToIconMap.put("stick", VaadinIcon.PIN);
        pngToIconMap.put("stop", VaadinIcon.STOP);
        pngToIconMap.put("todo", VaadinIcon.TASKS);
        pngToIconMap.put("top", VaadinIcon.BOOK);
        pngToIconMap.put("underline", VaadinIcon.UNDERLINE);
        pngToIconMap.put("undo", IronIcons.UNDO);
        pngToIconMap.put("unident", VaadinIcon.ARROW_CIRCLE_LEFT);
        pngToIconMap.put("unstick", VaadinIcon.PIN);
        pngToIconMap.put("update", EditorIcons.MODE_EDIT);
        pngToIconMap.put("users", VaadinIcon.USERS);
        pngToIconMap.put("utils", VaadinIcon.TOOLS);
        pngToIconMap.put("validate", VaadinIcon.CHECK);
        pngToIconMap.put("wait", DeviceIcons.ACCESS_TIME);
        pngToIconMap.put("warning", IronIcons.WARNING);
        pngToIconMap.put("window", IronIcons.CHEVRON_RIGHT);
        pngToIconMap.put("yellow", MapsIcons.MAP);
        pngToIconMap.put("zoomheight", VaadinIcon.VAADIN_H);
        pngToIconMap.put("zoomminus", VaadinIcon.SEARCH_MINUS);
        pngToIconMap.put("zoomoptimal", VaadinIcon.VAADIN_H);
        pngToIconMap.put("zoomplus", VaadinIcon.SEARCH_PLUS);
        pngToIconMap.put("zoomwidth", VaadinIcon.VAADIN_H);
    }
}

