/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.ui.vaadin.block;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasEnabled;
import com.vaadin.flow.component.html.H4;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kopi.galite.visual.ui.vaadin.block.BlockDropWrapper;
import org.kopi.galite.visual.ui.vaadin.block.BlockLayout;
import org.kopi.galite.visual.ui.vaadin.block.MultiBlockLayout;
import org.kopi.galite.visual.ui.vaadin.form.DBlock;
import org.kopi.galite.visual.ui.vaadin.form.DBlockDropHandler;
import org.kopi.galite.visual.ui.vaadin.form.Form;
import org.kopi.galite.visual.ui.vaadin.form.Page;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\b&\u0018\u00002\u00020\u00012\u00020\u0002:\u0002EFB\u0017\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J@\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020#2\u0006\u0010'\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020\u000fJ\b\u0010)\u001a\u00020\u001fH\u0002J\b\u0010*\u001a\u00020\u001fH\u0016J\n\u0010+\u001a\u0004\u0018\u00010\u0019H&J\b\u0010,\u001a\u00020\u000fH\u0016J\u0018\u0010-\u001a\u00020\u001f2\u0006\u0010.\u001a\u00020#2\u0006\u0010/\u001a\u00020#H\u0014J'\u00100\u001a\u00020\u001f2\u0006\u00101\u001a\u00020#2\u0006\u0010.\u001a\u00020#2\b\u00102\u001a\u0004\u0018\u000103H\u0010\u00a2\u0006\u0002\b4J\b\u00105\u001a\u00020\u000fH&J\u0006\u0010\u0018\u001a\u00020\u001fJ\u0006\u00106\u001a\u00020\u001fJ\u0010\u00107\u001a\u00020\u001f2\u0006\u00108\u001a\u00020\u000fH\u0002J \u0010\f\u001a\u00020\u001f2\b\u0010\b\u001a\u0004\u0018\u0001032\f\u00109\u001a\b\u0012\u0002\b\u0003\u0018\u00010:H\u0014J\u0010\u0010;\u001a\u00020\u001f2\u0006\u0010<\u001a\u00020!H\u0016J\u000e\u0010=\u001a\u00020\u001f2\u0006\u0010>\u001a\u00020\u000fJ\u0012\u0010?\u001a\u00020\u001f2\b\u0010@\u001a\u0004\u0018\u00010!H\u0016J&\u0010A\u001a\u00020\u001f2\u0006\u0010B\u001a\u00020#2\u0006\u0010C\u001a\u00020#2\u0006\u0010D\u001a\u00020\u000f2\u0006\u00102\u001a\u00020#R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006G"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/block/Block;", "Lcom/vaadin/flow/component/orderedlayout/VerticalLayout;", "Lcom/vaadin/flow/component/HasEnabled;", "dropHandler", "Lorg/kopi/galite/visual/ui/vaadin/form/DBlockDropHandler;", "form", "Lorg/kopi/galite/visual/ui/vaadin/form/Form;", "(Lorg/kopi/galite/visual/ui/vaadin/form/DBlockDropHandler;Lorg/kopi/galite/visual/ui/vaadin/form/Form;)V", "caption", "Lcom/vaadin/flow/component/html/H4;", "getCaption", "()Lcom/vaadin/flow/component/html/H4;", "setCaption", "(Lcom/vaadin/flow/component/html/H4;)V", "doNotUpdateScrollPosition", "", "dropWrapper", "Lorg/kopi/galite/visual/ui/vaadin/block/BlockDropWrapper;", "getForm", "()Lorg/kopi/galite/visual/ui/vaadin/form/Form;", "isAnimationEnabled", "()Z", "setAnimationEnabled", "(Z)V", "layout", "Lorg/kopi/galite/visual/ui/vaadin/block/BlockLayout;", "getLayout", "()Lorg/kopi/galite/visual/ui/vaadin/block/BlockLayout;", "setLayout", "(Lorg/kopi/galite/visual/ui/vaadin/block/BlockLayout;)V", "addComponent", "", "component", "Lcom/vaadin/flow/component/Component;", "x", "", "y", "width", "height", "alignRight", "useAll", "buildLayout", "clear", "createLayout", "delegateCaptionHandling", "fireRecordInfoChanged", "rec", "info", "fireValueChanged", "col", "value", "", "fireValueChanged$galite_core", "inDetailMode", "layoutAlignedComponents", "refresh", "force", "page", "Lorg/kopi/galite/visual/ui/vaadin/form/Page;", "setContent", "content", "switchView", "detail", "updateCaption", "connector", "updateScroll", "pageSize", "maxValue", "enable", "ColorPair", "RecordInfo", "galite-core"})
public abstract class Block
extends VerticalLayout
implements HasEnabled {
    @Nullable
    private final DBlockDropHandler dropHandler;
    @NotNull
    private final Form form;
    @Nullable
    private BlockLayout layout;
    @Nullable
    private H4 caption;
    @Nullable
    private BlockDropWrapper dropWrapper;
    private boolean doNotUpdateScrollPosition;
    private boolean isAnimationEnabled;

    public Block(@Nullable DBlockDropHandler dropHandler, @NotNull Form form) {
        Intrinsics.checkNotNullParameter((Object)form, (String)"form");
        this.dropHandler = dropHandler;
        this.form = form;
        this.setClassName("k-block");
    }

    @NotNull
    public final Form getForm() {
        return this.form;
    }

    @Nullable
    public final BlockLayout getLayout() {
        return this.layout;
    }

    public final void setLayout(@Nullable BlockLayout blockLayout) {
        this.layout = blockLayout;
    }

    @Nullable
    public final H4 getCaption() {
        return this.caption;
    }

    public final void setCaption(@Nullable H4 h4) {
        this.caption = h4;
    }

    public final boolean isAnimationEnabled() {
        return this.isAnimationEnabled;
    }

    public final void setAnimationEnabled(boolean bl) {
        this.isAnimationEnabled = bl;
    }

    public final void switchView(boolean detail) {
        if (this.layout instanceof MultiBlockLayout) {
            BlockLayout blockLayout = this.layout;
            if (blockLayout == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.kopi.galite.visual.ui.vaadin.block.MultiBlockLayout");
            }
            ((MultiBlockLayout)blockLayout).switchView(detail);
        }
    }

    public final void updateScroll(int pageSize, int maxValue, boolean enable, int value) {
    }

    public final void addComponent(@Nullable Component component, int x, int y, int width, int height, boolean alignRight, boolean useAll) {
        this.buildLayout();
        BlockLayout blockLayout = this.layout;
        Intrinsics.checkNotNull((Object)blockLayout);
        blockLayout.addComponent(component, x, y, width, height, alignRight, useAll);
    }

    private final void buildLayout() {
        if (this.layout == null) {
            this.layout = this.createLayout();
            if (this.dropHandler != null) {
                BlockLayout blockLayout = this.layout;
                if (blockLayout == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.vaadin.flow.component.Component");
                }
                BlockDropWrapper blockDropWrapper = this.dropWrapper = new BlockDropWrapper((Component)blockLayout, this.dropHandler);
                Intrinsics.checkNotNull((Object)((Object)blockDropWrapper));
                this.setContent((Component)blockDropWrapper);
            } else {
                BlockLayout blockLayout = this.layout;
                if (blockLayout == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.vaadin.flow.component.Component");
                }
                this.setContent((Component)blockLayout);
            }
        }
    }

    protected void fireRecordInfoChanged(int rec, int info) {
        this.refresh(true);
    }

    public void fireValueChanged$galite_core(int col, int rec, @Nullable String value) {
    }

    public void setContent(@NotNull Component content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        this.removeAll();
        Component[] componentArray = new Component[]{content};
        this.add(componentArray);
    }

    protected void setCaption(@Nullable String caption, @Nullable Page<?> page) {
        if (caption == null || ((CharSequence)caption).length() == 0) {
            return;
        }
        H4 h4 = this.caption = new H4(caption);
        Intrinsics.checkNotNull((Object)h4);
        h4.setClassName("block-title");
        Page<?> page2 = page;
        if (page2 != null) {
            page2.setCaption(this);
        }
    }

    public final void layout() {
        BlockLayout blockLayout = this.layout;
        if (blockLayout != null) {
            blockLayout.layout();
        }
    }

    public final void layoutAlignedComponents() {
        BlockLayout blockLayout = this.layout;
        if (blockLayout != null) {
            blockLayout.layoutAlignedComponents();
        }
    }

    public void clear() {
        super.removeAll();
        if (this.layout != null) {
            try {
                BlockLayout blockLayout = this.layout;
                Intrinsics.checkNotNull((Object)blockLayout);
                blockLayout.removeAll();
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            this.layout = null;
        }
        this.caption = null;
    }

    public boolean delegateCaptionHandling() {
        return false;
    }

    public void updateCaption(@Nullable Component connector) {
    }

    private final void refresh(boolean force) {
        ((DBlock)this).refresh(force);
    }

    public abstract boolean inDetailMode();

    @Nullable
    public abstract BlockLayout createLayout();

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\t\u00a8\u0006\f"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/block/Block$ColorPair;", "", "foreground", "", "background", "(Ljava/lang/String;Ljava/lang/String;)V", "getBackground", "()Ljava/lang/String;", "setBackground", "(Ljava/lang/String;)V", "getForeground", "setForeground", "galite-core"})
    public static final class ColorPair {
        @Nullable
        private String foreground;
        @Nullable
        private String background;

        public ColorPair(@Nullable String foreground, @Nullable String background) {
            this.foreground = foreground;
            this.background = background;
        }

        @Nullable
        public final String getForeground() {
            return this.foreground;
        }

        public final void setForeground(@Nullable String string) {
            this.foreground = string;
        }

        @Nullable
        public final String getBackground() {
            return this.background;
        }

        public final void setBackground(@Nullable String string) {
            this.background = string;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0003H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\t\u00a8\u0006\u0010"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/block/Block$RecordInfo;", "", "rec", "", "value", "(II)V", "getRec", "()I", "setRec", "(I)V", "getValue", "setValue", "equals", "", "other", "hashCode", "galite-core"})
    public static final class RecordInfo {
        private int rec;
        private int value;

        public RecordInfo(int rec, int value) {
            this.rec = rec;
            this.value = value;
        }

        public final int getRec() {
            return this.rec;
        }

        public final void setRec(int n) {
            this.rec = n;
        }

        public final int getValue() {
            return this.value;
        }

        public final void setValue(int n) {
            this.value = n;
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof RecordInfo ? this.rec == ((RecordInfo)other).rec && this.value == ((RecordInfo)other).value : super.equals(other);
        }

        public int hashCode() {
            return this.rec + this.value;
        }
    }
}

