/*
 * Decompiled with CFR 0.152.
 */
package org.kopi.galite.visual.ui.vaadin.field;

import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kopi.galite.visual.ui.vaadin.field.AllowAllValidator;
import org.kopi.galite.visual.ui.vaadin.field.CheckTypeException;
import org.kopi.galite.visual.ui.vaadin.field.InputTextField;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001c\u0010\u000b\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\f\u001a\u00020\nH\u0002J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003H\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/kopi/galite/visual/ui/vaadin/field/WeekValidator;", "Lorg/kopi/galite/visual/ui/vaadin/field/AllowAllValidator;", "maxLength", "", "(I)V", "checkType", "", "field", "Lorg/kopi/galite/visual/ui/vaadin/field/InputTextField;", "text", "", "parseWeek", "s", "toString", "year", "week", "validate", "", "c", "", "galite-core"})
public final class WeekValidator
extends AllowAllValidator {
    public WeekValidator(int maxLength) {
        super(maxLength);
    }

    @Override
    public boolean validate(char c) {
        return ('0' <= c ? c < ':' : false) || c == '.' || c == '/';
    }

    @Override
    public void checkType(@NotNull InputTextField<?> field, @NotNull String text) {
        Intrinsics.checkNotNullParameter(field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (Intrinsics.areEqual((Object)"", (Object)text)) {
            field.setValue(null);
        } else {
            this.parseWeek(field, text);
        }
    }

    private final void parseWeek(InputTextField<?> field, String s) {
        int week = 0;
        int year = -1;
        int bp = 0;
        int state = 1;
        String buffer = s + "\u0000";
        while (state > 0) {
            switch (state) {
                case 1: {
                    char c = buffer.charAt(bp);
                    boolean bl = '0' <= c ? c < ':' : false;
                    if (bl) {
                        week = buffer.charAt(bp) - 48;
                        state = 2;
                        break;
                    }
                    state = -1;
                    break;
                }
                case 2: {
                    char c = buffer.charAt(bp);
                    boolean bl = '0' <= c ? c < ':' : false;
                    if (bl) {
                        week = 10 * week + (buffer.charAt(bp) - 48);
                        state = 3;
                        break;
                    }
                    if (buffer.charAt(bp) == '.' || buffer.charAt(bp) == '/') {
                        state = 4;
                        break;
                    }
                    if (buffer.charAt(bp) == '\u0000') {
                        state = 0;
                        break;
                    }
                    state = -1;
                    break;
                }
                case 3: {
                    state = buffer.charAt(bp) == '.' || buffer.charAt(bp) == '/' ? 4 : (buffer.charAt(bp) == '\u0000' ? 0 : -1);
                    break;
                }
                case 4: {
                    char c = buffer.charAt(bp);
                    boolean bl = '0' <= c ? c < ':' : false;
                    if (bl) {
                        year = buffer.charAt(bp) - 48;
                        state = 5;
                        break;
                    }
                    if (buffer.charAt(bp) == '\u0000') {
                        state = 0;
                        break;
                    }
                    state = -1;
                    break;
                }
                case 5: {
                    char c = buffer.charAt(bp);
                    boolean bl = '0' <= c ? c < ':' : false;
                    if (bl) {
                        year = 10 * year + (buffer.charAt(bp) - 48);
                        state = 6;
                        break;
                    }
                    state = -1;
                    break;
                }
                case 6: {
                    char c = buffer.charAt(bp);
                    boolean bl = '0' <= c ? c < ':' : false;
                    if (bl) {
                        year = 10 * year + (buffer.charAt(bp) - 48);
                        state = 7;
                        break;
                    }
                    if (buffer.charAt(bp) == '\u0000') {
                        state = 0;
                        break;
                    }
                    state = -1;
                    break;
                }
                case 7: {
                    char c = buffer.charAt(bp);
                    boolean bl = '0' <= c ? c < ':' : false;
                    if (bl) {
                        year = 10 * year + (buffer.charAt(bp) - 48);
                        state = 8;
                        break;
                    }
                    state = -1;
                    break;
                }
                case 8: {
                    state = buffer.charAt(bp) == '\u0000' ? 0 : -1;
                    break;
                }
                default: {
                    throw new CheckTypeException(field, "00008");
                }
            }
            ++bp;
        }
        if (state == -1) {
            throw new CheckTypeException(field, "00008");
        }
        if (year == -1) {
            Date now = new Date();
            year = now.getYear() + 1900;
        } else if (year < 50) {
            year += 2000;
        } else if (year < 100) {
            year += 1900;
        }
        field.setValue(this.toString(year, week));
    }

    private final String toString(int year, int week) {
        return (week < 10 ? "0" + week : "" + week) + "." + year;
    }
}

